/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.exceptions.SaltInvalidModelException;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.impl.NodeImpl;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.SAnnotationContainerHelper;
import org.eclipse.emf.common.util.URI;

public class SNodeImpl
extends NodeImpl
implements SNode {
    protected SFeature name = null;

    @Override
    public List<SRelation> getOutRelations() {
        if (this.getGraph() == null) {
            return null;
        }
        List outRelations = this.getGraph().getOutRelations(this.getId());
        if (outRelations != null) {
            ArrayList<SRelation> sOutRelList = new ArrayList<SRelation>();
            for (SRelation rel : outRelations) {
                sOutRelList.add(rel);
            }
            return sOutRelList;
        }
        return null;
    }

    @Override
    public List<SRelation> getInRelations() {
        if (this.getGraph() == null) {
            return null;
        }
        List inRelations = this.getGraph().getInRelations(this.getId());
        if (inRelations != null) {
            ArrayList<SRelation> sInRelList = new ArrayList<SRelation>();
            for (SRelation rel : inRelations) {
                sInRelList.add(rel);
            }
            return sInRelList;
        }
        return null;
    }

    @Override
    public Set<SLayer> getLayers() {
        Set allLayers;
        HashSet<SLayer> layers = new HashSet<SLayer>();
        if (this.getGraph() != null && (allLayers = this.getGraph().getLayers()) != null && allLayers.size() > 0) {
            for (SLayer layer : allLayers) {
                if (!layer.getNodes().contains(this)) continue;
                layers.add(layer);
            }
        }
        return Collections.unmodifiableSet(layers);
    }

    @Override
    public SAnnotation createAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createAnnotation(this, namespace, name, value);
    }

    public Set<SAnnotation> createAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createAnnotations(this, annotationString);
    }

    @Override
    public void addAnnotation(SAnnotation annotation) {
        SAnnotationContainerHelper.addAnnotation(this, annotation);
    }

    @Override
    public <A extends SAnnotation> Set<A> getAnnotations() {
        return SAnnotationContainerHelper.getAnnotations(this);
    }

    @Override
    public SAnnotation getAnnotation(String qName) {
        return SAnnotationContainerHelper.getAnnotation(this, qName);
    }

    @Override
    public SAnnotation getAnnotation(String namespace, String name) {
        return SAnnotationContainerHelper.getAnnotation(this, SaltUtil.createQName(namespace, name));
    }

    @Override
    public Iterator<SAnnotation> iterator_SAnnotation() {
        return SAnnotationContainerHelper.iterator_SAnnotation(this);
    }

    @Override
    public void addMetaAnnotation(SMetaAnnotation metaAnnotation) {
        SAnnotationContainerHelper.addMetaAnnotation(this, metaAnnotation);
    }

    @Override
    public SMetaAnnotation createMetaAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createMetaAnnotation(this, namespace, name, value);
    }

    public Set<SMetaAnnotation> createMetaAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createMetaAnnotations(this, annotationString);
    }

    @Override
    public <A extends SMetaAnnotation> Set<A> getMetaAnnotations() {
        return SAnnotationContainerHelper.getMetaAnnotations(this);
    }

    @Override
    public SMetaAnnotation getMetaAnnotation(String qName) {
        return SAnnotationContainerHelper.getMetaAnnotation(this, qName);
    }

    @Override
    public Iterator<SMetaAnnotation> iterator_SMetaAnnotation() {
        return SAnnotationContainerHelper.iterator_SMetaAnnotation(this);
    }

    @Override
    public SProcessingAnnotation createProcessingAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createProcessingAnnotation(this, namespace, name, value);
    }

    public Set<SProcessingAnnotation> createProcessingAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createProcessingAnnotations(this, annotationString);
    }

    @Override
    public void addProcessingAnnotation(SProcessingAnnotation annotation) {
        SAnnotationContainerHelper.addProcessingAnnotation(this, annotation);
    }

    @Override
    public <A extends SProcessingAnnotation> Set<A> getProcessingAnnotations() {
        return SAnnotationContainerHelper.getProcessingAnnotations(this);
    }

    @Override
    public SProcessingAnnotation getProcessingAnnotation(String qName) {
        return SAnnotationContainerHelper.getProcessingAnnotation(this, qName);
    }

    @Override
    public Iterator<SProcessingAnnotation> iterator_SProcessingAnnotation() {
        return SAnnotationContainerHelper.iterator_SProcessingAnnotation(this);
    }

    @Override
    public SFeature createFeature(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createFeature(this, namespace, name, value);
    }

    public Set<SFeature> createFeatures(String featureString) {
        return SAnnotationContainerHelper.createFeatures(this, featureString);
    }

    @Override
    public void addFeature(SFeature feature) {
        SAnnotationContainerHelper.addFeature(this, feature);
    }

    @Override
    public <A extends SFeature> Set<A> getFeatures() {
        return SAnnotationContainerHelper.getFeatures(this);
    }

    @Override
    public SFeature getFeature(String qName) {
        return SAnnotationContainerHelper.getFeature(this, qName);
    }

    @Override
    public SFeature getFeature(String namespace, String name) {
        return SAnnotationContainerHelper.getFeature(this, SaltUtil.createQName(namespace, name));
    }

    @Override
    public Iterator<SFeature> iterator_SFeature() {
        return SAnnotationContainerHelper.iterator_SFeature(this);
    }

    @Override
    public void removeLabel(String qName) {
        if ("salt::SNAME".equals(qName)) {
            this.name = null;
        }
        super.removeLabel(qName);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            SFeature feature = this.getFeature("salt::SNAME");
            if (feature != null) {
                this.name = feature;
            }
            if (this.name == null) {
                return null;
            }
        }
        return this.name.getValue_STEXT();
    }

    @Override
    public void setName(String name) {
        if (this.name == null) {
            this.name = this.createFeature("salt", "SNAME", null);
        }
        this.name.setValue(name);
    }

    @Override
    public URI getPath() {
        return SaltUtil.createSaltURI(this.getId());
    }

    @Override
    public SGraph getGraph() {
        Graph superGraph = super.getGraph();
        if (superGraph == null) {
            return null;
        }
        if (superGraph instanceof SGraph) {
            return (SGraph)superGraph;
        }
        throw new SaltInvalidModelException("Graph implementation is not of type SGraph (actual type is " + superGraph.getClass().getName() + ")");
    }
}

