/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.salt.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SProcessingAnnotation;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.core.impl.GraphTraverserModule;
import org.corpus_tools.salt.graph.impl.GraphImpl;
import org.corpus_tools.salt.util.SaltUtil;
import org.corpus_tools.salt.util.internal.SAnnotationContainerHelper;
import org.eclipse.emf.common.util.URI;

public class SGraphImpl
extends GraphImpl<SNode, SRelation<SNode, SNode>, SLayer>
implements SGraph {
    protected SFeature name = null;

    @Override
    public void addLayer(SLayer layer) {
        if (layer.getName() == null) {
            layer.setName("l" + this.getLayers().size());
        }
        super.addLayer(layer);
    }

    @Override
    public List<SNode> getNodesByName(String nodeName) {
        SNode n;
        if (nodeName == null || nodeName.isEmpty()) {
            return null;
        }
        ArrayList<SNode> result = new ArrayList<SNode>();
        Iterator i$ = this.getNodes().iterator();
        while (i$.hasNext() && (n = (SNode)i$.next()).getName() != null && !n.getName().isEmpty()) {
            if (!nodeName.equals(n.getName())) continue;
            result.add(n);
        }
        return result;
    }

    @Override
    public List<SRelation> getRelationsByName(String relationName) {
        SRelation r;
        if (relationName == null || relationName.isEmpty()) {
            return null;
        }
        ArrayList<SRelation> result = new ArrayList<SRelation>();
        Iterator i$ = this.getRelations().iterator();
        while (i$.hasNext() && (r = (SRelation)i$.next()).getName() != null && !r.getName().isEmpty()) {
            if (!relationName.equals(r.getName())) continue;
            result.add(r);
        }
        return result;
    }

    @Override
    public List<SLayer> getLayerByName(String layerName) {
        SLayer l;
        if (layerName == null || layerName.isEmpty()) {
            return null;
        }
        ArrayList<SLayer> result = new ArrayList<SLayer>();
        Iterator i$ = this.getLayers().iterator();
        while (i$.hasNext() && (l = (SLayer)i$.next()).getName() != null && !l.getName().isEmpty()) {
            if (!layerName.equals(l.getName())) continue;
            result.add(l);
        }
        return result;
    }

    @Override
    public List<SNode> getRoots() {
        ArrayList<SNode> retList = new ArrayList<SNode>();
        if (this.getNodes().size() == 1) {
            retList.add((SNode)this.getNodes().get(0));
        } else {
            for (SNode node : Collections.synchronizedCollection(this.getNodes())) {
                List inEdges = this.getInRelations(node.getId());
                if (inEdges != null && inEdges.size() != 0) continue;
                retList.add(node);
            }
        }
        if (retList.size() == 0) {
            retList = null;
        }
        return retList;
    }

    @Override
    public List<SNode> getLeafs() {
        ArrayList<SNode> retList = new ArrayList<SNode>();
        if (this.getNodes().size() == 1) {
            retList.add((SNode)this.getNodes().get(0));
        } else {
            for (SNode node : Collections.synchronizedCollection(this.getNodes())) {
                List outEdges = this.getOutRelations(node.getId());
                if (outEdges != null && outEdges.size() != 0) continue;
                retList.add(node);
            }
        }
        if (retList.size() == 0) {
            retList = null;
        }
        return retList;
    }

    @Override
    public void traverse(List<SNode> startNodes, SGraph.GRAPH_TRAVERSE_TYPE traverseType, String traverseId, GraphTraverseHandler traverseHandler) {
        this.traverse(startNodes, traverseType, traverseId, traverseHandler, true);
    }

    @Override
    public void traverse(List<? extends SNode> startNodes, SGraph.GRAPH_TRAVERSE_TYPE traverseType, String traverseId, GraphTraverseHandler traverseHandler, boolean isCycleSafe) {
        GraphTraverserModule traverserModule = new GraphTraverserModule();
        traverserModule.setGraph(this);
        traverserModule.traverse(startNodes, traverseType, traverseId, traverseHandler, isCycleSafe);
    }

    @Override
    public void removeLabel(String qName) {
        if ("salt::SNAME".equals(qName)) {
            this.name = null;
        }
        super.removeLabel(qName);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            SFeature feature = this.getFeature("salt::SNAME");
            if (feature != null) {
                this.name = feature;
            }
            if (this.name == null) {
                return null;
            }
        }
        return this.name.getValue_STEXT();
    }

    @Override
    public void setName(String name) {
        if (this.name == null) {
            this.name = this.createFeature("salt", "SNAME", null);
        }
        this.name.setValue(name);
    }

    @Override
    public SAnnotation createAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createAnnotation(this, namespace, name, value);
    }

    public Set<SAnnotation> createAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createAnnotations(this, annotationString);
    }

    @Override
    public void addAnnotation(SAnnotation annotation) {
        SAnnotationContainerHelper.addAnnotation(this, annotation);
    }

    @Override
    public <A extends SAnnotation> Set<A> getAnnotations() {
        return SAnnotationContainerHelper.getAnnotations(this);
    }

    @Override
    public SAnnotation getAnnotation(String qName) {
        return SAnnotationContainerHelper.getAnnotation(this, qName);
    }

    @Override
    public SAnnotation getAnnotation(String namespace, String name) {
        return SAnnotationContainerHelper.getAnnotation(this, SaltUtil.createQName(namespace, name));
    }

    @Override
    public Iterator<SAnnotation> iterator_SAnnotation() {
        return SAnnotationContainerHelper.iterator_SAnnotation(this);
    }

    @Override
    public void addMetaAnnotation(SMetaAnnotation metaAnnotation) {
        SAnnotationContainerHelper.addMetaAnnotation(this, metaAnnotation);
    }

    @Override
    public SMetaAnnotation createMetaAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createMetaAnnotation(this, namespace, name, value);
    }

    public Set<SMetaAnnotation> createMetaAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createMetaAnnotations(this, annotationString);
    }

    @Override
    public <A extends SMetaAnnotation> Set<A> getMetaAnnotations() {
        return SAnnotationContainerHelper.getMetaAnnotations(this);
    }

    @Override
    public SMetaAnnotation getMetaAnnotation(String qName) {
        return SAnnotationContainerHelper.getMetaAnnotation(this, qName);
    }

    @Override
    public Iterator<SMetaAnnotation> iterator_SMetaAnnotation() {
        return SAnnotationContainerHelper.iterator_SMetaAnnotation(this);
    }

    @Override
    public SProcessingAnnotation createProcessingAnnotation(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createProcessingAnnotation(this, namespace, name, value);
    }

    public Set<SProcessingAnnotation> createProcessingAnnotations(String annotationString) {
        return SAnnotationContainerHelper.createProcessingAnnotations(this, annotationString);
    }

    @Override
    public void addProcessingAnnotation(SProcessingAnnotation annotation) {
        SAnnotationContainerHelper.addProcessingAnnotation(this, annotation);
    }

    @Override
    public <A extends SProcessingAnnotation> Set<A> getProcessingAnnotations() {
        return SAnnotationContainerHelper.getProcessingAnnotations(this);
    }

    @Override
    public SProcessingAnnotation getProcessingAnnotation(String qName) {
        return SAnnotationContainerHelper.getProcessingAnnotation(this, qName);
    }

    @Override
    public Iterator<SProcessingAnnotation> iterator_SProcessingAnnotation() {
        return SAnnotationContainerHelper.iterator_SProcessingAnnotation(this);
    }

    @Override
    public SFeature createFeature(String namespace, String name, Object value) {
        return SAnnotationContainerHelper.createFeature(this, namespace, name, value);
    }

    public Set<SFeature> createFeatures(String featureString) {
        return SAnnotationContainerHelper.createFeatures(this, featureString);
    }

    @Override
    public void addFeature(SFeature feature) {
        SAnnotationContainerHelper.addFeature(this, feature);
    }

    @Override
    public <A extends SFeature> Set<A> getFeatures() {
        return SAnnotationContainerHelper.getFeatures(this);
    }

    @Override
    public SFeature getFeature(String qName) {
        return SAnnotationContainerHelper.getFeature(this, qName);
    }

    @Override
    public SFeature getFeature(String namespace, String name) {
        return SAnnotationContainerHelper.getFeature(this, SaltUtil.createQName(namespace, name));
    }

    @Override
    public Iterator<SFeature> iterator_SFeature() {
        return SAnnotationContainerHelper.iterator_SFeature(this);
    }

    @Override
    public URI getPath() {
        return SaltUtil.createSaltURI(this.getId());
    }
}

