/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import annis.exceptions.AnnisQLSemanticsException;
import annis.model.AqlParseError;
import annis.model.Join;
import annis.model.QueryNode;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.corpus_tools.annis.ql.model.Inclusion;
import org.corpus_tools.annis.ql.model.LeftAlignment;
import org.corpus_tools.annis.ql.model.LeftOverlap;
import org.corpus_tools.annis.ql.model.NonBindingJoin;
import org.corpus_tools.annis.ql.model.Overlap;
import org.corpus_tools.annis.ql.model.RightAlignment;
import org.corpus_tools.annis.ql.model.RightOverlap;
import org.corpus_tools.annis.ql.model.SameSpan;
import org.corpus_tools.annis.ql.parser.QueryData;
import org.corpus_tools.annis.ql.parser.QueryDataTransformer;

public class SemanticValidator
implements QueryDataTransformer {
    @Override
    public QueryData transform(QueryData data) {
        int i = 1;
        for (List<QueryNode> alternative : data.getAlternatives()) {
            this.checkAlternative(data, alternative, i++, data.getAlternatives().size() > 1);
        }
        return data;
    }

    public void checkAlternative(QueryData data, List<QueryNode> alternative, int alternativeIndex, boolean queryWasNormalized) {
        if (alternative.isEmpty()) {
            throw new AnnisQLSemanticsException("Missing search expression.");
        }
        if (alternative.size() == 1) {
            QueryNode n = alternative.get(0);
            for (Join j : n.getOutgoingJoins()) {
                if (j.getTarget() == null) continue;
                throw new AnnisQLSemanticsException(j.getParseLocation(), "No binary linguistic relations allowed if there is only one node in query.");
            }
        }
        Multimap<Long, QueryNode> connected = this.calculateConnected(alternative);
        HashSet<Long> transitiveHull = new HashSet<Long>();
        transitiveHull.add(alternative.get(0).getId());
        this.createTransitiveHull(alternative.get(0), connected, transitiveHull);
        TreeMultiset variableNames = TreeMultiset.create();
        HashSet<Long> unconnectedNodes = new HashSet<Long>();
        for (QueryNode n : alternative) {
            unconnectedNodes.add(n.getId());
            variableNames.add((Object)n.getVariable());
        }
        unconnectedNodes.removeAll(transitiveHull);
        if (!unconnectedNodes.isEmpty()) {
            LinkedList<AqlParseError> errors = new LinkedList<AqlParseError>();
            for (QueryNode n : alternative) {
                if (!unconnectedNodes.contains(n.getId())) continue;
                errors.add(new AqlParseError(n, "variable \"" + n.getVariable() + "\" not bound (use linguistic operators)"));
            }
            if (!errors.isEmpty()) {
                if (queryWasNormalized) {
                    errors.add(new AqlParseError("Normalized query is: \n" + data.toAQL()));
                }
                throw new AnnisQLSemanticsException("Not all variables bound", errors);
            }
        }
        LinkedList<Object> invalidNames = new LinkedList<Object>();
        for (Multiset.Entry e : variableNames.entrySet()) {
            if (e.getCount() <= 1) continue;
            invalidNames.add(e.getElement());
        }
        if (!invalidNames.isEmpty()) {
            throw new AnnisQLSemanticsException("The following variable names are used for more than one node: " + Joiner.on((String)", ").join(invalidNames) + "\nNormalized Query is: \n" + data.toAQL());
        }
        for (QueryNode source : alternative) {
            for (Join join : source.getOutgoingJoins()) {
                if (!(join instanceof Inclusion) && !(join instanceof SameSpan) && !(join instanceof Overlap) && !(join instanceof RightOverlap) && !(join instanceof LeftOverlap) && !(join instanceof RightAlignment) && !(join instanceof LeftAlignment) || !source.equals((Object)join.getTarget())) continue;
                throw new AnnisQLSemanticsException(join, "Not-reflexive operator used with the same node as argument.");
            }
        }
    }

    private Multimap<Long, QueryNode> calculateConnected(List<QueryNode> nodes) {
        HashMultimap result = HashMultimap.create();
        for (QueryNode n : nodes) {
            for (Join j : n.getOutgoingJoins()) {
                if (j.getTarget() == null || j instanceof NonBindingJoin) continue;
                long left = n.getId();
                long right = j.getTarget().getId();
                result.put((Object)left, (Object)j.getTarget());
                result.put((Object)right, (Object)n);
            }
        }
        return result;
    }

    private void createTransitiveHull(QueryNode n, Multimap<Long, QueryNode> connected, Set<Long> transitiveHull) {
        Collection outgoing = connected.get((Object)n.getId());
        if (outgoing != null) {
            for (QueryNode otherNode : outgoing) {
                if (!transitiveHull.add(otherNode.getId())) continue;
                this.createTransitiveHull(otherNode, connected, transitiveHull);
            }
        }
    }
}

