/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.corpus_tools.annis.ql.RawAqlPreParser;
import org.corpus_tools.annis.ql.RawAqlPreParserBaseListener;
import org.corpus_tools.annis.ql.parser.LogicClause;

public class RawAqlListener
extends RawAqlPreParserBaseListener {
    private LogicClause root;
    private LogicClause current;

    @Override
    public void enterStart(RawAqlPreParser.StartContext ctx) {
        this.root = null;
    }

    @Override
    public void enterAndExpr(RawAqlPreParser.AndExprContext ctx) {
        LogicClause nodeAnd = new LogicClause(LogicClause.Operator.AND);
        nodeAnd.setContent(Lists.newArrayList((Object[])new Token[]{ctx.AND().getSymbol()}));
        if (this.current != null) {
            this.current.addChild(nodeAnd);
        }
        this.current = nodeAnd;
    }

    @Override
    public void exitAndExpr(RawAqlPreParser.AndExprContext ctx) {
        this.switchToParent();
    }

    @Override
    public void enterOrExpr(RawAqlPreParser.OrExprContext ctx) {
        LogicClause nodeOr = new LogicClause(LogicClause.Operator.OR);
        nodeOr.setContent(Lists.newArrayList((Object[])new Token[]{ctx.OR().getSymbol()}));
        if (this.current != null) {
            this.current.addChild(nodeOr);
        }
        this.current = nodeOr;
    }

    @Override
    public void exitOrExpr(RawAqlPreParser.OrExprContext ctx) {
        this.switchToParent();
    }

    @Override
    public void enterLeafExpr(RawAqlPreParser.LeafExprContext ctx) {
        LogicClause nodeLeaf = new LogicClause(LogicClause.Operator.LEAF);
        if (this.current != null) {
            this.current.addChild(nodeLeaf);
        }
        nodeLeaf.setContent(RawAqlListener.collectToken((ParseTree)ctx));
        this.current = nodeLeaf;
    }

    private static List<Token> collectToken(ParseTree node) {
        LinkedList<Token> token = new LinkedList<Token>();
        RawAqlListener.collectToken(node, token);
        return token;
    }

    private static void collectToken(ParseTree node, List<Token> token) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            ParseTree child = node.getChild(i);
            if (child.getPayload() instanceof Token) {
                token.add((Token)child.getPayload());
                continue;
            }
            RawAqlListener.collectToken(child, token);
        }
    }

    @Override
    public void exitLeafExpr(RawAqlPreParser.LeafExprContext ctx) {
        this.switchToParent();
    }

    private void switchToParent() {
        if (this.current.getParent() == null) {
            Preconditions.checkArgument((this.root == null ? 1 : 0) != 0, (Object)"There is only one root node allowed");
            this.root = this.current;
        }
        this.current = this.current.getParent();
    }

    public LogicClause getRoot() {
        return this.root;
    }
}

