/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import annis.exceptions.AnnisQLSyntaxException;
import annis.model.QueryAnnotation;
import annis.model.QueryNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.corpus_tools.annis.ql.AqlParser;
import org.corpus_tools.annis.ql.AqlParserBaseListener;
import org.corpus_tools.annis.ql.parser.AnnisParserAntlr;
import org.corpus_tools.annis.ql.parser.QueryData;

public class QueryNodeListener
extends AqlParserBaseListener {
    private Map<Interval, Long> nodeIntervalToID;
    private QueryData data = null;
    private final TreeMap<Long, QueryNode> currentAlternative = new TreeMap();
    private String lastVariableDefinition = null;
    private final Multimap<String, QueryNode> localNodes = HashMultimap.create();
    private List<Map<Interval, QueryNode>> tokenPositions;
    private final Map<Interval, QueryNode> currentTokenPosition = Maps.newHashMap();
    private final List<QueryAnnotation> metaData = new ArrayList<QueryAnnotation>();

    public QueryNodeListener(Map<Interval, Long> nodeIntervalToID) {
        this.nodeIntervalToID = nodeIntervalToID;
        if (this.nodeIntervalToID == null) {
            this.nodeIntervalToID = new HashMap<Interval, Long>();
        }
    }

    public QueryData getQueryData() {
        return this.data;
    }

    public List<QueryAnnotation> getMetaData() {
        return this.metaData;
    }

    @Override
    public void enterOrTop(AqlParser.OrTopContext ctx) {
        this.data = new QueryData();
        this.tokenPositions = new ArrayList<Map<Interval, QueryNode>>();
    }

    @Override
    public void enterAndExpr(AqlParser.AndExprContext ctx) {
        this.currentAlternative.clear();
        this.localNodes.clear();
        this.currentTokenPosition.clear();
    }

    @Override
    public void exitAndExpr(AqlParser.AndExprContext ctx) {
        this.data.addAlternative(new ArrayList<QueryNode>(this.currentAlternative.values()));
        this.tokenPositions.add(new HashMap<Interval, QueryNode>(this.currentTokenPosition));
    }

    @Override
    public void enterTokOnlyExpr(AqlParser.TokOnlyExprContext ctx) {
        QueryNode target = this.newNode(ctx);
        target.setToken(true);
    }

    @Override
    public void enterNodeExpr(AqlParser.NodeExprContext ctx) {
        this.newNode(ctx);
    }

    @Override
    public void enterTokTextExpr(AqlParser.TokTextExprContext ctx) {
        QueryNode target = this.newNode(ctx);
        target.setToken(true);
        QueryNode.TextMatching txtMatch = QueryNodeListener.textMatchingFromSpec(ctx.textSpec(), ctx.NEQ() != null);
        String content = QueryNodeListener.textFromSpec(ctx.textSpec());
        target.setSpannedText(content, txtMatch);
    }

    @Override
    public void enterTextOnly(AqlParser.TextOnlyContext ctx) {
        QueryNode target = this.newNode(ctx);
        target.setSpannedText(QueryNodeListener.textFromSpec(ctx.txt), QueryNodeListener.textMatchingFromSpec(ctx.txt, false));
    }

    @Override
    public void enterAnnoOnlyExpr(AqlParser.AnnoOnlyExprContext ctx) {
        QueryNode target = this.newNode(ctx);
        String namespace = ctx.qName().namespace == null ? null : ctx.qName().namespace.getText();
        QueryAnnotation anno = new QueryAnnotation(namespace, ctx.qName().name.getText());
        target.addNodeAnnotation(anno);
    }

    @Override
    public void enterAnnoEqTextExpr(AqlParser.AnnoEqTextExprContext ctx) {
        QueryNode target = this.newNode(ctx);
        String namespace = ctx.qName().namespace == null ? null : ctx.qName().namespace.getText();
        String name = ctx.qName().name.getText();
        String value = QueryNodeListener.textFromSpec(ctx.txt);
        QueryNode.TextMatching matching = QueryNodeListener.textMatchingFromSpec(ctx.txt, ctx.NEQ() != null);
        QueryAnnotation anno = new QueryAnnotation(namespace, name, value, matching);
        target.addNodeAnnotation(anno);
    }

    @Override
    public void enterMetaTermExpr(AqlParser.MetaTermExprContext ctx) {
        String namespace = ctx.id.namespace == null ? null : ctx.id.namespace.getText();
        String name = ctx.id.name.getText();
        String value = QueryNodeListener.textFromSpec(ctx.txt);
        QueryNode.TextMatching textMatching = QueryNodeListener.textMatchingFromSpec(ctx.txt, ctx.NEQ() != null);
        QueryAnnotation anno = new QueryAnnotation(namespace, name, value, textMatching);
        this.metaData.add(anno);
    }

    @Override
    public void enterNamedVariableTermExpr(AqlParser.NamedVariableTermExprContext ctx) {
        this.lastVariableDefinition = null;
        if (ctx != null) {
            String text = ctx.VAR_DEF().getText();
            this.lastVariableDefinition = text.endsWith("#") ? text.substring(0, text.length() - 1) : text;
        }
    }

    @Override
    public void enterReferenceNode(AqlParser.ReferenceNodeContext ctx) {
        if (ctx != null && ctx.VAR_DEF() != null) {
            this.lastVariableDefinition = null;
            String text = ctx.VAR_DEF().getText();
            this.lastVariableDefinition = text.endsWith("#") ? text.substring(0, text.length() - 1) : text;
        }
    }

    protected static String textFromSpec(AqlParser.TextSpecContext txtCtx) {
        if (txtCtx instanceof AqlParser.EmptyExactTextSpecContext || txtCtx instanceof AqlParser.EmptyRegexTextSpecContext) {
            return "";
        }
        if (txtCtx instanceof AqlParser.ExactTextSpecContext) {
            return ((AqlParser.ExactTextSpecContext)txtCtx).content.getText();
        }
        if (txtCtx instanceof AqlParser.RegexTextSpecContext) {
            String text = ((AqlParser.RegexTextSpecContext)txtCtx).content.getText();
            try {
                Pattern.compile(text);
            }
            catch (PatternSyntaxException ex) {
                throw new AnnisQLSyntaxException("Invalid regular expression: " + ex.getMessage());
            }
            return text;
        }
        return null;
    }

    protected static QueryNode.TextMatching textMatchingFromSpec(AqlParser.TextSpecContext txt, boolean not) {
        if (txt instanceof AqlParser.ExactTextSpecContext || txt instanceof AqlParser.EmptyExactTextSpecContext) {
            return not ? QueryNode.TextMatching.EXACT_NOT_EQUAL : QueryNode.TextMatching.EXACT_EQUAL;
        }
        if (txt instanceof AqlParser.RegexTextSpecContext || txt instanceof AqlParser.EmptyRegexTextSpecContext) {
            return not ? QueryNode.TextMatching.REGEXP_NOT_EQUAL : QueryNode.TextMatching.REGEXP_EQUAL;
        }
        return null;
    }

    private QueryNode newNode(ParserRuleContext ctx) {
        Long existingID = this.nodeIntervalToID.get(ctx.getSourceInterval());
        if (existingID == null) {
            throw new IllegalStateException("Could not find a node ID for interval " + ctx.getSourceInterval().toString());
        }
        QueryNode n = new QueryNode(existingID.longValue());
        if (this.lastVariableDefinition == null) {
            n.setVariable("" + n.getId());
        } else {
            n.setVariable(this.lastVariableDefinition);
        }
        this.lastVariableDefinition = null;
        n.setParseLocation(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()));
        this.currentAlternative.put(existingID, n);
        this.localNodes.put((Object)n.getVariable(), (Object)n);
        this.currentTokenPosition.put(ctx.getSourceInterval(), n);
        return n;
    }

    public List<Map<Interval, QueryNode>> getTokenPositions() {
        return this.tokenPositions;
    }
}

