/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import annis.model.QueryAnnotation;
import annis.model.QueryNode;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryData
implements Cloneable {
    private static final Logger log = LoggerFactory.getLogger(QueryData.class);
    private List<List<QueryNode>> alternatives = new ArrayList<List<QueryNode>>();
    private List<String> corpusList = new ArrayList<String>();
    private List<Long> documents = new ArrayList<Long>();
    private List<QueryAnnotation> metaData = new ArrayList<QueryAnnotation>();
    private int maxWidth;
    private Set<Object> extensions = new HashSet<Object>();
    private HashMap<String, Properties> corpusConfiguration;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<List<QueryNode>> itOr = this.getAlternatives().iterator();
        sb.append("ALTERNATIVES\n");
        while (itOr.hasNext()) {
            sb.append("\t");
            List<QueryNode> nextNodes = itOr.next();
            Iterator<QueryNode> itAnd = nextNodes.iterator();
            while (itAnd.hasNext()) {
                sb.append("{").append(itAnd.next());
                sb.append("}");
                if (!itAnd.hasNext()) continue;
                sb.append(" AND ");
            }
            if (!itOr.hasNext()) continue;
            sb.append("\n");
        }
        Iterator<QueryAnnotation> itMeta = this.getMetaData().iterator();
        if (itMeta.hasNext()) {
            sb.append("META");
            sb.append("\n");
        }
        while (itMeta.hasNext()) {
            sb.append("\t").append(itMeta.next().toString());
            sb.append("\n");
        }
        if (!this.extensions.isEmpty()) {
            sb.append("EXTENSIONS\n");
        }
        for (Object extension : this.extensions) {
            String toString = extension.toString();
            if ("".equals(toString)) continue;
            sb.append("\t" + toString + "\n");
        }
        return sb.toString();
    }

    public static String toAQL(List<QueryNode> alternative) {
        String frag;
        LinkedList<String> fragments = new LinkedList<String>();
        for (QueryNode n : alternative) {
            frag = n.toAQLNodeFragment();
            if (frag == null || frag.isEmpty()) continue;
            fragments.add(frag);
        }
        for (QueryNode n : alternative) {
            frag = n.toAQLEdgeFragment();
            if (frag == null || frag.isEmpty()) continue;
            fragments.add(frag);
        }
        return Joiner.on((String)" & ").join(fragments);
    }

    public String toAQL() {
        StringBuilder sb = new StringBuilder();
        Iterator<List<QueryNode>> itAlternative = this.alternatives.iterator();
        while (itAlternative.hasNext()) {
            List<QueryNode> alt = itAlternative.next();
            if (this.alternatives.size() > 1) {
                sb.append("(");
            }
            sb.append(QueryData.toAQL(alt));
            if (this.alternatives.size() <= 1) continue;
            sb.append(")");
            if (!itAlternative.hasNext()) continue;
            sb.append("\n|\n");
        }
        return sb.toString();
    }

    public List<List<QueryNode>> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(List<List<QueryNode>> alternatives) {
        this.alternatives = alternatives;
    }

    public List<String> getCorpusList() {
        return this.corpusList;
    }

    public void setCorpusList(List<String> corpusList) {
        this.corpusList = corpusList;
    }

    public List<QueryAnnotation> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(List<QueryAnnotation> metaData) {
        this.metaData = metaData;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public boolean addAlternative(List<QueryNode> nodes) {
        return this.alternatives.add(nodes);
    }

    public boolean addMetaAnnotations(List<QueryAnnotation> annotations) {
        return this.metaData.addAll(annotations);
    }

    public QueryData clone() {
        try {
            return (QueryData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            log.error(null, (Throwable)ex);
            throw new InternalError("could not clone QueryData");
        }
    }

    public List<Long> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Long> documents) {
        this.documents = documents;
    }

    public Set<Object> getExtensions() {
        return this.extensions;
    }

    public <T> List<T> getExtensions(Class<T> clazz) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object o : this.extensions) {
            if (!clazz.isInstance(o)) continue;
            result.add(o);
        }
        return result;
    }

    public boolean addExtension(Object extension) {
        return this.extensions.add(extension);
    }

    public HashMap<String, Properties> getCorpusConfiguration() {
        return this.corpusConfiguration;
    }

    public void setCorpusConfiguration(HashMap<String, Properties> corpusConfiguration) {
        this.corpusConfiguration = corpusConfiguration;
    }
}

