/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class LogicClause {
    private Operator op = Operator.LEAF;
    private List<LogicClause> children = new ArrayList<LogicClause>();
    private List<? extends Token> content = null;
    private LogicClause parent = null;

    public LogicClause() {
    }

    public LogicClause(Operator op) {
        this();
        this.op = op;
    }

    public LogicClause(LogicClause other) {
        this();
        this.op = other.op;
        this.parent = other.parent;
        this.content = new ArrayList<Token>(other.content);
        this.children.addAll(other.children);
    }

    public Operator getOp() {
        return this.op;
    }

    public void setOp(Operator op) {
        this.op = op;
    }

    public ImmutableList<LogicClause> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public void addAllChildren(Collection<LogicClause> children) {
        if (children != null) {
            for (LogicClause c : children) {
                this.addChild(c);
            }
        }
    }

    public void addChild(LogicClause child) {
        Preconditions.checkArgument((child != this ? 1 : 0) != 0, (Object)"Cannot add itself as children");
        child.parent = this;
        this.children.add(child);
    }

    public void addChild(int idx, LogicClause child) {
        Preconditions.checkArgument((child != this ? 1 : 0) != 0, (Object)"Cannot add itself as children");
        child.parent = this;
        this.children.add(idx, child);
    }

    public LogicClause removeChild(int idx) {
        LogicClause result = this.children.remove(idx);
        if (result != null && result.parent == this) {
            result.parent = null;
        }
        return result;
    }

    public void clearChildren() {
        for (LogicClause c : this.children) {
            if (c.parent != this) continue;
            c.parent = null;
        }
        this.children.clear();
    }

    public List<? extends Token> getContent() {
        return this.content;
    }

    public void setContent(List<? extends Token> content) {
        this.content = content;
    }

    public List<Token> getCoveredToken() {
        LinkedList<Token> result = new LinkedList<Token>();
        if (!(this.content == null || this.content.isEmpty() || this.op != Operator.AND && this.op != Operator.OR)) {
            Iterator<LogicClause> itChild = this.children.iterator();
            while (itChild.hasNext()) {
                result.addAll(itChild.next().getCoveredToken());
                if (!itChild.hasNext()) continue;
                result.addAll(this.content);
            }
        } else if (this.op == Operator.LEAF && this.content != null) {
            result.addAll(this.content);
        } else {
            for (LogicClause child : this.children) {
                result.addAll(child.getCoveredToken());
            }
        }
        return result;
    }

    public LogicClause getParent() {
        return this.parent;
    }

    public String toString() {
        if (this.op == Operator.AND) {
            return "(" + Joiner.on((String)" & ").join(this.children) + ")";
        }
        if (this.op == Operator.OR) {
            return "(" + Joiner.on((String)" \n| \n").join(this.children) + ")";
        }
        LinkedList<String> texts = new LinkedList<String>();
        if (this.content != null) {
            for (Token token : this.content) {
                texts.add(token.getText());
            }
        }
        return Joiner.on((String)" ").join(texts);
    }

    public static enum Operator {
        AND,
        OR,
        LEAF;


        public String toString() {
            return super.toString();
        }
    }
}

