/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.antlr.v4.runtime.Token;
import org.corpus_tools.annis.ql.parser.LogicClause;

public class DNFTransformer {
    public static void toDNF(LogicClause topNode) {
        while (!DNFTransformer.makeDNF(topNode)) {
        }
        DNFTransformer.cleanEmptyLeafs(topNode);
        DNFTransformer.flattenDNF(topNode);
    }

    private static boolean makeDNF(LogicClause node) {
        if (node.getOp() == LogicClause.Operator.LEAF || node.getChildren().size() < 2) {
            return true;
        }
        LogicClause left = (LogicClause)node.getChildren().get(0);
        LogicClause right = (LogicClause)node.getChildren().get(1);
        if (node.getOp() == LogicClause.Operator.AND) {
            LogicClause x1 = null;
            LogicClause x2 = null;
            LogicClause y = null;
            LogicClause z = null;
            List<? extends Token> orToken = null;
            if (right.getOp() == LogicClause.Operator.OR) {
                x1 = left;
                x2 = new LogicClause(x1);
                orToken = right.getContent();
                Preconditions.checkArgument((right.getChildren().size() == 2 ? 1 : 0) != 0, (Object)"OR nodes must always have exactly two children");
                y = (LogicClause)right.getChildren().get(0);
                z = (LogicClause)right.getChildren().get(1);
            } else if (left.getOp() == LogicClause.Operator.OR) {
                x1 = right;
                x2 = new LogicClause(x1);
                orToken = left.getContent();
                Preconditions.checkArgument((left.getChildren().size() == 2 ? 1 : 0) != 0, (Object)"OR nodes must always have exactly two children");
                y = (LogicClause)left.getChildren().get(0);
                z = (LogicClause)left.getChildren().get(1);
            }
            if (x1 != null && x2 != null && y != null && z != null) {
                LogicClause leftParentAnd = new LogicClause(LogicClause.Operator.AND);
                LogicClause rightParentAnd = new LogicClause(LogicClause.Operator.AND);
                leftParentAnd.setContent(new ArrayList<Token>(node.getContent()));
                rightParentAnd.setContent(new ArrayList<Token>(node.getContent()));
                node.setOp(LogicClause.Operator.OR);
                node.setContent(orToken);
                node.clearChildren();
                node.addChild(leftParentAnd);
                node.addChild(rightParentAnd);
                leftParentAnd.addChild(x1);
                leftParentAnd.addChild(y);
                rightParentAnd.addChild(x2);
                rightParentAnd.addChild(z);
                return false;
            }
        }
        return DNFTransformer.makeDNF(left) && DNFTransformer.makeDNF(right);
    }

    private static void cleanEmptyLeafs(LogicClause clause) {
        if (clause == null || clause.getOp() == LogicClause.Operator.LEAF) {
            return;
        }
        LinkedList<LogicClause> childListCopy = new LinkedList<LogicClause>((Collection<LogicClause>)clause.getChildren());
        clause.clearChildren();
        ListIterator itChildren = childListCopy.listIterator();
        while (itChildren.hasNext()) {
            LogicClause n = (LogicClause)itChildren.next();
            if (n.getOp() == LogicClause.Operator.LEAF && n.getContent() == null) continue;
            clause.addChild(n);
        }
        for (LogicClause c : clause.getChildren()) {
            DNFTransformer.cleanEmptyLeafs(c);
        }
    }

    private static void flattenDNF(LogicClause top) {
        if (top.getOp() == LogicClause.Operator.LEAF || top.getOp() == LogicClause.Operator.AND) {
            ArrayList<LogicClause> children = new ArrayList<LogicClause>();
            DNFTransformer.findAllChildrenForOp(top, children, LogicClause.Operator.AND);
            List<? extends Token> orginalAndContent = top.getContent();
            top.setOp(LogicClause.Operator.OR);
            top.clearChildren();
            top.setContent(null);
            LogicClause andClause = new LogicClause(LogicClause.Operator.AND);
            andClause.setContent(orginalAndContent);
            top.addChild(andClause);
            andClause.addAllChildren(children);
        } else if (top.getOp() == LogicClause.Operator.OR) {
            ArrayList<LogicClause> allOrNodes = new ArrayList<LogicClause>();
            DNFTransformer.findAllChildrenForOp(top, allOrNodes, LogicClause.Operator.OR, true);
            top.clearChildren();
            top.addAllChildren(allOrNodes);
            for (LogicClause subclause : top.getChildren()) {
                if (subclause.getOp() == LogicClause.Operator.LEAF) {
                    List<? extends Token> content = subclause.getContent();
                    subclause.clearChildren();
                    subclause.setOp(LogicClause.Operator.AND);
                    subclause.setContent(null);
                    LogicClause newLeaf = new LogicClause(LogicClause.Operator.LEAF);
                    newLeaf.setContent(content);
                    subclause.addChild(newLeaf);
                    continue;
                }
                if (subclause.getOp() == LogicClause.Operator.AND) {
                    ArrayList<LogicClause> children = new ArrayList<LogicClause>();
                    DNFTransformer.findAllChildrenForOp(subclause, children, LogicClause.Operator.AND);
                    subclause.clearChildren();
                    for (LogicClause c : children) {
                        subclause.addChild(c);
                    }
                    continue;
                }
                Preconditions.checkArgument((boolean)false, (Object)"input is not in DNF");
            }
        }
    }

    private static void findAllChildrenForOp(LogicClause node, List<LogicClause> followers, LogicClause.Operator op) {
        DNFTransformer.findAllChildrenForOp(node, followers, op, false);
    }

    private static void findAllChildrenForOp(LogicClause node, List<LogicClause> followers, LogicClause.Operator op, boolean addOtherOpsAsChild) {
        if (node.getOp() == LogicClause.Operator.LEAF || addOtherOpsAsChild && node.getOp() != op) {
            followers.add(new LogicClause(node));
            return;
        }
        if (!addOtherOpsAsChild) {
            Preconditions.checkArgument((node.getOp() == op ? 1 : 0) != 0, (Object)"BUG: Wrong operator found");
        }
        for (LogicClause c : node.getChildren()) {
            DNFTransformer.findAllChildrenForOp(c, followers, op, addOtherOpsAsChild);
        }
    }
}

