/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import annis.exceptions.AnnisQLSemanticsException;
import annis.exceptions.AnnisQLSyntaxException;
import annis.model.AqlParseError;
import annis.model.ParsedEntityLocation;
import com.google.common.base.Joiner;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.corpus_tools.annis.ql.AqlLexer;
import org.corpus_tools.annis.ql.AqlParser;
import org.corpus_tools.annis.ql.RawAqlPreParser;
import org.corpus_tools.annis.ql.parser.DNFTransformer;
import org.corpus_tools.annis.ql.parser.JoinListener;
import org.corpus_tools.annis.ql.parser.ListTokenSource;
import org.corpus_tools.annis.ql.parser.LogicClause;
import org.corpus_tools.annis.ql.parser.NodeIDListener;
import org.corpus_tools.annis.ql.parser.QueryData;
import org.corpus_tools.annis.ql.parser.QueryDataTransformer;
import org.corpus_tools.annis.ql.parser.QueryNodeListener;
import org.corpus_tools.annis.ql.parser.RawAqlListener;
import org.corpus_tools.annis.ql.parser.SemanticValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnisParserAntlr {
    private static final Logger log = LoggerFactory.getLogger(AnnisParserAntlr.class);
    private int precedenceBound;
    private final List<QueryDataTransformer> postProcessors = new LinkedList<QueryDataTransformer>();

    public AnnisParserAntlr() {
        this.postProcessors.add(new SemanticValidator());
        this.precedenceBound = 0;
    }

    public QueryData parse(String aql, List<String> corpusList) {
        LinkedList<AqlParseError> errors = new LinkedList<AqlParseError>();
        AqlLexer lexerNonDNF = new AqlLexer((CharStream)new ANTLRInputStream(aql));
        lexerNonDNF.removeErrorListeners();
        lexerNonDNF.addErrorListener((ANTLRErrorListener)new AqlLexerErrorListener(errors));
        RawAqlPreParser rawParser = new RawAqlPreParser((TokenStream)new CommonTokenStream((TokenSource)lexerNonDNF));
        rawParser.removeErrorListeners();
        rawParser.addErrorListener((ANTLRErrorListener)new AqlParseErrorListener(errors));
        RawAqlPreParser.StartContext treeRaw = rawParser.start();
        if (!errors.isEmpty()) {
            throw new AnnisQLSyntaxException(Joiner.on((String)"\n").join(errors), errors);
        }
        ParseTreeWalker walkerRaw = new ParseTreeWalker();
        RawAqlListener listenerRaw = new RawAqlListener();
        walkerRaw.walk((ParseTreeListener)listenerRaw, (ParseTree)treeRaw);
        LogicClause topNode = listenerRaw.getRoot();
        DNFTransformer.toDNF(topNode);
        ListTokenSource source = new ListTokenSource(topNode.getCoveredToken());
        AqlParser parserDNF = new AqlParser((TokenStream)new CommonTokenStream((TokenSource)source));
        parserDNF.removeErrorListeners();
        parserDNF.addErrorListener((ANTLRErrorListener)new AqlParseErrorListener(errors));
        AqlParser.StartContext treeDNF = parserDNF.start();
        if (!errors.isEmpty()) {
            throw new AnnisQLSyntaxException(Joiner.on((String)"\n").join(errors), errors);
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        NodeIDListener idListener = new NodeIDListener();
        walker.walk((ParseTreeListener)idListener, (ParseTree)treeDNF);
        QueryNodeListener nodeListener = new QueryNodeListener(idListener.getNodeIntervalToID());
        try {
            walker.walk((ParseTreeListener)nodeListener, (ParseTree)treeDNF);
            QueryData data = nodeListener.getQueryData();
            data.setCorpusList(corpusList);
            data.addMetaAnnotations(nodeListener.getMetaData());
            JoinListener joinListener = new JoinListener(data, this.precedenceBound, nodeListener.getTokenPositions());
            walker.walk((ParseTreeListener)joinListener, (ParseTree)treeDNF);
            if (this.postProcessors != null) {
                for (QueryDataTransformer transformer : this.postProcessors) {
                    data = transformer.transform(data);
                }
            }
            return data;
        }
        catch (NullPointerException ex) {
            log.warn("Null pointer exception occured during parsing", (Throwable)ex);
            throw new AnnisQLSemanticsException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new AnnisQLSemanticsException(ex.getMessage());
        }
    }

    public String dumpTree(String aql) {
        AqlLexer lexer = new AqlLexer((CharStream)new ANTLRInputStream(aql));
        AqlParser parser = new AqlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        LinkedList<AqlParseError> errors = new LinkedList<AqlParseError>();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new AqlParseErrorListener(errors));
        AqlParser.StartContext tree = parser.start();
        if (errors.isEmpty()) {
            return tree.toStringTree();
        }
        throw new AnnisQLSyntaxException(Joiner.on((String)"\n").join(errors), errors);
    }

    public int getPrecedenceBound() {
        return this.precedenceBound;
    }

    public void setPrecedenceBound(int precedenceBound) {
        this.precedenceBound = precedenceBound;
    }

    public static ParsedEntityLocation getLocation(Token start, Token stop) {
        if (start == null) {
            return new ParsedEntityLocation();
        }
        if (stop == null) {
            stop = start;
        }
        int startLine = start.getLine();
        int endLine = stop.getLine();
        int startColumn = start.getCharPositionInLine();
        String stopTokenText = stop.getText();
        int endColumn = stop.getCharPositionInLine();
        if (stopTokenText != null && !stopTokenText.isEmpty()) {
            endColumn += stopTokenText.length() - 1;
        }
        return new ParsedEntityLocation(startLine, startColumn, endLine, endColumn);
    }

    public static class AqlParseErrorListener
    extends BaseErrorListener {
        private final List<AqlParseError> errors;

        public AqlParseErrorListener(List<AqlParseError> errors) {
            this.errors = errors;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (this.errors != null && offendingSymbol instanceof Token) {
                Token t = (Token)offendingSymbol;
                this.errors.add(new AqlParseError(AnnisParserAntlr.getLocation(t, t), msg));
            }
        }
    }

    public static class AqlLexerErrorListener
    extends BaseErrorListener {
        private final List<AqlParseError> errors;

        public AqlLexerErrorListener(List<AqlParseError> errors) {
            this.errors = errors;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (this.errors != null) {
                ParsedEntityLocation loc = new ParsedEntityLocation(line, charPositionInLine, line, charPositionInLine);
                this.errors.add(new AqlParseError(loc, msg));
            }
        }
    }

    public static class StringListErrorListener
    extends BaseErrorListener {
        private final List<String> errors;

        public StringListErrorListener(List<String> errors) {
            this.errors = errors;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (this.errors != null) {
                this.errors.add("line " + line + ":" + charPositionInLine + " " + msg);
            }
        }
    }
}

