/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.model;

import annis.model.QueryNode;
import org.corpus_tools.annis.ql.model.RangedJoin;

public class Precedence
extends RangedJoin {
    private String segmentationName;

    public Precedence(QueryNode target) {
        this(target, 0, 0);
    }

    public Precedence(QueryNode target, String segmentationName) {
        this(target, 0, 0, segmentationName);
    }

    public Precedence(QueryNode target, int distance) {
        this(target, distance, distance);
    }

    public Precedence(QueryNode target, int distance, String segmentationName) {
        this(target, distance, distance, segmentationName);
    }

    public Precedence(QueryNode target, int minDistance, int maxDistance) {
        this(target, minDistance, maxDistance, null);
    }

    public Precedence(QueryNode target, int minDistance, int maxDistance, String segmentationName) {
        super(target, minDistance, maxDistance);
        this.segmentationName = segmentationName;
    }

    public String getSegmentationName() {
        return this.segmentationName;
    }

    public void setSegmentationName(String segmentationName) {
        this.segmentationName = segmentationName;
    }

    public String toString() {
        return "precedes node " + this.target.getId() + " (" + this.segmentationName + " " + this.minDistance + ", " + this.maxDistance + ")";
    }

    public String toAqlOperator() {
        String extraDistance = "";
        if (this.minDistance == 0 && this.maxDistance == 0) {
            extraDistance = "*";
        } else if (this.minDistance > 1 && this.minDistance == this.maxDistance) {
            extraDistance = "" + this.minDistance;
        } else if (this.minDistance > 1 || this.maxDistance > 1) {
            extraDistance = "" + this.minDistance + "," + this.maxDistance;
        }
        if (this.segmentationName == null) {
            return "." + extraDistance;
        }
        return "." + this.segmentationName + " " + extraDistance;
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Precedence other = (Precedence)((Object)obj);
        if (this.segmentationName == null ? other.segmentationName != null : !this.segmentationName.equals(other.segmentationName)) {
            return false;
        }
        return super.equals(obj);
    }
}

