/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.model;

import annis.model.QueryNode;
import org.corpus_tools.annis.ql.model.RankTableJoin;

public class PointingRelation
extends RankTableJoin {
    public PointingRelation(QueryNode target, String name) {
        this(target, name, 0, 0);
    }

    public PointingRelation(QueryNode target, String name, int distance) {
        this(target, name, distance, distance);
    }

    public PointingRelation(QueryNode target, String name, int minDistance, int maxDistance) {
        super(target, name, minDistance, maxDistance);
    }

    public String toString() {
        return "points to node " + this.target.getId() + " (" + this.name + ", " + this.minDistance + ", " + this.maxDistance + ")";
    }

    public String toAqlOperator() {
        String extraDistance = "";
        if (this.minDistance == 0 && this.maxDistance == 0) {
            extraDistance = "*";
        } else if (this.minDistance > 1 && this.minDistance == this.maxDistance) {
            extraDistance = "" + this.minDistance;
        } else if (this.minDistance > 1 || this.maxDistance > 1) {
            extraDistance = "" + this.minDistance + "," + this.maxDistance;
        }
        if (this.name == null) {
            return "->" + extraDistance;
        }
        return "->" + this.name + " " + extraDistance;
    }
}

