/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.corpus_tools.graphannis.API;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaltImport {
    public static final String ANNIS_NS = "annis";
    private static final Logger log = LoggerFactory.getLogger(SaltImport.class);
    private final API.GraphUpdate updateList = new API.GraphUpdate();

    public API.GraphUpdate finish() {
        return this.updateList;
    }

    public SaltImport map(SDocumentGraph g) {
        String targetName;
        String sourceName;
        for (SNode n : g.getNodes()) {
            this.addNode(n);
        }
        this.addTokenInformation(g);
        for (SNode n : g.getNodes()) {
            this.addCoverageInformation(n, g);
        }
        for (SDominanceRelation rel : g.getDominanceRelations()) {
            sourceName = SaltImport.nodeName((SNode)rel.getSource());
            targetName = SaltImport.nodeName((SNode)rel.getTarget());
            for (String l : SaltImport.getLayerNames(rel.getLayers())) {
                if (rel.getType() != null) {
                    this.updateList.addEdge(sourceName, targetName, l, "DOMINANCE", rel.getType());
                    this.addEdgeLabels((SRelation<?, ?>)rel, l, "DOMINANCE", rel.getType());
                }
                this.updateList.addEdge(sourceName, targetName, l, "DOMINANCE", "");
                this.addEdgeLabels((SRelation<?, ?>)rel, l, "DOMINANCE", "");
            }
        }
        for (SDominanceRelation rel : g.getPointingRelations()) {
            sourceName = SaltImport.nodeName((SNode)rel.getSource());
            targetName = SaltImport.nodeName((SNode)rel.getTarget());
            for (String l : SaltImport.getLayerNames(rel.getLayers())) {
                this.updateList.addEdge(sourceName, targetName, l, "POINTING", "" + rel.getType());
                this.addEdgeLabels((SRelation<?, ?>)rel, l, "POINTING", "" + rel.getType());
            }
        }
        return this;
    }

    private void addTokenInformation(SDocumentGraph g) {
        SToken lastToken = null;
        STextualDS lastTextDS = null;
        List sortedToken = g.getSortedTokenByText();
        if (sortedToken != null) {
            for (SToken t : sortedToken) {
                String nodeName = SaltImport.nodeName((SNode)t);
                this.updateList.addNodeLabel(nodeName, ANNIS_NS, "tok", g.getText((SNode)t));
                STextualDS textDS = SaltImport.getTextForToken(t);
                if (lastToken != null && textDS == lastTextDS) {
                    this.updateList.addEdge(SaltImport.nodeName((SNode)lastToken), nodeName, ANNIS_NS, "ORDERING", "");
                }
                lastToken = t;
                lastTextDS = textDS;
            }
        }
    }

    private void addCoverageInformation(SNode node, SDocumentGraph graph) {
        List overlappedToken;
        if (node instanceof SToken) {
            overlappedToken = Arrays.asList((SToken)node);
        } else if (node instanceof SStructure) {
            overlappedToken = graph.getOverlappedTokens(node, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION, SALT_TYPE.SDOMINANCE_RELATION});
        } else {
            if (node instanceof STextualDS) {
                return;
            }
            overlappedToken = graph.getOverlappedTokens(node, new SALT_TYPE[]{SALT_TYPE.SSPANNING_RELATION});
        }
        if (overlappedToken.isEmpty()) {
            log.warn("Node {} is not connected to any token. This is invalid for graphANNIS and the node will be excluded.", (Object)node.getId());
            return;
        }
        List sortedOverlappedToken = graph.getSortedTokenByText(overlappedToken);
        String name = SaltImport.nodeName(node);
        String firstOverlappedToken = SaltImport.nodeName((SNode)sortedOverlappedToken.get(0));
        String lastOverlappedToken = SaltImport.nodeName((SNode)sortedOverlappedToken.get(sortedOverlappedToken.size() - 1));
        this.updateList.addEdge(firstOverlappedToken, name, ANNIS_NS, "LEFT_TOKEN", "");
        this.updateList.addEdge(name, firstOverlappedToken, ANNIS_NS, "LEFT_TOKEN", "");
        this.updateList.addEdge(lastOverlappedToken, name, ANNIS_NS, "RIGHT_TOKEN", "");
        this.updateList.addEdge(name, lastOverlappedToken, ANNIS_NS, "RIGHT_TOKEN", "");
        for (SToken covered : sortedOverlappedToken) {
            this.updateList.addEdge(name, SaltImport.nodeName((SNode)covered), ANNIS_NS, "COVERAGE", "");
            this.updateList.addEdge(SaltImport.nodeName((SNode)covered), name, ANNIS_NS, "INVERSE_COVERAGE", "");
        }
    }

    private static String documentName(SNode node) {
        String[] segments;
        if (node != null && (segments = node.getPath().segments()).length > 0) {
            return segments[segments.length - 1];
        }
        return null;
    }

    private static String documentPath(SNode node) {
        Object[] segments;
        if (node != null && (segments = node.getPath().segments()).length > 0) {
            return Joiner.on((String)"/").join(segments);
        }
        return null;
    }

    private static String nodeName(SNode node) {
        if (node != null) {
            String path = SaltImport.documentPath(node);
            return path == null ? "#" + node.getPath().fragment() : path + "#" + node.getPath().fragment();
        }
        return null;
    }

    private static STextualDS getTextForToken(SToken t) {
        List out = t.getOutRelations();
        if (out != null) {
            for (SRelation rel : out) {
                if (!(rel instanceof STextualRelation)) continue;
                return (STextualDS)((STextualRelation)rel).getTarget();
            }
        }
        return null;
    }

    private static Set<String> getLayerNames(Set<SLayer> layers) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (layers == null || layers.isEmpty()) {
            result.add("");
        } else {
            for (SLayer l : layers) {
                result.add(l.getName());
            }
        }
        return result;
    }

    private void addNode(SNode n) {
        if (n instanceof SStructuredNode) {
            String name = SaltImport.nodeName(n);
            this.updateList.addNode(name);
            for (SAnnotation anno : n.getAnnotations()) {
                this.updateList.addNodeLabel(name, anno.getNamespace(), anno.getName(), anno.getValue_STEXT());
            }
        }
    }

    private void addEdgeLabels(SRelation<?, ?> rel, String layer, String componentType, String componentName) {
        Set annos = rel.getAnnotations();
        if (annos != null) {
            for (SAnnotation anno : annos) {
                this.updateList.addEdgeLabel(SaltImport.nodeName((SNode)rel.getSource()), SaltImport.nodeName((SNode)rel.getTarget()), layer, componentType, componentName, anno.getNamespace(), anno.getName(), anno.getValue_STEXT());
            }
        }
    }
}

