/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis;

import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.bytedeco.javacpp.BytePointer;
import org.corpus_tools.graphannis.API;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.SaltUtil;

public class SaltExport {
    private static void mapLabels(SAnnotationContainer n, API.StringMap labels) {
        API.StringMap.Iterator it = labels.begin();
        while (!it.equals(labels.end())) {
            String value;
            Pair qname = SaltUtil.splitQName((String)it.first().getString());
            String string = value = it.second() == null ? null : it.second().getString();
            if ("annis".equals(qname.getKey())) {
                n.createFeature((String)qname.getKey(), (String)qname.getValue(), (Object)value);
            } else {
                n.createAnnotation((String)qname.getKey(), (String)qname.getValue(), (Object)value);
            }
            it = it.increment();
        }
    }

    private static boolean hasDominanceEdge(API.Node n) {
        for (long i = 0L; i < n.outgoingEdges().size(); ++i) {
            API.Edge e = n.outgoingEdges().get(i);
            if (!"DOMINANCE".equals(e.componentType().getString())) continue;
            return true;
        }
        return false;
    }

    private static SNode mapNode(API.Node n) {
        Object newNode = n.labels().get(new BytePointer("annis::tok")) != null ? SaltFactory.createSToken() : (SaltExport.hasDominanceEdge(n) ? SaltFactory.createSStructure() : SaltFactory.createSSpan());
        BytePointer nodeID = n.labels().get(new BytePointer("annis::node_name"));
        if (nodeID != null) {
            String nodeIDString = nodeID.getString();
            if (!nodeIDString.startsWith("salt:/")) {
                nodeIDString = "salt:/" + nodeIDString;
            }
            newNode.setId(nodeIDString);
            newNode.setName(newNode.getPath().fragment());
        }
        SaltExport.mapLabels((SAnnotationContainer)newNode, n.labels());
        return newNode;
    }

    private static void mapAndAddEdge(SDocumentGraph g, API.Node node, API.Edge origEdge, Map<Long, SNode> nodesByID) {
        SNode source = nodesByID.get(origEdge.sourceID());
        SNode target = nodesByID.get(origEdge.targetID());
        String edgeType = null;
        if (source != null && target != null && source != target) {
            if (origEdge.componentName() != null) {
                edgeType = origEdge.componentName().getString();
            }
            SRelation rel = null;
            switch (origEdge.componentType().getString()) {
                case "DOMINANCE": {
                    if (edgeType == null || edgeType.isEmpty()) {
                        for (long i = 0L; i < node.outgoingEdges().size(); ++i) {
                            API.Edge outEdge = node.outgoingEdges().get(i);
                            if (outEdge.targetID() != origEdge.targetID() || outEdge.componentName() == null || outEdge.componentName().getString().isEmpty()) continue;
                            return;
                        }
                    }
                    rel = g.createRelation(source, target, SALT_TYPE.SDOMINANCE_RELATION, null);
                    break;
                }
                case "POINTING": {
                    rel = g.createRelation(source, target, SALT_TYPE.SPOINTING_RELATION, null);
                    break;
                }
                case "ORDERING": {
                    rel = g.createRelation(source, target, SALT_TYPE.SORDER_RELATION, null);
                    break;
                }
                case "COVERAGE": {
                    if (!(source instanceof SSpan) || !(target instanceof SToken)) break;
                    rel = g.createRelation(source, target, SALT_TYPE.SSPANNING_RELATION, null);
                }
            }
            if (rel != null) {
                String layerName;
                if (edgeType != null) {
                    rel.setType(edgeType);
                }
                SaltExport.mapLabels((SAnnotationContainer)rel, origEdge.labels());
                String string = layerName = origEdge.componentLayer() == null ? null : origEdge.componentLayer().getString();
                if (layerName != null && !layerName.isEmpty()) {
                    List<SLayer> layer = g.getLayerByName(layerName);
                    if (layer == null || layer.isEmpty()) {
                        SLayer newLayer = SaltFactory.createSLayer();
                        newLayer.setName(layerName);
                        g.addLayer((Layer)newLayer);
                        layer = Arrays.asList(newLayer);
                    }
                    ((SLayer)layer.get(0)).addRelation((Relation)rel);
                }
            }
        }
    }

    private static void addNodeLayers(SDocumentGraph g) {
        LinkedList nodeList = new LinkedList(g.getNodes());
        for (SNode n : nodeList) {
            SFeature featLayer = n.getFeature("annis", "layer");
            if (featLayer == null) continue;
            SLayer layer = (SLayer)g.getLayer(featLayer.getValue_STEXT());
            if (layer == null) {
                layer = SaltFactory.createSLayer();
                layer.setName(featLayer.getValue_STEXT());
                g.addLayer((Layer)layer);
            }
            layer.addNode((Node)n);
        }
    }

    private static void recreateText(final String name, List<SNode> rootNodes, SDocumentGraph g) {
        final StringBuilder text = new StringBuilder();
        STextualDS ds = g.createTextualDS("");
        ds.setName(name);
        final HashMap<SToken, Range> token2Range = new HashMap<SToken, Range>();
        g.traverse(rootNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "ORDERING_" + name, new GraphTraverseHandler(){

            public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
                SFeature featTok;
                if (fromNode != null) {
                    text.append(" ");
                }
                if ((featTok = currNode.getFeature("annis::tok")) != null && currNode instanceof SToken) {
                    int idxStart = text.length();
                    text.append(featTok.getValue_STEXT());
                    token2Range.put((SToken)currNode, Range.closed((Comparable)Integer.valueOf(idxStart), (Comparable)Integer.valueOf(text.length())));
                }
            }

            public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            }

            public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
                if (relation == null) {
                    return true;
                }
                return relation instanceof SOrderRelation && Objects.equal((Object)name, (Object)relation.getType());
            }
        });
        ds.setText(text.toString());
        token2Range.forEach((t, r) -> {
            STextualRelation rel = SaltFactory.createSTextualRelation();
            rel.setSource((Node)t);
            rel.setTarget((Node)ds);
            rel.setStart((Number)((Object)r.lowerEndpoint()));
            rel.setEnd((Number)((Object)r.upperEndpoint()));
            g.addRelation((Relation)rel);
        });
    }

    public static SDocumentGraph map(API.NodeVector orig) {
        SDocumentGraph g = SaltFactory.createSDocumentGraph();
        LinkedHashMap<Long, API.Node> nodesByID = new LinkedHashMap<Long, API.Node>();
        for (long i = 0L; i < orig.size(); ++i) {
            nodesByID.put(orig.get(i).id(), orig.get(i));
        }
        LinkedHashMap newNodesByID = new LinkedHashMap();
        for (Map.Entry entry : nodesByID.entrySet()) {
            API.Node v = (API.Node)entry.getValue();
            SNode n2 = SaltExport.mapNode(v);
            newNodesByID.put(entry.getKey(), n2);
        }
        newNodesByID.values().stream().forEach(n -> g.addNode((Node)n));
        nodesByID.values().forEach(n -> {
            for (long i = 0L; i < n.outgoingEdges().size(); ++i) {
                SaltExport.mapAndAddEdge(g, n, n.outgoingEdges().get(i), newNodesByID);
            }
        });
        Multimap orderRoots = g.getRootsByRelationType(SALT_TYPE.SORDER_RELATION);
        orderRoots.keySet().forEach(name -> {
            ArrayList<SNode> roots = new ArrayList<SNode>(orderRoots.get(name));
            if ("salt::NULL".equals(name)) {
                name = null;
            }
            SaltExport.recreateText(name, roots, g);
        });
        SaltExport.addNodeLayers(g);
        return g;
    }
}

