/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis;

import annis.exceptions.AnnisQLSyntaxException;
import annis.model.Join;
import annis.model.QueryAnnotation;
import annis.model.QueryNode;
import annis.sqlgen.model.CommonAncestor;
import annis.sqlgen.model.Dominance;
import annis.sqlgen.model.Inclusion;
import annis.sqlgen.model.LeftDominance;
import annis.sqlgen.model.Overlap;
import annis.sqlgen.model.PointingRelation;
import annis.sqlgen.model.Precedence;
import annis.sqlgen.model.RightDominance;
import annis.sqlgen.model.SameSpan;
import annis.sqlgen.model.Sibling;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.corpus_tools.annis.ql.parser.AnnisParserAntlr;
import org.corpus_tools.annis.ql.parser.QueryData;

public class QueryToJSON {
    private static final JsonNodeFactory factory = new JsonNodeFactory(true);
    private static final JaxbAnnotationModule jaxbModule = new JaxbAnnotationModule();

    public static String aqlToJSON(String aql) {
        AnnisParserAntlr parser = new AnnisParserAntlr();
        QueryData qd = parser.parse(aql, new LinkedList<Long>());
        return QueryToJSON.serializeQuery(qd.getAlternatives(), qd.getMetaData());
    }

    public static String serializeQuery(List<List<QueryNode>> query, List<QueryAnnotation> metaData) {
        return QueryToJSON.queryAsJSON(query, metaData).toString();
    }

    public static ObjectNode queryAsJSON(List<List<QueryNode>> query, List<QueryAnnotation> metaData) {
        ObjectNode root = factory.objectNode();
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)jaxbModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        if (query != null && !query.isEmpty()) {
            ArrayNode alternatives = root.putArray("alternatives");
            for (List<QueryNode> alt : query) {
                ObjectNode altNode = alternatives.addObject();
                ObjectNode nodes = altNode.putObject("nodes");
                ArrayNode joinObject = altNode.putArray("joins");
                for (QueryNode n : alt) {
                    if (n.getSpanTextMatching() == QueryNode.TextMatching.EXACT_NOT_EQUAL || n.getSpanTextMatching() == QueryNode.TextMatching.REGEXP_NOT_EQUAL) {
                        throw new AnnisQLSyntaxException("negation not supported yet");
                    }
                    if (n.isRoot()) {
                        throw new AnnisQLSyntaxException("\"root\" operator not supported yet");
                    }
                    if (n.getArity() != null) {
                        throw new AnnisQLSyntaxException("\"arity\" operator not supported yet");
                    }
                    if (n.getTokenArity() != null) {
                        throw new AnnisQLSyntaxException("\"tokenarity\" operator not supported yet");
                    }
                    for (QueryAnnotation anno : n.getNodeAnnotations()) {
                        if (anno.getTextMatching() != QueryNode.TextMatching.EXACT_NOT_EQUAL && anno.getTextMatching() != QueryNode.TextMatching.REGEXP_NOT_EQUAL) continue;
                        throw new AnnisQLSyntaxException("negation not supported yet");
                    }
                    for (QueryAnnotation anno : n.getEdgeAnnotations()) {
                        if (anno.getTextMatching() != QueryNode.TextMatching.EXACT_NOT_EQUAL && anno.getTextMatching() != QueryNode.TextMatching.REGEXP_NOT_EQUAL) continue;
                        throw new AnnisQLSyntaxException("negation not supported yet");
                    }
                    JsonNode nodeObject = mapper.valueToTree((Object)n);
                    if (nodeObject instanceof ObjectNode) {
                        ((ObjectNode)nodeObject).remove(Arrays.asList("partOfEdge", "artificial", "alternativeNumber", "parseLocation"));
                    }
                    nodes.set("" + n.getId(), nodeObject);
                    for (Join aqlJoin : n.getOutgoingJoins()) {
                        ObjectNode j = joinObject.addObject();
                        QueryToJSON.mapJoin(aqlJoin, n, j, mapper);
                    }
                }
                if (metaData == null || metaData.isEmpty() || alt.isEmpty()) continue;
                altNode.set("meta", mapper.valueToTree(metaData));
            }
        }
        return root;
    }

    private static void mapJoin(Join join, QueryNode source, ObjectNode node, ObjectMapper mapper) {
        if (join instanceof CommonAncestor || join instanceof LeftDominance || join instanceof RightDominance || join instanceof Sibling) {
            throw new AnnisQLSyntaxException("This join type can't be mapped yet: " + join.toAQLFragment(source));
        }
        if (join instanceof Dominance) {
            node.put("op", "Dominance");
            Dominance dom = (Dominance)join;
            node.put("name", dom.getName() == null ? "" : dom.getName());
            node.put("minDistance", (long)dom.getMinDistance());
            node.put("maxDistance", (long)dom.getMaxDistance());
            if (!dom.getEdgeAnnotations().isEmpty()) {
                for (QueryAnnotation anno : dom.getEdgeAnnotations()) {
                    if (anno.getTextMatching() == QueryNode.TextMatching.EXACT_EQUAL) continue;
                    throw new AnnisQLSyntaxException("Only non-regex and non-negated edge annotations are supported yet");
                }
                JsonNode edgeAnnos = mapper.valueToTree((Object)dom.getEdgeAnnotations());
                node.set("edgeAnnotations", edgeAnnos);
            }
        } else if (join instanceof PointingRelation) {
            node.put("op", "Pointing");
            PointingRelation pointing = (PointingRelation)join;
            node.put("name", pointing.getName() == null ? "" : pointing.getName());
            node.put("minDistance", (long)pointing.getMinDistance());
            node.put("maxDistance", (long)pointing.getMaxDistance());
            if (!pointing.getEdgeAnnotations().isEmpty()) {
                for (QueryAnnotation anno : pointing.getEdgeAnnotations()) {
                    if (anno.getTextMatching() == QueryNode.TextMatching.EXACT_EQUAL) continue;
                    throw new AnnisQLSyntaxException("Only non-regex and non-negated edge annotations are supported yet");
                }
                JsonNode edgeAnnos = mapper.valueToTree((Object)pointing.getEdgeAnnotations());
                node.set("edgeAnnotations", edgeAnnos);
            }
        } else if (join instanceof Precedence) {
            node.put("op", "Precedence");
            Precedence prec = (Precedence)join;
            node.put("minDistance", (long)prec.getMinDistance());
            node.put("maxDistance", (long)prec.getMaxDistance());
        } else if (join instanceof Overlap) {
            node.put("op", "Overlap");
        } else if (join instanceof Inclusion) {
            node.put("op", "Inclusion");
        } else if (join instanceof SameSpan) {
            node.put("op", "IdenticalCoverage");
        } else {
            throw new AnnisQLSyntaxException("This join type can't be mapped yet: " + join.toAQLFragment(source));
        }
        node.put("left", source.getId());
        node.put("right", join.getTarget().getId());
    }
}

