/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import com.google.common.base.Preconditions;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;

public class ListTokenSource
implements TokenSource {
    private final List<Token> token;
    private TokenFactory factory;
    private final CommonToken eofToken = new CommonToken(-1, "");

    public ListTokenSource(List<Token> token) {
        this.token = token;
        Preconditions.checkNotNull(token);
        Preconditions.checkArgument((!token.isEmpty() ? 1 : 0) != 0, (Object)"Internal token list must not be empty");
        for (Token t : token) {
            if (t.getTokenSource() == null) continue;
            this.factory = t.getTokenSource().getTokenFactory();
            break;
        }
        Preconditions.checkNotNull((Object)this.factory, (Object)"Internal token list needs a valid TokenSource");
        Token lastToken = token.get(token.size() - 1);
        this.eofToken.setLine(lastToken.getLine());
        this.eofToken.setCharPositionInLine(lastToken.getCharPositionInLine());
    }

    public Token nextToken() {
        if (this.token.isEmpty()) {
            return this.eofToken;
        }
        return this.token.remove(0);
    }

    public int getLine() {
        if (this.token.isEmpty()) {
            return this.eofToken.getLine();
        }
        return this.token.get(0).getLine();
    }

    public int getCharPositionInLine() {
        if (this.token.isEmpty()) {
            return this.eofToken.getCharPositionInLine();
        }
        return this.token.get(0).getCharPositionInLine();
    }

    public CharStream getInputStream() {
        if (this.token.isEmpty()) {
            return this.eofToken.getInputStream();
        }
        return this.token.get(0).getInputStream();
    }

    public String getSourceName() {
        if (this.token.isEmpty()) {
            return this.eofToken.getInputStream().getSourceName();
        }
        return this.token.get(0).getInputStream().getSourceName();
    }

    public TokenFactory getTokenFactory() {
        return this.factory;
    }

    public void setTokenFactory(TokenFactory factory) {
        this.factory = factory;
    }
}

