/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.annis.ql.parser;

import annis.exceptions.AnnisQLSemanticsException;
import annis.model.Join;
import annis.model.QueryAnnotation;
import annis.model.QueryNode;
import annis.sqlgen.model.CommonAncestor;
import annis.sqlgen.model.Dominance;
import annis.sqlgen.model.EqualValue;
import annis.sqlgen.model.Identical;
import annis.sqlgen.model.Inclusion;
import annis.sqlgen.model.LeftAlignment;
import annis.sqlgen.model.LeftDominance;
import annis.sqlgen.model.LeftOverlap;
import annis.sqlgen.model.Near;
import annis.sqlgen.model.NotEqualValue;
import annis.sqlgen.model.Overlap;
import annis.sqlgen.model.PointingRelation;
import annis.sqlgen.model.Precedence;
import annis.sqlgen.model.RightAlignment;
import annis.sqlgen.model.RightDominance;
import annis.sqlgen.model.RightOverlap;
import annis.sqlgen.model.SameSpan;
import annis.sqlgen.model.Sibling;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.corpus_tools.annis.ql.AqlParser;
import org.corpus_tools.annis.ql.AqlParserBaseListener;
import org.corpus_tools.annis.ql.parser.AnnisParserAntlr;
import org.corpus_tools.annis.ql.parser.QueryData;
import org.corpus_tools.annis.ql.parser.QueryNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinListener
extends AqlParserBaseListener {
    private static final Logger log = LoggerFactory.getLogger(JoinListener.class);
    private final int precedenceBound;
    private final ArrayList<Map<String, QueryNode>> alternativeNodes;
    private final List<Map<Interval, QueryNode>> tokenPositions;
    private int alternativeIndex;
    private ArrayList<QueryNode> relationChain = new ArrayList();
    private int relationIdx;

    public JoinListener(QueryData data, int precedenceBound, List<Map<Interval, QueryNode>> tokenPositionToNode) {
        this.precedenceBound = precedenceBound;
        this.alternativeNodes = new ArrayList(data.getAlternatives().size());
        this.tokenPositions = tokenPositionToNode;
        for (List<QueryNode> alternative : data.getAlternatives()) {
            HashMap<String, QueryNode> m = new HashMap<String, QueryNode>();
            this.alternativeNodes.add(m);
            for (QueryNode n : alternative) {
                if (m.containsKey(n.getVariable())) {
                    throw new AnnisQLSemanticsException(n, "A node variable name is only allowed once per normalized alternative");
                }
                m.put(n.getVariable(), n);
            }
        }
    }

    @Override
    public void enterAndExpr(AqlParser.AndExprContext ctx) {
        Preconditions.checkArgument((this.alternativeIndex < this.alternativeNodes.size() ? 1 : 0) != 0);
    }

    @Override
    public void exitAndExpr(AqlParser.AndExprContext ctx) {
        ++this.alternativeIndex;
    }

    @Override
    public void exitOperator(AqlParser.OperatorContext ctx) {
        ++this.relationIdx;
    }

    @Override
    public void enterBindingRelation(AqlParser.BindingRelationContext ctx) {
        int numOfReferences = ctx.refOrNode().size();
        this.relationIdx = 0;
        this.relationChain.clear();
        this.relationChain.ensureCapacity(numOfReferences);
        for (int i = 0; i < numOfReferences; ++i) {
            QueryNode n = this.node(ctx.refOrNode(i));
            if (n == null) {
                throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "invalid reference to '" + ctx.refOrNode(i).getText() + "'");
            }
            this.relationChain.add(i, n);
        }
    }

    @Override
    public void enterNonBindingRelation(AqlParser.NonBindingRelationContext ctx) {
        int numOfReferences = ctx.REF().size();
        this.relationIdx = 0;
        this.relationChain.clear();
        this.relationChain.ensureCapacity(numOfReferences);
        for (int i = 0; i < numOfReferences; ++i) {
            QueryNode n = this.nodeByRef(ctx.REF(i).getSymbol());
            if (n == null) {
                throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "invalid reference to '" + ctx.REF(i).getText() + "'");
            }
            this.relationChain.add(i, n);
        }
    }

    @Override
    public void enterRootTerm(AqlParser.RootTermContext ctx) {
        QueryNode target = this.nodeByRef(ctx.left);
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)(this.errorLHS("root") + ": " + ctx.getText()));
        target.setRoot(true);
    }

    @Override
    public void enterArityTerm(AqlParser.ArityTermContext ctx) {
        QueryNode target = this.nodeByRef(ctx.left);
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)(this.errorLHS("arity") + ": " + ctx.getText()));
        target.setArity(this.annisRangeFromARangeSpec(ctx.rangeSpec()));
    }

    @Override
    public void enterTokenArityTerm(AqlParser.TokenArityTermContext ctx) {
        QueryNode target = this.nodeByRef(ctx.left);
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)(this.errorLHS("token-arity") + ": " + ctx.getText()));
        target.setTokenArity(this.annisRangeFromARangeSpec(ctx.rangeSpec()));
    }

    @Override
    public void enterDirectPrecedence(AqlParser.DirectPrecedenceContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String segmentationName = null;
        if (ctx.NAMED_PRECEDENCE() != null) {
            segmentationName = ctx.NAMED_PRECEDENCE().getText().substring(1);
        }
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Precedence(right, 1, segmentationName)));
    }

    @Override
    public void enterDirectNear(AqlParser.DirectNearContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String segmentationName = this.getLayerName(ctx.NAMED_NEAR());
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Near(right, 1, segmentationName)));
    }

    @Override
    public void enterEqualvalue(AqlParser.EqualvalueContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new EqualValue(right)));
    }

    @Override
    public void enterNotequalvalue(AqlParser.NotequalvalueContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new NotEqualValue(right)));
    }

    @Override
    public void enterIndirectPrecedence(AqlParser.IndirectPrecedenceContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String segmentationName = this.getLayerName(ctx.NAMED_PRECEDENCE());
        if (this.precedenceBound > 0) {
            left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Precedence(right, 1, this.precedenceBound, segmentationName)));
        } else {
            left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Precedence(right, segmentationName)));
        }
    }

    @Override
    public void enterIndirectNear(AqlParser.IndirectNearContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String segmentationName = this.getLayerName(ctx.NAMED_NEAR());
        if (this.precedenceBound > 0) {
            left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Near(right, 1, this.precedenceBound, segmentationName)));
        } else {
            left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Near(right, segmentationName)));
        }
    }

    @Override
    public void enterRangePrecedence(AqlParser.RangePrecedenceContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        QueryNode.Range range = this.annisRangeFromARangeSpec(ctx.rangeSpec());
        if (range.getMin() == 0 || range.getMax() == 0) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Distance can't be 0");
        }
        if (range.getMin() > range.getMax()) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Minimal distance can't be larger than maximal distance");
        }
        String segmentationName = this.getLayerName(ctx.NAMED_PRECEDENCE());
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Precedence(right, range.getMin(), range.getMax(), segmentationName)));
    }

    @Override
    public void enterRangeNear(AqlParser.RangeNearContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        QueryNode.Range range = this.annisRangeFromARangeSpec(ctx.rangeSpec());
        if (range.getMin() == 0 || range.getMax() == 0) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Distance can't be 0");
        }
        if (range.getMin() > range.getMax()) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Minimal distance can't be larger than maximal distance");
        }
        String segmentationName = this.getLayerName(ctx.NAMED_NEAR());
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Near(right, range.getMin(), range.getMax(), segmentationName)));
    }

    @Override
    public void enterIdenticalCoverage(AqlParser.IdenticalCoverageContext ctx) {
        this.join(ctx, SameSpan.class);
    }

    @Override
    public void enterLeftAlign(AqlParser.LeftAlignContext ctx) {
        this.join(ctx, LeftAlignment.class);
    }

    @Override
    public void enterRightAlign(AqlParser.RightAlignContext ctx) {
        this.join(ctx, RightAlignment.class);
    }

    @Override
    public void enterInclusion(AqlParser.InclusionContext ctx) {
        this.join(ctx, Inclusion.class);
    }

    @Override
    public void enterOverlap(AqlParser.OverlapContext ctx) {
        this.join(ctx, Overlap.class);
    }

    @Override
    public void enterRightOverlap(AqlParser.RightOverlapContext ctx) {
        this.join(ctx, RightOverlap.class);
    }

    @Override
    public void enterLeftOverlap(AqlParser.LeftOverlapContext ctx) {
        this.join(ctx, LeftOverlap.class);
    }

    @Override
    public void enterDirectDominance(AqlParser.DirectDominanceContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String layer = this.getLayerName(ctx.NAMED_DOMINANCE());
        Object j = ctx.LEFT_CHILD() != null ? new LeftDominance(right, layer) : (ctx.RIGHT_CHILD() != null ? new RightDominance(right, layer) : new Dominance(right, layer, 1));
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)j));
        if (ctx.anno != null) {
            LinkedList<QueryAnnotation> annotations = this.fromRelationAnnotation(ctx.anno);
            for (QueryAnnotation a : annotations) {
                j.addEdgeAnnotation(a);
            }
        }
    }

    @Override
    public void enterIndirectDominance(AqlParser.IndirectDominanceContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String layer = this.getLayerName(ctx.NAMED_DOMINANCE());
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Dominance(right, layer)));
    }

    @Override
    public void enterRangeDominance(AqlParser.RangeDominanceContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String layer = this.getLayerName(ctx.NAMED_DOMINANCE());
        QueryNode.Range range = this.annisRangeFromARangeSpec(ctx.rangeSpec());
        if (range.getMin() == 0 || range.getMax() == 0) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Distance can't be 0");
        }
        if (range.getMin() > range.getMax()) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Minimal distance can't be larger than maximal distance");
        }
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Dominance(right, layer, range.getMin(), range.getMax())));
    }

    @Override
    public void enterDirectPointing(AqlParser.DirectPointingContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String label = this.getLayerName(ctx.POINTING(), 2);
        PointingRelation j = new PointingRelation(right, label, 1);
        if (ctx.anno != null) {
            LinkedList<QueryAnnotation> annotations = this.fromRelationAnnotation(ctx.anno);
            for (QueryAnnotation a : annotations) {
                j.addEdgeAnnotation(a);
            }
        }
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)j));
    }

    @Override
    public void enterIndirectPointing(AqlParser.IndirectPointingContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String label = this.getLayerName(ctx.POINTING(), 2);
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new PointingRelation(right, label)));
    }

    @Override
    public void enterRangePointing(AqlParser.RangePointingContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String label = this.getLayerName(ctx.POINTING(), 2);
        QueryNode.Range range = this.annisRangeFromARangeSpec(ctx.rangeSpec());
        if (range.getMin() == 0 || range.getMax() == 0) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Distance can't be 0");
        }
        if (range.getMin() > range.getMax()) {
            throw new AnnisQLSemanticsException(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()), "Minimal distance can't be larger than maximal distance");
        }
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new PointingRelation(right, label, range.getMin(), range.getMax())));
    }

    @Override
    public void enterCommonparent(AqlParser.CommonparentContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String label = ctx.label == null ? null : ctx.label.getText();
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new Sibling(right, label)));
    }

    @Override
    public void enterCommonancestor(AqlParser.CommonancestorContext ctx) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        String label = ctx.label == null ? null : ctx.label.getText();
        left.addOutgoingJoin(this.addParsedLocation(ctx, (Join)new CommonAncestor(right, label)));
    }

    @Override
    public void enterIdentity(AqlParser.IdentityContext ctx) {
        this.join(ctx, Identical.class);
    }

    private void join(ParserRuleContext ctx, Class<? extends Join> type) {
        QueryNode left = this.relationChain.get(this.relationIdx);
        QueryNode right = this.relationChain.get(this.relationIdx + 1);
        try {
            Constructor<? extends Join> c = type.getConstructor(QueryNode.class);
            Join newJoin = c.newInstance(right);
            left.addOutgoingJoin(this.addParsedLocation(ctx, newJoin));
        }
        catch (NoSuchMethodException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            log.error(null, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private Join addParsedLocation(ParserRuleContext ctx, Join j) {
        j.setParseLocation(AnnisParserAntlr.getLocation(ctx.getStart(), ctx.getStop()));
        return j;
    }

    private QueryNode.Range annisRangeFromARangeSpec(AqlParser.RangeSpecContext spec) {
        String max;
        String min = spec.min.getText();
        String string = max = spec.max != null ? spec.max.getText() : null;
        if (max == null) {
            return new QueryNode.Range(Integer.parseInt(min), Integer.parseInt(min));
        }
        return new QueryNode.Range(Integer.parseInt(min), Integer.parseInt(max));
    }

    private LinkedList<QueryAnnotation> fromRelationAnnotation(AqlParser.EdgeSpecContext ctx) {
        LinkedList<QueryAnnotation> annos = new LinkedList<QueryAnnotation>();
        for (AqlParser.EdgeAnnoContext annoCtx : ctx.edgeAnno()) {
            String namespace = annoCtx.qName().namespace == null ? null : annoCtx.qName().namespace.getText();
            String name = annoCtx.qName().name.getText();
            String value = QueryNodeListener.textFromSpec(annoCtx.value);
            QueryNode.TextMatching matching = QueryNodeListener.textMatchingFromSpec(annoCtx.value, annoCtx.NEQ() != null);
            annos.add(new QueryAnnotation(namespace, name, value, matching));
        }
        return annos;
    }

    private String getLayerName(TerminalNode node) {
        return this.getLayerName(node, 1);
    }

    private String getLayerName(TerminalNode node, int lengthOfOperator) {
        if (node == null || node.getText() == null) {
            return null;
        }
        return node.getText().substring(lengthOfOperator);
    }

    private QueryNode node(AqlParser.RefOrNodeContext ctx) {
        if (ctx instanceof AqlParser.ReferenceNodeContext) {
            return this.nodeByDef((AqlParser.ReferenceNodeContext)ctx);
        }
        if (ctx instanceof AqlParser.ReferenceRefContext) {
            return this.nodeByRef(((AqlParser.ReferenceRefContext)ctx).REF().getSymbol());
        }
        return null;
    }

    private QueryNode nodeByDef(AqlParser.ReferenceNodeContext ctx) {
        if (ctx.VAR_DEF() == null) {
            QueryNode result = this.tokenPositions.get(this.alternativeIndex).get(ctx.variableExpr().getSourceInterval());
            if (result == null) {
                return null;
            }
            return result;
        }
        String varDefText = ctx.VAR_DEF().getText();
        varDefText = varDefText.substring(0, varDefText.length() - 1);
        return this.alternativeNodes.get(this.alternativeIndex).get(varDefText);
    }

    private QueryNode nodeByRef(Token ref) {
        return this.alternativeNodes.get(this.alternativeIndex).get("" + ref.getText().substring(1));
    }

    private String errorLHS(String function) {
        return function + " operator needs a left-hand-side";
    }
}

