/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Cast;

public class BytePointer
extends Pointer {
    public BytePointer(String s, String charsetName) throws UnsupportedEncodingException {
        this(s.getBytes(charsetName).length + 1);
        this.putString(s, charsetName);
    }

    public BytePointer(String s) {
        this(s.getBytes().length + 1);
        this.putString(s);
    }

    public BytePointer(byte ... array) {
        this(array.length);
        this.put(array);
    }

    public BytePointer(ByteBuffer buffer) {
        super(buffer);
        if (buffer != null && !buffer.isDirect() && buffer.hasArray()) {
            byte[] array = buffer.array();
            this.allocateArray(array.length - buffer.arrayOffset());
            this.put(array, buffer.arrayOffset(), array.length - buffer.arrayOffset());
            this.position(buffer.position());
            this.limit(buffer.limit());
        }
    }

    public BytePointer(long size) {
        try {
            this.allocateArray(size);
            if (size > 0L && this.address == 0L) {
                throw new OutOfMemoryError("Native allocator returned address == 0");
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e);
        }
        catch (OutOfMemoryError e) {
            OutOfMemoryError e2 = new OutOfMemoryError("Cannot allocate new BytePointer(" + size + "): totalBytes = " + BytePointer.formatBytes(BytePointer.totalBytes()) + ", physicalBytes = " + BytePointer.formatBytes(BytePointer.physicalBytes()));
            e2.initCause(e);
            throw e2;
        }
    }

    public BytePointer() {
    }

    public BytePointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(long var1);

    public BytePointer position(long position) {
        return (BytePointer)super.position(position);
    }

    public BytePointer limit(long limit) {
        return (BytePointer)super.limit(limit);
    }

    public BytePointer capacity(long capacity) {
        return (BytePointer)super.capacity(capacity);
    }

    public byte[] getStringBytes() {
        long size = this.limit - this.position;
        if (size <= 0L) {
            size = BytePointer.strlen(this);
        }
        byte[] array = new byte[(int)Math.min(size, Integer.MAX_VALUE)];
        this.get(array);
        return array;
    }

    public String getString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.getStringBytes(), charsetName);
    }

    public String getString() {
        return new String(this.getStringBytes());
    }

    public BytePointer putString(String s, String charsetName) throws UnsupportedEncodingException {
        byte[] bytes = s.getBytes(charsetName);
        return this.put(bytes).put(bytes.length, (byte)0).limit(bytes.length);
    }

    public BytePointer putString(String s) {
        byte[] bytes = s.getBytes();
        return this.put(bytes).put(bytes.length, (byte)0).limit(bytes.length);
    }

    public byte get() {
        return this.get(0L);
    }

    public native byte get(long var1);

    public BytePointer put(byte b) {
        return this.put(0L, b);
    }

    public native BytePointer put(long var1, byte var3);

    public BytePointer get(byte[] array) {
        return this.get(array, 0, array.length);
    }

    public BytePointer put(byte ... array) {
        return this.put(array, 0, array.length);
    }

    public native BytePointer get(byte[] var1, int var2, int var3);

    public native BytePointer put(byte[] var1, int var2, int var3);

    @Override
    public final ByteBuffer asBuffer() {
        return this.asByteBuffer();
    }

    @Cast(value={"char*"})
    public static native BytePointer strcat(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strchr(@Cast(value={"char*"}) BytePointer var0, int var1);

    public static native int strcmp(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    public static native int strcoll(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strcpy(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"size_t"})
    public static native long strcspn(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strerror(int var0);

    @Cast(value={"size_t"})
    public static native long strlen(@Cast(value={"char*"}) BytePointer var0);

    @Cast(value={"char*"})
    public static native BytePointer strncat(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);

    public static native int strncmp(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);

    @Cast(value={"char*"})
    public static native BytePointer strncpy(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);

    @Cast(value={"char*"})
    public static native BytePointer strpbrk(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strrchr(@Cast(value={"char*"}) BytePointer var0, int var1);

    @Cast(value={"size_t"})
    public static native long strspn(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strstr(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"char*"})
    public static native BytePointer strtok(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1);

    @Cast(value={"size_t"})
    public static native long strxfrm(@Cast(value={"char*"}) BytePointer var0, @Cast(value={"char*"}) BytePointer var1, @Cast(value={"size_t"}) long var2);
}

