/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.corpus_tools.graphannis.model.Component;
import org.corpus_tools.graphannis.model.Graph;
import org.corpus_tools.graphannis.model.Node;
import org.corpus_tools.graphannis.model.QName;

public class Edge {
    private Node source;
    private Node target;
    private final int sourceID;
    private final int targetID;
    private final Graph graph;
    private final Component component;
    private final Map<QName, String> labels;

    public Edge(int sourceID, int targetID, Component component, Map<QName, String> labels, Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.sourceID = sourceID;
        this.targetID = targetID;
        this.component = component;
        this.labels = labels == null ? new LinkedHashMap() : labels;
        this.graph = graph;
    }

    public Node getSource() {
        if (this.source == null) {
            this.source = this.graph.getNodeForID(this.sourceID);
        }
        return this.source;
    }

    public int getSourceID() {
        return this.sourceID;
    }

    public Node getTarget() {
        if (this.target == null) {
            this.target = this.graph.getNodeForID(this.targetID);
        }
        return this.target;
    }

    public int getTargetID() {
        return this.targetID;
    }

    public Map<QName, String> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    public Component getComponent() {
        return this.component;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + this.sourceID;
        result = 31 * result + this.targetID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        if (this.sourceID != other.sourceID) {
            return false;
        }
        return this.targetID == other.targetID;
    }
}

