/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis.capi;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import org.corpus_tools.graphannis.capi.CAPI;
import org.corpus_tools.graphannis.errors.AQLSemanticError;
import org.corpus_tools.graphannis.errors.AQLSyntaxError;
import org.corpus_tools.graphannis.errors.GraphANNISException;
import org.corpus_tools.graphannis.errors.NoSuchCorpus;
import org.corpus_tools.graphannis.errors.SetLoggerError;

public class AnnisErrorListRef
extends PointerType {
    private final Memory memPtr = new Memory((long)Pointer.SIZE);

    public AnnisErrorListRef() {
        this(null);
    }

    public AnnisErrorListRef(Pointer value) {
        this.setPointer((Pointer)this.memPtr);
        this.setValue(value);
    }

    public void checkErrors() throws GraphANNISException {
        long num_of_errors;
        if (this.getValue() != Pointer.NULL && (num_of_errors = CAPI.annis_error_size(this.getValue()).longValue()) > 0L) {
            GraphANNISException cause = null;
            for (long i = num_of_errors - 1L; i >= 0L; --i) {
                String msg = CAPI.annis_error_get_msg(this.getValue(), new NativeLong(i));
                String kind = CAPI.annis_error_get_kind(this.getValue(), new NativeLong(i));
                cause = "SetLoggerError".equals(kind) ? new SetLoggerError(msg, cause) : ("AQLSemanticError".equals(kind) ? new AQLSemanticError(msg, cause) : ("AQLSyntaxError".equals(kind) ? new AQLSyntaxError(msg, cause) : ("NoSuchCorpus".equals(kind) ? new NoSuchCorpus(msg, cause) : new GraphANNISException(msg, cause))));
            }
            if (cause != null) {
                throw cause;
            }
        }
    }

    public void setValue(Pointer value) {
        this.getPointer().setPointer(0L, value);
    }

    public Pointer getValue() {
        if (this.memPtr.valid()) {
            return this.memPtr.getPointer(0L);
        }
        return null;
    }

    public synchronized void dispose() {
        Pointer val = this.getValue();
        if (val != Pointer.NULL) {
            CAPI.annis_free(val);
            this.setValue(null);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

