/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.sun.jna.NativeLong;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.graphannis.capi.AnnisEdge;
import org.corpus_tools.graphannis.capi.CAPI;
import org.corpus_tools.graphannis.capi.CharPointer;
import org.corpus_tools.graphannis.capi.NodeID;
import org.corpus_tools.graphannis.capi.NodeIDByRef;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SOrderRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;

public class SaltExport {
    private final CAPI.AnnisGraph orig;
    private final SDocumentGraph docGraph;
    private final BiMap<Integer, SNode> nodesByID;
    private final Map<Integer, Integer> node2timelinePOT;

    protected SaltExport(CAPI.AnnisGraph orig) {
        this.orig = orig;
        this.docGraph = SaltFactory.createSDocumentGraph();
        this.nodesByID = HashBiMap.create();
        this.node2timelinePOT = new HashMap<Integer, Integer>();
    }

    private static void mapLabels(SAnnotationContainer n, Map<Pair<String, String>, String> labels, boolean isMeta) {
        for (Map.Entry<Pair<String, String>, String> e : labels.entrySet()) {
            if ("annis".equals(e.getKey().getKey())) {
                n.createFeature((String)e.getKey().getKey(), (String)e.getKey().getValue(), (Object)e.getValue());
                continue;
            }
            if (isMeta) {
                n.createMetaAnnotation((String)e.getKey().getKey(), (String)e.getKey().getValue(), (Object)e.getValue());
                continue;
            }
            n.createAnnotation((String)e.getKey().getKey(), (String)e.getKey().getValue(), (Object)e.getValue());
        }
    }

    private boolean hasDominanceEdge(NodeIDByRef nID) {
        CAPI.AnnisVec_AnnisComponent components = CAPI.annis_graph_all_components_by_type(this.orig, 2);
        for (int i = 0; i < CAPI.annis_vec_component_size(components).intValue(); ++i) {
            CAPI.AnnisComponentConst c = CAPI.annis_vec_component_get(components, new NativeLong((long)i));
            CAPI.AnnisVec_AnnisEdge outEdges = CAPI.annis_graph_outgoing_edges(this.orig, new NodeID(nID.getValue()), c);
            if (CAPI.annis_vec_edge_size(outEdges).longValue() <= 0L) continue;
            return true;
        }
        return false;
    }

    private boolean hasCoverageEdge(NodeIDByRef nID) {
        CAPI.AnnisVec_AnnisComponent components = CAPI.annis_graph_all_components_by_type(this.orig, 0);
        for (int i = 0; i < CAPI.annis_vec_component_size(components).intValue(); ++i) {
            CAPI.AnnisComponentConst c = CAPI.annis_vec_component_get(components, new NativeLong((long)i));
            CAPI.AnnisVec_AnnisEdge outEdges = CAPI.annis_graph_outgoing_edges(this.orig, new NodeID(nID.getValue()), c);
            if (CAPI.annis_vec_edge_size(outEdges).longValue() <= 0L) continue;
            return true;
        }
        return false;
    }

    private static Map<Pair<String, String>, String> getNodeLabels(CAPI.AnnisGraph g, int nID) {
        LinkedHashMap<Pair<String, String>, String> labels = new LinkedHashMap<Pair<String, String>, String>();
        CAPI.AnnisVec_AnnisAnnotation annos = CAPI.annis_graph_annotations_for_node(g, new NodeID(nID));
        for (long i = 0L; i < CAPI.annis_vec_annotation_size(annos).longValue(); ++i) {
            CAPI.AnnisAnnotation a = CAPI.annis_vec_annotation_get(annos, new NativeLong(i));
            String ns = CAPI.annis_annotation_ns(a).toString();
            String name = CAPI.annis_annotation_name(a).toString();
            String value = CAPI.annis_annotation_val(a).toString();
            if (name == null || value == null) continue;
            if (ns == null) {
                labels.put((Pair<String, String>)new ImmutablePair((Object)"", (Object)name), value);
                continue;
            }
            labels.put((Pair<String, String>)new ImmutablePair((Object)ns, (Object)name), value);
        }
        annos.dispose();
        return labels;
    }

    private SNode mapNode(NodeIDByRef nID) {
        int copyID = nID.getValue();
        Map<Pair<String, String>, String> labels = SaltExport.getNodeLabels(this.orig, copyID);
        Object newNode = labels.containsKey(new ImmutablePair((Object)"annis", (Object)"tok")) && !this.hasCoverageEdge(nID) ? SaltFactory.createSToken() : (this.hasDominanceEdge(nID) ? SaltFactory.createSStructure() : SaltFactory.createSSpan());
        newNode.createFeature("annis", "node_id", (Object)copyID);
        String nodeName = labels.get(new ImmutablePair((Object)"annis", (Object)"node_name"));
        if (nodeName != null) {
            if (!nodeName.startsWith("salt:/")) {
                nodeName = "salt:/" + nodeName;
            }
            newNode.setId(nodeName);
            newNode.setName(newNode.getPath().fragment());
        }
        SaltExport.mapLabels((SAnnotationContainer)newNode, labels, false);
        return newNode;
    }

    private void mapAndAddEdge(NodeID node, AnnisEdge origEdge, CAPI.AnnisComponentConst component) {
        SNode source = (SNode)this.nodesByID.get((Object)origEdge.source.intValue());
        SNode target = (SNode)this.nodesByID.get((Object)origEdge.target.intValue());
        String edgeType = null;
        if (source != null && target != null && source != target) {
            CharPointer cName = CAPI.annis_component_name(component);
            if (cName != null) {
                edgeType = cName.toString();
            }
            SRelation rel = null;
            switch (CAPI.annis_component_type(component)) {
                case 2: {
                    if (edgeType == null || edgeType.isEmpty()) {
                        CAPI.AnnisVec_AnnisComponent domComponents = CAPI.annis_graph_all_components_by_type(this.orig, 2);
                        for (int cIdx = 0; cIdx < CAPI.annis_vec_component_size(domComponents).intValue(); ++cIdx) {
                            CAPI.AnnisComponentConst dc = CAPI.annis_vec_component_get(domComponents, new NativeLong((long)cIdx));
                            if (CAPI.annis_component_name(dc).toString().isEmpty() || CAPI.annis_component_layer(dc).toString().isEmpty()) continue;
                            CAPI.AnnisVec_AnnisEdge outEdges = CAPI.annis_graph_outgoing_edges(this.orig, origEdge.source, dc);
                            for (int i = 0; i < CAPI.annis_vec_edge_size(outEdges).intValue(); ++i) {
                                AnnisEdge outEdge = CAPI.annis_vec_edge_get(outEdges, new NativeLong((long)i));
                                if (!outEdge.target.equals((Object)origEdge.target)) continue;
                                return;
                            }
                        }
                    }
                    rel = this.docGraph.createRelation(source, target, SALT_TYPE.SDOMINANCE_RELATION, null);
                    break;
                }
                case 3: {
                    rel = this.docGraph.createRelation(source, target, SALT_TYPE.SPOINTING_RELATION, null);
                    break;
                }
                case 4: {
                    rel = this.docGraph.createRelation(source, target, SALT_TYPE.SORDER_RELATION, null);
                    break;
                }
                case 0: {
                    if (!(source instanceof SSpan) || !(target instanceof SToken)) break;
                    rel = this.docGraph.createRelation(source, target, SALT_TYPE.SSPANNING_RELATION, null);
                }
            }
            if (rel != null) {
                String layerName;
                rel.setType(edgeType);
                LinkedHashMap<Pair<String, String>, String> labels = new LinkedHashMap<Pair<String, String>, String>();
                AnnisEdge.ByValue copyEdge = new AnnisEdge.ByValue();
                copyEdge.source = origEdge.source;
                copyEdge.target = origEdge.target;
                CAPI.AnnisVec_AnnisAnnotation annos = CAPI.annis_graph_annotations_for_edge(this.orig, copyEdge, component);
                for (long i = 0L; i < CAPI.annis_vec_annotation_size(annos).longValue(); ++i) {
                    CAPI.AnnisAnnotation a = CAPI.annis_vec_annotation_get(annos, new NativeLong(i));
                    String ns = CAPI.annis_annotation_ns(a).toString();
                    String name = CAPI.annis_annotation_name(a).toString();
                    String value = CAPI.annis_annotation_val(a).toString();
                    if (name == null || value == null) continue;
                    if (ns == null) {
                        labels.put((Pair<String, String>)new ImmutablePair((Object)"", (Object)name), value);
                        continue;
                    }
                    labels.put((Pair<String, String>)new ImmutablePair((Object)ns, (Object)name), value);
                }
                annos.dispose();
                SaltExport.mapLabels((SAnnotationContainer)rel, labels, false);
                CharPointer layerNameRaw = CAPI.annis_component_layer(component);
                String string = layerName = layerNameRaw == null ? null : layerNameRaw.toString();
                if (layerName != null && !layerName.isEmpty()) {
                    List<SLayer> layer = this.docGraph.getLayerByName(layerName);
                    if (layer == null || layer.isEmpty()) {
                        SLayer newLayer = SaltFactory.createSLayer();
                        newLayer.setName(layerName);
                        this.docGraph.addLayer((Layer)newLayer);
                        layer = Arrays.asList(newLayer);
                    }
                    ((SLayer)layer.get(0)).addRelation((Relation)rel);
                }
            }
        }
    }

    private void addNodeLayers() {
        LinkedList nodeList = new LinkedList(this.docGraph.getNodes());
        for (SNode n : nodeList) {
            SFeature featLayer = n.getFeature("annis", "layer");
            if (featLayer == null) continue;
            SLayer layer = (SLayer)this.docGraph.getLayer(featLayer.getValue_STEXT());
            if (layer == null) {
                layer = SaltFactory.createSLayer();
                layer.setName(featLayer.getValue_STEXT());
                this.docGraph.addLayer((Layer)layer);
            }
            layer.addNode((Node)n);
        }
    }

    private void recreateText(final String name, List<SNode> rootNodes) {
        final StringBuilder text = new StringBuilder();
        STextualDS ds = this.docGraph.createTextualDS("");
        ds.setName(name);
        final HashMap<SToken, Range> token2Range = new HashMap<SToken, Range>();
        this.docGraph.traverse(rootNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "ORDERING_" + name, new GraphTraverseHandler(){

            public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
                SFeature featTok;
                if (fromNode != null) {
                    text.append(" ");
                }
                if ((featTok = currNode.getFeature("annis::tok")) != null && currNode instanceof SToken) {
                    int idxStart = text.length();
                    text.append(featTok.getValue_STEXT());
                    token2Range.put((SToken)currNode, Range.closed((Comparable)Integer.valueOf(idxStart), (Comparable)Integer.valueOf(text.length())));
                }
            }

            public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            }

            public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
                if (relation == null) {
                    return true;
                }
                return relation instanceof SOrderRelation && Objects.equal((Object)name, (Object)relation.getType());
            }
        });
        ds.setText(text.toString());
        token2Range.forEach((t, r) -> {
            STextualRelation rel = SaltFactory.createSTextualRelation();
            rel.setSource((Node)t);
            rel.setTarget((Node)ds);
            rel.setStart((Number)((Object)r.lowerEndpoint()));
            rel.setEnd((Number)((Object)r.upperEndpoint()));
            this.docGraph.addRelation((Relation)rel);
        });
        if (this.docGraph.getTimeline() != null) {
            CAPI.AnnisVec_AnnisComponent coverageComponents = CAPI.annis_graph_all_components_by_type(this.orig, 0);
            int coverageComponents_size = CAPI.annis_vec_component_size(coverageComponents).intValue();
            CAPI.AnnisComponentConst covComponent = null;
            for (int i = 0; i < coverageComponents_size; ++i) {
                CAPI.AnnisComponentConst c = CAPI.annis_vec_component_get(coverageComponents, new NativeLong((long)i));
                CharPointer cName = CAPI.annis_component_name(c);
                CharPointer cLayer = CAPI.annis_component_layer(c);
                if (cName != null && !cName.toString().isEmpty() || !"annis".equals(cLayer.toString())) continue;
                covComponent = c;
                break;
            }
            if (covComponent != null) {
                for (SToken tok : token2Range.keySet()) {
                    Integer tokID = (Integer)this.nodesByID.inverse().get((Object)tok);
                    if (tokID == null) continue;
                    Integer tokPOT = this.node2timelinePOT.get(tokID);
                    if (tokPOT != null) {
                        STimelineRelation rel = SaltFactory.createSTimelineRelation();
                        rel.setSource((Node)tok);
                        rel.setTarget((Node)this.docGraph.getTimeline());
                        rel.setStart((Number)tokPOT);
                        rel.setEnd((Number)tokPOT);
                        this.docGraph.addRelation((Relation)rel);
                        continue;
                    }
                    CAPI.AnnisVec_AnnisEdge edges = CAPI.annis_graph_outgoing_edges(this.orig, new NodeID(tokID), covComponent);
                    int edges_size = CAPI.annis_vec_edge_size(edges).intValue();
                    for (int i = 0; i < edges_size; ++i) {
                        AnnisEdge e = CAPI.annis_vec_edge_get(edges, new NativeLong((long)i));
                        Integer pot = this.node2timelinePOT.get(e.target.intValue());
                        if (pot == null) continue;
                        STimelineRelation rel = SaltFactory.createSTimelineRelation();
                        rel.setSource((Node)tok);
                        rel.setTarget((Node)this.docGraph.getTimeline());
                        rel.setStart((Number)pot);
                        rel.setEnd((Number)pot);
                        this.docGraph.addRelation((Relation)rel);
                    }
                }
            }
        }
    }

    private void addTextToSegmentation(final String name, List<SNode> rootNodes) {
        this.docGraph.traverse(rootNodes, SGraph.GRAPH_TRAVERSE_TYPE.TOP_DOWN_DEPTH_FIRST, "ORDERING_" + name, new GraphTraverseHandler(){

            public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
                SFeature featTok = currNode.getFeature("annis::tok");
                if (featTok != null && currNode instanceof SSpan) {
                    currNode.createAnnotation(null, name, (Object)featTok.getValue().toString());
                }
            }

            public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation<SNode, SNode> relation, SNode fromNode, long order) {
            }

            public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation relation, SNode currNode, long order) {
                if (relation == null) {
                    return true;
                }
                return relation instanceof SOrderRelation && Objects.equal((Object)name, (Object)relation.getType());
            }
        });
    }

    public static SDocumentGraph map(CAPI.AnnisGraph orig) {
        if (orig == null) {
            return null;
        }
        SaltExport export = new SaltExport(orig);
        export.mapDocGraph();
        return export.docGraph;
    }

    private void mapDocGraph() {
        CAPI.AnnisIterPtr_AnnisNodeID itNodes = CAPI.annis_graph_nodes_by_type(this.orig, "node");
        if (itNodes != null) {
            NodeIDByRef nID = CAPI.annis_iter_nodeid_next(itNodes);
            while (nID != null) {
                SNode n2 = this.mapNode(nID);
                this.nodesByID.put((Object)nID.getValue(), (Object)n2);
                nID = CAPI.annis_iter_nodeid_next(itNodes);
            }
            itNodes.dispose();
        }
        CAPI.AnnisVec_AnnisComponent components = CAPI.annis_graph_all_components(this.orig);
        int component_size = CAPI.annis_vec_component_size(components).intValue();
        this.nodesByID.values().stream().forEach(n -> this.docGraph.addNode((Node)n));
        for (Map.Entry nodeEntry : this.nodesByID.entrySet()) {
            for (int i = 0; i < component_size; ++i) {
                CAPI.AnnisComponentConst c = CAPI.annis_vec_component_get(components, new NativeLong((long)i));
                NodeID nId = new NodeID((Integer)nodeEntry.getKey());
                CAPI.AnnisVec_AnnisEdge outEdges = CAPI.annis_graph_outgoing_edges(this.orig, nId, c);
                for (int edgeIdx = 0; edgeIdx < CAPI.annis_vec_edge_size(outEdges).intValue(); ++edgeIdx) {
                    AnnisEdge edge = CAPI.annis_vec_edge_get(outEdges, new NativeLong((long)edgeIdx));
                    this.mapAndAddEdge(nId, edge, c);
                }
            }
        }
        components.dispose();
        components = null;
        Multimap orderRoots = this.docGraph.getRootsByRelationType(SALT_TYPE.SORDER_RELATION);
        orderRoots.keySet().forEach(name -> {
            ArrayList<SNode> roots = new ArrayList<SNode>(orderRoots.get(name));
            if ("salt::NULL".equals(name)) {
                name = null;
            }
            if (name == null || "".equals(name)) {
                this.recreateText((String)name, (List<SNode>)roots);
            } else {
                this.addTextToSegmentation((String)name, (List<SNode>)roots);
            }
        });
        this.addNodeLayers();
    }

    /*
     * WARNING - void declaration
     */
    private void mapTimeline(CAPI.AnnisVec_AnnisComponent components, boolean removeOriginalToken) {
        int component_size = CAPI.annis_vec_component_size(components).intValue();
        TreeMap<String, CAPI.AnnisComponentConst> types = new TreeMap<String, CAPI.AnnisComponentConst>();
        for (int i = 0; i < component_size; ++i) {
            CAPI.AnnisComponentConst c = CAPI.annis_vec_component_get(components, new NativeLong((long)i));
            if (CAPI.annis_component_type(c) != 4) continue;
            CharPointer t = CAPI.annis_component_name(c);
            types.put(t == null ? "" : t.toString(), c);
        }
        CAPI.AnnisComponentConst timelineOrderComponent = (CAPI.AnnisComponentConst)((Object)types.get(""));
        if (types.size() > 1 && timelineOrderComponent != null) {
            HashMap<Integer, Integer> timelineOrderEdges = new HashMap<Integer, Integer>();
            for (Object node : this.nodesByID.entrySet()) {
                CAPI.AnnisVec_AnnisEdge annisVec_AnnisEdge = CAPI.annis_graph_outgoing_edges(this.orig, new NodeID((Integer)node.getKey()), timelineOrderComponent);
                int edges_size = CAPI.annis_vec_edge_size(annisVec_AnnisEdge).intValue();
                for (int i = 0; i < edges_size; ++i) {
                    AnnisEdge e = CAPI.annis_vec_edge_get(annisVec_AnnisEdge, new NativeLong((long)i));
                    timelineOrderEdges.put(e.source.intValue(), e.target.intValue());
                }
            }
            HashSet rootNodes = new HashSet(timelineOrderEdges.keySet());
            for (Map.Entry entry : timelineOrderEdges.entrySet()) {
                rootNodes.remove(entry.getValue());
            }
            if (rootNodes.size() == 1) {
                void var9_14;
                STimeline timeline = this.docGraph.createTimeline();
                Integer n = (Integer)rootNodes.iterator().next();
                while (var9_14 != null) {
                    SNode token = null;
                    token = removeOriginalToken ? (SNode)this.nodesByID.remove((Object)var9_14) : (SNode)this.nodesByID.get((Object)var9_14);
                    if (token != null) {
                        timeline.increasePointOfTime();
                        this.node2timelinePOT.put((Integer)var9_14, (Integer)timeline.getEnd());
                    }
                    Integer n2 = (Integer)timelineOrderEdges.get(var9_14);
                }
            }
        }
    }

    private static SCorpus addCorpusAndParents(SCorpusGraph cg, long id, Map<Long, Long> parentOfNode, Map<Long, SCorpus> id2corpus, Map<Long, Map<Pair<String, String>, String>> node2labels) {
        if (id2corpus.containsKey(id)) {
            return id2corpus.get(id);
        }
        Map<Pair<String, String>, String> labels = node2labels.get(id);
        if (labels == null) {
            return null;
        }
        Long parentID = parentOfNode.get(id);
        SCorpus parent = null;
        if (parentID != null) {
            parent = SaltExport.addCorpusAndParents(cg, parentID, parentOfNode, id2corpus, node2labels);
        }
        String corpusName = labels.getOrDefault(new ImmutablePair((Object)"annis", (Object)"node_name"), "corpus");
        List corpusNameSplitted = Splitter.on((char)'/').trimResults().splitToList((CharSequence)corpusName);
        SCorpus newCorpus = cg.createCorpus(parent, (String)corpusNameSplitted.get(corpusNameSplitted.size() - 1));
        id2corpus.put(id, newCorpus);
        return newCorpus;
    }

    public static SCorpusGraph mapCorpusGraph(CAPI.AnnisGraph orig) {
        if (orig == null) {
            return null;
        }
        SCorpusGraph cg = SaltFactory.createSCorpusGraph();
        CAPI.AnnisVec_AnnisComponent components = CAPI.annis_graph_all_components(orig);
        CAPI.AnnisComponentConst subcorpusComponent = null;
        for (int i = 0; i < CAPI.annis_vec_component_size(components).intValue(); ++i) {
            CAPI.AnnisComponentConst c = CAPI.annis_vec_component_get(components, new NativeLong((long)i));
            if (CAPI.annis_component_type(c) != 7) continue;
            subcorpusComponent = c;
        }
        if (subcorpusComponent == null) {
            return null;
        }
        LinkedHashMap<Long, Map<Pair<String, String>, String>> node2labels = new LinkedHashMap<Long, Map<Pair<String, String>, String>>();
        LinkedHashMap<Long, Long> parentOfNode = new LinkedHashMap<Long, Long>();
        CAPI.AnnisIterPtr_AnnisNodeID itNodes = CAPI.annis_graph_nodes_by_type(orig, "corpus");
        if (itNodes != null) {
            NodeIDByRef nID = CAPI.annis_iter_nodeid_next(itNodes);
            while (nID != null) {
                Map<Pair<String, String>, String> nodeLabels = SaltExport.getNodeLabels(orig, nID.getValue());
                node2labels.put(Long.valueOf(nID.getValue()), nodeLabels);
                CAPI.AnnisVec_AnnisEdge annisVec_AnnisEdge = CAPI.annis_graph_outgoing_edges(orig, new NodeID(nID.getValue()), subcorpusComponent);
                for (int edgeIdx = 0; edgeIdx < CAPI.annis_vec_edge_size(annisVec_AnnisEdge).intValue(); ++edgeIdx) {
                    AnnisEdge edge = CAPI.annis_vec_edge_get(annisVec_AnnisEdge, new NativeLong((long)edgeIdx));
                    parentOfNode.put(edge.source.longValue(), edge.target.longValue());
                }
                nID = CAPI.annis_iter_nodeid_next(itNodes);
            }
            itNodes.dispose();
        }
        HashMap<Long, SCorpus> id2corpus = new HashMap<Long, SCorpus>();
        for (Long l : parentOfNode.values()) {
            SaltExport.addCorpusAndParents(cg, l, parentOfNode, id2corpus, node2labels);
        }
        for (Map.Entry entry : id2corpus.entrySet()) {
            Map labels = (Map)node2labels.get(entry.getKey());
            if (labels == null) continue;
            SaltExport.mapLabels((SAnnotationContainer)entry.getValue(), labels, true);
        }
        for (Map.Entry entry : parentOfNode.entrySet()) {
            Map labels;
            long childID = (Long)entry.getKey();
            long parentID = (Long)entry.getValue();
            if (id2corpus.containsKey(childID) || (labels = (Map)node2labels.get(childID)) == null) continue;
            String docName = labels.getOrDefault(new ImmutablePair((Object)"annis", (Object)"doc"), "document");
            SCorpus parent = (SCorpus)id2corpus.get(parentID);
            SDocument doc = cg.createDocument(parent, docName);
            SaltExport.mapLabels((SAnnotationContainer)doc, labels, true);
        }
        return cg;
    }
}

