/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.graphannis;

import com.sun.jna.NativeLong;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.corpus_tools.graphannis.GraphUpdate;
import org.corpus_tools.graphannis.LogLevel;
import org.corpus_tools.graphannis.SaltExport;
import org.corpus_tools.graphannis.capi.AnnisCountExtra;
import org.corpus_tools.graphannis.capi.AnnisErrorListRef;
import org.corpus_tools.graphannis.capi.CAPI;
import org.corpus_tools.graphannis.capi.CharPointer;
import org.corpus_tools.graphannis.capi.QueryAttributeDescription;
import org.corpus_tools.graphannis.errors.GraphANNISException;
import org.corpus_tools.graphannis.errors.SetLoggerError;
import org.corpus_tools.graphannis.model.AnnoKey;
import org.corpus_tools.graphannis.model.Annotation;
import org.corpus_tools.graphannis.model.Component;
import org.corpus_tools.graphannis.model.FrequencyTableEntry;
import org.corpus_tools.graphannis.model.NodeDesc;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpusStorageManager {
    private final CAPI.AnnisCorpusStorage instance;
    private final Logger log = LoggerFactory.getLogger(CorpusStorageManager.class);

    public CorpusStorageManager(String dbDir) throws GraphANNISException {
        this(dbDir, null, false, LogLevel.Off);
    }

    public CorpusStorageManager(String dbDir, String logfile, boolean useParallel, LogLevel level) throws GraphANNISException {
        File dbDirFile = new File(dbDir);
        if (dbDirFile.mkdirs()) {
            this.log.info("Created directory {} for CorpusStorageManager", (Object)dbDir);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_init_logging(logfile, level.getRaw(), err);
        try {
            err.checkErrors();
        }
        catch (SetLoggerError ex) {
            this.log.warn("Could not initialize graphANNIS logger", (Throwable)ex);
        }
        this.instance = CAPI.annis_cs_with_auto_cache_size(dbDir, useParallel);
    }

    public CorpusStorageManager(String dbDir, String logfile, long maxCacheSize, boolean useParallel, LogLevel level) throws GraphANNISException {
        File dbDirFile = new File(dbDir);
        if (dbDirFile.mkdirs()) {
            this.log.info("Created directory {} for CorpusStorageManager", (Object)dbDir);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_init_logging(logfile, level.getRaw(), err);
        try {
            err.checkErrors();
        }
        catch (SetLoggerError ex) {
            this.log.warn("Could not initialize graphANNIS logger", (Throwable)ex);
        }
        this.instance = CAPI.annis_cs_with_max_cache_size(dbDir, maxCacheSize, useParallel);
    }

    public String[] list() throws GraphANNISException {
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisVec_AnnisCString orig = CAPI.annis_cs_list(this.instance, err);
        err.checkErrors();
        String[] copy = new String[CAPI.annis_vec_str_size(orig).intValue()];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = CAPI.annis_vec_str_get(orig, new NativeLong((long)i));
        }
        orig.dispose();
        return copy;
    }

    public List<Annotation> listNodeAnnotations(String corpusName, boolean listValues, boolean onlyMostFrequentValues) {
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        if (this.instance != null) {
            CAPI.AnnisMatrix_AnnisCString orig = CAPI.annis_cs_list_node_annotations(this.instance, corpusName, listValues, onlyMostFrequentValues);
            int nrows = CAPI.annis_matrix_str_nrows(orig).intValue();
            int ncols = CAPI.annis_matrix_str_ncols(orig).intValue();
            if (ncols >= (listValues ? 3 : 2)) {
                for (int i = 0; i < nrows; ++i) {
                    Annotation anno = new Annotation();
                    AnnoKey key = new AnnoKey();
                    String ns = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(0L));
                    String name = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(1L));
                    if (!"".equals(ns)) {
                        key.setNs(ns);
                    }
                    key.setName(name);
                    anno.setKey(key);
                    if (listValues) {
                        String val = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(2L));
                        anno.setValue(val);
                    }
                    result.add(anno);
                }
            }
            orig.dispose();
        }
        return result;
    }

    public List<Annotation> listEdgeAnnotations(String corpusName, int component_type, String component_name, String component_layer, boolean listValues, boolean onlyMostFrequentValues) {
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        if (this.instance != null) {
            CAPI.AnnisMatrix_AnnisCString orig = CAPI.annis_cs_list_edge_annotations(this.instance, corpusName, component_type, component_name, component_layer, listValues, onlyMostFrequentValues);
            int nrows = CAPI.annis_matrix_str_nrows(orig).intValue();
            int ncols = CAPI.annis_matrix_str_ncols(orig).intValue();
            if (ncols >= (listValues ? 3 : 2)) {
                for (int i = 0; i < nrows; ++i) {
                    Annotation anno = new Annotation();
                    AnnoKey key = new AnnoKey();
                    String ns = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(0L));
                    String name = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(1L));
                    if (!"".equals(ns)) {
                        key.setNs(ns);
                    }
                    key.setName(name);
                    anno.setKey(key);
                    if (listValues) {
                        String val = CAPI.annis_matrix_str_get(orig, new NativeLong((long)i), new NativeLong(2L));
                        anno.setValue(val);
                    }
                    result.add(anno);
                }
            }
            orig.dispose();
        }
        return result;
    }

    public List<Component> getAllComponentsByType(String corpusName, int ctype) {
        LinkedList<Component> result = new LinkedList<Component>();
        if (this.instance != null) {
            CAPI.AnnisVec_AnnisComponent orig = CAPI.annis_cs_list_components_by_type(this.instance, corpusName, ctype);
            for (int i = 0; i < CAPI.annis_vec_component_size(orig).intValue(); ++i) {
                CAPI.AnnisComponentConst cOrig = CAPI.annis_vec_component_get(orig, new NativeLong((long)i));
                Component c = new Component();
                c.setType(ctype);
                CharPointer cname = CAPI.annis_component_name(cOrig);
                c.setName(cname == null ? "" : cname.toString());
                CharPointer clayer = CAPI.annis_component_layer(cOrig);
                c.setLayer(clayer == null ? "" : clayer.toString());
                result.add(c);
            }
        }
        return result;
    }

    public boolean validateQuery(List<String> corpora, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        boolean result = true;
        for (String corpusName : corpora) {
            AnnisErrorListRef err;
            if (!CAPI.annis_cs_validate_query(this.instance, corpusName, query, queryLanguage.capiVal, err = new AnnisErrorListRef())) {
                result = false;
            }
            err.checkErrors();
        }
        return result;
    }

    public List<NodeDesc> getNodeDescriptions(String query, QueryLanguage queryLanguage) throws GraphANNISException {
        AnnisErrorListRef err = new AnnisErrorListRef();
        QueryAttributeDescription desc = CAPI.annis_cs_node_descriptions(this.instance, query, queryLanguage.capiVal, err);
        err.checkErrors();
        return desc.getList();
    }

    public long count(List<String> corpora, String query) throws GraphANNISException {
        return this.count(corpora, query, QueryLanguage.AQL);
    }

    public long count(List<String> corpora, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        long result = 0L;
        for (String corpusName : corpora) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            result += CAPI.annis_cs_count(this.instance, corpusName, query, queryLanguage.capiVal, err);
            err.checkErrors();
        }
        return result;
    }

    public CountResult countExtra(List<String> corpora, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        CountResult result = new CountResult();
        result.documentCount = 0L;
        result.matchCount = 0L;
        for (String corpusName : corpora) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            AnnisCountExtra.ByValue resultForCorpus = CAPI.annis_cs_count_extra(this.instance, corpusName, query, queryLanguage.capiVal, err);
            err.checkErrors();
            result.matchCount += resultForCorpus.matchCount;
            result.documentCount += resultForCorpus.documentCount;
        }
        return result;
    }

    public String[] find(List<String> corpora, String query, long offset, long limit, QueryLanguage queryLanguage) throws GraphANNISException {
        return this.find(corpora, query, offset, limit, ResultOrder.Normal, queryLanguage);
    }

    public String[] find(List<String> corpora, String query, long offset, long limit, ResultOrder order) throws GraphANNISException {
        return this.find(corpora, query, offset, limit, order, QueryLanguage.AQL);
    }

    public String[] find(List<String> corpora, String query, long offset, long limit, ResultOrder order, QueryLanguage queryLanguage) throws GraphANNISException {
        ArrayList<String> result = new ArrayList<String>();
        for (String corpusName : corpora) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.AnnisVec_AnnisCString vec = CAPI.annis_cs_find(this.instance, corpusName, query, queryLanguage.capiVal, offset, limit, order.capiVal, err);
            err.checkErrors();
            int vecSize = CAPI.annis_vec_str_size(vec).intValue();
            for (int i = 0; i < vecSize; ++i) {
                result.add(CAPI.annis_vec_str_get(vec, new NativeLong((long)i)));
            }
            vec.dispose();
        }
        return result.toArray(new String[0]);
    }

    public SDocumentGraph subgraph(String corpusName, List<String> node_ids, long ctx_left, long ctx_right) throws GraphANNISException {
        CAPI.AnnisVec_AnnisCString c_node_ids = CAPI.annis_vec_str_new();
        for (String id : node_ids) {
            CAPI.annis_vec_str_push(c_node_ids, id);
        }
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.AnnisGraph graph = CAPI.annis_cs_subgraph(this.instance, corpusName, c_node_ids, new NativeLong(ctx_left), new NativeLong(ctx_right), err);
        err.checkErrors();
        SDocumentGraph result = SaltExport.map(graph);
        c_node_ids.dispose();
        graph.dispose();
        return result;
    }

    public SDocumentGraph subcorpusGraph(String corpusName, List<String> document_ids) throws GraphANNISException {
        CAPI.AnnisVec_AnnisCString c_document_ids = CAPI.annis_vec_str_new();
        for (String id : document_ids) {
            CAPI.annis_vec_str_push(c_document_ids, id);
        }
        SDocumentGraph result = null;
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.AnnisGraph graph = CAPI.annis_cs_subcorpus_graph(this.instance, corpusName, c_document_ids, err);
            err.checkErrors();
            result = SaltExport.map(graph);
            c_document_ids.dispose();
            if (graph != null) {
                graph.dispose();
            }
        }
        return result;
    }

    public SCorpusGraph corpusGraph(String corpusName) throws GraphANNISException {
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.AnnisGraph graph = CAPI.annis_cs_corpus_graph(this.instance, corpusName, err);
            err.checkErrors();
            SCorpusGraph result = SaltExport.mapCorpusGraph(graph);
            if (graph != null) {
                graph.dispose();
            }
            return result;
        }
        return null;
    }

    public SCorpusGraph corpusGraphForQuery(String corpusName, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.AnnisGraph graph = CAPI.annis_cs_subgraph_for_query_with_ctype(this.instance, corpusName, query, queryLanguage.capiVal, 7, err);
            err.checkErrors();
            SCorpusGraph result = SaltExport.mapCorpusGraph(graph);
            if (graph != null) {
                graph.dispose();
            }
            return result;
        }
        return null;
    }

    public SDocumentGraph subGraphForQuery(String corpusName, String query, QueryLanguage queryLanguage) throws GraphANNISException {
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.AnnisGraph graph = CAPI.annis_cs_subgraph_for_query(this.instance, corpusName, query, queryLanguage.capiVal, err);
            err.checkErrors();
            SDocumentGraph result = SaltExport.map(graph);
            if (graph != null) {
                graph.dispose();
            }
            return result;
        }
        return null;
    }

    public List<FrequencyTableEntry<String>> frequency(String corpusName, String query, String frequencyQueryDefinition, QueryLanguage queryLanguage) throws GraphANNISException {
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.AnnisFrequencyTable_AnnisCString orig = CAPI.annis_cs_frequency(this.instance, corpusName, query, queryLanguage.capiVal, frequencyQueryDefinition, err);
            err.checkErrors();
            if (orig != null) {
                ArrayList<FrequencyTableEntry<String>> result = new ArrayList<FrequencyTableEntry<String>>();
                int nrows = CAPI.annis_freqtable_str_nrows(orig).intValue();
                int ncols = CAPI.annis_freqtable_str_ncols(orig).intValue();
                for (int i = 0; i < nrows; ++i) {
                    NativeLong count = CAPI.annis_freqtable_str_count(orig, new NativeLong((long)i));
                    String[] tuple = new String[ncols];
                    for (int c = 0; c < ncols; ++c) {
                        tuple[c] = CAPI.annis_freqtable_str_get(orig, new NativeLong((long)i), new NativeLong((long)c));
                    }
                    result.add(new FrequencyTableEntry<String>(tuple, count.longValue()));
                }
                return result;
            }
        }
        return null;
    }

    public void importFromFileSystem(String path, ImportFormat format, String corpusName) throws GraphANNISException {
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            CAPI.annis_cs_import_from_fs(this.instance, path, format.capiVal, corpusName, err);
            err.checkErrors();
        }
    }

    public boolean deleteCorpus(String corpusName) throws GraphANNISException {
        boolean result = false;
        if (this.instance != null) {
            AnnisErrorListRef err = new AnnisErrorListRef();
            result = CAPI.annis_cs_delete(this.instance, corpusName, err);
            err.checkErrors();
        }
        return result;
    }

    public void applyUpdate(String corpusName, GraphUpdate update) throws GraphANNISException {
        AnnisErrorListRef err = new AnnisErrorListRef();
        CAPI.annis_cs_apply_update(this.instance, corpusName, update.getInstance(), err);
        err.checkErrors();
    }

    public static enum ImportFormat {
        RelANNIS(0);

        protected final int capiVal;

        private ImportFormat(int capiVal) {
            this.capiVal = capiVal;
        }
    }

    public static enum ResultOrder {
        Normal(0),
        Inverted(1),
        Randomized(2),
        NotSorted(3);

        protected final int capiVal;

        private ResultOrder(int capiVal) {
            this.capiVal = capiVal;
        }
    }

    public static enum QueryLanguage {
        AQL(0),
        AQLQuirksV3(1);

        protected final int capiVal;

        private QueryLanguage(int capiVal) {
            this.capiVal = capiVal;
        }
    }

    public static class CountResult {
        public long matchCount;
        public long documentCount;
    }
}

