[#-- This template contains the core logic for generating the various parser routines. --]
[#import "common_utils.inc.ftl" as CU]
[#var nodeNumbering = 0]
[#var exceptionNesting = 0]
[#--
[#var NODE_USES_PARSER = settings.nodeUsesParser]
[#var NODE_PREFIX = grammar.nodePrefix]
--]
[#var currentProduction]
[#var topLevelExpansion] [#-- A "one-shot" indication that we are processing
                              an expansion immediately below the BNF production expansion,
                              ignoring an ExpansionSequence that might be there. This is
                              primarily, if not exclusively, for allowing JTB-compatible
                              syntactic trees to be built. While seemingly silly (and perhaps could be done differently),
                              it is also a bit tricky, so treat it like the Holy Hand-grenade in that respect.
                          --]
[#var inFirstVarName = "", inFirstIndex = 0]
[#var jtbNameMap = {
   "Terminal" : "nodeToken",
   "Sequence" : "nodeSequence",
   "Choice" : "nodeChoice",
   "ZeroOrOne" : "nodeOptional",
   "ZeroOrMore" : "nodeListOptional",
   "OneOrMore" : "nodeList" }]
[#var nodeFieldOrdinal = {}]
[#var injectedFields = {}]
[#var syntheticNodesEnabled = settings.syntheticNodesEnabled && settings.treeBuildingEnabled]
[#var jtbParseTree = syntheticNodesEnabled && settings.jtbParseTree]

[#macro Productions]
# ===================================================================
# Start of methods for BNF Productions
# This code is generated by the parser_productions.inc.ftl template.
# ===================================================================
[#list grammar.parserProductions as production]
   [#set nodeNumbering = 0]
   [@CU.firstSetVar production.expansion/]
   [#if !production.onlyForLookahead]
      [#set currentProduction = production]
   [@ParserProduction production 4/]
   [/#if]
[/#list]
[#if settings.faultTolerant]
   [@BuildRecoverRoutines 4/]
[/#if]
[/#macro]

[#macro ParserProduction production indent]
[#var is = ""?right_pad(indent)]
   [#set nodeNumbering = 0]
   [#set nodeFieldOrdinal = {}]
   [#set injectedFields = {}]
   [#set newVarIndex = 0 in CU]
   [#-- Generate the method modifiers and header --]
   [#if production.leadingComments?has_content]
${is}# ${production.leadingComments}
   [/#if]
${is}# ${production.location}
${is}${globals::startProduction()}def parse_${production.name}(self[#if production.parameterList??], ${globals::translateParameters(production.parameterList)}[/#if]):
   [#-- Now generate the body --]
${is}    # import pdb; pdb.set_trace()
   [#-- OMITTED: "if (cancelled) throw new CancellationException();" --]
${is}    self.currently_parsed_production = '${production.name}'
   [#--${production.javaCode!}
      This is actually inserted further down because
      we want the prologue java code block to be able to refer to
      CURRENT_NODE.
   --]
   [#set topLevelExpansion = false]
${BuildCode(production, indent + 4)}
${is}# end of parse_${production.name}${globals::endProduction()}
[/#macro]

[#--
   Macro to build routines that scan up to the start of an expansion
   as part of a recovery routine
--]
[#macro BuildRecoverRoutines indent]
[#var is = ""?right_pad(indent)]
   [#list grammar.expansionsNeedingRecoverMethod as expansion]
${is}def ${expansion.recoverMethodName}(self):
${is}    initial_token = self.last_consumed_token
${is}    skipped_tokens = []
${is}    success = False
${is}    while self.last_consumed_token.type != EOF:
   [#if expansion.simpleName = "OneOrMore" || expansion.simpleName = "ZeroOrMore"]
${is}        if (${ExpansionCondition(expansion.nestedExpansion)}):
   [#else]
${is}        if (${ExpansionCondition(expansion)}):
   [/#if]
${is}            success = True
${is}            break
   [#if expansion.simpleName = "ZeroOrMore" || expansion.simpleName = "OneOrMore"]
      [#var followingExpansion = expansion.followingExpansion]
      [#list 1..1000000 as unused]
      [#if followingExpansion?is_null][#break][/#if]
      [#if followingExpansion.maximumSize > 0]
         [#if followingExpansion.simpleName = "OneOrMore" || followingExpansion.simpleName = "ZeroOrOne" || followingExpansion.simpleName = "ZeroOrMore"]
${is}        if (${ExpansionCondition(followingExpansion.nestedExpansion)}):
         [#else]
${is}        if (${ExpansionCondition(followingExpansion)}):
         [/#if]
${is}            success = True
${is}            break
      [/#if]
      [#if !followingExpansion.possiblyEmpty][#break][/#if]
      [#if followingExpansion.followingExpansion?is_null]
${is}        if self.outer_follow_set is not None:
${is}            if self.next_token_type() in self.outer_follow_set:
${is}                success = True
${is}                break
         [#break/]
      [/#if]
      [#set followingExpansion = followingExpansion.followingExpansion]
      [/#list]
   [/#if]
${is}        self.last_consumed_token = self.next_token(self.last_consumed_token)
${is}        skipped_tokens.append(self.last_consumed_token)
${is}        if not success and skipped_tokens:
${is}            self.last_consumed_token = initial_token
${is}        if success and skipped_tokens:
${is}            iv = InvalidNode(self)
         [#-- OMITTED: "iv.copyLocationInfo(skippedTokens.get(0));" --]
${is}        for tok in skipped_tokens:
${is}            iv.add(tok)
         [#-- OMITTED: "iv.setEndOffset(tok.getEndOffset());" --]
${is}        #   if self.debug_fault_tolerant:
${is}        #       logger.info('Skipping %s tokens starting at: %s', len(skipped_tokens), skipped_tokens[0].location)
${is}        self.push_node(iv)
${is}        self.pending_recovery = not success

   [/#list]
[/#macro]

#macro BuildCode expansion indent
#var is = ""?right_pad(indent)
[#--${is}# DBG > BuildCode ${indent} ${expansion.simpleName} --]
#if expansion.simpleName != "ExpansionSequence" && expansion.simpleName != "ExpansionWithParentheses"
${is}# Code for ${expansion.simpleName} specified at ${expansion.location}
/#if
[@CU.HandleLexicalStateChange expansion false indent; indent]
  #if settings.faultTolerant && expansion.requiresRecoverMethod && !expansion.possiblyEmpty
    [#var is = ""?right_pad(indent)][#-- needed for when passed as nested content --]
${is}if self.pending_recovery:
${is}    self.${expansion.recoverMethodName}()
  /#if
  [@BuildExpansionCode expansion indent/]
[/@CU.HandleLexicalStateChange][#rt]
[#--${is}# DBG < BuildCode ${indent} ${expansion.simpleName} --]
/#macro

[#macro TreeBuildingAndRecovery expansion indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > TreeBuildingAndRecovery ${indent} --]
   [#var production = null,
         treeNodeBehavior,
         buildingTreeNode = false,
         nodeVarName,
         javaCodePrologue = null,
         parseExceptionVar = CU.newVarName("parseException"),
         callStackSizeVar = CU.newVarName("callStackSize"),
         canRecover = settings.faultTolerant && expansion.tolerantParsing && expansion.simpleName != "Terminal"
   ]
   [#set treeNodeBehavior = resolveTreeNodeBehavior(expansion)]
   [#if expansion == currentProduction]
      [#-- Set this expansion as the current production and capture any Java code specified before the first expansion unit --]
      [#set production = currentProduction]
      [#set javaCodePrologue = production.javaCode!]
   [/#if]
   [#if treeNodeBehavior??]
      [#if settings.treeBuildingEnabled]
         [#set buildingTreeNode = true]
         [#set nodeVarName = nodeVar(production??)]
      [/#if]
   [/#if]
   [#if !buildingTreeNode && !canRecover]
      [#-- We need neither tree nodes nor recovery code; do the simple one. --]
${globals::translateCodeBlock(javaCodePrologue, indent)}[#rt]
      [#nested indent][#rt]
   [#else]
      [#-- We need tree nodes and/or recovery code. --]
      [#if buildingTreeNode]
         [#-- Build the tree node (part 1). --]
         [@buildTreeNode production treeNodeBehavior nodeVarName indent/]
      [/#if]
      [#-- Any prologue code can refer to CURRENT_NODE at this point. --]
${globals::translateCodeBlock(javaCodePrologue, indent)}[#rt]
${is}${parseExceptionVar} = None
${is}${callStackSizeVar} = len(self.parsing_stack)
${is}try:
${is}    pass  # in case there's nothing else in the try clause!
[#nested indent + 4]
${is}except ParseException as ${exceptionVar()}:
${is}    ${parseExceptionVar} = ${exceptionVar()}
      [#if !canRecover]
         [#if settings.faultTolerant]
${is}    if self.is_tolerant: self.pending_recovery = True
         [/#if]
${is}    raise
      [#else]
${is}    if not self.is_tolerant: raise
${is}    self.pending_recovery = True
         ${expansion.customErrorRecoveryBlock!}
         [#if !production?is_null && production.returnType != "void"]
            [#var rt = production.returnType]
            [#-- We need a return statement here or the code won't compile! --]
            [#if rt = "int" || rt = "char" || rt == "byte" || rt = "short" || rt = "long" || rt = "float"|| rt = "double"]
${is}    return 0
            [#else]
${is}    return None
            [/#if]
         [/#if]
      [/#if]
${is}finally:
${is}    self.restore_call_stack(${callStackSizeVar})
      [#if buildingTreeNode]
         [#-- Build the tree node (part 2). --]
[@buildTreeNodeEpilogue treeNodeBehavior nodeVarName parseExceptionVar indent /]
      [/#if]
   [/#if]
[#--${is}# DBG < TreeBuildingAndRecovery ${indent} --]
[/#macro]

[#function imputedJtbFieldName nodeClass]
   [#if nodeClass?? && jtbParseTree && topLevelExpansion]
      [#-- Determine the name of the node field containing the reference to a synthetic syntax node --]
      [#var fieldName = nodeClass?uncap_first]
      [#var fieldOrdinal]
      [#if jtbNameMap[nodeClass]??]
         [#-- Allow for JTB-style syntactic node names (but exclude Token and <non-terminal> ). --]
         [#set fieldName = jtbNameMap[nodeClass]/]
      [/#if]
      [#set fieldOrdinal = nodeFieldOrdinal[nodeClass]!null]
      [#if fieldOrdinal?is_null]
         [#set nodeFieldOrdinal = nodeFieldOrdinal + {nodeClass : 1}]
      [#else]
         [#set nodeFieldOrdinal = nodeFieldOrdinal + {nodeClass : fieldOrdinal + 1}]
      [/#if]
      [#var nodeFieldName = fieldName + fieldOrdinal!""]
      [#-- INJECT <production-node> : { public <field-type> <unique-field-name> } --]
      ${injectDeclaration(nodeClass, nodeFieldName)}
      [#return nodeFieldName/]
   [/#if]
   [#-- Indicate that no field name is required (either not JTB or not a top-level production node) --]
   [#return null/]
[/#function]

[#function resolveTreeNodeBehavior expansion]
   [#var treeNodeBehavior = expansion.treeNodeBehavior]
   [#var isProduction = false]
   [#if expansion.simpleName = "BNFProduction"]
      [#set isProduction = true]
   #else
      #var nodeName = syntacticNodeName(expansion) [#-- This maps ExpansionSequence containing more than one syntax element to "Sequence", otherwise to the element itself --]
      #if !treeNodeBehavior?? &&
           expansion.assignment??
         #if syntheticNodesEnabled && isProductionInstantiatingNode(expansion)
            #-- Assignment is explicitly provided and synthetic nodes are enabled --
            [#-- NOTE: An explicit assignment will take precedence over a synthetic JTB node.
               I.e., it will not create a field in the production node.  It WILL, however,
               use the syntactic node type for the natural assignment value, as seen below.
            --]
            #-- This expansion has an explicit assignment; check if we need to synthesize a definite node --
            #if nodeName?? && (
               nodeName == "ZeroOrOne" ||
               nodeName == "ZeroOrMore" ||
               nodeName == "OneOrMore" ||
               nodeName == "Choice" ||
               nodeName == "Sequence"
               )
               #-- We do need to create a definite node --
               #if !jtbParseTree
                  [#-- It's not a JTB tree, so use the BASE_NODE type for type for assignment rather than syntactic type --][#-- (jb) is there a reason to use the syntactic type always?  Perhaps, but I can't think of one. --]
               #set nodeName = settings.baseNodeClassName
               /#if
               #-- Make a new node to wrap the current expansion with the expansion's assignment. --
               #-- Default to a definite node --
               #var gtNode = false
               #var condition = null
               #var initialShorthand = null
               #if nodeName == "ZeroOrOne" ||
                   nodeName == "ZeroOrMore"
                  #-- Generate an optional node only if at least one child node --
                  #set gtNode = true
                  #set condition = "0"
                  #set initialShorthand = " > "
               /#if
               #set treeNodeBehavior = {
                                          'nodeName' : nodeName,
                                          'condition' : condition,
                                          'gtNode' : gtNode,
                                          'initialShorthand' : initialShorthand,
                                          'void' : false,
                                          'assignment' : expansion.assignment
                                       }
               #if expansion.assignment.propertyAssignment && expansion.assignment.declarationOf
                  [#-- Inject the receiving property --]
${injectDeclaration(nodeName, expansion.assignment.name, expansion.assignment)}[#t]
               /#if
            /#if
         #elseif nodeName??
            [#-- We are attempting to do assignment of a syntactic node value, but synthetic nodes are not enabled --]
            #exec grammar.errors::addWarning(currentProduction, "Attempt to assign " + nodeName + " in production node " + currentProduction.name + " but either synthetic nodes are not enabled or the production is not instantiated; the assignment will be ignored.")
            #return null
         /#if
      [#elseif treeNodeBehavior?? &&
               treeNodeBehavior.assignment??]
         [#-- There is an explicit tree node annotation with assignment; make sure a property is injected if needed. --]
         [#if treeNodeBehavior.assignment.declarationOf]
${injectDeclaration(treeNodeBehavior.nodeName, treeNodeBehavior.assignment.name, treeNodeBehavior.assignment)}[#t]
         [/#if]
         #if jtbParseTree
           #exec grammar.errors::addWarning(currentProduction, "Attempt to assign " + nodeName + " in production node " + currentProduction.name + " but it is an implicit JTB syntactic node.")
         /#if
      [#elseif jtbParseTree && expansion.parent.simpleName != "ExpansionWithParentheses" && isProductionInstantiatingNode(currentProduction)]
         [#-- No in-line definite node annotation; synthesize a parser node for the expansion type being built, if needed. --]
         [#if nodeName??]
            [#-- Determine the node name depending on syntactic type --]
            [#var nodeFieldName = imputedJtbFieldName(nodeName)] [#-- Among other things this injects the node field into the generated node if result is non-nullv--]
            #-- Default to a definite node --
            [#var gtNode = false]
            [#var condition = null]
            [#var initialShorthand = null]
            [#if nodeName == "Choice"]
               [#-- Generate a Choice node only if at least one child node --]
               [#set gtNode = true]
               [#set condition = "0"]
               [#set initialShorthand = ">"]
            [/#if]
            [#if nodeFieldName??]
               [#-- Provide an assignment to save the syntactic node in a
               synthetic field injected into the actual production node per JTB behavior. --]
               [#set treeNodeBehavior = {
                                          'nodeName' : nodeName!"nemo",
                                          'condition' : condition,
                                          'gtNode' : gtNode,
                                          'initialShorthand' : initialShorthand,
                                          'void' : false,
                                          'assignment' :
                                             { 'name' : globals::translateIdentifier("THIS_PRODUCTION") + "." + nodeFieldName,
                                               'propertyAssignment' : false,
                                               'declarationOf' : true,
                                               'existenceOf' : false }
                                       } /]
            [#else]
               [#-- Just provide the syntactic node with no LHS needed --]
               [#set treeNodeBehavior = {
                                          'nodeName' : nodeName!"nemo",
                                          'condition' : condition,
                                          'gtNode' : gtNode,
                                          'initialShorthand' : initialShorthand,
                                          'void' : false,
                                          'assignment' : null
                                       } /]
            [/#if]
         [/#if]
      [/#if]
   [/#if]
   [#if !treeNodeBehavior??]
      [#-- There is still no treeNodeBehavior determined; supply the default if this is a BNF production node. No assignment is needed. --]
      [#if isProduction && !settings.nodeDefaultVoid
                        && !grammar::nodeIsInterface(expansion.name)
                        && !grammar::nodeIsAbstract(expansion.name)]
         [#if settings.smartNodeCreation]
            [#set treeNodeBehavior = {
                                       "nodeName" : expansion.name!"nemo",
                                       "condition" : "1",
                                       "gtNode" : true,
                                       "void" :false,
                                       "initialShorthand" : ">",
                                       'assignment' : null
                                     }]
         [#else]
            [#set treeNodeBehavior = {
                                       "nodeName" : expansion.name!"nemo",
                                       "condition" : null,
                                       "gtNode" : false,
                                       "void" : false,
                                       'assignment' : null
                                     }]
         [/#if]
      [/#if]
   [/#if]
   [#if treeNodeBehavior?? && treeNodeBehavior.neverInstantiated?? && treeNodeBehavior.neverInstantiated]
      [#-- Now, if the treeNodeBehavior says it will never be instantiated, throw it all away --]
      [#return null/]
   [/#if]
   [#-- This is the actual treeNodeBehavior for this node --]
   [#return treeNodeBehavior]
[/#function]

[#-- This is primarily to distinguish sequences of syntactic elements from effectively single elements --]
[#function syntacticNodeName expansion]
      [#var classname = expansion.simpleName]
      [#if classname = "ZeroOrOne"]
         [#return classname/]
      [#elseif classname = "ZeroOrMore"]
         [#return classname/]
      [#elseif classname = "OneOrMore"]
         [#return classname/]
      [#elseif jtbParseTree && classname = "Terminal"]
         [#return classname/]
      [#elseif classname = "ExpansionChoice"]
         [#return "Choice"/]
      [#elseif classname = "ExpansionWithParentheses" || classname = "BNFProduction"]
         [#-- the () will be skipped and the nested expansion processed, so built the tree node for it rather than this --]
         [#var innerExpansion = expansion.nestedExpansion/]
         [#return syntacticNodeName(innerExpansion)/]
      [#elseif classname = "ExpansionSequence" &&
               expansion.parent?? &&
               (
                  expansion.parent.simpleName == "ExpansionWithParentheses" ||
                  (
                     expansion.parent.simpleName == "ZeroOrOne" ||
                     expansion.parent.simpleName == "OneOrMore" ||
                     expansion.parent.simpleName == "ZeroOrMore" ||
                     expansion.parent.simpleName == "ExpansionChoice"
                  ) && expansion.essentialSequence
               )]
         [#return "Sequence"/]
      [/#if]
      [#return null/]
[/#function]

#function isProductionInstantiatingNode expansion
   #return !expansion.containingProduction.treeNodeBehavior?? ||
           !expansion.containingProduction.treeNodeBehavior.neverInstantiated!true
/#function

#function nodeVar isProduction
   #var nodeVarName
   #if isProduction
      #set nodeVarName = globals::translateIdentifier("THIS_PRODUCTION")
   #else
      #set nodeNumbering = nodeNumbering + 1
      #set nodeVarName = currentProduction.name + nodeNumbering
   /#if
   #return nodeVarName
/#function

#function exceptionVar(isNesting)
   #var exceptionVarName = "e"
   #if exceptionNesting > 0
      #set exceptionVarName = "e" + exceptionNesting
   /#if
   #if isNesting!false
      #set exceptionNesting = exceptionNesting + 1
   /#if
   #return exceptionVarName
/#function

[#macro buildTreeNode production treeNodeBehavior nodeVarName indent]
[#-- FIXME: production is not used here --]
[#var is = ""?right_pad(indent)]
#exec globals::pushNodeVariableName(nodeVarName)
[@createNode nodeClassName(treeNodeBehavior) nodeVarName indent /]
[/#macro]

[#--  Boilerplate code to create the node variable --]
[#macro createNode nodeName nodeVarName indent]
[#var is = ""?right_pad(indent)]
${is}${nodeVarName} = None
${is}if self.build_tree:
${is}    ${nodeVarName} = ${nodeName}([#if settings.nodeUsesParser]self[#else]self.input_source[/#if])
${is}    self.open_node_scope(${nodeVarName})
[/#macro]

[#macro buildTreeNodeEpilogue treeNodeBehavior nodeVarName parseExceptionVar indent]
[#var is = ""?right_pad(indent)]
${is}    if ${nodeVarName}:
${is}        if ${parseExceptionVar} is None:
      [#if treeNodeBehavior?? && treeNodeBehavior.assignment??]
         [#var LHS = getLhsPattern(treeNodeBehavior.assignment, null)]
${is}            if self.close_node_scope(${nodeVarName}, ${closeCondition(treeNodeBehavior)}):
${is}                ${LHS?replace("@", "self.peek_node()")}
${is}            else:
${is}                ${LHS?replace("@", "None")}
      [#else]
${is}            self.close_node_scope(${nodeVarName}, ${closeCondition(treeNodeBehavior)})
      [/#if]
      [#list grammar.closeNodeHooksByClass[nodeClassName(treeNodeBehavior)]! as hook]
${is}            ${hook}(${nodeVarName})
      [/#list]
${is}    else:
   [#if settings.faultTolerant]
${is}        self.close_node_scope(${nodeVarName}, True)
${is}        ${nodeVarName}.dirty = True
   [#else]
${is}        self.clear_node_scope()
   [/#if]
#exec globals::popNodeVariableName()
[/#macro]

[#function getRhsAssignmentPattern assignment]
   [#if assignment.existenceOf!false]
      [#-- replace "@" with "(((@) != null) ? true : false)" --]
      [#return "(True if ((@) != None) else False)" /]
   [#elseif assignment.stringOf!false]
      [#-- replace "@" with the string value of the node or the empty string if None --]
      [#return "(lambda x = (@) : str(x) if x is not None else '')()" /]
   [/#if]
   [#return "@" /]
[/#function]

[#function getLhsPattern assignment, lhsType]
   [#if assignment??]
      [#var lhsName = assignment.name]
      [#if assignment.propertyAssignment]
         [#-- This is the assignment of the current node's effective value to a property of the production node --]
         [#if lhsType?? && assignment.declarationOf]
            [#-- This is a declaration assignment; inject required property --]
            ${injectDeclaration(lhsType, assignment.name, assignment)}
         [/#if]
         [#if assignment.addTo!false]
            [#-- This is the addition of the current node as an element of the specified list property --]
            [#return globals::translateIdentifier("THIS_PRODUCTION") + "." + globals::translateIdentifier(lhsName) + ".add(" + getRhsAssignmentPattern(assignment) + ")" /]
         [#else]
            [#-- This is an assignment of the current node's effective value to the specified property of the production node --]
            [#return globals::translateIdentifier("THIS_PRODUCTION") + "." + globals::translateIdentifier(lhsName) + " = " + getRhsAssignmentPattern(assignment) /]
         [/#if]
      [#elseif assignment.namedAssignment!false]
         [#if assignment.addTo]
            [#-- This is the addition of the current node to the named child list of the production node --]
            [#return "${globals.currentNodeVariableName}" + ".add_to_named_child_list(\"" + globals::translateIdentifier(lhsName) + "\", " + getRhsAssignmentPattern(assignment) + ")" /]
         [#else]
            [#-- This is an assignment of the current node to a named child of the production node --]
            [#return "${globals.currentNodeVariableName}" + ".set_named_child(\"" + globals::translateIdentifier(lhsName) + "\", " + getRhsAssignmentPattern(assignment) + ")" /]
         [/#if]
      [/#if]
      [#-- This is the assignment of the current node or it's returned value to an arbitrary LHS "name" (i.e., the legacy JavaCC assignment) --]
      [#return globals::translateIdentifier(lhsName) + " = " + getRhsAssignmentPattern(assignment) /]
   [/#if]
   [#-- There is no LHS --]
   [#return "@" /]
[/#function]

[#function injectDeclaration typeName, fieldName, assignment]
    #if !isProductionInstantiatingNode(currentProduction)
      #exec grammar.errors::addWarning(currentProduction, "Attempt to inject property or field declaration " + fieldName + " into an un-instantiated production node " + currentProduction.name + "; the assignment will be ignored.")
      #return ""
    /#if
   [#var modifier = "public"]
   [#var type = typeName]
   [#var field = fieldName]
   [#if assignment?? && assignment.propertyAssignment]
      [#set modifier = "@Property"]
   [/#if]
   [#if assignment?? && assignment.existenceOf]
      [#set type = "boolean"]
   [#elseif assignment?? && assignment.existenceOf]
      [#set type = "String"]
   [#elseif assignment?? && assignment.addTo]
      [#set type = "List<Node>"]
      [#set field = field + " = new ArrayList<Node>()"]
   [/#if]
   [#if !(injectedFields[field])??]
      [#set injectedFields = injectedFields + {field : type}]
      #exec grammar::addFieldInjection(currentProduction.nodeName, modifier, type, field)
   [/#if]
   [#return "" /]
[/#function]

[#function closeCondition treeNodeBehavior]
   [#var cc = "True"]
   [#if (treeNodeBehavior.condition)??]
         [#set cc = treeNodeBehavior.condition]
         [#if treeNodeBehavior.gtNode]
            [#set cc = "self.node_arity " + treeNodeBehavior.initialShorthand  + " " + cc]
         [/#if]
   [/#if]
   [#return cc/]
[/#function]

[#function nodeClassName treeNodeBehavior]
   [#if treeNodeBehavior?? && treeNodeBehavior.nodeName??]
      [#-- [#return NODE_PREFIX + treeNodeBehavior.nodeName] --]
      [#return treeNodeBehavior.nodeName]
   [/#if]
   [#-- [#return NODE_PREFIX + currentProduction.name] --]
   [#return currentProduction.name]
[/#function]

[#macro BuildExpansionCode expansion indent]
[#var is = ""?right_pad(indent)]
[#var classname = expansion.simpleName]
[#--${is}# DBG > BuildExpansionCode ${indent} ${classname} --]
    [#var prevLexicalStateVar = CU.newVarName("previousLexicalState")]
   [#-- take care of the non-tree-building classes --]
   [#if classname = "CodeBlock"]
${globals::translateCodeBlock(expansion, indent)}
   [#elseif classname = "UncacheTokens"]
${is}self.uncache_tokens()
   [#elseif classname = "Failure"]
      [@BuildCodeFailure expansion indent /]
   [#elseif classname = "Assertion"]
      [@BuildAssertionCode expansion indent /]
   [#elseif classname = "TokenTypeActivation"]
      [@BuildCodeTokenTypeActivation expansion indent /]
   [#elseif classname = "TryBlock"]
      [@BuildCodeTryBlock expansion indent /]
   [#elseif classname = "AttemptBlock"]
      [@BuildCodeAttemptBlock expansion indent /]
   [#else]
      [#-- take care of the tree node (if any) --]
      [@TreeBuildingAndRecovery expansion indent; indent]
         [#if classname = "BNFProduction"]
            [#-- The tree node having been built, now build the actual top-level expansion --]
            [#set topLevelExpansion = true]
            [@BuildCode expansion.nestedExpansion indent /]
         [#else]
            [#-- take care of terminal and non-terminal expansions; they cannot contain child expansions --]
            [#if classname = "NonTerminal"]
               [@BuildCodeNonTerminal expansion indent /]
            [#elseif classname = "Terminal"]
               [@BuildCodeTerminal expansion indent /]
            [#else]
               [#-- take care of the syntactical expansions (which can contain child expansions) --]
               [#-- capture the top-level indication in order to restore when bubbling up --]
               [#var stackedTopLevel = topLevelExpansion]
               [#if topLevelExpansion && classname != "ExpansionSequence"]
                  [#-- turn off top-level indication unless an expansion sequence (the tree node has already been determined when this nested template is expanded) --]
                  [#set topLevelExpansion = false]
               [/#if]
               [#if classname = "ZeroOrOne"]
                  [@BuildCodeZeroOrOne expansion indent /]
               [#elseif classname = "ZeroOrMore"]
                  [@BuildCodeZeroOrMore expansion indent /]
               [#elseif classname = "OneOrMore"]
                  [@BuildCodeOneOrMore expansion indent /]
               [#elseif classname = "ExpansionChoice"]
                  [@BuildCodeChoice expansion indent /]
               [#elseif classname = "ExpansionWithParentheses"]
                  [#-- Recurse; the real expansion is nested within this one (but the LHS, if any, is on the parent) --]
                  [@BuildExpansionCode expansion.nestedExpansion indent /]
               [#elseif classname = "ExpansionSequence"]
                  [@BuildCodeSequence expansion indent /]
                  [#-- leave the topLevelExpansion one-shot alone (see above) --]
               [/#if]
               [#set topLevelExpansion = stackedTopLevel]
            [/#if]
         [/#if]
      [/@TreeBuildingAndRecovery]
   [/#if]
[#--${is}# DBG < BuildExpansionCode ${indent} ${classname} --]
[/#macro]

[#-- The following macros build expansions that never build tree nodes. --]

[#macro BuildCodeFailure fail indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeFailure ${indent} --]
    [#if fail.code?is_null]
      [#if fail.exp??]
${is}self.fail('Failure: %s' % "${fail.exp?j_string}")
      [#else]
${is}self.fail('Failure')
      [/#if]
    [#else]
${globals::translateCodeBlock(fail.code, indent)}[#rt]
    [/#if]
[#--${is}# DBG < BuildCodeFailure ${indent} --]
[/#macro]

[#macro BuildAssertionCode assertion indent]
[#var is = ""?right_pad(indent)]
[#var optionalPart = ""]
[#if assertion.messageExpression??]
  [#set optionalPart = " + " + globals::translateExpression(assertion.messageExpression)]
[/#if]
[#var assertionMessage = "Assertion at: " + assertion.location?j_string + " failed."]
[#if assertion.assertionExpression??]
${is}if not (${globals::translateExpression(assertion.assertionExpression)}):
${is}    self.fail("${assertionMessage}"${optionalPart})
[/#if]
[#if assertion.expansion??]
${is}if [#if !assertion.expansionNegated]not [/#if]self.${assertion.expansion.scanRoutineName}():
${is}    self.fail("${assertionMessage}"${optionalPart})
[/#if]
[/#macro]

[#macro BuildCodeTokenTypeActivation activation indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeTokenTypeActivation ${indent} --]
[#if activation.deactivate]
${is}self.deactivate_token_types(
[#else]
${is}self.activate_token_types(
[/#if]
[#list activation.tokenNames as name]
${is}    ${name}[#if name_has_next],[/#if]
[/#list]
${is})
[#--${is}# DBG < BuildCodeTokenTypeActivation ${indent} --]
[/#macro]

[#macro BuildCodeTryBlock tryblock indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeTryBlock ${indent} --]
${is}try:
${BuildCode(tryblock.nestedExpansion, indent + 4)}[#rt]
${is}[#t]
   [#list tryblock.catchBlocks as catchBlock]
${is}${catchBlock}
   [/#list]
   # TODO verify indentation
${is}${tryblock.finallyBlock!}
[#--${is}# DBG < BuildCodeTryBlock ${indent} --]
[/#macro]

[#macro BuildCodeAttemptBlock attemptBlock indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeAttemptBlock ${indent} --]
${is}try:
${is}    self.stash_parse_state()
${BuildCode(attemptBlock.nestedExpansion, indent + 4)}
${is}    self.pop_parse_state()
#var pe = exceptionVar(true)
${is}except ParseException as ${pe}:
${is}    self.restore_stashed_parse_state()
${BuildCode(attemptBlock.recoveryExpansion, indent + 4)}
#set exceptionNesting = exceptionNesting - 1
[#--${is}# DBG < BuildCodeAttemptBlock ${indent} --]
[/#macro]

[#-- The following macros build expansions that might build tree nodes (could be called "syntactic" nodes). --]

[#macro BuildCodeNonTerminal nonterminal indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeNonTerminal ${indent} ${nonterminal.production.name} --]
   [#var production = nonterminal.production]
${is}self.push_onto_call_stack('${nonterminal.containingProduction.name}', '${nonterminal.inputSource?j_string}', ${nonterminal.beginLine}, ${nonterminal.beginColumn})
[#if settings.faultTolerant]
   [#var followSet = nonterminal.followSet]
   [#if !followSet.incomplete]
      [#if !nonterminal.beforeLexicalStateSwitch]
${is}self.outer_follow_set = self.${nonterminal.followSetVarName}
      [#else]
${is}self.outer_follow_set = None
      [/#if]
   [#elseif !followSet.empty]
${is}if self.outer_follow_set is not None:
${is}    new_follow_set = set(self.${nonterminal.followSetVarName}) | self.outer_follow_set
${is}    self.outer_follow_set = new_follow_set
   [/#if]
[/#if]
${is}try:
[@AcceptNonTerminal nonterminal indent + 4 /]
${is}finally:
${is}    self.pop_call_stack()
[#--${is}# DBG < BuildCodeNonTerminal ${indent} ${nonterminal.production.name} --]
[/#macro]

[#macro AcceptNonTerminal nonterminal indent]
[#var is = ""?right_pad(indent)]
   [#var lhsClassName = nonterminal.production.nodeName]
   [#var expressedLHS = getLhsPattern(nonterminal.assignment, lhsClassName)]
   [#var impliedLHS = "@"]
   #if jtbParseTree && isProductionInstantiatingNode(nonterminal.production) && topLevelExpansion
      #var newName = imputedJtbFieldName(nonterminal.production.nodeName)
      #set impliedLHS = globals::translateIdentifier("THIS_PRODUCTION") + "." + newName + " = @"
   /#if
   [#-- Accept the non-terminal expansion --]
   [#if nonterminal.production.returnType != "void" && expressedLHS != "@" && !nonterminal.assignment.namedAssignment && !nonterminal.assignment.propertyAssignment]
      [#-- Not a void production, so accept and clear the expressedLHS, it has already been applied. --]
${is}${expressedLHS?replace("@", "self.parse_" + nonterminal.name + "(" + globals::translateNonterminalArgs(nonterminal.args) + ")")}
      [#set expressedLHS = "@"]
   [#else]
${is}${"self.parse_" + nonterminal.name + "(" + globals::translateNonterminalArgs(nonterminal.args) + ")"}
   [/#if]
   [#if expressedLHS != "@" || impliedLHS != "@"]
      [#if nonterminal.assignment?? && (nonterminal.assignment.addTo!false || nonterminal.assignment.namedAssignment)]
${is}if self.build_tree:
${is}    ${expressedLHS?replace("@", impliedLHS?replace("@", "self.peek_node()"))}
      [#else]
${is}try:
      [#-- There had better be a node here! --]
${is}    ${expressedLHS?replace("@", impliedLHS?replace("@", "self.peek_node()"))}
${is}except Exception:
${is}    ${expressedLHS?replace("@", impliedLHS?replace("@", "None"))}
      [/#if]
   [/#if]
[/#macro]

[#macro BuildCodeTerminal terminal indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeRegexp ${indent} --]
   [#var LHS = getLhsPattern(terminal.assignment, "Token"),
         regexp = terminal.regexp ]
   [#if !settings.faultTolerant]
${is}${LHS?replace("@", "self.consume_token(" + regexp.label + ")")}
   [#else]
      [#var tolerant = terminal.tolerantParsing?string("True", "False")]
      [#var followSetVarName = "self." + terminal.followSetVarName]
      [#if terminal.followSet.incomplete]
         [#set followSetVarName = "follow_set" + CU.newID()]
${is}${followSetVarName} = None
${is}if self.outer_follow_set is not None:
${is}    ${followSetVarName} = set(self.${terminal.followSetVarName}) | self.outer_follow_set
      [/#if]
${is}${LHS?replace("@", "self.consume_token(" + regexp.label + ", " + tolerant + ", " + followSetVarName + ")")}
   [/#if]
[#--${is}# DBG < BuildCodeRegexp ${indent} --]
[/#macro]

[#macro BuildCodeZeroOrOne zoo indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeZeroOrOne ${indent} ${zoo.nestedExpansion.class.simpleName} --]
    [#if zoo.nestedExpansion.class.simpleName = "ExpansionChoice"]
${BuildCode(zoo.nestedExpansion, indent)}[#rt]
    [#else]
${is}if ${ExpansionCondition(zoo.nestedExpansion)}:
${BuildCode(zoo.nestedExpansion, indent + 4)}[#rt]
    [/#if]
[#--${is}# DBG < BuildCodeZeroOrOne ${indent} ${zoo.nestedExpansion.class.simpleName} --]
[/#macro]

[#macro BuildCodeOneOrMore oom indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeOneOrMore ${indent} --]
[#var nestedExp = oom.nestedExpansion, prevInFirstVarName = inFirstVarName/]
   [#if nestedExp.simpleName = "ExpansionChoice"]
     [#set inFirstVarName = "inFirst" + inFirstIndex, inFirstIndex = inFirstIndex + 1 /]
${is}${inFirstVarName} = True
   [/#if]
${is}while True:
${RecoveryLoop(oom, indent + 4)}
      [#if nestedExp.simpleName = "ExpansionChoice"]
${is}    ${inFirstVarName} = False
      [#else]
${is}    if not (${ExpansionCondition(oom.nestedExpansion)}): break
      [/#if]
   [#set inFirstVarName = prevInFirstVarName /]
[#--${is}# DBG < BuildCodeOneOrMore ${indent} --]
[/#macro]

[#macro BuildCodeZeroOrMore zom indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeZeroOrMore ${indent} --]
${is}while True:
       [#if zom.nestedExpansion.class.simpleName != "ExpansionChoice"]
${is}    if not (${ExpansionCondition(zom.nestedExpansion)}): break
       [/#if]
[@RecoveryLoop zom indent + 4 /]
[#--${is}# DBG < BuildCodeZeroOrMore ${indent} --]
[/#macro]

[#macro RecoveryLoop loopExpansion indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > RecoveryLoop ${indent} --]
   [#if !settings.faultTolerant || !loopExpansion.requiresRecoverMethod]
${BuildCode(loopExpansion.nestedExpansion, indent)}[#rt]
   [#else]
   [#var initialTokenVarName = "initialToken" + CU.newID()]
${is}${initialTokenVarName} = self.last_consumed_token
${is}try:
${BuildCode(loopExpansion.nestedExpansion, indent + 4)}[#rt]
${is}except ParseException as pe:
${is}    logger.exception('Hit a parsing exception: %s', pe)
${is}    if not self.is_tolerant: raise
${is}    if self.debug_fault_tolerant:
${is}        logger.info('Handling exception. Last consumed token: %s at: %s', self.last_consumed_token.image, self.last_consumed_token.location)
${is}    if ${initialTokenVarName} is self.last_consumed_token:
${is}        self.last_consumed_token = self.next_token(self.last_consumed_token)
${is}        # We have to skip a token in this spot or
${is}        # we'll be stuck in an infinite loop!
${is}        self.last_consumed_token.skipped = True
${is}        if self.debug_fault_tolerant:
${is}            logger.info('Skipping token %s at: %s', self.last_consumed_token.image, self.last_consumed_token.location)
${is}    if self.debug_fault_tolerant:
${is}        logger.info('Repeat re-sync for expansion at: ${loopExpansion.location?j_string}');
${is}    self.${loopExpansion.recoverMethodName}();
${is}    if self.pending_recovery: raise
   [/#if]
[#--${is}# DBG < RecoveryLoop ${indent} --]
[/#macro]

#macro BuildCodeChoice choice indent
#var is = ""?right_pad(indent)
[#--${is}# DBG > BuildCodeChoice ${indent} --]
#list choice.choices as expansion
  #if expansion.enteredUnconditionally
${is}else:
${BuildCode(expansion, indent + 4)}[#rt]
    #if expansion_has_next
      #var nextExpansion = choice[expansion_index + 1]
${is}# Warning: choice at ${nextExpansion.location} is is ignored because the
${is}# choice at ${expansion.location} is entered unconditionally and we jump
${is}# out of the loop..
    /#if
    #return
  /#if
${is}${(expansion_index == 0)?string("if", "elif")} (${ExpansionCondition(expansion)}):
${BuildCode(expansion, indent + 4)}[#rt]
  #if jtbParseTree && isProductionInstantiatingNode(expansion)
${is}    ${globals.currentNodeVariableName}.setChoice(${expansion_index})
  /#if
/#list
[#if choice.parent.simpleName == "ZeroOrMore"][#t]
${is}else:  # *
${is}    break
[#elseif choice.parent.simpleName = "OneOrMore"][#t]
${is}elif (${inFirstVarName}): # +
${is}    self.push_onto_call_stack('${currentProduction.name}', '${choice.inputSource?j_string}', ${choice.beginLine}, ${choice.beginColumn})
${is}    raise ParseException(self, expected=self.${choice.firstSetVarName})
${is}else:
${is}    break
[#elseif choice.parent.simpleName != "ZeroOrOne"][#t]
${is}else:  # not *, +, or ?
${is}    self.push_onto_call_stack('${currentProduction.name}', '${choice.inputSource?j_string}', ${choice.beginLine}, ${choice.beginColumn})
${is}    raise ParseException(self, expected=self.${choice.firstSetVarName})
[/#if]
[#--${is}# DBG < BuildCodeChoice ${indent} --]
/#macro

[#macro BuildCodeSequence expansion indent]
[#var is = ""?right_pad(indent)]
[#--${is}# DBG > BuildCodeSequence ${indent} --]
   [#list expansion.units as subexp]
${BuildCode(subexp, indent)}[#rt]
   [/#list]
[#--${is}# DBG < BuildCodeSequence ${indent} --]
[/#macro]

[#-- The following is a set of utility macros used in expansions. --]

[#--
     Macro to generate the condition for entering an expansion
     including the default single-token lookahead
--]
[#macro ExpansionCondition expansion]
   [#if expansion.requiresPredicateMethod]
${ScanAheadCondition(expansion)}[#t]
   [#else]
${SingleTokenCondition(expansion)}[#t]
   [/#if]
[/#macro]

[#-- Generates code for when we need a scanahead --]
[#macro ScanAheadCondition expansion]
[#if expansion.lookahead?? && expansion.lookahead.assignment??](${expansion..assignment.name} = [/#if][#if expansion.hasSemanticLookahead && !expansion.lookahead.semanticLookaheadNested](${globals::translateExpression(expansion.semanticLookahead)}) and [/#if]self.${expansion.predicateMethodName}()[#if expansion.lookahead?? && expansion.lookahead.assignment??])[/#if][#t]
[/#macro]

[#-- Generates code for when we don't need any scanahead routine --]
[#macro SingleTokenCondition expansion]
[#if expansion.hasSemanticLookahead](${globals::translateExpression(expansion.semanticLookahead)}) and [/#if][#t]
[#if expansion.enteredUnconditionally]True[#elseif expansion.firstSet.tokenNames?size == 0]False[#elseif expansion.firstSet.tokenNames?size < 5][#list expansion.firstSet.tokenNames as name](self.next_token_type == ${name})[#if name_has_next] or [/#if][/#list][#else](self.next_token_type in self.${expansion.firstSetVarName})[/#if][#t]
[/#macro]
