// Generated by ${generated_by}. Do not edit.
// ReSharper disable InconsistentNaming
[#import "CommonUtils.inc.ftl" as CU]
[#var NFA_RANGE_THRESHOLD = 16]
[#var MAX_INT = 2147483647]
[#var multipleLexicalStates = lexerData.lexicalStates?size > 1]
[#var TT = "TokenType."]
[#var PRESERVE_LINE_ENDINGS = settings.preserveLineEndings?string("true", "false")
      JAVA_UNICODE_ESCAPE = settings.javaUnicodeEscape?string("true", "false")
      ENSURE_FINAL_EOL = settings.ensureFinalEOL?string("true", "false")
      TERMINATING_STRING = "\"" + settings.terminatingString?j_string + "\""
      PRESERVE_TABS = settings.preserveTabs?string("true", "false")
 ]
[#var BaseToken = settings.baseTokenClassName]
[#-- if settings.treeBuildingEnabled || settings.rootAPIPackage]
  [#set BaseToken = "Node.TerminalNode"]
[/#if --]
[#var TOKEN = settings.baseTokenClassName]

[#macro EnumSet varName tokenNames indent = 0]
[#if tokenNames?size == 0]
private static HashSet<TokenType> ${varName} = Utils.GetOrMakeSet();
[#else]
private static HashSet<TokenType> ${varName} = Utils.GetOrMakeSet(
[#list tokenNames as type]
    TokenType.${type}[#if type_index < (tokenNames?size - 1)],[/#if]
[/#list]
);
[/#if]
[/#macro]

[#--
  Generate all the NFA transition code
  for the given lexical state
--]
[#macro GenerateStateCode lexicalState]
  [#list lexicalState.canonicalSets as state]
    [#if state_index = 0]
     [@GenerateInitialStateMethod state /]
    [#else]
     [@GenerateNfaMethod state /]
    [/#if]
  [/#list]

  [#list lexicalState.allNfaStates as nfaState]
    [#if nfaState.moveRanges?size >= NFA_RANGE_THRESHOLD]
      [@GenerateMoveArray nfaState /]
    [/#if]
  [/#list]



        private static void NFA_FUNCTIONS_${lexicalState.name}Init() {
            var f = new NfaFunction[] {
[#list lexicalState.canonicalSets as state]
                ${state.methodName}[#if state_has_next],[/#if]
[/#list]
            };
    [#if multipleLexicalStates]
            functionTableMap.Add(LexicalState.${lexicalState.name}, f);
    [#else]
            nfaFunctions = f;
    [/#if]
        }

[/#macro]

[#--
   Generate the array representing the characters
   that this NfaState "accepts".
   This corresponds to the moveRanges field in
   org.congocc.core.NfaState
--]
[#macro GenerateMoveArray nfaState]
[#var moveRanges = nfaState.moveRanges]
[#var arrayName = nfaState.movesArrayName]
        private static int[] ${arrayName} = {
[#list nfaState.moveRanges as char]
            ${globals.displayChar(char)}[#if char_has_next],[/#if]
[/#list]
        };

[/#macro]

[#macro GenerateInitialStateMethod nfaState]
        static TokenType? ${nfaState.methodName}(int ch, BitSet nextStates, HashSet<TokenType> validTypes, HashSet<TokenType> AlreadyMatchedTypes) {
            TokenType? type = null;
    [#var states = nfaState.orderedStates, lastBlockStartIndex = 0, useIf = false]
    [#list states as state]
      [#if state_index == 0 || !state.moveRanges::equals(states[state_index - 1].moveRanges)]
          [#-- In this case we need a new if or possibly else if --]
         [#if state_index == 0 || state::overlaps(states::subList(lastBlockStartIndex, state_index))]
           [#-- If there is overlap between this state and any of the states
                 handled since the last lone if, we start a new if-else
                 If not, we continue in the same if-else block as before. --]
           [#set lastBlockStartIndex = state_index]
           [#set useIf = true]
         [/#if]
            [#if useIf]if[#else]else if[/#if] ([@NfaStateCondition state /]) {
      [/#if]
      [#if state.nextStateIndex >= 0]
                nextStates.Set(${state.nextStateIndex});
      [/#if]
      [#if !state_has_next || !state.moveRanges::equals(states[state_index + 1].moveRanges)]
        [#-- We've reached the end of the block. --]
          [#if state.nextState.final]
                [#var type = state.type]
                if (validTypes.Contains(${TT}${type.label})) {
                    type = ${TT}${type.label};
                }
          [/#if]
            }
      [/#if]
    [/#list]
            return type;
        }
[/#macro]


[#--
   Generate the method that represents the transitions
   that correspond to an instanceof org.congocc.core.CompositeNfaState
--]
[#macro GenerateNfaMethod nfaState]
        static TokenType? ${nfaState.methodName}(int ch, BitSet nextStates, HashSet<TokenType> validTypes, HashSet<TokenType> AlreadyMatchedTypes) {
  [#if lexerData::isLazy(nfaState.type)]
    if (AlreadyMatchedTypes.Contains(${TT}${nfaState.type.label})) {
        return null;
    }
  [/#if]

            TokenType? type = null;
    [#var states = nfaState.orderedStates, lastBlockStartIndex = 0, useIf = false]
    [#list states as state]
      [#if state_index == 0 || !state.moveRanges::equals(states[state_index - 1].moveRanges)]
          [#-- In this case we need a new if or possibly else if --]
         [#if state_index == 0 || state::overlaps(states::subList(lastBlockStartIndex, state_index))]
           [#-- If there is overlap between this state and any of the states
                 handled since the last lone if, we start a new if-else
                 If not, we continue in the same if-else block as before. --]
           [#set lastBlockStartIndex = state_index]
           [#set useIf = true]
         [/#if]
            [#if useIf]if[#else]else if[/#if] ([@NfaStateCondition state /]) {
      [/#if]
      [#if state.nextStateIndex >= 0]
                nextStates.Set(${state.nextStateIndex});
      [/#if]
      [#if !state_has_next || !state.moveRanges::equals(states[state_index + 1].moveRanges)]
        [#-- We've reached the end of the block. --]
          [#if state.nextState.final]
                [#var type = state.type]
                if (validTypes.Contains(${TT}${type.label})) {
                    type = ${TT}${type.label};
                }
          [/#if]
            }
      [/#if]
    [/#list]
            return type;
        }

[/#macro]

[#--
Generate the condition part of the NFA state transition
If the size of the moveRanges vector is greater than NFA_RANGE_THRESHOLD
it uses the canned binary search routine. For the smaller moveRanges
it just generates the inline conditional expression
--]
[#macro NfaStateCondition nfaState]
    [#if nfaState.moveRanges?size < NFA_RANGE_THRESHOLD]
      [@RangesCondition nfaState.moveRanges /]
    [#elseif nfaState.hasAsciiMoves && nfaState.hasNonAsciiMoves]
      ([@RangesCondition nfaState.asciiMoveRanges/]) || ((ch >= (char) 128) && CheckIntervals(${nfaState.movesArrayName}, ch))
    [#else]
      CheckIntervals(${nfaState.movesArrayName}, ch)
    [/#if]
[/#macro]

[#--
This is a recursive macro that generates the code corresponding
to the accepting condition for an NFA state. It is used
if NFA state's moveRanges array is smaller than NFA_RANGE_THRESHOLD
(which is set to 16 for now)
--]
[#macro RangesCondition moveRanges]
    [#var left = moveRanges[0], right = moveRanges[1]]
    [#var displayLeft = globals.displayChar(left), displayRight = globals.displayChar(right)]
    [#var singleChar = left == right]
    [#if moveRanges?size == 2]
       [#if singleChar]
          ch == ${displayLeft}
       [#elseif left + 1 == right]
          ch == ${displayLeft} || ch == ${displayRight}
       [#elseif left > 0]
          ch >= ${displayLeft}
          [#if right < 1114111]
 && ch <= ${displayRight}
          [/#if]
       [#else]
           ch <= ${displayRight}
       [/#if]
    [#else]
       ([@RangesCondition moveRanges[0..1]/]) || ([@RangesCondition moveRanges[2..]/])
    [/#if]
[/#macro]

[#var csPackage = globals::getPreprocessorSymbol('cs.package', settings.parserPackage) ]
namespace ${csPackage} {
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.IO;
    using System.Text;
    using System.Text.RegularExpressions;
${globals::translateLexerImports()}

    public class TokenSource {
        internal const int DEFAULT_TAB_SIZE = ${settings.tabSize};

        internal static readonly Token DummyStartToken[#if settings.usesPreprocessor], Ignored[/#if], Skipped;
        public string InputSource { get; internal set; }
        internal readonly string _content;
        internal readonly int _contentLength;
        // The starting line and column, usually 1,1
        // that is used to report a file position
        // in 1-based line/column terms
        internal int startingLine, startingColumn;

        internal readonly int[] _lineOffsets;   // offsets to the beginnings of lines
        internal readonly Token[] _tokenLocationTable;
        internal readonly BitSet _tokenOffsets;

        //  A Bitset that stores the line numbers that
        // contain either hard tabs or extended (beyond 0xFFFF) unicode
        // characters.
        internal readonly BitSet _needToCalculateColumns;

        static TokenSource() {
            DummyStartToken = new InvalidToken(null, 0, 0);
[#if settings.usesPreprocessor]
            Ignored = new InvalidToken(null, 0, 0);
            Ignored.IsUnparsed = true;
[/#if]
            Skipped = new InvalidToken(null, 0, 0);
            Skipped.IsUnparsed = true;
        }

        protected TokenSource(string inputSource, int startLine, int startColumn) {
            InputSource = inputSource;
            startingLine = startLine;
            startingColumn = startColumn;
            var input = InputText(inputSource);
            _content = MungeContent(input, ${PRESERVE_TABS}, ${PRESERVE_LINE_ENDINGS}, ${JAVA_UNICODE_ESCAPE}, ${TERMINATING_STRING});
            _contentLength = _content.Length;
            _needToCalculateColumns = new BitSet(_contentLength + 1);
            _lineOffsets = CreateLineOffsetsTable(_content);
            _tokenLocationTable = new Token[_contentLength + 1];
            _tokenOffsets = new BitSet(_contentLength + 1);
        }

        public void SetStartingPos(int line, int col) {
            startingLine = line;
            startingColumn = col;
        }

        // string-like methods
        internal int Length {
            get { return _contentLength; }
        }

        internal char this[int index] {
            get { return _content[index]; }
        }


        private static readonly Regex PythonCodingPattern = new Regex(@"^[ \t\f]*#.*\bcoding[:=][ \t]*([-_.a-zA-Z0-9]+)");
        private static readonly UTF8Encoding Utf8 = new UTF8Encoding(true);
        private static readonly UnicodeEncoding Utf16Le = new UnicodeEncoding(false, true, true);
        private static readonly UnicodeEncoding Utf16Be = new UnicodeEncoding(true, true, true);
        private static readonly UTF32Encoding Utf32Le = new UTF32Encoding(false, true, true);
        private static readonly UTF32Encoding Utf32Be = new UTF32Encoding(true, true, true);

        private bool PreamblesEqual(Span<byte> data, byte[] preamble) {
            for (int i = preamble.Length - 1; i >= 0; i--) {
                if (data[i] != preamble[i]) {
                    return false;
                }
            }
            return true;
        }

        private String InputText(string path) {
            FileStream fs;

            try {
                fs = new FileStream(path, FileMode.Open);
            }
            catch (IOException) {
                // assume we were passed source code.
                return path;
            }
            var fileLen = (int) fs.Length;
            var bytes = new byte[fileLen];
            var bomLen = 3;
            Encoding encoding;
            var allBytes = new Span<byte>(bytes);
            Span<byte> bomBytes;
            Span<byte> foundBom = null;

            fs.Read(bytes, 0, fileLen);

            if (fileLen <= bomLen) {
                encoding = Utf8;
            }
            else if (PreamblesEqual(bomBytes = allBytes[..bomLen], Utf8.GetPreamble())) {
                encoding = Utf8;
                foundBom = bomBytes;
            }
            else if (PreamblesEqual(bomBytes = allBytes[..(bomLen = 2)], Utf16Le.GetPreamble())) {
                encoding = Utf16Le;
                foundBom = bomBytes;
            }
            else if (PreamblesEqual(bomBytes, Utf16Be.GetPreamble())) {
                encoding = Utf16Be;
                foundBom = bomBytes;
            }
            else if (PreamblesEqual(bomBytes = allBytes[(bomLen = 4)..], Utf32Le.GetPreamble())) {
                encoding = Utf32Le;
                foundBom = bomBytes;
            }
            else if (PreamblesEqual(bomBytes, Utf32Be.GetPreamble())) {
                encoding = Utf32Be;
                foundBom = bomBytes;
            }
            else {
                encoding = Utf8;
                if (path.EndsWith(".py")) {
                    // Look for coding declared in first two lines
                    var pos = System.Array.IndexOf(bytes, '\n');
                    if (pos > 0) {
                        var s = Utf8.GetString(allBytes.Slice(0, pos));
                        var m = PythonCodingPattern.Match(s);

                        if (m.Success) {
                            s = m.Groups[1].Value;
                            encoding = Encoding.GetEncoding(s);
                        }
                        else {
                            pos = System.Array.IndexOf(bytes, '\n', pos + 1);
                            if (pos > 0) {
                                s = Utf8.GetString(allBytes.Slice(0, pos));
                                m = PythonCodingPattern.Match(s);
                                if (m.Success) {
                                    s = m.Groups[1].Value;
                                    encoding = Encoding.GetEncoding(s);
                                }
                            }
                        }
                    }
                }
            }
            var rest = (foundBom == null) ? allBytes : allBytes[bomLen..];
            return encoding.GetString(rest);
        }

        private string MungeContent(string content, bool preserveTabs, bool preserveLines,
                      bool unicodeEscape, string terminatingString)
        {
            StringBuilder buf;

            if (preserveTabs && preserveLines && !unicodeEscape) {
                if (terminatingString.Length == 0) return _content;
                if (content.Length == 0) {
                    content = terminatingString;
                }
                else {
                    if (content.EndsWith(terminatingString)) {
                       return content;
                    }
                    buf = new StringBuilder(content);
                    buf.Append(terminatingString);
                    content = buf.ToString();
                }
                return content;
            }
            buf = new StringBuilder();
            // This is just to handle tabs to spaces. If you don't have that setting set, it
            // is really unused.
            var col = 0;
            var justSawUnicodeEscape = false;
            // There might be some better way of doing this ...
            var bytes = Encoding.UTF32.GetBytes(content);
            var codePoints = new int[bytes.Length / 4];
            Buffer.BlockCopy(bytes, 0, codePoints, 0, bytes.Length);
            for (var index = 0; index < codePoints.Length; )
            {
                var ch = codePoints[index++];
                switch (ch)
                {
                    case '\\' when unicodeEscape && index < codePoints.Length:
                    {
                        ch = codePoints[index++];
                        if (ch != 'u') {
                            justSawUnicodeEscape = false;
                            buf.Append('\\');
                            buf.Append((char) ch);
                            if (ch == '\n')
                                col = 0;
                            else
                                col += 2;
                        } else {
                            while (codePoints[index] == 'u') {
                                index++;
                                // col++;
                            }
                            var hexBuf = new StringBuilder(4);
                            for (var i = 0; i < 4; i++) hexBuf.Append((char) codePoints[index++]);
                            var current = (char) Convert.ToInt32(hexBuf.ToString(), 16);
                            var last = buf.Length > 0 ? buf[^1] : (char) 0;
                            if (justSawUnicodeEscape && char.IsSurrogatePair(last, current)) {
                                buf.Length -= 1;
                                --col;
                                buf.Append(char.ConvertToUtf32(last, current));
                                justSawUnicodeEscape = false;
                            } else {
                                buf.Append(current);
                                justSawUnicodeEscape = true;
                            }
                            // col += 6;
                            ++col;
                            // We're not going to be trying to track line/column information relative to the original content
                            // with tabs or unicode escape, so we just increment 1, not 6
                        }

                        break;
                    }
                    case '\r' when !preserveLines:
                    {
                        justSawUnicodeEscape = false;
                        buf.Append('\n');
                        if (index < codePoints.Length) {
                            ch = codePoints[index++];
                            if (ch != '\n') {
                                buf.Append((char) ch);
                                ++col;
                            }
                            else
                            {
                                col = 0;
                            }
                        }
                        break;
                    }
                    case '\t' when !preserveTabs:
                    {
                        justSawUnicodeEscape = false;
                        int spacesToAdd = ${settings.tabSize} - col % ${settings.tabSize};
                        for (int i = 0; i < spacesToAdd; i++) {
                            buf.Append(' ');
                            col++;
                        }

                        break;
                    }
                    default:
                    {
                        justSawUnicodeEscape = false;
                        buf.Append(char.ConvertFromUtf32(ch));
                        if (ch == '\n') {
                            col = 0;
                        } else
                            col++;

                        break;
                    }
                }
            }
            if (terminatingString.Length == 0) return buf.ToString();
            if (buf.Length < terminatingString.Length) {
                buf.Append(terminatingString);
            }
            else {
                String finalPart = buf.ToString(buf.Length - terminatingString.Length, terminatingString.Length);
                if (!finalPart.Equals(terminatingString)) {
                    buf.Append(terminatingString);
                }
            }
            return buf.ToString();
        }

        private static readonly int[] EmptyInt = new int[] { 0 };

        private int[] CreateLineOffsetsTable(string content) {
            var length = content.Length;
            if (length == 0) {
                return EmptyInt;
            }
            var lineCount = 0;
            for (var i = 0; i < length; i++) {
                var ch = content[i];
                if (ch == '\t' || char.IsHighSurrogate(ch)) {
                    _needToCalculateColumns.Set(lineCount);
                }
                if (ch == '\n') {
                    lineCount++;
                }
            }
            if (content[^1] != '\n') {
                lineCount++;
            }
            var lineOffsets = new int[lineCount];
            lineOffsets[0] = 0;
            var index = 1;
            for (var i = 0; i < length; i++) {
                var ch = content[i];
                if (ch == '\n') {
                    if (i + 1 == length)
                        break;
                    lineOffsets[index++] = i + 1;
                }
            }
            return lineOffsets;
        }

        protected void SkipTokens(int begin, int end) {
            for (int i = begin; i < end; i++) {
[#if settings.usesPreprocessor]
                if (_tokenLocationTable[i] != Ignored) {
                    _tokenLocationTable[i] = Skipped;
                }
[#else]
                _tokenLocationTable[i] = Skipped;
[/#if]
            }
        }

[#if settings.usesPreprocessor]
        public int NextUnignoredOffset(int offset) {
            while (offset < _tokenLocationTable.Length - 1  && _tokenLocationTable[offset] == Ignored) {
                ++offset;
            }
            return offset;
        }

        protected void SetIgnoredRange(int begin, int end) {
            for (int offset = begin; offset < end; offset++) {
                _tokenLocationTable[offset] = Ignored;
                _tokenOffsets.Clear(begin, end);
            }
        }

        public bool IsIgnored(int offset) {
            return _tokenLocationTable[offset] == Ignored;
        }

        public bool SpansPPInstruction(int start, int end) {
            for (int i = start; i < end; i++) {
                if (IsIgnored(i)) {
                    return true;
                }
            }
            return false;
        }
/*
        public int Length(int start, int end) {
            int result = 0;
            for (int i = start; i < end; i++) {
                if (!IsIgnored(i)) {
                    ++result;
                }
            }
            return result;
        }
 */
        protected void SetLineSkipped(${BaseToken} tok, bool ignore = true) {
            int lineNum = tok.BeginLine;
            int start = GetLineStartOffset(lineNum);
            int end = GetLineStartOffset(lineNum + 1);
            if (ignore) {
                SetIgnoredRange(start, end);
            }
            tok.BeginOffset = start;
            tok.EndOffset = end;
        }

[/#if]
[#if settings.cppContinuationLine]
    protected void HandleCContinuationLines() {
      for (int offset = _content.IndexOf('\\'); offset >= 0; offset = _content.IndexOf('\\', offset + 1)) {
          int nlIndex = _content.IndexOf('\n', offset);
          if (nlIndex < 0) break;
          if (_content.Substring(offset + 1, nlIndex).Trim().IsEmpty) {
              SetIgnoredRange(offset, nlIndex + 1);
          }
      }
    }

[/#if]
        virtual public void CacheToken(Token tok) {
            int beginOffset = tok.BeginOffset;
            int endOffset = tok.EndOffset;

            _tokenOffsets.Set(beginOffset);
            if (endOffset > beginOffset + 1) {
                // This handles some weird usage cases where token locations
                // have been adjusted.
                _tokenOffsets.Clear(beginOffset + 1, endOffset);
                for (int i = beginOffset + 1; i < endOffset; i++) {
[#if settings.usesPreprocessor]
                    if (_tokenLocationTable[i] != Ignored)
[/#if]
                        _tokenLocationTable[i] = null;
                }
            }
            _tokenLocationTable[beginOffset] = tok;
        }

        virtual public void UncacheTokens(Token lastToken) {
            int endOffset = lastToken.EndOffset;
            if (endOffset < _tokenOffsets.Length) {
                _tokenOffsets.Clear(lastToken.EndOffset, _tokenOffsets.Length);
            }
        }

        /**
        * return the line length in code _units_
        */
        public int GetLineLength(int lineNumber) {
            int startOffset = GetLineStartOffset(lineNumber);
            int endOffset = GetLineEndOffset(lineNumber);
            return 1 + endOffset - startOffset;
        }

        /**
        * The number of supplementary unicode characters in the specified
        * offset range. The range is expressed in code units

        private int NumSupplementaryCharactersInRange(int start, int end) {
            int result = 0;
            while (start < end - 1) {
                if (char.IsHighSurrogate(_content[start++])) {
                    if (char.IsLowSurrogate(_content[start])) {
                        start++;
                        result++;
                    }
                }
            }
            return result;
        }
        */

        public int GetCodePointColumnFromOffset(int pos) {
            if (pos >= _contentLength) return 1;
            if (pos == 0) return startingColumn;
            var line = GetLineFromOffset(pos) - startingLine;
            var lineStart = _lineOffsets[line];
            var startColumnAdjustment = line > 0 ? 1 : startingColumn;
            var unadjustedColumn = pos - lineStart + startColumnAdjustment;
            if (!_needToCalculateColumns[line]) {
                return unadjustedColumn;
            }
            if (char.IsLowSurrogate(_content[pos])) --pos;
            var result = startColumnAdjustment;
            for (int i = lineStart; i < pos; i++) {
                var ch = _content[i];
                if (ch == '\t') {
                    result += DEFAULT_TAB_SIZE - (result - 1) % DEFAULT_TAB_SIZE;
                }
                else if (char.IsHighSurrogate(ch)) {
                    ++result;
                    ++i;
                }
                else {
                    ++result;
                }
            }
            return result;
        }

        /**
        * @return the text between startOffset (inclusive)
        * and endOffset(exclusive)
        */
        public string GetText(int startOffset, int endOffset) {
[#if !settings.usesPreprocessor]
            return _content.Substring(startOffset, endOffset - startOffset);
[#else]
            StringBuilder buf = new StringBuilder();
            for (int offset = startOffset; offset < endOffset; offset++) {
                if (_tokenLocationTable[offset] != Ignored) {
                    buf.Append(_content[offset]);
                }
            }
            return buf.ToString();
[/#if]
        }

        public ${BaseToken} NextCachedToken(int offset) {
            int nextOffset = _tokenOffsets.NextSetBit(offset);
            return nextOffset == -1 ? null : _tokenLocationTable[nextOffset];
        }

        public ${BaseToken} PreviousCachedToken(int offset) {
            int prevOffset = _tokenOffsets.PreviousSetBit(offset - 1);
            return prevOffset == -1 ? null : _tokenLocationTable[prevOffset];
        }

[#if settings.usesPreprocessor]
        /**
        * This is used in conjunction with having a preprocessor.
        * We set which lines are actually parsed lines and the
        * unset ones are ignored.
        * @param parsedLines a #java.util.BitSet that holds which lines
        * are parsed (i.e. not ignored)
        */
        private void SetParsedLines(BitSet parsedLines, bool reversed) {
            for (int i = 0; i < _lineOffsets.Length; i++) {
                bool turnOffLine = !parsedLines[i + 1];
                if (reversed) turnOffLine = !turnOffLine;
                if (turnOffLine) {
                    int lineOffset = _lineOffsets[i];
                    int nextLineOffset = i < _lineOffsets.Length - 1 ? _lineOffsets[i + 1] : _contentLength;
                    SetIgnoredRange(lineOffset, nextLineOffset);
                }
            }
        }

        /**
        * This is used in conjunction with having a preprocessor.
        * We set which lines are actually parsed lines and the
        * unset ones are ignored.
        * @param parsedLines a #java.util.BitSet that holds which lines
        * are parsed (i.e. not ignored)
        */
        public void SetParsedLines(BitSet parsedLines) {SetParsedLines(parsedLines, false);}

        public void SetUnparsedLines(BitSet unparsedLines) {SetParsedLines(unparsedLines, true);}

[/#if]
        /*
         * The offset of the start of the given line. This is in code units
         */
        public int GetLineStartOffset(int lineNumber) {
            int realLineNumber = lineNumber - startingLine;
            if (realLineNumber <= 0) {
                return 0;
            }
            if (realLineNumber >= _lineOffsets.Length) {
                return _contentLength;
            }
            return _lineOffsets[realLineNumber];
        }

        /*
         * The offset of the end of the given line. This is in code units.
         */
        public int GetLineEndOffset(int lineNumber) {
            int realLineNumber = lineNumber - startingLine;
            if (realLineNumber < 0) {
                return 0;
            }
            if (realLineNumber >= _lineOffsets.Length) {
                return _contentLength;
            }
            if (realLineNumber == _lineOffsets.Length - 1) {
                return _contentLength - 1;
            }
            return _lineOffsets[realLineNumber + 1] - 1;
        }

        /**
        * @return the line number from the absolute offset passed in as a parameter
        */
        public int GetLineFromOffset(int pos) {
            if (pos >= _contentLength) {
                if (_content[_contentLength - 1] == '\n') {
                    return startingLine + _lineOffsets.Length;
                }
                return startingLine + _lineOffsets.Length - 1;
            }
            int bsearchResult = System.Array.BinarySearch(_lineOffsets, pos);
            if (bsearchResult >= 0) {
                return startingLine + bsearchResult;
            }
            return startingLine -(bsearchResult + 2);
        }

    }

    internal class MatchInfo {
        internal TokenType matchedType;
        internal int matchLength;

        override public int GetHashCode() {
            return matchLength.GetHashCode() + matchedType.GetHashCode();
        }

        override public bool Equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (GetType() != obj.GetType())
                return false;
            MatchInfo other = (MatchInfo) obj;
            return matchLength == other.matchLength && matchedType == other.matchedType;
        }
    }

    public class Lexer : TokenSource[#if useLogging!false], IObservable<LogInfo>[/#if] {

[#if settings.lexerUsesParser]
        internal Parser Parser { get; internal set; }
[/#if]


[#if lexerData.hasLexicalStateTransitions]
        // A lookup for lexical state transitions triggered by a certain token type
        private static Dictionary<TokenType, LexicalState> tokenTypeToLexicalStateMap = new Dictionary<TokenType, LexicalState>();
[/#if]

        // Token types that are "regular" tokens that participate in parsing,
        // i.e. declared as TOKEN
        [@EnumSet "regularTokens" lexerData.regularTokens.tokenNames 8 /]
        // Token types that do not participate in parsing
        // i.e. declared as UNPARSED (or SPECIAL_TOKEN)
        [@EnumSet "unparsedTokens" lexerData.unparsedTokens.tokenNames 8 /]
        [#-- // Tokens that are skipped, i.e. SKIP --]
        [@EnumSet "skippedTokens" lexerData.skippedTokens.tokenNames 8 /]
        // Tokens that correspond to a MORE, i.e. that are pending
        // additional input
        [@EnumSet "moreTokens" lexerData.moreTokens.tokenNames 8 /]

        // NFA code and data

        // The functional interface that represents
        // the acceptance method of an NFA state
        private delegate TokenType? NfaFunction(int ch, BitSet bs, HashSet<TokenType> validTypes, HashSet<TokenType> AlreadyMatchedTypes);

[#--        private delegate MatchInfo? MatcherHook(LexicalState lexicalState, string source, int position, HashSet<TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo); --]

[#if multipleLexicalStates]
        // A lookup of the NFA function tables for the respective lexical states.
        private static Dictionary<LexicalState, NfaFunction[]> functionTableMap = new Dictionary<LexicalState, NfaFunction[]>();
[#else]
        [#-- We don't need the above lookup if there is only one lexical state.--]
        private static NfaFunction[] nfaFunctions;
[/#if]

        // Just use the canned binary search to check whether the char
        // is in one of the intervals
        private static bool CheckIntervals(int[] ranges, int ch) {
            var temp = System.Array.BinarySearch(ranges, ch);
            return temp >= 0 || temp % 2 == 0;
        }

[#list lexerData.lexicalStates as lexicalState]
[@GenerateStateCode lexicalState/]
[/#list]

        [#-- Compute the maximum size of state bitsets --]
[#if !multipleLexicalStates]
            private const int MaxStates = ${lexerData.lexicalStates[0].allNfaStates?size};
[#else]
            private static int MaxStates = Utils.MaxOf(
[#list lexerData.lexicalStates as state]
                ${state.allNfaStates?size}[#if state_has_next],[/#if]
[/#list]
            );
[/#if]

[#--        private static MatcherHook MATCHER_HOOK; --]

        // The following two BitSets are used to store
        // the current active NFA states in the core tokenization loop
        private BitSet _nextStates = new BitSet(MaxStates), _currentStates = new BitSet(MaxStates);

        internal HashSet<TokenType> ActiveTokenTypes = Utils.EnumSet(
[#list lexerData.regularExpressions as regexp]
            TokenType.${regexp.label}[#if regexp_has_next],[/#if]
[/#list]
        );

        private LexicalState _lexicalState;
        public LexicalState LexicalState => _lexicalState;

        // constructors

        static Lexer() {
[#list lexerData.lexicalStates as lexicalState]
            NFA_FUNCTIONS_${lexicalState.name}Init();
[/#list]
[#if lexerData.hasLexicalStateTransitions]
            // Generate the map for lexical state transitions from the various token types
  [#list lexerData.regularExpressions as regexp]
    [#if !regexp.newLexicalState?is_null]
            tokenTypeToLexicalStateMap[TokenType.${regexp.label}] = LexicalState.${regexp.newLexicalState.name};
    [/#if]
  [/#list]
[/#if]
        }

[#if useLogging!false]
        private readonly IList<IObserver<LogInfo>> observers = new List<IObserver<LogInfo>>();
[/#if]

        public Lexer(string inputSource, LexicalState lexState = LexicalState.${lexerData.lexicalStates[0].name}, int line = 1, int column = 1) : base(inputSource, line, column) {
[#if settings.deactivatedTokens?size > 0 || settings.extraTokens?size > 0]
  [#list settings.deactivatedTokens as token]
            ActiveTokenTypes.Remove(${CU.TT}${token});
  [/#list]
  [#list settings.extraTokenNames as token]
            regularTokens.Add(${CU.TT}${token});
  [/#list]
[/#if]
${globals::translateLexerInitializers()}
            SwitchTo(lexState);
        }

[#if useLogging!false]
        public IDisposable Subscribe(IObserver<LogInfo> observer)
        {
            if (!observers.Contains(observer)) {
                observers.Add(observer);
            }
            return new Unsubscriber<LogInfo>(observers, observer);
        }

        internal void Log(LogLevel level, string message, params object[] arguments) {
            var info = new LogInfo(level, message, arguments);
            foreach (var observer in observers) {
                observer.OnNext(info);
            }
        }
[/#if]
        //
        // Switch to specified lexical state.
        //
        public bool SwitchTo(LexicalState lexState) {
            if (_lexicalState != lexState) {
                _lexicalState = lexState;
                return true;
            }
            return false;
        }

[#if lexerData.hasLexicalStateTransitions]
        internal bool DoLexicalStateSwitch(TokenType tokenType) {
            if (!tokenTypeToLexicalStateMap.ContainsKey(tokenType)) {
                return false;
            }
            LexicalState newState = tokenTypeToLexicalStateMap[tokenType];
            return SwitchTo(newState);
        }
[/#if]

        public Token GetNextToken(${TOKEN} tok) {
            return GetNextToken(tok, ActiveTokenTypes);
        }

        /**
        * The public method for getting the next token.
        * If the tok parameter is null, it just tokenizes
        * starting at the internal _bufferPosition
        * Otherwise, it checks whether we have already cached
        * the token after this one. If not, it finally goes
        * to the NFA machinery
        */
        public ${TOKEN} GetNextToken(${TOKEN} tok, HashSet<TokenType> activeTokenTypes) {
            if(tok == null) {
                tok = TokenizeAt(0, null, activeTokenTypes);
                CacheToken(tok);
                return tok;
            }
            ${TOKEN} cachedToken = tok.NextCachedToken;
            // If the cached next token is not currently active, we
            // throw it away and go back to the lexer
            if (cachedToken != null && (activeTokenTypes != null) && !activeTokenTypes.Contains(cachedToken.Type)) {
                Reset(tok);
                cachedToken = null;
            }
            if (cachedToken == null) {
                ${TOKEN} token = TokenizeAt(tok.EndOffset, null, activeTokenTypes);
                CacheToken(token);
                return token;
            }
            return cachedToken;
        }

        static private int ReadChar(string content, int length, ref int position) {
            char ch = content[position++];
            if (char.IsHighSurrogate(ch) && position < length) {
                char nextChar = content[position];
                if (char.IsLowSurrogate(nextChar)) {
                    ++position;
                    return char.ConvertToUtf32(ch, nextChar);
                }
            }
            return ch;
        }

        /**
        * Core tokenization method. Note that this can be called from a static context.
        * Hence the extra parameters that need to be passed in.
        */
        static MatchInfo GetMatchInfo(TokenSource input, int position, HashSet<TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet? currentStates, BitSet? nextStates, MatchInfo? matchInfo) {
            if (matchInfo == null) {
                matchInfo = new MatchInfo();
            }
            if (position >= input._contentLength) {
                matchInfo.matchedType = TokenType.EOF;
                matchInfo.matchLength = 0;
                return matchInfo;
            }
            int start = position;
            int matchLength = 0;
            TokenType matchedType = TokenType.INVALID;
            HashSet<TokenType> alreadyMatchedTypes = new HashSet<TokenType>();
            if (currentStates == null)
                currentStates = new BitSet(MaxStates);
            else
                currentStates.Clear();
            if (nextStates == null)
                nextStates = new BitSet(MaxStates);
            else
                nextStates.Clear();
            // the core NFA loop
            do {
                // Holder for the new type (if any) matched on this iteration
                if (position > start) {
                    // What was nextStates on the last iteration
                    // is now the currentStates!
                    BitSet temp = currentStates;
                    currentStates = nextStates;
                    nextStates = temp;
                    nextStates.Clear();
[#if settings.usesPreprocessor]
                    position = input.NextUnignoredOffset(position);
[/#if]
                } else {
                    currentStates.Set(0);
                }
                if (position >= input._contentLength) {
                    break;
                }
                int curChar = ReadChar(input._content, input._contentLength, ref position);
                int nextActive = currentStates.NextSetBit(0);
                while(nextActive != -1) {
                    TokenType? returnedType = nfaFunctions[nextActive](curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                    if (returnedType != null && ((position - start > matchLength) || (returnedType < matchedType))) {
                        matchedType = (TokenType) returnedType;
                        matchLength = position - start;
                        alreadyMatchedTypes.Add((TokenType) returnedType);
                    }
                    nextActive = currentStates.NextSetBit(nextActive + 1);
                }
                if (position >= input._contentLength) break;
            } while (!nextStates.IsEmpty);
            matchInfo.matchedType = matchedType;
            matchInfo.matchLength = matchLength;
            return matchInfo;
        }

        /**
        * @param position The position at which to tokenize.
        * @param lexicalState The lexical state in which to tokenize. If this is null, it is the instance variable #lexicalState
        * @param activeTokenTypes The active token types. If this is null, they are all active.
        * @return the Token at position
        */
        private ${TOKEN} TokenizeAt(int position, LexicalState? lexicalState, HashSet<TokenType> activeTokenTypes) {
            if (lexicalState == null) lexicalState = this._lexicalState;
            int tokenBeginOffset = position;
            bool inMore = false;
            int invalidRegionStart = -1;
            ${TOKEN} matchedToken = null;
            TokenType? matchedType = null;
            // The core tokenization loop
            MatchInfo matchInfo = new MatchInfo();
            BitSet currentStates = new BitSet(MaxStates);
            BitSet nextStates = new BitSet(MaxStates);
            while (matchedToken == null) {
[#if multipleLexicalStates]
            // Get the NFA function table for the current lexical state.
            // If we are in a MORE, there is some possibility that there
            // was a lexical state change since the last iteration of this loop!
                NfaFunction[] nfaFunctions = GetFunctionTable(_lexicalState);
[/#if]
[#if settings.usesPreprocessor]
                position = NextUnignoredOffset(position);
[/#if]
                if (!inMore) {
                    tokenBeginOffset = position;
                }
[#--
                if (MATCHER_HOOK != null) {
                    matchInfo = MATCHER_HOOK((LexicalState) lexicalState, _content, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                    if (matchInfo == null) {
                        matchInfo = GetMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                    }
                } else {
                    matchInfo = GetMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
--]
                matchInfo = GetMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                matchedType = matchInfo.matchedType;
                inMore = moreTokens.Contains((TokenType) matchedType);
                position += matchInfo.matchLength;
[#if lexerData.hasLexicalStateTransitions]
                LexicalState newState;

                if (tokenTypeToLexicalStateMap.TryGetValue((TokenType) matchedType, out newState)) {
                    lexicalState = this._lexicalState = newState;
                }
[/#if]
                if (matchedType == TokenType.INVALID) {
                    if (invalidRegionStart == -1) {
                        invalidRegionStart = tokenBeginOffset;
                    }
                    char cp  = _content[position];
                    ++position;
                    if (cp > 0xFFFF) {
                        ++position;
                    }
                    continue;
                }
                if (invalidRegionStart != -1) {
                    return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
                }
                if (skippedTokens.Contains((TokenType) matchedType)) {
                    SkipTokens(tokenBeginOffset, position);
                }
                else if (regularTokens.Contains((TokenType) matchedType) || unparsedTokens.Contains((TokenType) matchedType)) {
                    matchedToken = ${TOKEN}.NewToken((TokenType) matchedType,
                                                  this,
                                                  tokenBeginOffset,
                                                  position);
                    matchedToken.IsUnparsed = !regularTokens.Contains((TokenType) matchedType);
                }
            }
[#if lexerData.hasLexicalStateTransitions]
            DoLexicalStateSwitch(matchedToken.Type);
[/#if]
[#if lexerData.hasTokenActions]
            matchedToken = TokenLexicalActions(matchedToken, matchedType);
[/#if  ]
[#list grammar.lexerTokenHooks as tokenHookMethodName]
  [#if tokenHookMethodName = "CommonTokenAction"]
                ${globals::translateIdentifier(tokenHookMethodName)}(matchedToken);
  [#else]
                    matchedToken = ${globals::translateIdentifier(tokenHookMethodName)}(matchedToken);
  [/#if]
[/#list]
            return matchedToken;
        }

        /* The main method to invoke the NFA machinery
        private Token NextToken() {
            Token matchedToken = null;
            var inMore = false;
            var tokenBeginOffset = _bufferPosition;
            var firstChar = 0;
            // The core tokenization loop
            while (matchedToken == null) {
                var codeUnitsRead = 0;
                var matchedPos = 0;
                int curChar;
                TokenType? matchedType = null;
                var reachedEnd = false;
                if (inMore) {
                    curChar = ReadChar();
                    if (curChar < 0) reachedEnd = true;
                }
                else {
                    tokenBeginOffset = _bufferPosition;
                    firstChar = curChar = ReadChar();
                    if (curChar < 0) {
                        matchedType = TokenType.EOF;
                        reachedEnd = true;
                    }
                }
[#if multipleLexicalStates]
                // Get the NFA function table current lexical state
                // There is some possibility that there was a lexical state change
                // since the last iteration of this loop!
[/#if]
                NfaFunction[] functions = GetFunctionTable(_lexicalState);
                HashSet<TokenType> AlreadyMatchedTypes = new HashSet<TokenType>();
                // the core NFA loop
                if (!reachedEnd) do {
                    // Holder for the new type (if any) matched on this iteration
                    TokenType? newType = null;
                    if (codeUnitsRead > 0) {
                        // What was _nextStates on the last iteration
                        // is now the _currentStates!
                        (_currentStates, _nextStates) = (_nextStates, _currentStates);
                        var c = ReadChar();
                        if (c >= 0) {
                            curChar = c;
                        }
                        else {
                            // reachedEnd = true;
                            break;
                        }
                    }
                    _nextStates.Clear();
                    if (codeUnitsRead == 0) {
                        TokenType? returnedType = functions[0](curChar, _nextStates, ActiveTokenTypes, AlreadyMatchedTypes);
                        if (returnedType != null) {
                            AlreadyMatchedTypes.Add((TokenType) returnedType);
                            newType = returnedType;
                        }
                    }
                    else {
                        int nextActive = _currentStates.NextSetBit(0);
                        while (nextActive != -1) {
                            TokenType? returnedType = functions[nextActive](curChar, _nextStates, ActiveTokenTypes, AlreadyMatchedTypes);
                            if ((returnedType != null) && ((newType == null) || (returnedType.Value < (int) newType.Value))) {
                                AlreadyMatchedTypes.Add((TokenType) returnedType);
                                newType = returnedType;
                            }
                            nextActive = _currentStates.NextSetBit(nextActive + 1);
                        }
                    }
                    ++codeUnitsRead;
                    if (curChar >= 0xFFFF) {
                        ++codeUnitsRead;
                    }
                    if (newType != null) {
                        matchedType = newType;
                        inMore = moreTokens.Contains(matchedType.Value);
                        matchedPos = codeUnitsRead;
                    }
                } while (!_nextStates.IsEmpty);
                if (matchedType == null) {
                    _bufferPosition = tokenBeginOffset + 1;
                    if (firstChar > 0xFFFF) {
                        ++_bufferPosition;
                    }
                    return new InvalidToken(this, tokenBeginOffset, _bufferPosition);
                }
                _bufferPosition -= (codeUnitsRead - matchedPos);
                if (skippedTokens.Contains((TokenType) matchedType)) {
                    for (int i = tokenBeginOffset; i < _bufferPosition; i++) {
                        if (_tokenLocationTable[i] != Ignored) {
                            _tokenLocationTable[i] = Skipped;
                        }
                    }
                }
                if (regularTokens.Contains((TokenType) matchedType) || unparsedTokens.Contains((TokenType) matchedType)) {
                    matchedToken = ${TOKEN}.NewToken((TokenType) matchedType,
                                                  this,
                                                  tokenBeginOffset,
                                                  _bufferPosition);
                    matchedToken.IsUnparsed = !regularTokens.Contains((TokenType) matchedType);
                }
     [#if lexerData.hasTokenActions]
                matchedToken = TokenLexicalActions(matchedToken, matchedType);
     [/#if]
     [#if lexerData.hasLexicalStateTransitions]
                DoLexicalStateSwitch(matchedType.Value);
     [/#if]
            }
 [#list grammar.lexerTokenHooks as tokenHookMethodName]
    [#if tokenHookMethodName = "CommonTokenAction"]
                ${tokenHookMethodName}(matchedToken);
    [#else]
                matchedToken = ${tokenHookMethodName}(matchedToken);
    [/#if]
 [/#list]
            return matchedToken;
        }
*/
        // Reset the token source input
        // to just after the ${TOKEN} passed in.
        internal void Reset(${TOKEN} t, LexicalState? state = null) {
[#list grammar.resetTokenHooks as resetTokenHookMethodName]
            ${globals::translateIdentifier(resetTokenHookMethodName)}(t);
[/#list]
            UncacheTokens(t);
            if (state != null) {
                SwitchTo(state.Value);
            }
[#if lexerData.hasLexicalStateTransitions]
            else {
                DoLexicalStateSwitch(t.Type);
            }
[/#if]
        }

[#if lexerData.hasTokenActions]
        private Token TokenLexicalActions(Token matchedToken, TokenType? matchedType) {
            switch (matchedType) {
        [#list lexerData.regularExpressions as regexp]
                [#if regexp.codeSnippet??]
            case TokenType.${regexp.label}:
${globals::translateCodeBlock(regexp.codeSnippet.javaCode, 16)}
                break;
                [/#if]
        [/#list]
            default: break;
            }
            return matchedToken;
        }
[/#if]
#if false
        private int ReadChar() {
            while (_tokenLocationTable[_bufferPosition] == Ignored && _bufferPosition < _contentLength) {
                ++_bufferPosition;
            }
            if (_bufferPosition >= _contentLength) {
                return -1;
            }
            char ch = _content[_bufferPosition++];
            if (char.IsHighSurrogate(ch) && _bufferPosition < _contentLength) {
                char nextChar = _content[_bufferPosition];
                if (char.IsLowSurrogate(nextChar)) {
                    ++_bufferPosition;
                    return char.ConvertToUtf32(ch, nextChar);
                }
            }
            return ch;
        }

/#if
[#if settings.tokenChaining]
        override public void CacheToken(${BaseToken} tok) {
            ${TOKEN} token = (${TOKEN}) tok;
            if (token.isInserted) {
                ${TOKEN} next = tok.NextCachedToken;
                if (next != null) CacheToken(next);
                return;
            }
            base.CacheToken(tok);
        }

        override public void UncacheTokens(${BaseToken} lastToken) {
            base.UncacheTokens(lastToken);
            ((${TOKEN}) lastToken).UnsetAppendedToken();
        }
[/#if]

        protected bool AtLineStart(${TOKEN} tok) {
            int offset = tok.BeginOffset;
            while (offset > 0) {
                --offset;
                char c = _content[offset];
                if (!Char.IsWhiteSpace(c)) return false;
                if (c == '\n') break;
            }
            return true;
        }

        protected string GetLine(${TOKEN} tok) {
            int lineNum = tok.BeginLine;
            return GetText(GetLineStartOffset(lineNum), GetLineEndOffset(lineNum) + 1);
        }

        private static NfaFunction[] GetFunctionTable(LexicalState lexicalState) {
[#if multipleLexicalStates]
            return functionTableMap[lexicalState];
[#else]
            // We only have one lexical state in this case, so we return that!
            return nfaFunctions;
[/#if]
        }

${globals::translateLexerInjections(true)}

${globals::translateLexerInjections(false)}
    }
}
