/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.preprocessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.congocc.preprocessor.PreprocessorLexer;
import org.congocc.preprocessor.TokenSource;

public class Token
implements CharSequence {
    private PreprocessorLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Boolean spansPPInstruction;

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public PreprocessorLexer getTokenSource() {
        return this.tokenSource;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (PreprocessorLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    public int getBeginLine() {
        PreprocessorLexer ts = this.getTokenSource();
        return ts == null ? 0 : ts.getLineFromOffset(this.getBeginOffset());
    }

    public int getEndLine() {
        PreprocessorLexer ts = this.getTokenSource();
        return ts == null ? 0 : ts.getLineFromOffset(this.getEndOffset() - 1);
    }

    public int getBeginColumn() {
        PreprocessorLexer ts = this.getTokenSource();
        return ts == null ? 0 : ts.getCodePointColumnFromOffset(this.getBeginOffset());
    }

    public int getEndColumn() {
        PreprocessorLexer ts = this.getTokenSource();
        return ts == null ? 0 : ts.getCodePointColumnFromOffset(this.getEndOffset() - 1);
    }

    public String getInputSource() {
        PreprocessorLexer ts = this.getTokenSource();
        return ts != null ? ts.getInputSource() : "input";
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        PreprocessorLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        PreprocessorLexer ts = this.getTokenSource();
        return ts == null ? null : ts.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, PreprocessorLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    public boolean isUnparsed() {
        return this.unparsed;
    }

    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, PreprocessorLexer tokenSource, int beginOffset, int endOffset) {
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    protected boolean spansPPInstruction() {
        if (this.spansPPInstruction == null) {
            this.spansPPInstruction = this.getTokenSource().spansPPInstruction(this.beginOffset, this.endOffset);
        }
        return this.spansPPInstruction;
    }

    @Override
    public int length() {
        if (this.spansPPInstruction()) {
            return this.getTokenSource().length(this.beginOffset, this.endOffset);
        }
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.spansPPInstruction()) {
            StringBuilder buf = new StringBuilder();
            PreprocessorLexer ts = this.getTokenSource();
            int scanTo = this.beginOffset + end;
            for (int i = this.beginOffset + start; i < scanTo; ++i) {
                if (ts.isIgnored(i)) {
                    ++scanTo;
                    continue;
                }
                buf.append(ts.charAt(i));
            }
            return buf;
        }
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        PreprocessorLexer ts = this.getTokenSource();
        int scanTo = this.beginOffset + offset;
        if (this.spansPPInstruction()) {
            for (int index = this.beginOffset; index < scanTo; ++index) {
                if (!ts.isIgnored(index)) continue;
                ++scanTo;
            }
        }
        return ts.charAt(scanTo);
    }

    @Deprecated
    public String getImage() {
        return this.getSource();
    }

    @Override
    public String toString() {
        return this.getSource();
    }

    public static enum TokenType {
        EOF,
        PP_TRUE,
        PP_FALSE,
        PP_OR,
        PP_AND,
        PP_LPAREN,
        PP_RPAREN,
        PP_ASSIGN,
        PP_EQUALS,
        PP_NOT_EQUALS,
        PP_NOT,
        PP_LINE,
        PP_DEFINE,
        PP_UNDEF,
        PP_IF,
        PP_ELIF,
        PP_ELSE,
        PP_ENDIF,
        PP_IGNORED_DIRECTIVE,
        PP_START,
        PP_FALSE_ALERT,
        PP_SYMBOL,
        PP_EOL_COMMENT,
        _TOKEN_23,
        DUMMY,
        INVALID;


        public boolean isUndefined() {
            return this == DUMMY;
        }

        public boolean isInvalid() {
            return this == INVALID;
        }

        public boolean isEOF() {
            return this == EOF;
        }
    }
}

