/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.preprocessor;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.congocc.preprocessor.NonTerminalCall;
import org.congocc.preprocessor.ParseException;
import org.congocc.preprocessor.PreprocessorLexer;
import org.congocc.preprocessor.Token;
import org.congocc.preprocessor.TokenSource;

public class PreprocessorParser {
    private final BitSet lineMarkers = new BitSet(100000);
    private Map<String, String> definedSymbols = new HashMap<String, String>();
    private boolean currentlyOn = true;
    static final int UNLIMITED = Integer.MAX_VALUE;
    Token lastConsumedToken;
    private Token.TokenType nextTokenType;
    private Token currentLookaheadToken;
    private String currentlyParsedProduction;
    private String currentLookaheadProduction;
    private final boolean legacyGlitchyLookahead = false;
    private final Token DUMMY_START_TOKEN = new Token();
    private boolean cancelled;
    private PreprocessorLexer token_source;
    private static final HashMap<Token.TokenType[], EnumSet<Token.TokenType>> enumSetCache = new HashMap();
    private static final EnumSet<Token.TokenType> first_set$Preprocessor_ccc$149$21 = PreprocessorParser.tokenTypeSet(Token.TokenType.PP_LINE, Token.TokenType.PP_FALSE_ALERT);
    private static final EnumSet<Token.TokenType> first_set$Preprocessor_ccc$211$6 = PreprocessorParser.tokenTypeSet(Token.TokenType.PP_EQUALS, Token.TokenType.PP_NOT_EQUALS);
    private static final EnumSet<Token.TokenType> first_set$Preprocessor_ccc$285$7 = PreprocessorParser.tokenTypeSet(Token.TokenType.PP_TRUE, Token.TokenType.PP_FALSE, Token.TokenType.PP_LPAREN, Token.TokenType.PP_SYMBOL);
    private ArrayList<NonTerminalCall> parsingStack = new ArrayList();
    private final ArrayList<NonTerminalCall> lookaheadStack = new ArrayList();

    public BitSet getLineMarkers() {
        return this.lineMarkers;
    }

    private void setLineMarker() {
        int lineNumber = this.lastConsumedToken.getBeginLine();
        if (this.currentlyOn) {
            this.lineMarkers.set(lineNumber);
        }
    }

    public void setSymbol(String symbol, String value) {
        this.definedSymbols.put(symbol, value);
    }

    public void unsetSymbol(String symbol) {
        this.definedSymbols.put(symbol, "0");
    }

    public void addSymbols(Map<String, String> symbols) {
        this.definedSymbols.putAll(symbols);
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setInputSource(String inputSource) {
        this.token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return this.token_source.getInputSource();
    }

    public PreprocessorParser(String inputSource, CharSequence content) {
        this(new PreprocessorLexer(inputSource, content));
    }

    public PreprocessorParser(CharSequence content) {
        this("input", content);
    }

    public PreprocessorParser(String inputSource, Path path) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path)));
    }

    public PreprocessorParser(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path), charset));
    }

    public PreprocessorParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    public PreprocessorParser(PreprocessorLexer lexer) {
        this.token_source = lexer;
        this.lastConsumedToken = this.DUMMY_START_TOKEN;
        this.lastConsumedToken.setTokenSource(lexer);
    }

    public void setStartingPos(int startingLine, int startingColumn) {
        this.token_source.setStartingPos(startingLine, startingColumn);
    }

    public boolean getLegacyGlitchyLookahead() {
        return false;
    }

    private Token nextToken(Token tok) {
        Token result = this.token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result = this.token_source.getNextToken(result);
        }
        this.nextTokenType = null;
        return result;
    }

    public final Token getNextToken() {
        return this.getToken(1);
    }

    public final Token getToken(int index) {
        int i;
        Token t = this.currentLookaheadToken == null ? this.lastConsumedToken : this.currentLookaheadToken;
        for (i = 0; i < index; ++i) {
            t = this.nextToken(t);
        }
        for (i = 0; i > index && (t = t.getPrevious()) != null; --i) {
        }
        return t;
    }

    private Token.TokenType nextTokenType() {
        if (this.nextTokenType == null) {
            this.nextTokenType = this.nextToken(this.lastConsumedToken).getType();
        }
        return this.nextTokenType;
    }

    boolean activateTokenTypes(Token.TokenType ... types) {
        if (this.token_source.activeTokenTypes == null) {
            return false;
        }
        boolean result = false;
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.add(tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    boolean deactivateTokenTypes(Token.TokenType ... types) {
        boolean result = false;
        if (this.token_source.activeTokenTypes == null) {
            this.token_source.activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
        }
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.remove((Object)tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    private static EnumSet<Token.TokenType> tokenTypeSet(Token.TokenType first, Token.TokenType ... rest) {
        Token.TokenType[] key = new Token.TokenType[1 + rest.length];
        key[0] = first;
        if (rest.length > 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort((Object[])key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<Token.TokenType> result = rest.length == 0 ? EnumSet.of(first) : EnumSet.of(first, rest);
        enumSetCache.put(key, result);
        return result;
    }

    public final BitSet PP_Root() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_Root";
        this.pushOntoCallStack("PP_Root", "examples/preprocessor/Preprocessor.ccc", 145, 23);
        try {
            this.PP_Block();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.EOF);
        return this.lineMarkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void PP_Block() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_Block";
        while (true) {
            if (this.nextTokenType() == Token.TokenType.PP_IF) {
                this.pushOntoCallStack("PP_Block", "examples/preprocessor/Preprocessor.ccc", 147, 18);
                try {
                    this.PP_IfBlock();
                }
                finally {
                    this.popCallStack();
                }
                continue;
            }
            if (this.nextTokenType() == Token.TokenType.PP_DEFINE) {
                this.pushOntoCallStack("PP_Block", "examples/preprocessor/Preprocessor.ccc", 147, 31);
                try {
                    this.PP_DefStatement();
                }
                finally {
                    this.popCallStack();
                }
                continue;
            }
            if (this.nextTokenType() == Token.TokenType.PP_UNDEF) {
                this.pushOntoCallStack("PP_Block", "examples/preprocessor/Preprocessor.ccc", 147, 49);
                try {
                    this.PP_UndefStatement();
                }
                finally {
                    this.popCallStack();
                }
                continue;
            }
            if (this.nextTokenType() != Token.TokenType.PP_LINE && this.nextTokenType != Token.TokenType.PP_FALSE_ALERT) return;
            this.pushOntoCallStack("PP_Block", "examples/preprocessor/Preprocessor.ccc", 147, 69);
            try {
                this.PP_Content();
                continue;
            }
            finally {
                this.popCallStack();
                continue;
            }
            break;
        }
    }

    public final void PP_Content() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_Content";
        do {
            if (this.nextTokenType() == Token.TokenType.PP_LINE) {
                this.consumeToken(Token.TokenType.PP_LINE);
            } else if (this.nextTokenType() == Token.TokenType.PP_FALSE_ALERT) {
                this.consumeToken(Token.TokenType.PP_FALSE_ALERT);
            } else {
                this.pushOntoCallStack("PP_Content", "examples/preprocessor/Preprocessor.ccc", 149, 21);
                throw new ParseException(this.lastConsumedToken, first_set$Preprocessor_ccc$149$21, this.parsingStack);
            }
            this.setLineMarker();
        } while (this.nextTokenType() == Token.TokenType.PP_LINE || this.nextTokenType == Token.TokenType.PP_FALSE_ALERT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void PP_IfBlock() {
        Expression result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_IfBlock";
        boolean alreadyHandled = false;
        boolean previouslyOn = this.currentlyOn;
        this.consumeToken(Token.TokenType.PP_IF);
        this.pushOntoCallStack("PP_IfBlock", "examples/preprocessor/Preprocessor.ccc", 158, 5);
        try {
            result = this.PP_Expression();
        }
        finally {
            this.popCallStack();
        }
        if (result.booleanValue) {
            alreadyHandled = true;
        }
        this.currentlyOn = result.booleanValue && previouslyOn;
        this.pushOntoCallStack("PP_IfBlock", "examples/preprocessor/Preprocessor.ccc", 162, 5);
        try {
            this.PP_Block();
        }
        finally {
            this.popCallStack();
        }
        if (alreadyHandled) {
            this.currentlyOn = false;
        }
        while (this.nextTokenType() == Token.TokenType.PP_ELIF) {
            this.consumeToken(Token.TokenType.PP_ELIF);
            this.pushOntoCallStack("PP_IfBlock", "examples/preprocessor/Preprocessor.ccc", 164, 19);
            try {
                result = this.PP_Expression();
            }
            finally {
                this.popCallStack();
            }
            if (!alreadyHandled) {
                alreadyHandled = result.booleanValue;
                this.currentlyOn = previouslyOn && result.booleanValue;
            }
            this.pushOntoCallStack("PP_IfBlock", "examples/preprocessor/Preprocessor.ccc", 171, 9);
            try {
                this.PP_Block();
            }
            finally {
                this.popCallStack();
            }
        }
        if (this.nextTokenType() == Token.TokenType.PP_ELSE) {
            this.consumeToken(Token.TokenType.PP_ELSE);
            this.currentlyOn = !alreadyHandled && previouslyOn;
            this.pushOntoCallStack("PP_IfBlock", "examples/preprocessor/Preprocessor.ccc", 175, 9);
            try {
                this.PP_Block();
            }
            finally {
                this.popCallStack();
            }
        }
        this.consumeToken(Token.TokenType.PP_ENDIF);
        this.currentlyOn = previouslyOn;
    }

    public final void PP_DefStatement() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_DefStatement";
        String value = "1";
        this.consumeToken(Token.TokenType.PP_DEFINE);
        this.consumeToken(Token.TokenType.PP_SYMBOL);
        if (this.nextTokenType() == Token.TokenType.PP_ASSIGN) {
            this.consumeToken(Token.TokenType.PP_ASSIGN);
            this.consumeToken(Token.TokenType.PP_SYMBOL);
            value = this.lastConsumedToken.toString();
        }
        if (this.currentlyOn) {
            this.definedSymbols.put(this.lastConsumedToken.toString(), value);
        }
    }

    public final void PP_UndefStatement() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_UndefStatement";
        this.consumeToken(Token.TokenType.PP_UNDEF);
        this.consumeToken(Token.TokenType.PP_SYMBOL);
        if (this.currentlyOn) {
            this.definedSymbols.remove(this.lastConsumedToken.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression PP_Expression() {
        Expression result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_Expression";
        boolean inequality = false;
        this.pushOntoCallStack("PP_Expression", "examples/preprocessor/Preprocessor.ccc", 209, 3);
        try {
            result = this.PP_OrExpression();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.PP_EQUALS || this.nextTokenType == Token.TokenType.PP_NOT_EQUALS) {
            Expression result2;
            if (this.nextTokenType() == Token.TokenType.PP_EQUALS) {
                this.consumeToken(Token.TokenType.PP_EQUALS);
            } else if (this.nextTokenType() == Token.TokenType.PP_NOT_EQUALS) {
                this.consumeToken(Token.TokenType.PP_NOT_EQUALS);
                inequality = true;
            } else {
                this.pushOntoCallStack("PP_Expression", "examples/preprocessor/Preprocessor.ccc", 211, 6);
                throw new ParseException(this.lastConsumedToken, first_set$Preprocessor_ccc$211$6, this.parsingStack);
            }
            this.pushOntoCallStack("PP_Expression", "examples/preprocessor/Preprocessor.ccc", 212, 5);
            try {
                result2 = this.PP_OrExpression();
            }
            finally {
                this.popCallStack();
            }
            if (result.symbol == null || result2.symbol == null) {
                result.booleanValue = inequality == (result.booleanValue != result2.booleanValue);
            } else {
                String keyValue;
                String key = result.symbol;
                String value = result2.symbol;
                result.symbol = null;
                result2.symbol = null;
                result.booleanValue = !this.definedSymbols.containsKey(key) ? (!this.definedSymbols.containsKey(value) ? !inequality : inequality != this.definedSymbols.get(value).equals("0")) : inequality != value.equals(keyValue = this.definedSymbols.get(key));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression PP_OrExpression() {
        Expression result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_OrExpression";
        this.pushOntoCallStack("PP_OrExpression", "examples/preprocessor/Preprocessor.ccc", 247, 4);
        try {
            result = this.PP_AndExpression();
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == Token.TokenType.PP_OR) {
            Expression result2;
            this.consumeToken(Token.TokenType.PP_OR);
            this.pushOntoCallStack("PP_OrExpression", "examples/preprocessor/Preprocessor.ccc", 248, 12);
            try {
                result2 = this.PP_AndExpression();
            }
            finally {
                this.popCallStack();
            }
            result.booleanValue = result.booleanValue || result2.booleanValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression PP_AndExpression() {
        Expression result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_AndExpression";
        this.pushOntoCallStack("PP_AndExpression", "examples/preprocessor/Preprocessor.ccc", 254, 4);
        try {
            result = this.PP_NotExpression();
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == Token.TokenType.PP_AND) {
            Expression result2;
            this.consumeToken(Token.TokenType.PP_AND);
            this.pushOntoCallStack("PP_AndExpression", "examples/preprocessor/Preprocessor.ccc", 255, 13);
            try {
                result2 = this.PP_NotExpression();
            }
            finally {
                this.popCallStack();
            }
            result.booleanValue = result.booleanValue && result2.booleanValue;
        }
        return result;
    }

    public final Expression PP_NotExpression() {
        Expression result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_NotExpression";
        boolean notFlag = false;
        while (this.nextTokenType() == Token.TokenType.PP_NOT) {
            this.consumeToken(Token.TokenType.PP_NOT);
            notFlag = !notFlag;
        }
        this.pushOntoCallStack("PP_NotExpression", "examples/preprocessor/Preprocessor.ccc", 265, 4);
        try {
            result = this.PP_PrimaryExpression();
        }
        finally {
            this.popCallStack();
        }
        if (notFlag) {
            result.booleanValue = !result.booleanValue;
        }
        return result;
    }

    public final Expression PP_Parentheses() {
        Expression result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_Parentheses";
        this.consumeToken(Token.TokenType.PP_LPAREN);
        this.pushOntoCallStack("PP_Parentheses", "examples/preprocessor/Preprocessor.ccc", 277, 4);
        try {
            result = this.PP_Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.PP_RPAREN);
        return result;
    }

    public final Expression PP_PrimaryExpression() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        this.currentlyParsedProduction = "PP_PrimaryExpression";
        Expression result = new Expression();
        if (this.nextTokenType() == Token.TokenType.PP_LPAREN) {
            this.pushOntoCallStack("PP_PrimaryExpression", "examples/preprocessor/Preprocessor.ccc", 285, 7);
            try {
                result = this.PP_Parentheses();
            }
            finally {
                this.popCallStack();
            }
        } else if (this.nextTokenType() == Token.TokenType.PP_SYMBOL) {
            this.consumeToken(Token.TokenType.PP_SYMBOL);
            result.symbol = this.lastConsumedToken.toString();
            result.booleanValue = this.definedSymbols.containsKey(result.symbol);
        } else if (this.nextTokenType() == Token.TokenType.PP_TRUE) {
            this.consumeToken(Token.TokenType.PP_TRUE);
            result.booleanValue = true;
        } else if (this.nextTokenType() == Token.TokenType.PP_FALSE) {
            this.consumeToken(Token.TokenType.PP_FALSE);
            result.booleanValue = false;
        } else {
            this.pushOntoCallStack("PP_PrimaryExpression", "examples/preprocessor/Preprocessor.ccc", 285, 7);
            throw new ParseException(this.lastConsumedToken, first_set$Preprocessor_ccc$285$7, this.parsingStack);
        }
        return result;
    }

    private void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        this.parsingStack.add(new NonTerminalCall("PreprocessorParser", this.token_source, fileName, methodName, line, column));
    }

    private void popCallStack() {
        NonTerminalCall ntc = this.parsingStack.remove(this.parsingStack.size() - 1);
        this.currentlyParsedProduction = ntc.productionName;
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.lookaheadStack.listIterator(this.lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.parsingStack.listIterator(this.parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: " + this.currentlyParsedProduction);
        ps.println("Current Lookahead Production is: " + this.currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        this.dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        this.dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(Token.TokenType expectedType) {
        Token nextToken = this.nextToken(this.lastConsumedToken);
        if (nextToken.getType() != expectedType) {
            nextToken = this.handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken = nextToken;
        this.nextTokenType = null;
        return this.lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(Token.TokenType expectedType, Token nextToken) {
        throw new ParseException(nextToken, EnumSet.of(expectedType), this.parsingStack);
    }

    public boolean isTreeBuildingEnabled() {
        return false;
    }

    private static class Expression {
        boolean booleanValue;
        String symbol;

        private Expression() {
        }
    }
}

