/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.tree;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Annotation;
import org.congocc.parser.tree.ClassOrInterfaceBody;
import org.congocc.parser.tree.ClassOrInterfaceBodyDeclaration;
import org.congocc.parser.tree.CompilationUnit;
import org.congocc.parser.tree.EnumBody;
import org.congocc.parser.tree.ExtendsList;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.ImplementsList;
import org.congocc.parser.tree.ImportDeclaration;
import org.congocc.parser.tree.InterfaceDeclaration;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.PermitsList;
import org.congocc.parser.tree.TypeParameters;

public interface TypeDeclaration
extends Node,
ClassOrInterfaceBodyDeclaration {
    default public void addElements(List<ClassOrInterfaceBodyDeclaration> elements) {
        HashSet<String> keys = new HashSet<String>();
        for (ClassOrInterfaceBodyDeclaration decl : elements) {
            if (!(decl instanceof MethodDeclaration)) continue;
            keys.add(((MethodDeclaration)decl).getFullSignature());
        }
        Iterator it = this.getBody().iterator();
        while (it.hasNext()) {
            String s;
            Node n = (Node)it.next();
            if (!(n instanceof MethodDeclaration) || !keys.contains(s = ((MethodDeclaration)n).getFullSignature())) continue;
            it.remove();
        }
        this.getBody().prepend(elements);
    }

    default public void addAnnotations(Set<Annotation> annotations) {
        Node parent = this.getParent();
        int index = parent.indexOf(this);
        for (Annotation annotation : annotations) {
            parent.add(index, annotation);
        }
    }

    default public boolean isClass() {
        return this.firstChildOfType(Token.TokenType.CLASS) != null;
    }

    default public void addImplements(ObjectType type) {
        ImplementsList implementsList = this.getImplementsList();
        if (implementsList == null) {
            Node node;
            implementsList = new ImplementsList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && !((node = (Node)iterator.next()) instanceof ClassOrInterfaceBody) && !(node instanceof EnumBody)) {
            }
            iterator.previous();
            iterator.add(implementsList);
        }
        implementsList.addType(type);
    }

    default public void addExtends(ObjectType type) {
        ExtendsList extendsList = this.getExtendsList();
        if (extendsList == null) {
            Node node;
            extendsList = new ExtendsList();
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && !((node = (Node)iterator.next()) instanceof ImplementsList) && !(node instanceof ClassOrInterfaceBody)) {
            }
            iterator.previous();
            iterator.add(extendsList);
        }
        extendsList.addType(type, this instanceof InterfaceDeclaration);
    }

    default public String getName() {
        Node thisNode = this.getNamedChild("name");
        return thisNode != null ? thisNode.toString() : this.firstChildOfType(Identifier.class).toString();
    }

    default public TypeParameters getTypeParameters() {
        return this.firstChildOfType(TypeParameters.class);
    }

    default public ClassOrInterfaceBody getBody() {
        return this.firstChildOfType(ClassOrInterfaceBody.class);
    }

    default public ExtendsList getExtendsList() {
        return this.firstChildOfType(ExtendsList.class);
    }

    default public ImplementsList getImplementsList() {
        return this.firstChildOfType(ImplementsList.class);
    }

    default public PermitsList getPermitsList() {
        return this.firstChildOfType(PermitsList.class);
    }

    default public CompilationUnit getCompilationUnit() {
        return this.firstAncestorOfType(CompilationUnit.class);
    }

    default public List<ImportDeclaration> getImportDeclarations() {
        CompilationUnit jcu = this.getCompilationUnit();
        return jcu.getImportDeclarations();
    }
}

