/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.tree;

import java.util.ArrayList;
import java.util.List;
import org.congocc.core.Grammar;
import org.congocc.parser.CongoCCParser;
import org.congocc.parser.Token;
import org.congocc.parser.tree.BaseNode;
import org.congocc.parser.tree.ClassOrInterfaceBody;
import org.congocc.parser.tree.Modifiers;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.PermitsList;

public class CodeInjection
extends BaseNode {
    public List<ObjectType> extendsList = new ArrayList<ObjectType>();
    public List<ObjectType> implementsList = new ArrayList<ObjectType>();
    public ClassOrInterfaceBody body;
    private String name;

    public static void inject(Grammar grammar, String nodeName, String injection) {
        String inject = "INJECT " + nodeName + " : " + injection;
        try {
            CongoCCParser parser = new CongoCCParser(grammar, "dynamicInjection", inject);
            parser.setEnterIncludes(true);
            CodeInjection ci = parser.CodeInjection();
            grammar.getInjector().add(ci);
        }
        catch (Exception e) {
            System.err.println("parser exception injecting '" + inject + "': ");
            throw new RuntimeException("Unable to dynamically inject code into " + nodeName);
        }
        finally {
            Object parser = null;
        }
    }

    public void addExtendsType(ObjectType type) {
        this.extendsList.add(type);
    }

    public void addImplementsType(ObjectType type) {
        this.implementsList.add(type);
    }

    public boolean isMarkedFinal() {
        if (this.firstChildOfType(Token.TokenType.FINAL) != null) {
            return true;
        }
        Modifiers mods = this.firstChildOfType(Modifiers.class);
        return mods != null && mods.firstChildOfType(Token.TokenType.FINAL) != null;
    }

    public boolean isMarkedAbstract() {
        if (this.firstChildOfType(Token.TokenType.ABSTRACT) != null) {
            return true;
        }
        Modifiers mods = this.firstChildOfType(Modifiers.class);
        return mods != null && mods.firstChildOfType(Token.TokenType.ABSTRACT) != null;
    }

    public boolean isMarkedInterface() {
        return this.firstChildOfType(Token.TokenType.INTERFACE) != null;
    }

    public boolean isMarkedClass() {
        return this.firstChildOfType(Token.TokenType.CLASS) != null;
    }

    public boolean isSealed() {
        if (this.firstChildOfType(Token.TokenType.SEALED) != null) {
            return true;
        }
        Modifiers mods = this.firstChildOfType(Modifiers.class);
        return mods != null && mods.firstChildOfType(Token.TokenType.SEALED) != null;
    }

    public boolean isNonSealed() {
        if (this.firstChildOfType(Token.TokenType.NON_SEALED) != null) {
            return true;
        }
        Modifiers mods = this.firstChildOfType(Modifiers.class);
        return mods != null && mods.firstChildOfType(Token.TokenType.NON_SEALED) != null;
    }

    public PermitsList getPermitsList() {
        return this.firstChildOfType(PermitsList.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

