/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.csharp;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.congocc.parser.TokenSource;
import org.congocc.parser.csharp.CSToken;
import org.congocc.parser.csharp.InvalidToken;
import org.congocc.parser.csharp.ast.PPLine;
import org.parsers.csharp.ppline.PPDirectiveLineParser;

public class CSLexer
extends TokenSource {
    private String pendingString = "";
    private int startingQuotes;
    private int startingDollars;
    private boolean parsingOn = true;
    private boolean alreadyHandled;
    private boolean seenElse;
    private int ifNesting;
    private Set<String> ppSymbols = new HashSet<String>();
    private Map<Integer, PPDirectiveLineParser.Info> ppInfoCache = new HashMap<Integer, PPDirectiveLineParser.Info>();
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<CSToken.TokenType> activeTokenTypes = EnumSet.allOf(CSToken.TokenType.class);
    private static final EnumMap<CSToken.TokenType, LexicalState> tokenTypeToLexicalStateMap;
    static final EnumSet<CSToken.TokenType> regularTokens;
    static final EnumSet<CSToken.TokenType> unparsedTokens;
    static final EnumSet<CSToken.TokenType> skippedTokens;
    static final EnumSet<CSToken.TokenType> moreTokens;
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap;

    private CSToken tokenHook$CSharpLexer_ccc$375$29(CSToken tok) {
        CSToken.TokenType type = tok.getType();
        if (type == CSToken.TokenType.INTERPOLATED_RAW_STRING_START) {
            String image = tok.toString();
            this.startingDollars = 0;
            this.startingQuotes = 0;
            for (int i = 0; i < image.length(); ++i) {
                char ch = image.charAt(i);
                if (ch == '\"') {
                    ++this.startingQuotes;
                    continue;
                }
                if (ch == '$') {
                    ++this.startingDollars;
                    continue;
                }
                break;
            }
        } else {
            if (type == CSToken.TokenType.INTERPOLATED_RAW_STRING_END) {
                if (tok.toString().length() < this.startingQuotes) {
                    tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                }
                return tok;
            }
            if (type == CSToken.TokenType.NON_INTERPOLATED_TEXT3) {
                int followingOpenBraces = 0;
                for (int k = tok.getEndOffset(); k < this.length() && this.charAt(k) == '{'; ++k) {
                    ++followingOpenBraces;
                }
                int amountToExtend = followingOpenBraces - this.startingDollars;
                if (amountToExtend < 0) {
                    amountToExtend = followingOpenBraces;
                }
                tok.setEndOffset(tok.getEndOffset() + amountToExtend);
            } else {
                if (type == CSToken.TokenType.START_INTERPOLATION) {
                    int tokLength = tok.toString().length();
                    if (tokLength > this.startingDollars) {
                        tok.setEndOffset(tok.getEndOffset() - (tokLength - this.startingDollars));
                        tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                        return tok;
                    }
                    if (tok.toString().length() < this.startingDollars) {
                        tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                        return tok;
                    }
                    return tok;
                }
                if (type == CSToken.TokenType.END_RAW_INTERPOLATION) {
                    if (tok.toString().length() < this.startingDollars) {
                        tok.setType(CSToken.TokenType.NON_INTERPOLATED_TEXT3);
                        return tok;
                    }
                    return tok;
                }
                if (tok.getType() == CSToken.TokenType.RAW_STRING_LITERAL) {
                    String image = tok.toString();
                    if (this.pendingString == "" && this.endsWithEnoughQuotes(image)) {
                        this.switchTo(LexicalState.CSHARP);
                        return tok;
                    }
                    this.pendingString = this.pendingString + tok.toString();
                    if (this.endsWithEnoughQuotes(this.pendingString)) {
                        tok.setBeginOffset(tok.getEndOffset() - this.pendingString.length());
                        this.pendingString = "";
                        this.switchTo(LexicalState.CSHARP);
                        return tok;
                    }
                    tok.setUnparsed(true);
                }
            }
        }
        return tok;
    }

    private boolean endsWithEnoughQuotes(String img) {
        int startingQuotes = 0;
        int endingQuotes = 0;
        for (int i = 0; i < img.length() && img.charAt(i) == '\"'; ++i) {
            ++startingQuotes;
        }
        if (img.endsWith("u8")) {
            img = img.substring(0, img.length() - 2);
        }
        for (int k = img.length() - 1; k >= 0 && img.charAt(k) == '\"'; --k) {
            ++endingQuotes;
        }
        return endingQuotes >= startingQuotes;
    }

    private PPDirectiveLineParser.Info findMatchingIfInfo(CSToken tok) {
        Iterator<CSToken> precedingTokens = tok.precedingTokens();
        int nesting = 0;
        while (precedingTokens.hasNext()) {
            CSToken prev = precedingTokens.next();
            CSToken.TokenType type = prev.getType();
            if (type == CSToken.TokenType.PP_ENDIF) {
                ++nesting;
                continue;
            }
            if (type != CSToken.TokenType.PP_IF) continue;
            if (nesting == 0) {
                return this.ppInfoCache.get(prev.getBeginOffset());
            }
            --nesting;
        }
        return null;
    }

    void addSymbols(Set<String> symbols) {
        this.ppSymbols.addAll(symbols);
    }

    private CSToken tokenHook$CSharpLexer_ccc$495$29(CSToken tok) {
        PPDirectiveLineParser.Info info;
        CSToken.TokenType type = tok.getType();
        if (type == CSToken.TokenType.EOF && this.ifNesting != 0) {
            tok.setType(CSToken.TokenType.INVALID);
            return tok;
        }
        if (!(tok instanceof PPLine)) {
            return tok;
        }
        if (!this.atLineStart(tok)) {
            tok.setType(CSToken.TokenType.INVALID);
            tok.setUnparsed(false);
            return tok;
        }
        int beginOffset = tok.getBeginOffset();
        if (this.ppInfoCache.containsKey(beginOffset)) {
            info = this.ppInfoCache.get(beginOffset);
        } else {
            info = PPDirectiveLineParser.evaluate(tok.toString(), this.ppSymbols, this.ifNesting, this.parsingOn, this.alreadyHandled, this.seenElse);
            this.ppInfoCache.put(beginOffset, info);
        }
        PPDirectiveLineParser.DirectiveType directiveType = info.directiveType;
        if (tok.getType() == CSToken.TokenType.PP_ENDIF) {
            info = this.findMatchingIfInfo(tok);
        }
        this.ifNesting = info.ifNesting;
        this.alreadyHandled = info.alreadyHandled;
        this.seenElse = info.seenElse;
        this.ppSymbols = info.ppSymbols;
        this._setParsingEnabled(info.parsingOn);
        if (directiveType == PPDirectiveLineParser.DirectiveType.UNKNOWN) {
            tok.setUnparsed(false);
            tok.setType(CSToken.TokenType.INVALID);
            return tok;
        }
        if (!(this.ifNesting != 0 && !this.seenElse || directiveType != PPDirectiveLineParser.DirectiveType.ELIF && directiveType != PPDirectiveLineParser.DirectiveType.ELSE)) {
            tok.setType(CSToken.TokenType.INVALID);
            tok.setUnparsed(false);
            return tok;
        }
        if (type == CSToken.TokenType.PP_ELSE) {
            this.seenElse = true;
            this._setParsingEnabled(!this.alreadyHandled && this.findMatchingIfInfo((CSToken)tok).parsingOn);
        } else if (type == CSToken.TokenType.PP_ELIF) {
            this._setParsingEnabled(!this.alreadyHandled && info.evaluationResult && this.findMatchingIfInfo((CSToken)tok).parsingOn);
            this.alreadyHandled |= info.evaluationResult;
        } else if (type == CSToken.TokenType.PP_IF) {
            ++this.ifNesting;
            this.seenElse = false;
            this.alreadyHandled = info.evaluationResult;
            this._setParsingEnabled(this.parsingOn && info.evaluationResult);
        }
        return tok;
    }

    void _setParsingEnabled(boolean parsingOn) {
        if (parsingOn) {
            this.switchTo(LexicalState.CSHARP);
        } else {
            this.switchTo(LexicalState.IN_IGNORED_SECTION);
        }
        this.parsingOn = parsingOn;
    }

    public CSLexer(CharSequence input) {
        this("input", input);
    }

    public CSLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.CSHARP, 1, 1);
    }

    public CSLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 4, false, false, false, "\n");
        this.activeTokenTypes.remove(CSToken.TokenType.ADD);
        this.activeTokenTypes.remove(CSToken.TokenType.ASSEMBLY);
        this.activeTokenTypes.remove(CSToken.TokenType.INTO);
        this.activeTokenTypes.remove(CSToken.TokenType.SET);
        this.activeTokenTypes.remove(CSToken.TokenType.VAR);
        this.activeTokenTypes.remove(CSToken.TokenType.RECORD);
        this.activeTokenTypes.remove(CSToken.TokenType.JOIN);
        this.activeTokenTypes.remove(CSToken.TokenType.AWAIT);
        this.activeTokenTypes.remove(CSToken.TokenType.FROM);
        this.activeTokenTypes.remove(CSToken.TokenType.GROUP);
        this.activeTokenTypes.remove(CSToken.TokenType.WHEN);
        this.activeTokenTypes.remove(CSToken.TokenType.BY);
        this.activeTokenTypes.remove(CSToken.TokenType.DESCENDING);
        this.activeTokenTypes.remove(CSToken.TokenType.REMOVE);
        this.activeTokenTypes.remove(CSToken.TokenType.ORDERBY);
        this.activeTokenTypes.remove(CSToken.TokenType.ON);
        this.activeTokenTypes.remove(CSToken.TokenType.OR);
        this.activeTokenTypes.remove(CSToken.TokenType.EQUALS);
        this.activeTokenTypes.remove(CSToken.TokenType.YIELD);
        this.activeTokenTypes.remove(CSToken.TokenType.ASYNC);
        this.activeTokenTypes.remove(CSToken.TokenType.SCOPED);
        this.activeTokenTypes.remove(CSToken.TokenType.REQUIRED);
        this.activeTokenTypes.remove(CSToken.TokenType.PARTIAL);
        this.activeTokenTypes.remove(CSToken.TokenType.MANAGED);
        this.activeTokenTypes.remove(CSToken.TokenType.WHERE);
        this.activeTokenTypes.remove(CSToken.TokenType.WITH);
        this.activeTokenTypes.remove(CSToken.TokenType.SELECT);
        this.activeTokenTypes.remove(CSToken.TokenType.DYNAMIC);
        this.activeTokenTypes.remove(CSToken.TokenType.UNMANAGED);
        this.activeTokenTypes.remove(CSToken.TokenType.NAMEOF);
        this.activeTokenTypes.remove(CSToken.TokenType.MODULE);
        this.activeTokenTypes.remove(CSToken.TokenType.INIT);
        this.activeTokenTypes.remove(CSToken.TokenType.NOT);
        this.activeTokenTypes.remove(CSToken.TokenType.ASCENDING);
        this.activeTokenTypes.remove(CSToken.TokenType.GET);
        this.activeTokenTypes.remove(CSToken.TokenType.AND);
        this.activeTokenTypes.remove(CSToken.TokenType.ARGLIST);
        this.activeTokenTypes.remove(CSToken.TokenType.LET);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public CSToken getNextToken(CSToken tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public CSToken getNextToken(CSToken tok, EnumSet<CSToken.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        CSToken cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            CSToken token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<CSToken.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = CSToken.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        CSToken.TokenType matchedType = CSToken.TokenType.INVALID;
        EnumSet<CSToken.TokenType> alreadyMatchedTypes = EnumSet.noneOf(CSToken.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(874);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(874);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                CSToken.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final CSToken tokenizeAt(int position, LexicalState lexicalState, EnumSet<CSToken.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        CSToken matchedToken = null;
        CSToken.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(874);
        BitSet nextStates = new BitSet(874);
        while (matchedToken == null) {
            NfaFunction[] nfaFunctions = functionTableMap.get((Object)lexicalState);
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = CSLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = CSLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            LexicalState newState = tokenTypeToLexicalStateMap.get(matchedType);
            if (newState != null) {
                lexicalState = this.lexicalState = newState;
            }
            if (matchedType == CSToken.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = CSToken.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        this.doLexicalStateSwitch(matchedToken.getType());
        matchedToken = this.tokenLexicalActions(matchedToken, matchedType);
        matchedToken = this.tokenHook$CSharpLexer_ccc$375$29(matchedToken);
        matchedToken = this.tokenHook$CSharpLexer_ccc$495$29(matchedToken);
        return matchedToken;
    }

    boolean doLexicalStateSwitch(CSToken.TokenType tokenType) {
        LexicalState newState = tokenTypeToLexicalStateMap.get(tokenType);
        if (newState == null) {
            return false;
        }
        return this.switchTo(newState);
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(CSToken t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        } else {
            this.doLexicalStateSwitch(t.getType());
        }
    }

    void reset(CSToken t) {
        this.reset(t, null);
    }

    private CSToken tokenLexicalActions(CSToken matchedToken, CSToken.TokenType matchedType) {
        switch (matchedType) {
            case PP_LINE: {
                String trimmed = matchedToken.toString().trim().substring(1).trim();
                if (trimmed.startsWith("if")) {
                    matchedToken.setType(CSToken.TokenType.PP_IF);
                    break;
                }
                if (trimmed.startsWith("elif")) {
                    matchedToken.setType(CSToken.TokenType.PP_ELIF);
                    break;
                }
                if (trimmed.startsWith("else")) {
                    matchedToken.setType(CSToken.TokenType.PP_ELSE);
                    break;
                }
                if (trimmed.startsWith("endif")) {
                    matchedToken.setType(CSToken.TokenType.PP_ENDIF);
                    break;
                }
                if (trimmed.startsWith("define")) {
                    matchedToken.setType(CSToken.TokenType.PP_DEFINE);
                    break;
                }
                if (!trimmed.startsWith("undef")) break;
                matchedToken.setType(CSToken.TokenType.PP_UNDEF);
                break;
            }
        }
        return matchedToken;
    }

    private boolean atLineStart(CSToken tok) {
        int offset = tok.getBeginOffset();
        while (offset > 0) {
            char c;
            if (!Character.isWhitespace(c = this.charAt(--offset))) {
                return false;
            }
            if (c != '\n') continue;
            break;
        }
        return true;
    }

    static {
        tokenTypeToLexicalStateMap = new EnumMap(CSToken.TokenType.class);
        regularTokens = EnumSet.of(CSToken.TokenType.EOF, new CSToken.TokenType[]{CSToken.TokenType.FALSE, CSToken.TokenType.TRUE, CSToken.TokenType.NULL, CSToken.TokenType.LPAREN, CSToken.TokenType.RPAREN, CSToken.TokenType.RBRACE, CSToken.TokenType.LBRACKET, CSToken.TokenType.RBRACKET, CSToken.TokenType.SEMICOLON, CSToken.TokenType.COMMA, CSToken.TokenType.GT, CSToken.TokenType.LT, CSToken.TokenType.BANG, CSToken.TokenType.TILDE, CSToken.TokenType.HOOK, CSToken.TokenType.DOUBLE_HOOK, CSToken.TokenType.DOUBLE_HOOK_EQUALS, CSToken.TokenType.COLON, CSToken.TokenType.EQ, CSToken.TokenType.LE, CSToken.TokenType.GE, CSToken.TokenType.NE, CSToken.TokenType.SC_OR, CSToken.TokenType.SC_AND, CSToken.TokenType.INCR, CSToken.TokenType.DECR, CSToken.TokenType.PLUS, CSToken.TokenType.MINUS, CSToken.TokenType.STAR, CSToken.TokenType.SLASH, CSToken.TokenType.BIT_AND, CSToken.TokenType.BIT_OR, CSToken.TokenType.HAT, CSToken.TokenType.REM, CSToken.TokenType.LEFT_SHIFT, CSToken.TokenType.PLUSASSIGN, CSToken.TokenType.MINUSASSIGN, CSToken.TokenType.STARASSIGN, CSToken.TokenType.SLASHASSIGN, CSToken.TokenType.ANDASSIGN, CSToken.TokenType.ORASSIGN, CSToken.TokenType.XORASSIGN, CSToken.TokenType.REMASSIGN, CSToken.TokenType.LEFT_SHIFT_ASSIGN, CSToken.TokenType.RIGHT_SHIFT, CSToken.TokenType.UNSIGNED_RIGHT_SHIFT, CSToken.TokenType.RIGHT_SHIFT_ASSIGN, CSToken.TokenType.UNSIGNED_RIGHT_SHIFT_ASSIGN, CSToken.TokenType.ARROW, CSToken.TokenType.POINTER_ACCESS, CSToken.TokenType.ASSIGN, CSToken.TokenType.DOUBLE_COLON, CSToken.TokenType.DOT, CSToken.TokenType.RANGE, CSToken.TokenType.VAR_ARGS, CSToken.TokenType.AT, CSToken.TokenType.ABSTRACT, CSToken.TokenType.AS, CSToken.TokenType.BASE, CSToken.TokenType.BOOL, CSToken.TokenType.BREAK, CSToken.TokenType.BYTE, CSToken.TokenType.CASE, CSToken.TokenType.CATCH, CSToken.TokenType.CHAR, CSToken.TokenType.CHECKED, CSToken.TokenType.CLASS, CSToken.TokenType.CONST, CSToken.TokenType.CONTINUE, CSToken.TokenType.DECIMAL, CSToken.TokenType.DEFAULT, CSToken.TokenType.DELEGATE, CSToken.TokenType.DO, CSToken.TokenType.DOUBLE, CSToken.TokenType.ELSE, CSToken.TokenType.ENUM, CSToken.TokenType.EVENT, CSToken.TokenType.EXPLICIT, CSToken.TokenType.EXTERN, CSToken.TokenType.FINALLY, CSToken.TokenType.FIXED, CSToken.TokenType.FLOAT, CSToken.TokenType.FOR, CSToken.TokenType.FOREACH, CSToken.TokenType.GOTO, CSToken.TokenType.IF, CSToken.TokenType.IMPLICIT, CSToken.TokenType.IN, CSToken.TokenType.INT, CSToken.TokenType.INTERFACE, CSToken.TokenType.INTERNAL, CSToken.TokenType.IS, CSToken.TokenType.LOCK, CSToken.TokenType.LONG, CSToken.TokenType.NAMESPACE, CSToken.TokenType.NEW, CSToken.TokenType.OBJECT, CSToken.TokenType.OPERATOR, CSToken.TokenType.OUT, CSToken.TokenType.OVERRIDE, CSToken.TokenType.PARAMS, CSToken.TokenType.PRIVATE, CSToken.TokenType.PROTECTED, CSToken.TokenType.PUBLIC, CSToken.TokenType.READONLY, CSToken.TokenType.REF, CSToken.TokenType.RETURN, CSToken.TokenType.SBYTE, CSToken.TokenType.SEALED, CSToken.TokenType.SHORT, CSToken.TokenType.SIZEOF, CSToken.TokenType.STACKALLOC, CSToken.TokenType.STATIC, CSToken.TokenType.STRING, CSToken.TokenType.STRUCT, CSToken.TokenType.SWITCH, CSToken.TokenType.THIS, CSToken.TokenType.THROW, CSToken.TokenType.TRY, CSToken.TokenType.TYPEOF, CSToken.TokenType.UINT, CSToken.TokenType.ULONG, CSToken.TokenType.UNCHECKED, CSToken.TokenType.UNSAFE, CSToken.TokenType.USHORT, CSToken.TokenType.VIRTUAL, CSToken.TokenType.VOID, CSToken.TokenType.VOLATILE, CSToken.TokenType.WHILE, CSToken.TokenType.ARGLIST, CSToken.TokenType.ADD, CSToken.TokenType.ASSEMBLY, CSToken.TokenType.ASYNC, CSToken.TokenType.AWAIT, CSToken.TokenType.DYNAMIC, CSToken.TokenType.GET, CSToken.TokenType.INIT, CSToken.TokenType.MANAGED, CSToken.TokenType.UNMANAGED, CSToken.TokenType.MODULE, CSToken.TokenType.NAMEOF, CSToken.TokenType.PARTIAL, CSToken.TokenType.RECORD, CSToken.TokenType.REMOVE, CSToken.TokenType.REQUIRED, CSToken.TokenType.SCOPED, CSToken.TokenType.SET, CSToken.TokenType.VAR, CSToken.TokenType.WHEN, CSToken.TokenType.YIELD, CSToken.TokenType.AND, CSToken.TokenType.OR, CSToken.TokenType.NOT, CSToken.TokenType.WITH, CSToken.TokenType.ASCENDING, CSToken.TokenType.BY, CSToken.TokenType.DESCENDING, CSToken.TokenType.EQUALS, CSToken.TokenType.FROM, CSToken.TokenType.GROUP, CSToken.TokenType.INTO, CSToken.TokenType.JOIN, CSToken.TokenType.LET, CSToken.TokenType.ON, CSToken.TokenType.ORDERBY, CSToken.TokenType.SELECT, CSToken.TokenType.WHERE, CSToken.TokenType.REGULAR_INTERPOLATION_START, CSToken.TokenType.LBRACE, CSToken.TokenType.ENDING_QUOTE, CSToken.TokenType.INTEGER_LITERAL, CSToken.TokenType.REAL_LITERAL, CSToken.TokenType.USING, CSToken.TokenType.IDENTIFIER, CSToken.TokenType.CHARACTER_LITERAL, CSToken.TokenType.REGULAR_STRING_LITERAL, CSToken.TokenType.VERBATIM_STRING_LITERAL, CSToken.TokenType.MULTI_INTERPOLATION_START, CSToken.TokenType.INTERPOLATED_RAW_STRING_START, CSToken.TokenType.NON_INTERPOLATED_TEXT, CSToken.TokenType.NON_INTERPOLATED_TEXT2, CSToken.TokenType.START_INTERPOLATION, CSToken.TokenType.NON_INTERPOLATED_TEXT3, CSToken.TokenType.END_RAW_INTERPOLATION, CSToken.TokenType.INTERPOLATED_RAW_STRING_END, CSToken.TokenType.RAW_STRING_LITERAL});
        unparsedTokens = EnumSet.of(CSToken.TokenType.MULTI_LINE_COMMENT, CSToken.TokenType.SINGLE_LINE_COMMENT, CSToken.TokenType.PP_LINE, CSToken.TokenType.WHITESPACE_LINE, CSToken.TokenType.IGNORED_LINE);
        skippedTokens = EnumSet.of(CSToken.TokenType.WHITESPACE);
        moreTokens = EnumSet.of(CSToken.TokenType.RAW_STRING_START, CSToken.TokenType.ANY_CHAR);
        regularTokens.add(CSToken.TokenType.PP_IF);
        regularTokens.add(CSToken.TokenType.PP_ENDIF);
        regularTokens.add(CSToken.TokenType.PP_ELSE);
        regularTokens.add(CSToken.TokenType.PP_ELIF);
        regularTokens.add(CSToken.TokenType.PP_DEFINE);
        regularTokens.add(CSToken.TokenType.PP_UNDEF);
        tokenTypeToLexicalStateMap.put(CSToken.TokenType.RAW_STRING_START, LexicalState.IN_RAW_STRING);
        functionTableMap = new EnumMap(LexicalState.class);
        CSHARP.NFA_FUNCTIONS_init();
        IN_REGULAR_INTERPOLATION.NFA_FUNCTIONS_init();
        IN_MULTI_INTERPOLATION.NFA_FUNCTIONS_init();
        IN_IGNORED_SECTION.NFA_FUNCTIONS_init();
        IN_INTERPOLATED_RAW_STRING.NFA_FUNCTIONS_init();
        IN_RAW_STRING.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        CSHARP,
        IN_REGULAR_INTERPOLATION,
        IN_MULTI_INTERPOLATION,
        IN_IGNORED_SECTION,
        IN_INTERPOLATED_RAW_STRING,
        IN_RAW_STRING;

    }

    static class MatchInfo {
        CSToken.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public CSToken.TokenType apply(int var1, BitSet var2, EnumSet<CSToken.TokenType> var3, EnumSet<CSToken.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<CSToken.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class CSHARP {
        private static final int[] NFA_MOVES_CSHARP_0 = CSHARP.NFA_MOVES_CSHARP_0_init();
        private static final int[] NFA_MOVES_CSHARP_543 = CSHARP.NFA_MOVES_CSHARP_543_init();
        private static final int[] NFA_MOVES_CSHARP_773 = CSHARP.NFA_MOVES_CSHARP_773_init();
        private static final int[] NFA_MOVES_CSHARP_789 = CSHARP.NFA_MOVES_CSHARP_789_init();
        private static final int[] NFA_MOVES_CSHARP_808 = CSHARP.NFA_MOVES_CSHARP_808_init();
        private static final int[] NFA_MOVES_CSHARP_823 = CSHARP.NFA_MOVES_CSHARP_823_init();
        private static final int[] NFA_MOVES_CSHARP_866 = CSHARP.NFA_MOVES_CSHARP_866_init();

        private CSHARP() {
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_866, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PP_LINE)) {
                    nextStates.set(252);
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NE)) {
                    nextStates.set(106);
                }
            } else if (ch == 34) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REGULAR_STRING_LITERAL)) {
                    nextStates.set(43);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RAW_STRING_START)) {
                    nextStates.set(443);
                }
            } else if (ch == 35) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PP_LINE)) {
                    nextStates.set(31);
                }
            } else if (ch == 36) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REGULAR_INTERPOLATION_START)) {
                    nextStates.set(12);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MULTI_INTERPOLATION_START)) {
                    nextStates.set(395);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERPOLATED_RAW_STRING_START)) {
                    nextStates.set(403);
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REMASSIGN)) {
                    nextStates.set(37);
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SC_AND)) {
                    nextStates.set(17);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ANDASSIGN)) {
                    nextStates.set(176);
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CHARACTER_LITERAL)) {
                    nextStates.set(571);
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.STARASSIGN)) {
                    nextStates.set(5);
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INCR)) {
                    nextStates.set(15);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PLUSASSIGN)) {
                    nextStates.set(62);
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.POINTER_ACCESS)) {
                    nextStates.set(57);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MINUSASSIGN)) {
                    nextStates.set(103);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DECR)) {
                    nextStates.set(145);
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    nextStates.set(20);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.VAR_ARGS)) {
                    nextStates.set(545);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RANGE)) {
                    nextStates.set(174);
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SLASHASSIGN)) {
                    nextStates.set(104);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SINGLE_LINE_COMMENT)) {
                    nextStates.set(632);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MULTI_LINE_COMMENT)) {
                    nextStates.set(633);
                }
            } else if (ch == 48) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    nextStates.set(483);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    nextStates.set(570);
                }
            }
            if (ch >= 48 && ch <= 57) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    nextStates.set(552);
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE_COLON)) {
                    nextStates.set(34);
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LE)) {
                    nextStates.set(48);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LEFT_SHIFT_ASSIGN)) {
                    nextStates.set(295);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LEFT_SHIFT)) {
                    nextStates.set(93);
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.EQ)) {
                    nextStates.set(75);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ARROW)) {
                    nextStates.set(182);
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.GE)) {
                    nextStates.set(29);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RIGHT_SHIFT)) {
                    nextStates.set(65);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RIGHT_SHIFT_ASSIGN)) {
                    nextStates.set(341);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.UNSIGNED_RIGHT_SHIFT)) {
                    nextStates.set(440);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.UNSIGNED_RIGHT_SHIFT_ASSIGN)) {
                    nextStates.set(504);
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE_HOOK)) {
                    nextStates.set(81);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE_HOOK_EQUALS)) {
                    nextStates.set(410);
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    nextStates.set(42);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MULTI_INTERPOLATION_START)) {
                    nextStates.set(391);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.VERBATIM_STRING_LITERAL)) {
                    nextStates.set(559);
                }
            } else if (ch == 92) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    nextStates.set(213);
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.XORASSIGN)) {
                    nextStates.set(161);
                }
            } else if (ch == 95) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ARGLIST)) {
                    nextStates.set(615);
                }
            } else if (ch == 97) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ASSEMBLY)) {
                    nextStates.set(207);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.AS)) {
                    nextStates.set(55);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ADD)) {
                    nextStates.set(312);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.AWAIT)) {
                    nextStates.set(321);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ASYNC)) {
                    nextStates.set(406);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.AND)) {
                    nextStates.set(409);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ABSTRACT)) {
                    nextStates.set(609);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ASCENDING)) {
                    nextStates.set(650);
                }
            } else if (ch == 98) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BREAK)) {
                    nextStates.set(274);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BY)) {
                    nextStates.set(50);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BYTE)) {
                    nextStates.set(310);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BOOL)) {
                    nextStates.set(441);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BASE)) {
                    nextStates.set(444);
                }
            } else if (ch == 99) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CHECKED)) {
                    nextStates.set(202);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CATCH)) {
                    nextStates.set(249);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CHAR)) {
                    nextStates.set(296);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CASE)) {
                    nextStates.set(383);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CONST)) {
                    nextStates.set(388);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CLASS)) {
                    nextStates.set(429);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.CONTINUE)) {
                    nextStates.set(546);
                }
            } else if (ch == 100) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DECIMAL)) {
                    nextStates.set(348);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DEFAULT)) {
                    nextStates.set(413);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DESCENDING)) {
                    nextStates.set(448);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DYNAMIC)) {
                    nextStates.set(488);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DO)) {
                    nextStates.set(180);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DELEGATE)) {
                    nextStates.set(626);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DOUBLE)) {
                    nextStates.set(638);
                }
            } else if (ch == 101) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ELSE)) {
                    nextStates.set(385);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.EXTERN)) {
                    nextStates.set(418);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ENUM)) {
                    nextStates.set(423);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.EQUALS)) {
                    nextStates.set(436);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.EVENT)) {
                    nextStates.set(456);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.EXPLICIT)) {
                    nextStates.set(578);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.FOR)) {
                    nextStates.set(201);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.FLOAT)) {
                    nextStates.set(259);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.FALSE)) {
                    nextStates.set(264);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.FIXED)) {
                    nextStates.set(333);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.FROM)) {
                    nextStates.set(401);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.FOREACH)) {
                    nextStates.set(461);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.FINALLY)) {
                    nextStates.set(532);
                }
            } else if (ch == 103) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.USING)) {
                    nextStates.set(369);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.GOTO)) {
                    nextStates.set(512);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.GROUP)) {
                    nextStates.set(522);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.GET)) {
                    nextStates.set(644);
                }
            } else if (ch == 105) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INIT)) {
                    nextStates.set(239);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERNAL)) {
                    nextStates.set(253);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IF)) {
                    nextStates.set(61);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INT)) {
                    nextStates.set(387);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IN)) {
                    nextStates.set(118);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IMPLICIT)) {
                    nextStates.set(493);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERFACE)) {
                    nextStates.set(525);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IS)) {
                    nextStates.set(158);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTO)) {
                    nextStates.set(568);
                }
            } else if (ch == 106) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.JOIN)) {
                    nextStates.set(434);
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LET)) {
                    nextStates.set(238);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LONG)) {
                    nextStates.set(262);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LOCK)) {
                    nextStates.set(336);
                }
            } else if (ch == 109) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MODULE)) {
                    nextStates.set(267);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MANAGED)) {
                    nextStates.set(514);
                }
            } else if (ch == 110) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NEW)) {
                    nextStates.set(396);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NULL)) {
                    nextStates.set(459);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NAMEOF)) {
                    nextStates.set(474);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NOT)) {
                    nextStates.set(601);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NAMESPACE)) {
                    nextStates.set(602);
                }
            } else if (ch == 111) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.OPERATOR)) {
                    nextStates.set(195);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ON)) {
                    nextStates.set(11);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.OUT)) {
                    nextStates.set(405);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ORDERBY)) {
                    nextStates.set(478);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.OR)) {
                    nextStates.set(154);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.OBJECT)) {
                    nextStates.set(537);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.OVERRIDE)) {
                    nextStates.set(588);
                }
            } else if (ch == 112) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PROTECTED)) {
                    nextStates.set(303);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PARTIAL)) {
                    nextStates.set(316);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PUBLIC)) {
                    nextStates.set(379);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PRIVATE)) {
                    nextStates.set(645);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PARAMS)) {
                    nextStates.set(657);
                }
            } else if (ch == 114) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RETURN)) {
                    nextStates.set(324);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REQUIRED)) {
                    nextStates.set(353);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RECORD)) {
                    nextStates.set(500);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.READONLY)) {
                    nextStates.set(506);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REF)) {
                    nextStates.set(519);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REMOVE)) {
                    nextStates.set(584);
                }
            } else if (ch == 115) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SCOPED)) {
                    nextStates.set(241);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SELECT)) {
                    nextStates.set(245);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SHORT)) {
                    nextStates.set(277);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.STATIC)) {
                    nextStates.set(299);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SEALED)) {
                    nextStates.set(397);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.STACKALLOC)) {
                    nextStates.set(466);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SIZEOF)) {
                    nextStates.set(484);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SET)) {
                    nextStates.set(499);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.STRUCT)) {
                    nextStates.set(541);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SWITCH)) {
                    nextStates.set(555);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.STRING)) {
                    nextStates.set(622);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SBYTE)) {
                    nextStates.set(635);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.THROW)) {
                    nextStates.set(313);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.TRUE)) {
                    nextStates.set(342);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.TRY)) {
                    nextStates.set(422);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.TYPEOF)) {
                    nextStates.set(425);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.THIS)) {
                    nextStates.set(642);
                }
            } else if (ch == 117) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ULONG)) {
                    nextStates.set(338);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.UNSAFE)) {
                    nextStates.set(344);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.USHORT)) {
                    nextStates.set(365);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.UINT)) {
                    nextStates.set(520);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.UNCHECKED)) {
                    nextStates.set(561);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.UNMANAGED)) {
                    nextStates.set(594);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.USING)) {
                    nextStates.set(376);
                }
            } else if (ch == 118) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.VAR)) {
                    nextStates.set(298);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.VIRTUAL)) {
                    nextStates.set(328);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.VOLATILE)) {
                    nextStates.set(359);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.VOID)) {
                    nextStates.set(411);
                }
            } else if (ch == 119) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WHILE)) {
                    nextStates.set(271);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WHERE)) {
                    nextStates.set(392);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WHEN)) {
                    nextStates.set(432);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WITH)) {
                    nextStates.set(446);
                }
            } else if (ch == 121) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.YIELD)) {
                    nextStates.set(235);
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ORASSIGN)) {
                    nextStates.set(58);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SC_OR)) {
                    nextStates.set(71);
                }
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_773, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IDENTIFIER)) {
                    nextStates.set(7);
                    type = CSToken.TokenType.IDENTIFIER;
                }
            } else if (ch >= 48 && ch <= 57) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REAL_LITERAL)) {
                    nextStates.set(21);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTEGER_LITERAL)) {
                    nextStates.set(165);
                    type = CSToken.TokenType.INTEGER_LITERAL;
                }
            } else if (ch >= 9 && ch <= 11 || ch == 13 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_0, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WHITESPACE)) {
                    nextStates.set(97);
                    type = CSToken.TokenType.WHITESPACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACE)) {
                    type = CSToken.TokenType.LBRACE;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.AT)) {
                    type = CSToken.TokenType.AT;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.DOT)) {
                    type = CSToken.TokenType.DOT;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ASSIGN)) {
                    type = CSToken.TokenType.ASSIGN;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.REM)) {
                    type = CSToken.TokenType.REM;
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.HAT)) {
                    type = CSToken.TokenType.HAT;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BIT_OR)) {
                    type = CSToken.TokenType.BIT_OR;
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BIT_AND)) {
                    type = CSToken.TokenType.BIT_AND;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SLASH)) {
                    type = CSToken.TokenType.SLASH;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.STAR)) {
                    type = CSToken.TokenType.STAR;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.MINUS)) {
                    type = CSToken.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PLUS)) {
                    type = CSToken.TokenType.PLUS;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.COLON)) {
                    type = CSToken.TokenType.COLON;
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.HOOK)) {
                    type = CSToken.TokenType.HOOK;
                }
            } else if (ch == 126) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.TILDE)) {
                    type = CSToken.TokenType.TILDE;
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.BANG)) {
                    type = CSToken.TokenType.BANG;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LT)) {
                    type = CSToken.TokenType.LT;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.GT)) {
                    type = CSToken.TokenType.GT;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.COMMA)) {
                    type = CSToken.TokenType.COMMA;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.SEMICOLON)) {
                    type = CSToken.TokenType.SEMICOLON;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RBRACKET)) {
                    type = CSToken.TokenType.RBRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACKET)) {
                    type = CSToken.TokenType.LBRACKET;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RBRACE)) {
                    type = CSToken.TokenType.RBRACE;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.RPAREN)) {
                    type = CSToken.TokenType.RPAREN;
                }
            } else if (ch == 40 && (validTypes == null || validTypes.contains(CSToken.TokenType.LPAREN))) {
                type = CSToken.TokenType.LPAREN;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return CSToken.TokenType.OPERATOR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return CSToken.TokenType.FOR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.CHECKED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return CSToken.TokenType.ASSEMBLY;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.STARASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex6(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(7);
                return CSToken.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex7(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(221);
            } else if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_789, ch)) {
                nextStates.set(7);
                type = CSToken.TokenType.IDENTIFIER;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex8(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(7);
                return CSToken.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex9(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(7);
                return CSToken.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex10(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(7);
                return CSToken.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex11(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return CSToken.TokenType.ON;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex12(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                return CSToken.TokenType.REGULAR_INTERPOLATION_START;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex13(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.YIELD;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex14(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.LET;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex15(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 43) {
                return CSToken.TokenType.INCR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex16(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.INIT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex17(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 38) {
                return CSToken.TokenType.SC_AND;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex18(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.SCOPED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex19(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.SELECT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex20(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(21);
                return CSToken.TokenType.REAL_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex21(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(22);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(24);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(23);
                type = CSToken.TokenType.REAL_LITERAL;
            } else if (ch == 68 || ch == 70 || ch == 77 || ch == 100 || ch == 102 || ch == 109) {
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex22(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(22);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(23);
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex23(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(24);
            } else if (ch == 68 || ch == 70 || ch == 77 || ch == 100 || ch == 102 || ch == 109) {
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex24(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(28);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(25);
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex25(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(27);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
                type = CSToken.TokenType.REAL_LITERAL;
            } else if (ch == 68 || ch == 70 || ch == 77 || ch == 100 || ch == 102 || ch == 109) {
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex26(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 68 || ch == 70 || ch == 77 || ch == 100 || ch == 102 || ch == 109) {
                return CSToken.TokenType.REAL_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex27(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(27);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
                type = CSToken.TokenType.REAL_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex28(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(25);
                return CSToken.TokenType.REAL_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex29(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.GE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex30(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return CSToken.TokenType.CATCH;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex31(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(31);
            } else if (ch == 10 || ch == 13 || ch == 133 || ch == 8232 || ch == 8233) {
                type = CSToken.TokenType.PP_LINE;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex32(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.INTERNAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex33(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.FLOAT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex34(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 58) {
                return CSToken.TokenType.DOUBLE_COLON;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex35(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return CSToken.TokenType.LONG;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex36(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.FALSE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex37(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.REMASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex38(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.MODULE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex39(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.WHILE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex40(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                return CSToken.TokenType.BREAK;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex41(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.SHORT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex42(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(213);
            } else if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_773, ch)) {
                nextStates.set(7);
                type = CSToken.TokenType.IDENTIFIER;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex43(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(43);
            } else if (ch == 92) {
                nextStates.set(280);
            } else if (ch == 34) {
                nextStates.set(290);
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex44(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(43);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(43);
                nextStates.set(45);
                nextStates.set(47);
            } else if (ch == 92) {
                nextStates.set(280);
            } else if (ch == 34) {
                nextStates.set(290);
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex45(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(43);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(43);
            } else if (ch == 92) {
                nextStates.set(280);
            } else if (ch == 34) {
                nextStates.set(290);
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex46(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 56) {
                return CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex47(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(43);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(43);
                nextStates.set(45);
            } else if (ch == 92) {
                nextStates.set(280);
            } else if (ch == 34) {
                nextStates.set(290);
                type = CSToken.TokenType.REGULAR_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex48(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.LE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex49(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.LEFT_SHIFT_ASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex50(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return CSToken.TokenType.BY;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex51(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return CSToken.TokenType.CHAR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex52(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return CSToken.TokenType.VAR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex53(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return CSToken.TokenType.STATIC;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex54(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.PROTECTED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex55(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return CSToken.TokenType.AS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex56(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.BYTE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex57(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                return CSToken.TokenType.POINTER_ACCESS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex58(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.ORASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex59(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.ADD;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex60(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                return CSToken.TokenType.THROW;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex61(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return CSToken.TokenType.IF;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex62(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.PLUSASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex63(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.PARTIAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex64(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.AWAIT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex65(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                return CSToken.TokenType.RIGHT_SHIFT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex66(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return CSToken.TokenType.RETURN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex67(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.VIRTUAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex68(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.FIXED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex69(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                return CSToken.TokenType.LOCK;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex70(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return CSToken.TokenType.ULONG;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex71(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 124) {
                return CSToken.TokenType.SC_OR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex72(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.RIGHT_SHIFT_ASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex73(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.TRUE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex74(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.UNSAFE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex75(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.EQ;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex76(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.DECIMAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex77(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.REQUIRED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex78(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.VOLATILE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex79(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.USHORT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex80(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return CSToken.TokenType.USING;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex81(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 63) {
                return CSToken.TokenType.DOUBLE_HOOK;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex82(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return CSToken.TokenType.PUBLIC;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex83(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.CASE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex84(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.ELSE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex85(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.INT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex86(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.CONST;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex87(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                return CSToken.TokenType.MULTI_INTERPOLATION_START;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex88(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.WHERE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex89(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                return CSToken.TokenType.MULTI_INTERPOLATION_START;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex90(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                return CSToken.TokenType.NEW;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex91(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.SEALED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex92(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return CSToken.TokenType.FROM;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex93(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 60) {
                return CSToken.TokenType.LEFT_SHIFT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex94(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(95);
                return CSToken.TokenType.INTERPOLATED_RAW_STRING_START;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex95(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(95);
                return CSToken.TokenType.INTERPOLATED_RAW_STRING_START;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex96(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.OUT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex97(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 9 && ch <= 11 || ch == 13 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_0, ch)) {
                nextStates.set(97);
                return CSToken.TokenType.WHITESPACE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex98(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return CSToken.TokenType.ASYNC;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex99(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.AND;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex100(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.DOUBLE_HOOK_EQUALS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex101(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.VOID;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex102(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.DEFAULT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex103(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.MINUSASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex104(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.SLASHASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex105(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return CSToken.TokenType.EXTERN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex106(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.NE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex107(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return CSToken.TokenType.TRY;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex108(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return CSToken.TokenType.ENUM;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex109(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return CSToken.TokenType.TYPEOF;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex110(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return CSToken.TokenType.CLASS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex111(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return CSToken.TokenType.WHEN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex112(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return CSToken.TokenType.JOIN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex113(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return CSToken.TokenType.EQUALS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex114(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                return CSToken.TokenType.UNSIGNED_RIGHT_SHIFT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex115(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.BOOL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex116(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(117);
                return CSToken.TokenType.RAW_STRING_START;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex117(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(117);
                return CSToken.TokenType.RAW_STRING_START;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex118(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return CSToken.TokenType.IN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex119(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.BASE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex120(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return CSToken.TokenType.WITH;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex121(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return CSToken.TokenType.DESCENDING;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex122(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.EVENT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex123(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.NULL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex124(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return CSToken.TokenType.FOREACH;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex125(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return CSToken.TokenType.STACKALLOC;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex126(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return CSToken.TokenType.NAMEOF;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex127(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return CSToken.TokenType.ORDERBY;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex128(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(129);
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex129(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 76) {
                nextStates.set(132);
                nextStates.set(133);
            } else if (ch == 85) {
                nextStates.set(130);
                nextStates.set(135);
            } else if (ch == 108) {
                nextStates.set(134);
                nextStates.set(138);
            } else if (ch == 117) {
                nextStates.set(131);
                nextStates.set(136);
            } else if (ch == 48 || ch == 49) {
                nextStates.set(137);
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            if (ch == 48 || ch == 49 || ch == 95) {
                nextStates.set(129);
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 76) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 85) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 108) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 117) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex130(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 76) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex131(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 76) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex132(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex133(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 85) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex134(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 85) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex135(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex136(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex137(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 76) {
                nextStates.set(132);
                nextStates.set(133);
            } else if (ch == 85) {
                nextStates.set(130);
                nextStates.set(135);
            } else if (ch == 108) {
                nextStates.set(134);
                nextStates.set(138);
            } else if (ch == 117) {
                nextStates.set(131);
                nextStates.set(136);
            }
            if (ch == 76) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 85) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 108) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 117) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex138(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                return CSToken.TokenType.INTEGER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex139(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return CSToken.TokenType.SIZEOF;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex140(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return CSToken.TokenType.DYNAMIC;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex141(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.IMPLICIT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex142(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.SET;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex143(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.RECORD;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex144(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.UNSIGNED_RIGHT_SHIFT_ASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex145(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                return CSToken.TokenType.DECR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex146(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return CSToken.TokenType.READONLY;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex147(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return CSToken.TokenType.GOTO;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex148(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.MANAGED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex149(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return CSToken.TokenType.REF;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex150(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.UINT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex151(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return CSToken.TokenType.GROUP;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex152(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.INTERFACE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex153(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return CSToken.TokenType.FINALLY;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex154(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return CSToken.TokenType.OR;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex155(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.OBJECT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex156(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.STRUCT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex157(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                return CSToken.TokenType.VAR_ARGS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex158(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return CSToken.TokenType.IS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex159(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.CONTINUE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex160(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return CSToken.TokenType.SWITCH;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex161(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.XORASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex162(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(162);
            } else if (ch == 34) {
                nextStates.set(560);
                type = CSToken.TokenType.VERBATIM_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex163(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.UNCHECKED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex164(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return CSToken.TokenType.INTO;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex165(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(166);
            } else if (ch == 76) {
                nextStates.set(132);
                nextStates.set(133);
            } else if (ch == 85) {
                nextStates.set(130);
                nextStates.set(135);
            } else if (ch == 108) {
                nextStates.set(134);
                nextStates.set(138);
            } else if (ch == 117) {
                nextStates.set(131);
                nextStates.set(136);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(137);
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 76) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 85) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 108) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            } else if (ch == 117) {
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex166(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(166);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(137);
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex167(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch == 95 || ch >= 97 && ch <= 102) {
                nextStates.set(167);
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(137);
                type = CSToken.TokenType.INTEGER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex168(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 39) {
                return CSToken.TokenType.CHARACTER_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex169(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(170);
                nextStates.set(168);
                nextStates.set(171);
            } else if (ch == 39) {
                type = CSToken.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex170(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(168);
                nextStates.set(171);
            } else if (ch == 39) {
                type = CSToken.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex171(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(168);
            } else if (ch == 39) {
                type = CSToken.TokenType.CHARACTER_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex172(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.EXPLICIT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex173(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.REMOVE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex174(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                return CSToken.TokenType.RANGE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex175(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.OVERRIDE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex176(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return CSToken.TokenType.ANDASSIGN;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex177(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return CSToken.TokenType.UNMANAGED;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex178(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.NOT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex179(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.NAMESPACE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex180(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return CSToken.TokenType.DO;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex181(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.ABSTRACT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex182(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                return CSToken.TokenType.ARROW;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex183(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.ARGLIST;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex184(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return CSToken.TokenType.STRING;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex185(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.DELEGATE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex186(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(186);
            } else if (ch == 10 || ch == 13 || ch == 133 || ch == 8232 || ch == 8233) {
                type = CSToken.TokenType.SINGLE_LINE_COMMENT;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex187(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(CSToken.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch == 47) {
                return CSToken.TokenType.MULTI_LINE_COMMENT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex188(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.SBYTE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex189(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.DOUBLE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex190(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return CSToken.TokenType.THIS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex191(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return CSToken.TokenType.GET;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex192(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return CSToken.TokenType.PRIVATE;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex193(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return CSToken.TokenType.ASCENDING;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex194(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return CSToken.TokenType.PARAMS;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex195(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(196);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex196(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(197);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex197(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(198);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex198(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(199);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex199(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(200);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex200(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex201(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(2);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex202(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(203);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex203(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(204);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex204(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(205);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex205(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(206);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex206(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(3);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex207(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(208);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex208(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(209);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex209(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(210);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex210(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(211);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex211(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(212);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex212(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(4);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex213(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 85) {
                nextStates.set(214);
            } else if (ch == 117) {
                nextStates.set(232);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex214(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(215);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex215(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(216);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex216(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(217);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex217(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(218);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex218(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(219);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex219(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(220);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex220(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(6);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex221(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 85) {
                nextStates.set(225);
            } else if (ch == 117) {
                nextStates.set(222);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex222(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(223);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex223(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(224);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex224(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(8);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex225(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(226);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex226(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(227);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex227(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(228);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex228(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(229);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex229(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(230);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex230(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(231);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex231(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(9);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex232(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(233);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex233(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(234);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex234(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(10);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex235(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(236);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex236(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(237);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex237(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(13);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex238(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(14);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex239(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(240);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex240(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(16);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex241(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(242);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex242(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(243);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex243(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(244);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex244(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(18);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex245(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(246);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex246(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(247);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex247(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(248);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex248(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(19);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex249(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(250);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex250(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(251);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex251(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(30);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex252(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_866, ch)) {
                nextStates.set(252);
            } else if (ch == 35) {
                nextStates.set(31);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex253(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(254);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex254(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(255);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex255(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(256);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex256(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(257);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex257(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(258);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex258(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(32);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex259(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(260);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex260(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(261);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex261(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(33);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex262(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(263);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex263(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(35);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex264(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(265);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex265(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(266);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex266(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(36);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex267(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(268);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex268(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(269);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex269(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(270);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex270(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(38);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex271(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(272);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex272(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(273);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex273(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(39);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex274(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(275);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex275(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(276);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex276(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(40);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex277(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(278);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex278(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(279);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex279(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(41);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex280(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_823, ch)) {
                nextStates.set(43);
            } else if (ch == 85) {
                nextStates.set(281);
            } else if (ch == 117) {
                nextStates.set(291);
            } else if (ch == 120) {
                nextStates.set(289);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex281(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(282);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex282(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(283);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex283(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(284);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex284(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(285);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex285(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(286);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex286(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(287);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex287(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(288);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex288(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(43);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex289(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(44);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex290(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(46);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex291(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(292);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex292(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(293);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex293(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(294);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex294(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(43);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex295(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 60) {
                nextStates.set(49);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex296(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(297);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex297(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(51);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex298(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(52);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex299(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(300);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex300(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(301);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex301(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(302);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex302(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(53);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex303(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(304);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex304(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(305);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex305(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(306);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex306(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(307);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex307(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(308);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex308(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(309);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex309(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(54);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex310(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(311);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex311(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(56);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex312(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(59);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex313(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(314);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex314(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(315);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex315(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(60);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex316(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(317);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex317(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(318);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex318(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(319);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex319(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(320);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex320(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(63);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex321(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(322);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex322(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(323);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex323(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(64);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex324(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(325);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex325(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(326);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex326(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(327);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex327(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(66);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex328(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(329);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex329(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(330);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex330(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(331);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex331(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(332);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex332(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(67);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex333(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(334);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex334(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(335);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex335(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(68);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex336(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(337);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex337(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(69);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex338(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(339);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex339(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(340);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex340(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(70);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex341(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                nextStates.set(72);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex342(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(343);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex343(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(73);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex344(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(345);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex345(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(346);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex346(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(347);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex347(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(74);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex348(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(349);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex349(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(350);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex350(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(351);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex351(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(352);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex352(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(76);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex353(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(354);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex354(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 113) {
                nextStates.set(355);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex355(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(356);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex356(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(357);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex357(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(358);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex358(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(77);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex359(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(360);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex360(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(361);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex361(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(362);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex362(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(363);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex363(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(364);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex364(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(78);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex365(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(366);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex366(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(367);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex367(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(368);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex368(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(79);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex369(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(370);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex370(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(371);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex371(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(372);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex372(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(373);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex373(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(374);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex374(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 9 && ch <= 11 || ch == 13 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_543, ch)) {
                nextStates.set(375);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex375(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 9 && ch <= 11 || ch == 13 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_543, ch)) {
                nextStates.set(375);
            } else if (ch == 117) {
                nextStates.set(376);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex376(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(377);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex377(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(378);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex378(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(80);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex379(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(380);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex380(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(381);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex381(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(382);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex382(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(82);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex383(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(384);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex384(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(83);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex385(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(386);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex386(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(84);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex387(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(85);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex388(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(389);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex389(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(390);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex390(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(86);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex391(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 36) {
                nextStates.set(87);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex392(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(393);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex393(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(394);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex394(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(88);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex395(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 64) {
                nextStates.set(89);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex396(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(90);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex397(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(398);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex398(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(399);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex399(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(400);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex400(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(91);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex401(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(402);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex402(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(92);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex403(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(404);
            } else if (ch == 36) {
                nextStates.set(403);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex404(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(94);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex405(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(96);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex406(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(407);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex407(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(408);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex408(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(98);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex409(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(99);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex410(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 63) {
                nextStates.set(100);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex411(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(412);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex412(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(101);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex413(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(414);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex414(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(415);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex415(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(416);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex416(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(417);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex417(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(102);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex418(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(419);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex419(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(420);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex420(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(421);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex421(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(105);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex422(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(107);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex423(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(424);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex424(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(108);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex425(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(426);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex426(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(427);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex427(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(428);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex428(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(109);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex429(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(430);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex430(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(431);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex431(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(110);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex432(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(433);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex433(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(111);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex434(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(435);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex435(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(112);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex436(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 113) {
                nextStates.set(437);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex437(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(438);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex438(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(439);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex439(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(113);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex440(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                nextStates.set(114);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex441(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(442);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex442(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(115);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex443(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(116);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex444(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(445);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex445(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(119);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex446(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(447);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex447(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(120);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex448(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(449);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex449(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(450);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex450(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(451);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex451(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(452);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex452(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(453);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex453(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(454);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex454(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(455);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex455(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(121);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex456(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(457);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex457(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(458);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex458(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(122);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex459(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(460);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex460(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(123);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex461(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(462);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex462(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(463);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex463(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(464);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex464(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(465);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex465(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(124);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex466(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(467);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex467(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(468);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex468(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(469);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex469(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(470);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex470(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(471);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex471(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(472);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex472(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(473);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex473(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(125);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex474(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(475);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex475(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(476);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex476(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(477);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex477(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(126);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex478(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(479);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex479(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(480);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex480(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(481);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex481(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(482);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex482(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(127);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex483(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(128);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex484(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(485);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex485(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(486);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex486(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(487);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex487(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(139);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex488(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(489);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex489(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(490);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex490(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(491);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex491(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(492);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex492(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(140);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex493(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(494);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex494(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(495);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex495(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(496);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex496(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(497);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex497(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(498);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex498(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(141);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex499(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(142);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex500(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(501);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex501(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(502);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex502(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(503);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex503(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(143);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex504(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                nextStates.set(505);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex505(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                nextStates.set(144);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex506(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(507);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex507(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(508);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex508(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(509);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex509(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(510);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex510(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(511);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex511(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(146);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex512(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(513);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex513(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(147);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex514(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(515);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex515(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(516);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex516(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(517);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex517(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(518);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex518(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(148);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex519(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(149);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex520(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(521);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex521(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(150);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex522(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(523);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex523(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(524);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex524(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(151);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex525(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(526);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex526(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(527);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex527(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(528);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex528(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(529);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex529(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(530);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex530(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(531);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex531(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(152);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex532(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(533);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex533(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(534);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex534(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(535);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex535(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(536);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex536(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(153);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex537(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(538);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex538(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 106) {
                nextStates.set(539);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex539(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(540);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex540(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(155);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex541(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(542);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex542(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(543);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex543(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(544);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex544(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(156);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex545(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(157);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex546(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(547);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex547(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(548);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex548(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(549);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex549(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(550);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex550(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(551);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex551(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(159);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex552(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(20);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(553);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(554);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex553(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(20);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex554(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(553);
            }
            if (ch >= 48 && ch <= 57 || ch == 95) {
                nextStates.set(554);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex555(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(556);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex556(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(557);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex557(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(558);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex558(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(160);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex559(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(162);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex560(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(162);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex561(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(562);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex562(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(563);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex563(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(564);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex564(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(565);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex565(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(566);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex566(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(567);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex567(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(163);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex568(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(569);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex569(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(164);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex570(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(167);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex571(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(168);
            } else if (ch == 92) {
                nextStates.set(572);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex572(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (CSLexer.checkIntervals(CSHARP.NFA_MOVES_CSHARP_808, ch)) {
                nextStates.set(168);
            } else if (ch == 117) {
                nextStates.set(573);
            } else if (ch == 120) {
                nextStates.set(577);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex573(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(574);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex574(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(575);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex575(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(576);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex576(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(168);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex577(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(169);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex578(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(579);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex579(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(580);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex580(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(581);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex581(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(582);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex582(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(583);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex583(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(172);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex584(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(585);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex585(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(586);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex586(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(587);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex587(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(173);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex588(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(589);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex589(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(590);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex590(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(591);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex591(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(592);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex592(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(593);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex593(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(175);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex594(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(595);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex595(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(596);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex596(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(597);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex597(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(598);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex598(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(599);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex599(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(600);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex600(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(177);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex601(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(178);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex602(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(603);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex603(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(604);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex604(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(605);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex605(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(606);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex606(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(607);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex607(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(608);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex608(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(179);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex609(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(610);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex610(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(611);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex611(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(612);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex612(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(613);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex613(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(614);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex614(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(181);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex615(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(616);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex616(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(617);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex617(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(618);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex618(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(619);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex619(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(620);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex620(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(621);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex621(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(183);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex622(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(623);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex623(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(624);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex624(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(625);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex625(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(184);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex626(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(627);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex627(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(628);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex628(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(629);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex629(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(630);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex630(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(631);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex631(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(185);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex632(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(186);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex633(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(CSToken.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch == 42) {
                nextStates.set(634);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex634(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(CSToken.TokenType.MULTI_LINE_COMMENT)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(634);
            }
            if (ch == 42) {
                nextStates.set(187);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex635(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(636);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex636(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(637);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex637(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(188);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex638(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(639);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex639(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(640);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex640(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(641);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex641(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(189);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex642(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(643);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex643(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(190);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex644(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(191);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex645(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(646);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex646(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(647);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex647(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(648);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex648(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(649);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex649(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(192);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex650(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(651);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex651(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(652);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex652(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(653);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex653(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(654);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex654(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(655);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex655(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(656);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex656(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(193);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex657(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(658);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex658(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(659);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex659(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(660);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameCSHARPIndex660(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(194);
            }
            return null;
        }

        private static int[] NFA_MOVES_CSHARP_0_init() {
            return new int[]{9, 11, 13, 13, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_CSHARP_543_init() {
            return new int[]{9, 11, 13, 13, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_CSHARP_773_init() {
            return new int[]{65, 90, 95, 95, 97, 122, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1488, 1514, 1519, 1522, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2048, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2208, 2228, 2230, 2247, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2545, 2556, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3294, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3648, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5905, 5920, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6108, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6987, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8305, 8305, 8319, 8319, 8336, 8348, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65136, 65140, 65142, 65276, 65313, 65338, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69552, 69572, 69600, 69622, 69635, 69687, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 123136, 123180, 123191, 123197, 123214, 123214, 123584, 123627, 124928, 125124, 125184, 125251, 125259, 125259, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_CSHARP_789_init() {
            return new int[]{48, 57, 65, 90, 95, 95, 97, 122, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2045, 2048, 2093, 2112, 2139, 2144, 2154, 2208, 2228, 2230, 2247, 2259, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2545, 2556, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3294, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3648, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5900, 5902, 5908, 5920, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6108, 6109, 6112, 6121, 6155, 6158, 6160, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6848, 6912, 6987, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7673, 7675, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11310, 11312, 11358, 11360, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 40956, 40960, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42943, 42946, 42954, 42997, 43047, 43052, 43052, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65019, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65136, 65140, 65142, 65276, 65279, 65279, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 67072, 67382, 67392, 67413, 67424, 67431, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69743, 69759, 69818, 69821, 69821, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72384, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73728, 74649, 74752, 74862, 74880, 75075, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110592, 110878, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123584, 123641, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173789, 173824, 177972, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static int[] NFA_MOVES_CSHARP_808_init() {
            return new int[]{34, 34, 39, 39, 48, 48, 92, 92, 97, 98, 102, 102, 110, 110, 114, 114, 116, 116, 118, 118};
        }

        private static int[] NFA_MOVES_CSHARP_823_init() {
            return new int[]{34, 34, 39, 39, 48, 48, 92, 92, 97, 98, 102, 102, 110, 110, 114, 114, 116, 116, 118, 118};
        }

        private static int[] NFA_MOVES_CSHARP_866_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{CSHARP::getNfaNameCSHARPIndex0, CSHARP::getNfaNameCSHARPIndex1, CSHARP::getNfaNameCSHARPIndex2, CSHARP::getNfaNameCSHARPIndex3, CSHARP::getNfaNameCSHARPIndex4, CSHARP::getNfaNameCSHARPIndex5, CSHARP::getNfaNameCSHARPIndex6, CSHARP::getNfaNameCSHARPIndex7, CSHARP::getNfaNameCSHARPIndex8, CSHARP::getNfaNameCSHARPIndex9, CSHARP::getNfaNameCSHARPIndex10, CSHARP::getNfaNameCSHARPIndex11, CSHARP::getNfaNameCSHARPIndex12, CSHARP::getNfaNameCSHARPIndex13, CSHARP::getNfaNameCSHARPIndex14, CSHARP::getNfaNameCSHARPIndex15, CSHARP::getNfaNameCSHARPIndex16, CSHARP::getNfaNameCSHARPIndex17, CSHARP::getNfaNameCSHARPIndex18, CSHARP::getNfaNameCSHARPIndex19, CSHARP::getNfaNameCSHARPIndex20, CSHARP::getNfaNameCSHARPIndex21, CSHARP::getNfaNameCSHARPIndex22, CSHARP::getNfaNameCSHARPIndex23, CSHARP::getNfaNameCSHARPIndex24, CSHARP::getNfaNameCSHARPIndex25, CSHARP::getNfaNameCSHARPIndex26, CSHARP::getNfaNameCSHARPIndex27, CSHARP::getNfaNameCSHARPIndex28, CSHARP::getNfaNameCSHARPIndex29, CSHARP::getNfaNameCSHARPIndex30, CSHARP::getNfaNameCSHARPIndex31, CSHARP::getNfaNameCSHARPIndex32, CSHARP::getNfaNameCSHARPIndex33, CSHARP::getNfaNameCSHARPIndex34, CSHARP::getNfaNameCSHARPIndex35, CSHARP::getNfaNameCSHARPIndex36, CSHARP::getNfaNameCSHARPIndex37, CSHARP::getNfaNameCSHARPIndex38, CSHARP::getNfaNameCSHARPIndex39, CSHARP::getNfaNameCSHARPIndex40, CSHARP::getNfaNameCSHARPIndex41, CSHARP::getNfaNameCSHARPIndex42, CSHARP::getNfaNameCSHARPIndex43, CSHARP::getNfaNameCSHARPIndex44, CSHARP::getNfaNameCSHARPIndex45, CSHARP::getNfaNameCSHARPIndex46, CSHARP::getNfaNameCSHARPIndex47, CSHARP::getNfaNameCSHARPIndex48, CSHARP::getNfaNameCSHARPIndex49, CSHARP::getNfaNameCSHARPIndex50, CSHARP::getNfaNameCSHARPIndex51, CSHARP::getNfaNameCSHARPIndex52, CSHARP::getNfaNameCSHARPIndex53, CSHARP::getNfaNameCSHARPIndex54, CSHARP::getNfaNameCSHARPIndex55, CSHARP::getNfaNameCSHARPIndex56, CSHARP::getNfaNameCSHARPIndex57, CSHARP::getNfaNameCSHARPIndex58, CSHARP::getNfaNameCSHARPIndex59, CSHARP::getNfaNameCSHARPIndex60, CSHARP::getNfaNameCSHARPIndex61, CSHARP::getNfaNameCSHARPIndex62, CSHARP::getNfaNameCSHARPIndex63, CSHARP::getNfaNameCSHARPIndex64, CSHARP::getNfaNameCSHARPIndex65, CSHARP::getNfaNameCSHARPIndex66, CSHARP::getNfaNameCSHARPIndex67, CSHARP::getNfaNameCSHARPIndex68, CSHARP::getNfaNameCSHARPIndex69, CSHARP::getNfaNameCSHARPIndex70, CSHARP::getNfaNameCSHARPIndex71, CSHARP::getNfaNameCSHARPIndex72, CSHARP::getNfaNameCSHARPIndex73, CSHARP::getNfaNameCSHARPIndex74, CSHARP::getNfaNameCSHARPIndex75, CSHARP::getNfaNameCSHARPIndex76, CSHARP::getNfaNameCSHARPIndex77, CSHARP::getNfaNameCSHARPIndex78, CSHARP::getNfaNameCSHARPIndex79, CSHARP::getNfaNameCSHARPIndex80, CSHARP::getNfaNameCSHARPIndex81, CSHARP::getNfaNameCSHARPIndex82, CSHARP::getNfaNameCSHARPIndex83, CSHARP::getNfaNameCSHARPIndex84, CSHARP::getNfaNameCSHARPIndex85, CSHARP::getNfaNameCSHARPIndex86, CSHARP::getNfaNameCSHARPIndex87, CSHARP::getNfaNameCSHARPIndex88, CSHARP::getNfaNameCSHARPIndex89, CSHARP::getNfaNameCSHARPIndex90, CSHARP::getNfaNameCSHARPIndex91, CSHARP::getNfaNameCSHARPIndex92, CSHARP::getNfaNameCSHARPIndex93, CSHARP::getNfaNameCSHARPIndex94, CSHARP::getNfaNameCSHARPIndex95, CSHARP::getNfaNameCSHARPIndex96, CSHARP::getNfaNameCSHARPIndex97, CSHARP::getNfaNameCSHARPIndex98, CSHARP::getNfaNameCSHARPIndex99, CSHARP::getNfaNameCSHARPIndex100, CSHARP::getNfaNameCSHARPIndex101, CSHARP::getNfaNameCSHARPIndex102, CSHARP::getNfaNameCSHARPIndex103, CSHARP::getNfaNameCSHARPIndex104, CSHARP::getNfaNameCSHARPIndex105, CSHARP::getNfaNameCSHARPIndex106, CSHARP::getNfaNameCSHARPIndex107, CSHARP::getNfaNameCSHARPIndex108, CSHARP::getNfaNameCSHARPIndex109, CSHARP::getNfaNameCSHARPIndex110, CSHARP::getNfaNameCSHARPIndex111, CSHARP::getNfaNameCSHARPIndex112, CSHARP::getNfaNameCSHARPIndex113, CSHARP::getNfaNameCSHARPIndex114, CSHARP::getNfaNameCSHARPIndex115, CSHARP::getNfaNameCSHARPIndex116, CSHARP::getNfaNameCSHARPIndex117, CSHARP::getNfaNameCSHARPIndex118, CSHARP::getNfaNameCSHARPIndex119, CSHARP::getNfaNameCSHARPIndex120, CSHARP::getNfaNameCSHARPIndex121, CSHARP::getNfaNameCSHARPIndex122, CSHARP::getNfaNameCSHARPIndex123, CSHARP::getNfaNameCSHARPIndex124, CSHARP::getNfaNameCSHARPIndex125, CSHARP::getNfaNameCSHARPIndex126, CSHARP::getNfaNameCSHARPIndex127, CSHARP::getNfaNameCSHARPIndex128, CSHARP::getNfaNameCSHARPIndex129, CSHARP::getNfaNameCSHARPIndex130, CSHARP::getNfaNameCSHARPIndex131, CSHARP::getNfaNameCSHARPIndex132, CSHARP::getNfaNameCSHARPIndex133, CSHARP::getNfaNameCSHARPIndex134, CSHARP::getNfaNameCSHARPIndex135, CSHARP::getNfaNameCSHARPIndex136, CSHARP::getNfaNameCSHARPIndex137, CSHARP::getNfaNameCSHARPIndex138, CSHARP::getNfaNameCSHARPIndex139, CSHARP::getNfaNameCSHARPIndex140, CSHARP::getNfaNameCSHARPIndex141, CSHARP::getNfaNameCSHARPIndex142, CSHARP::getNfaNameCSHARPIndex143, CSHARP::getNfaNameCSHARPIndex144, CSHARP::getNfaNameCSHARPIndex145, CSHARP::getNfaNameCSHARPIndex146, CSHARP::getNfaNameCSHARPIndex147, CSHARP::getNfaNameCSHARPIndex148, CSHARP::getNfaNameCSHARPIndex149, CSHARP::getNfaNameCSHARPIndex150, CSHARP::getNfaNameCSHARPIndex151, CSHARP::getNfaNameCSHARPIndex152, CSHARP::getNfaNameCSHARPIndex153, CSHARP::getNfaNameCSHARPIndex154, CSHARP::getNfaNameCSHARPIndex155, CSHARP::getNfaNameCSHARPIndex156, CSHARP::getNfaNameCSHARPIndex157, CSHARP::getNfaNameCSHARPIndex158, CSHARP::getNfaNameCSHARPIndex159, CSHARP::getNfaNameCSHARPIndex160, CSHARP::getNfaNameCSHARPIndex161, CSHARP::getNfaNameCSHARPIndex162, CSHARP::getNfaNameCSHARPIndex163, CSHARP::getNfaNameCSHARPIndex164, CSHARP::getNfaNameCSHARPIndex165, CSHARP::getNfaNameCSHARPIndex166, CSHARP::getNfaNameCSHARPIndex167, CSHARP::getNfaNameCSHARPIndex168, CSHARP::getNfaNameCSHARPIndex169, CSHARP::getNfaNameCSHARPIndex170, CSHARP::getNfaNameCSHARPIndex171, CSHARP::getNfaNameCSHARPIndex172, CSHARP::getNfaNameCSHARPIndex173, CSHARP::getNfaNameCSHARPIndex174, CSHARP::getNfaNameCSHARPIndex175, CSHARP::getNfaNameCSHARPIndex176, CSHARP::getNfaNameCSHARPIndex177, CSHARP::getNfaNameCSHARPIndex178, CSHARP::getNfaNameCSHARPIndex179, CSHARP::getNfaNameCSHARPIndex180, CSHARP::getNfaNameCSHARPIndex181, CSHARP::getNfaNameCSHARPIndex182, CSHARP::getNfaNameCSHARPIndex183, CSHARP::getNfaNameCSHARPIndex184, CSHARP::getNfaNameCSHARPIndex185, CSHARP::getNfaNameCSHARPIndex186, CSHARP::getNfaNameCSHARPIndex187, CSHARP::getNfaNameCSHARPIndex188, CSHARP::getNfaNameCSHARPIndex189, CSHARP::getNfaNameCSHARPIndex190, CSHARP::getNfaNameCSHARPIndex191, CSHARP::getNfaNameCSHARPIndex192, CSHARP::getNfaNameCSHARPIndex193, CSHARP::getNfaNameCSHARPIndex194, CSHARP::getNfaNameCSHARPIndex195, CSHARP::getNfaNameCSHARPIndex196, CSHARP::getNfaNameCSHARPIndex197, CSHARP::getNfaNameCSHARPIndex198, CSHARP::getNfaNameCSHARPIndex199, CSHARP::getNfaNameCSHARPIndex200, CSHARP::getNfaNameCSHARPIndex201, CSHARP::getNfaNameCSHARPIndex202, CSHARP::getNfaNameCSHARPIndex203, CSHARP::getNfaNameCSHARPIndex204, CSHARP::getNfaNameCSHARPIndex205, CSHARP::getNfaNameCSHARPIndex206, CSHARP::getNfaNameCSHARPIndex207, CSHARP::getNfaNameCSHARPIndex208, CSHARP::getNfaNameCSHARPIndex209, CSHARP::getNfaNameCSHARPIndex210, CSHARP::getNfaNameCSHARPIndex211, CSHARP::getNfaNameCSHARPIndex212, CSHARP::getNfaNameCSHARPIndex213, CSHARP::getNfaNameCSHARPIndex214, CSHARP::getNfaNameCSHARPIndex215, CSHARP::getNfaNameCSHARPIndex216, CSHARP::getNfaNameCSHARPIndex217, CSHARP::getNfaNameCSHARPIndex218, CSHARP::getNfaNameCSHARPIndex219, CSHARP::getNfaNameCSHARPIndex220, CSHARP::getNfaNameCSHARPIndex221, CSHARP::getNfaNameCSHARPIndex222, CSHARP::getNfaNameCSHARPIndex223, CSHARP::getNfaNameCSHARPIndex224, CSHARP::getNfaNameCSHARPIndex225, CSHARP::getNfaNameCSHARPIndex226, CSHARP::getNfaNameCSHARPIndex227, CSHARP::getNfaNameCSHARPIndex228, CSHARP::getNfaNameCSHARPIndex229, CSHARP::getNfaNameCSHARPIndex230, CSHARP::getNfaNameCSHARPIndex231, CSHARP::getNfaNameCSHARPIndex232, CSHARP::getNfaNameCSHARPIndex233, CSHARP::getNfaNameCSHARPIndex234, CSHARP::getNfaNameCSHARPIndex235, CSHARP::getNfaNameCSHARPIndex236, CSHARP::getNfaNameCSHARPIndex237, CSHARP::getNfaNameCSHARPIndex238, CSHARP::getNfaNameCSHARPIndex239, CSHARP::getNfaNameCSHARPIndex240, CSHARP::getNfaNameCSHARPIndex241, CSHARP::getNfaNameCSHARPIndex242, CSHARP::getNfaNameCSHARPIndex243, CSHARP::getNfaNameCSHARPIndex244, CSHARP::getNfaNameCSHARPIndex245, CSHARP::getNfaNameCSHARPIndex246, CSHARP::getNfaNameCSHARPIndex247, CSHARP::getNfaNameCSHARPIndex248, CSHARP::getNfaNameCSHARPIndex249, CSHARP::getNfaNameCSHARPIndex250, CSHARP::getNfaNameCSHARPIndex251, CSHARP::getNfaNameCSHARPIndex252, CSHARP::getNfaNameCSHARPIndex253, CSHARP::getNfaNameCSHARPIndex254, CSHARP::getNfaNameCSHARPIndex255, CSHARP::getNfaNameCSHARPIndex256, CSHARP::getNfaNameCSHARPIndex257, CSHARP::getNfaNameCSHARPIndex258, CSHARP::getNfaNameCSHARPIndex259, CSHARP::getNfaNameCSHARPIndex260, CSHARP::getNfaNameCSHARPIndex261, CSHARP::getNfaNameCSHARPIndex262, CSHARP::getNfaNameCSHARPIndex263, CSHARP::getNfaNameCSHARPIndex264, CSHARP::getNfaNameCSHARPIndex265, CSHARP::getNfaNameCSHARPIndex266, CSHARP::getNfaNameCSHARPIndex267, CSHARP::getNfaNameCSHARPIndex268, CSHARP::getNfaNameCSHARPIndex269, CSHARP::getNfaNameCSHARPIndex270, CSHARP::getNfaNameCSHARPIndex271, CSHARP::getNfaNameCSHARPIndex272, CSHARP::getNfaNameCSHARPIndex273, CSHARP::getNfaNameCSHARPIndex274, CSHARP::getNfaNameCSHARPIndex275, CSHARP::getNfaNameCSHARPIndex276, CSHARP::getNfaNameCSHARPIndex277, CSHARP::getNfaNameCSHARPIndex278, CSHARP::getNfaNameCSHARPIndex279, CSHARP::getNfaNameCSHARPIndex280, CSHARP::getNfaNameCSHARPIndex281, CSHARP::getNfaNameCSHARPIndex282, CSHARP::getNfaNameCSHARPIndex283, CSHARP::getNfaNameCSHARPIndex284, CSHARP::getNfaNameCSHARPIndex285, CSHARP::getNfaNameCSHARPIndex286, CSHARP::getNfaNameCSHARPIndex287, CSHARP::getNfaNameCSHARPIndex288, CSHARP::getNfaNameCSHARPIndex289, CSHARP::getNfaNameCSHARPIndex290, CSHARP::getNfaNameCSHARPIndex291, CSHARP::getNfaNameCSHARPIndex292, CSHARP::getNfaNameCSHARPIndex293, CSHARP::getNfaNameCSHARPIndex294, CSHARP::getNfaNameCSHARPIndex295, CSHARP::getNfaNameCSHARPIndex296, CSHARP::getNfaNameCSHARPIndex297, CSHARP::getNfaNameCSHARPIndex298, CSHARP::getNfaNameCSHARPIndex299, CSHARP::getNfaNameCSHARPIndex300, CSHARP::getNfaNameCSHARPIndex301, CSHARP::getNfaNameCSHARPIndex302, CSHARP::getNfaNameCSHARPIndex303, CSHARP::getNfaNameCSHARPIndex304, CSHARP::getNfaNameCSHARPIndex305, CSHARP::getNfaNameCSHARPIndex306, CSHARP::getNfaNameCSHARPIndex307, CSHARP::getNfaNameCSHARPIndex308, CSHARP::getNfaNameCSHARPIndex309, CSHARP::getNfaNameCSHARPIndex310, CSHARP::getNfaNameCSHARPIndex311, CSHARP::getNfaNameCSHARPIndex312, CSHARP::getNfaNameCSHARPIndex313, CSHARP::getNfaNameCSHARPIndex314, CSHARP::getNfaNameCSHARPIndex315, CSHARP::getNfaNameCSHARPIndex316, CSHARP::getNfaNameCSHARPIndex317, CSHARP::getNfaNameCSHARPIndex318, CSHARP::getNfaNameCSHARPIndex319, CSHARP::getNfaNameCSHARPIndex320, CSHARP::getNfaNameCSHARPIndex321, CSHARP::getNfaNameCSHARPIndex322, CSHARP::getNfaNameCSHARPIndex323, CSHARP::getNfaNameCSHARPIndex324, CSHARP::getNfaNameCSHARPIndex325, CSHARP::getNfaNameCSHARPIndex326, CSHARP::getNfaNameCSHARPIndex327, CSHARP::getNfaNameCSHARPIndex328, CSHARP::getNfaNameCSHARPIndex329, CSHARP::getNfaNameCSHARPIndex330, CSHARP::getNfaNameCSHARPIndex331, CSHARP::getNfaNameCSHARPIndex332, CSHARP::getNfaNameCSHARPIndex333, CSHARP::getNfaNameCSHARPIndex334, CSHARP::getNfaNameCSHARPIndex335, CSHARP::getNfaNameCSHARPIndex336, CSHARP::getNfaNameCSHARPIndex337, CSHARP::getNfaNameCSHARPIndex338, CSHARP::getNfaNameCSHARPIndex339, CSHARP::getNfaNameCSHARPIndex340, CSHARP::getNfaNameCSHARPIndex341, CSHARP::getNfaNameCSHARPIndex342, CSHARP::getNfaNameCSHARPIndex343, CSHARP::getNfaNameCSHARPIndex344, CSHARP::getNfaNameCSHARPIndex345, CSHARP::getNfaNameCSHARPIndex346, CSHARP::getNfaNameCSHARPIndex347, CSHARP::getNfaNameCSHARPIndex348, CSHARP::getNfaNameCSHARPIndex349, CSHARP::getNfaNameCSHARPIndex350, CSHARP::getNfaNameCSHARPIndex351, CSHARP::getNfaNameCSHARPIndex352, CSHARP::getNfaNameCSHARPIndex353, CSHARP::getNfaNameCSHARPIndex354, CSHARP::getNfaNameCSHARPIndex355, CSHARP::getNfaNameCSHARPIndex356, CSHARP::getNfaNameCSHARPIndex357, CSHARP::getNfaNameCSHARPIndex358, CSHARP::getNfaNameCSHARPIndex359, CSHARP::getNfaNameCSHARPIndex360, CSHARP::getNfaNameCSHARPIndex361, CSHARP::getNfaNameCSHARPIndex362, CSHARP::getNfaNameCSHARPIndex363, CSHARP::getNfaNameCSHARPIndex364, CSHARP::getNfaNameCSHARPIndex365, CSHARP::getNfaNameCSHARPIndex366, CSHARP::getNfaNameCSHARPIndex367, CSHARP::getNfaNameCSHARPIndex368, CSHARP::getNfaNameCSHARPIndex369, CSHARP::getNfaNameCSHARPIndex370, CSHARP::getNfaNameCSHARPIndex371, CSHARP::getNfaNameCSHARPIndex372, CSHARP::getNfaNameCSHARPIndex373, CSHARP::getNfaNameCSHARPIndex374, CSHARP::getNfaNameCSHARPIndex375, CSHARP::getNfaNameCSHARPIndex376, CSHARP::getNfaNameCSHARPIndex377, CSHARP::getNfaNameCSHARPIndex378, CSHARP::getNfaNameCSHARPIndex379, CSHARP::getNfaNameCSHARPIndex380, CSHARP::getNfaNameCSHARPIndex381, CSHARP::getNfaNameCSHARPIndex382, CSHARP::getNfaNameCSHARPIndex383, CSHARP::getNfaNameCSHARPIndex384, CSHARP::getNfaNameCSHARPIndex385, CSHARP::getNfaNameCSHARPIndex386, CSHARP::getNfaNameCSHARPIndex387, CSHARP::getNfaNameCSHARPIndex388, CSHARP::getNfaNameCSHARPIndex389, CSHARP::getNfaNameCSHARPIndex390, CSHARP::getNfaNameCSHARPIndex391, CSHARP::getNfaNameCSHARPIndex392, CSHARP::getNfaNameCSHARPIndex393, CSHARP::getNfaNameCSHARPIndex394, CSHARP::getNfaNameCSHARPIndex395, CSHARP::getNfaNameCSHARPIndex396, CSHARP::getNfaNameCSHARPIndex397, CSHARP::getNfaNameCSHARPIndex398, CSHARP::getNfaNameCSHARPIndex399, CSHARP::getNfaNameCSHARPIndex400, CSHARP::getNfaNameCSHARPIndex401, CSHARP::getNfaNameCSHARPIndex402, CSHARP::getNfaNameCSHARPIndex403, CSHARP::getNfaNameCSHARPIndex404, CSHARP::getNfaNameCSHARPIndex405, CSHARP::getNfaNameCSHARPIndex406, CSHARP::getNfaNameCSHARPIndex407, CSHARP::getNfaNameCSHARPIndex408, CSHARP::getNfaNameCSHARPIndex409, CSHARP::getNfaNameCSHARPIndex410, CSHARP::getNfaNameCSHARPIndex411, CSHARP::getNfaNameCSHARPIndex412, CSHARP::getNfaNameCSHARPIndex413, CSHARP::getNfaNameCSHARPIndex414, CSHARP::getNfaNameCSHARPIndex415, CSHARP::getNfaNameCSHARPIndex416, CSHARP::getNfaNameCSHARPIndex417, CSHARP::getNfaNameCSHARPIndex418, CSHARP::getNfaNameCSHARPIndex419, CSHARP::getNfaNameCSHARPIndex420, CSHARP::getNfaNameCSHARPIndex421, CSHARP::getNfaNameCSHARPIndex422, CSHARP::getNfaNameCSHARPIndex423, CSHARP::getNfaNameCSHARPIndex424, CSHARP::getNfaNameCSHARPIndex425, CSHARP::getNfaNameCSHARPIndex426, CSHARP::getNfaNameCSHARPIndex427, CSHARP::getNfaNameCSHARPIndex428, CSHARP::getNfaNameCSHARPIndex429, CSHARP::getNfaNameCSHARPIndex430, CSHARP::getNfaNameCSHARPIndex431, CSHARP::getNfaNameCSHARPIndex432, CSHARP::getNfaNameCSHARPIndex433, CSHARP::getNfaNameCSHARPIndex434, CSHARP::getNfaNameCSHARPIndex435, CSHARP::getNfaNameCSHARPIndex436, CSHARP::getNfaNameCSHARPIndex437, CSHARP::getNfaNameCSHARPIndex438, CSHARP::getNfaNameCSHARPIndex439, CSHARP::getNfaNameCSHARPIndex440, CSHARP::getNfaNameCSHARPIndex441, CSHARP::getNfaNameCSHARPIndex442, CSHARP::getNfaNameCSHARPIndex443, CSHARP::getNfaNameCSHARPIndex444, CSHARP::getNfaNameCSHARPIndex445, CSHARP::getNfaNameCSHARPIndex446, CSHARP::getNfaNameCSHARPIndex447, CSHARP::getNfaNameCSHARPIndex448, CSHARP::getNfaNameCSHARPIndex449, CSHARP::getNfaNameCSHARPIndex450, CSHARP::getNfaNameCSHARPIndex451, CSHARP::getNfaNameCSHARPIndex452, CSHARP::getNfaNameCSHARPIndex453, CSHARP::getNfaNameCSHARPIndex454, CSHARP::getNfaNameCSHARPIndex455, CSHARP::getNfaNameCSHARPIndex456, CSHARP::getNfaNameCSHARPIndex457, CSHARP::getNfaNameCSHARPIndex458, CSHARP::getNfaNameCSHARPIndex459, CSHARP::getNfaNameCSHARPIndex460, CSHARP::getNfaNameCSHARPIndex461, CSHARP::getNfaNameCSHARPIndex462, CSHARP::getNfaNameCSHARPIndex463, CSHARP::getNfaNameCSHARPIndex464, CSHARP::getNfaNameCSHARPIndex465, CSHARP::getNfaNameCSHARPIndex466, CSHARP::getNfaNameCSHARPIndex467, CSHARP::getNfaNameCSHARPIndex468, CSHARP::getNfaNameCSHARPIndex469, CSHARP::getNfaNameCSHARPIndex470, CSHARP::getNfaNameCSHARPIndex471, CSHARP::getNfaNameCSHARPIndex472, CSHARP::getNfaNameCSHARPIndex473, CSHARP::getNfaNameCSHARPIndex474, CSHARP::getNfaNameCSHARPIndex475, CSHARP::getNfaNameCSHARPIndex476, CSHARP::getNfaNameCSHARPIndex477, CSHARP::getNfaNameCSHARPIndex478, CSHARP::getNfaNameCSHARPIndex479, CSHARP::getNfaNameCSHARPIndex480, CSHARP::getNfaNameCSHARPIndex481, CSHARP::getNfaNameCSHARPIndex482, CSHARP::getNfaNameCSHARPIndex483, CSHARP::getNfaNameCSHARPIndex484, CSHARP::getNfaNameCSHARPIndex485, CSHARP::getNfaNameCSHARPIndex486, CSHARP::getNfaNameCSHARPIndex487, CSHARP::getNfaNameCSHARPIndex488, CSHARP::getNfaNameCSHARPIndex489, CSHARP::getNfaNameCSHARPIndex490, CSHARP::getNfaNameCSHARPIndex491, CSHARP::getNfaNameCSHARPIndex492, CSHARP::getNfaNameCSHARPIndex493, CSHARP::getNfaNameCSHARPIndex494, CSHARP::getNfaNameCSHARPIndex495, CSHARP::getNfaNameCSHARPIndex496, CSHARP::getNfaNameCSHARPIndex497, CSHARP::getNfaNameCSHARPIndex498, CSHARP::getNfaNameCSHARPIndex499, CSHARP::getNfaNameCSHARPIndex500, CSHARP::getNfaNameCSHARPIndex501, CSHARP::getNfaNameCSHARPIndex502, CSHARP::getNfaNameCSHARPIndex503, CSHARP::getNfaNameCSHARPIndex504, CSHARP::getNfaNameCSHARPIndex505, CSHARP::getNfaNameCSHARPIndex506, CSHARP::getNfaNameCSHARPIndex507, CSHARP::getNfaNameCSHARPIndex508, CSHARP::getNfaNameCSHARPIndex509, CSHARP::getNfaNameCSHARPIndex510, CSHARP::getNfaNameCSHARPIndex511, CSHARP::getNfaNameCSHARPIndex512, CSHARP::getNfaNameCSHARPIndex513, CSHARP::getNfaNameCSHARPIndex514, CSHARP::getNfaNameCSHARPIndex515, CSHARP::getNfaNameCSHARPIndex516, CSHARP::getNfaNameCSHARPIndex517, CSHARP::getNfaNameCSHARPIndex518, CSHARP::getNfaNameCSHARPIndex519, CSHARP::getNfaNameCSHARPIndex520, CSHARP::getNfaNameCSHARPIndex521, CSHARP::getNfaNameCSHARPIndex522, CSHARP::getNfaNameCSHARPIndex523, CSHARP::getNfaNameCSHARPIndex524, CSHARP::getNfaNameCSHARPIndex525, CSHARP::getNfaNameCSHARPIndex526, CSHARP::getNfaNameCSHARPIndex527, CSHARP::getNfaNameCSHARPIndex528, CSHARP::getNfaNameCSHARPIndex529, CSHARP::getNfaNameCSHARPIndex530, CSHARP::getNfaNameCSHARPIndex531, CSHARP::getNfaNameCSHARPIndex532, CSHARP::getNfaNameCSHARPIndex533, CSHARP::getNfaNameCSHARPIndex534, CSHARP::getNfaNameCSHARPIndex535, CSHARP::getNfaNameCSHARPIndex536, CSHARP::getNfaNameCSHARPIndex537, CSHARP::getNfaNameCSHARPIndex538, CSHARP::getNfaNameCSHARPIndex539, CSHARP::getNfaNameCSHARPIndex540, CSHARP::getNfaNameCSHARPIndex541, CSHARP::getNfaNameCSHARPIndex542, CSHARP::getNfaNameCSHARPIndex543, CSHARP::getNfaNameCSHARPIndex544, CSHARP::getNfaNameCSHARPIndex545, CSHARP::getNfaNameCSHARPIndex546, CSHARP::getNfaNameCSHARPIndex547, CSHARP::getNfaNameCSHARPIndex548, CSHARP::getNfaNameCSHARPIndex549, CSHARP::getNfaNameCSHARPIndex550, CSHARP::getNfaNameCSHARPIndex551, CSHARP::getNfaNameCSHARPIndex552, CSHARP::getNfaNameCSHARPIndex553, CSHARP::getNfaNameCSHARPIndex554, CSHARP::getNfaNameCSHARPIndex555, CSHARP::getNfaNameCSHARPIndex556, CSHARP::getNfaNameCSHARPIndex557, CSHARP::getNfaNameCSHARPIndex558, CSHARP::getNfaNameCSHARPIndex559, CSHARP::getNfaNameCSHARPIndex560, CSHARP::getNfaNameCSHARPIndex561, CSHARP::getNfaNameCSHARPIndex562, CSHARP::getNfaNameCSHARPIndex563, CSHARP::getNfaNameCSHARPIndex564, CSHARP::getNfaNameCSHARPIndex565, CSHARP::getNfaNameCSHARPIndex566, CSHARP::getNfaNameCSHARPIndex567, CSHARP::getNfaNameCSHARPIndex568, CSHARP::getNfaNameCSHARPIndex569, CSHARP::getNfaNameCSHARPIndex570, CSHARP::getNfaNameCSHARPIndex571, CSHARP::getNfaNameCSHARPIndex572, CSHARP::getNfaNameCSHARPIndex573, CSHARP::getNfaNameCSHARPIndex574, CSHARP::getNfaNameCSHARPIndex575, CSHARP::getNfaNameCSHARPIndex576, CSHARP::getNfaNameCSHARPIndex577, CSHARP::getNfaNameCSHARPIndex578, CSHARP::getNfaNameCSHARPIndex579, CSHARP::getNfaNameCSHARPIndex580, CSHARP::getNfaNameCSHARPIndex581, CSHARP::getNfaNameCSHARPIndex582, CSHARP::getNfaNameCSHARPIndex583, CSHARP::getNfaNameCSHARPIndex584, CSHARP::getNfaNameCSHARPIndex585, CSHARP::getNfaNameCSHARPIndex586, CSHARP::getNfaNameCSHARPIndex587, CSHARP::getNfaNameCSHARPIndex588, CSHARP::getNfaNameCSHARPIndex589, CSHARP::getNfaNameCSHARPIndex590, CSHARP::getNfaNameCSHARPIndex591, CSHARP::getNfaNameCSHARPIndex592, CSHARP::getNfaNameCSHARPIndex593, CSHARP::getNfaNameCSHARPIndex594, CSHARP::getNfaNameCSHARPIndex595, CSHARP::getNfaNameCSHARPIndex596, CSHARP::getNfaNameCSHARPIndex597, CSHARP::getNfaNameCSHARPIndex598, CSHARP::getNfaNameCSHARPIndex599, CSHARP::getNfaNameCSHARPIndex600, CSHARP::getNfaNameCSHARPIndex601, CSHARP::getNfaNameCSHARPIndex602, CSHARP::getNfaNameCSHARPIndex603, CSHARP::getNfaNameCSHARPIndex604, CSHARP::getNfaNameCSHARPIndex605, CSHARP::getNfaNameCSHARPIndex606, CSHARP::getNfaNameCSHARPIndex607, CSHARP::getNfaNameCSHARPIndex608, CSHARP::getNfaNameCSHARPIndex609, CSHARP::getNfaNameCSHARPIndex610, CSHARP::getNfaNameCSHARPIndex611, CSHARP::getNfaNameCSHARPIndex612, CSHARP::getNfaNameCSHARPIndex613, CSHARP::getNfaNameCSHARPIndex614, CSHARP::getNfaNameCSHARPIndex615, CSHARP::getNfaNameCSHARPIndex616, CSHARP::getNfaNameCSHARPIndex617, CSHARP::getNfaNameCSHARPIndex618, CSHARP::getNfaNameCSHARPIndex619, CSHARP::getNfaNameCSHARPIndex620, CSHARP::getNfaNameCSHARPIndex621, CSHARP::getNfaNameCSHARPIndex622, CSHARP::getNfaNameCSHARPIndex623, CSHARP::getNfaNameCSHARPIndex624, CSHARP::getNfaNameCSHARPIndex625, CSHARP::getNfaNameCSHARPIndex626, CSHARP::getNfaNameCSHARPIndex627, CSHARP::getNfaNameCSHARPIndex628, CSHARP::getNfaNameCSHARPIndex629, CSHARP::getNfaNameCSHARPIndex630, CSHARP::getNfaNameCSHARPIndex631, CSHARP::getNfaNameCSHARPIndex632, CSHARP::getNfaNameCSHARPIndex633, CSHARP::getNfaNameCSHARPIndex634, CSHARP::getNfaNameCSHARPIndex635, CSHARP::getNfaNameCSHARPIndex636, CSHARP::getNfaNameCSHARPIndex637, CSHARP::getNfaNameCSHARPIndex638, CSHARP::getNfaNameCSHARPIndex639, CSHARP::getNfaNameCSHARPIndex640, CSHARP::getNfaNameCSHARPIndex641, CSHARP::getNfaNameCSHARPIndex642, CSHARP::getNfaNameCSHARPIndex643, CSHARP::getNfaNameCSHARPIndex644, CSHARP::getNfaNameCSHARPIndex645, CSHARP::getNfaNameCSHARPIndex646, CSHARP::getNfaNameCSHARPIndex647, CSHARP::getNfaNameCSHARPIndex648, CSHARP::getNfaNameCSHARPIndex649, CSHARP::getNfaNameCSHARPIndex650, CSHARP::getNfaNameCSHARPIndex651, CSHARP::getNfaNameCSHARPIndex652, CSHARP::getNfaNameCSHARPIndex653, CSHARP::getNfaNameCSHARPIndex654, CSHARP::getNfaNameCSHARPIndex655, CSHARP::getNfaNameCSHARPIndex656, CSHARP::getNfaNameCSHARPIndex657, CSHARP::getNfaNameCSHARPIndex658, CSHARP::getNfaNameCSHARPIndex659, CSHARP::getNfaNameCSHARPIndex660};
            functionTableMap.put(LexicalState.CSHARP, functions);
        }
    }

    private static class IN_REGULAR_INTERPOLATION {
        private static final int[] NFA_MOVES_IN_REGULAR_INTERPOLATION_0 = IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_0_init();
        private static final int[] NFA_MOVES_IN_REGULAR_INTERPOLATION_6 = IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_6_init();

        private IN_REGULAR_INTERPOLATION() {
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    nextStates.set(1);
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    nextStates.set(5);
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    nextStates.set(4);
                }
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126 && ch <= 132 || ch >= 128 && CSLexer.checkIntervals(IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_0, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT)) {
                    nextStates.set(3);
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
                }
            } else if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.ENDING_QUOTE))) {
                type = CSToken.TokenType.ENDING_QUOTE;
            }
            if (ch == 123 && (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACE))) {
                type = CSToken.TokenType.LBRACE;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 85) {
                nextStates.set(14);
            } else if (ch == 117) {
                nextStates.set(11);
            } else if (ch == 120) {
                nextStates.set(6);
            } else if (CSLexer.checkIntervals(IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_6, ch)) {
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(3);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(1);
            } else if (ch == 123) {
                nextStates.set(5);
            } else if (ch == 125) {
                nextStates.set(4);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126 && ch <= 132 || ch >= 128 && CSLexer.checkIntervals(IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_0, ch)) {
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 125) {
                nextStates.set(3);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 123) {
                nextStates.set(3);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex6(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(7);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex7(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(1);
            } else if (ch == 123) {
                nextStates.set(5);
            } else if (ch == 125) {
                nextStates.set(4);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126 && ch <= 132 || ch >= 128 && CSLexer.checkIntervals(IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_0, ch)) {
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(8);
                nextStates.set(9);
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex8(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(1);
            } else if (ch == 123) {
                nextStates.set(5);
            } else if (ch == 125) {
                nextStates.set(4);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126 && ch <= 132 || ch >= 128 && CSLexer.checkIntervals(IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_0, ch)) {
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(9);
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex9(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 92) {
                nextStates.set(1);
            } else if (ch == 123) {
                nextStates.set(5);
            } else if (ch == 125) {
                nextStates.set(4);
            } else if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93 && ch <= 122 || ch == 124 || ch >= 126 && ch <= 132 || ch >= 128 && CSLexer.checkIntervals(IN_REGULAR_INTERPOLATION.NFA_MOVES_IN_REGULAR_INTERPOLATION_0, ch)) {
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex10(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(3);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex11(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(12);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex12(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(13);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex13(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(2);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex14(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(15);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex15(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(16);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex16(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(17);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex17(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(18);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex18(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(19);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex19(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(20);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_REGULAR_INTERPOLATIONIndex20(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(10);
            }
            return null;
        }

        private static int[] NFA_MOVES_IN_REGULAR_INTERPOLATION_0_init() {
            return new int[]{0, 9, 11, 12, 14, 33, 35, 91, 93, 122, 124, 124, 126, 132, 134, 8231, 8234, 0x10FFFF};
        }

        private static int[] NFA_MOVES_IN_REGULAR_INTERPOLATION_6_init() {
            return new int[]{34, 34, 39, 39, 48, 48, 92, 92, 97, 98, 102, 102, 110, 110, 114, 114, 116, 116, 118, 118};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex0, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex1, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex2, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex3, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex4, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex5, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex6, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex7, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex8, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex9, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex10, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex11, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex12, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex13, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex14, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex15, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex16, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex17, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex18, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex19, IN_REGULAR_INTERPOLATION::getNfaNameIN_REGULAR_INTERPOLATIONIndex20};
            functionTableMap.put(LexicalState.IN_REGULAR_INTERPOLATION, functions);
        }
    }

    private static class IN_MULTI_INTERPOLATION {
        private IN_MULTI_INTERPOLATION() {
        }

        private static CSToken.TokenType getNfaNameIN_MULTI_INTERPOLATIONIndex0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    nextStates.set(3);
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    nextStates.set(4);
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2)) {
                    nextStates.set(1);
                }
            } else if ((ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) && (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT2))) {
                nextStates.set(2);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT2;
            }
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.ENDING_QUOTE)) {
                    type = CSToken.TokenType.ENDING_QUOTE;
                }
            } else if (ch == 123 && (validTypes == null || validTypes.contains(CSToken.TokenType.LBRACE))) {
                type = CSToken.TokenType.LBRACE;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_MULTI_INTERPOLATIONIndex1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 125) {
                nextStates.set(2);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT2;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_MULTI_INTERPOLATIONIndex2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                nextStates.set(3);
            } else if (ch == 123) {
                nextStates.set(4);
            } else if (ch == 125) {
                nextStates.set(1);
            } else if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(2);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT2;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_MULTI_INTERPOLATIONIndex3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(2);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT2;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_MULTI_INTERPOLATIONIndex4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 123) {
                nextStates.set(2);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT2;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_MULTI_INTERPOLATION::getNfaNameIN_MULTI_INTERPOLATIONIndex0, IN_MULTI_INTERPOLATION::getNfaNameIN_MULTI_INTERPOLATIONIndex1, IN_MULTI_INTERPOLATION::getNfaNameIN_MULTI_INTERPOLATIONIndex2, IN_MULTI_INTERPOLATION::getNfaNameIN_MULTI_INTERPOLATIONIndex3, IN_MULTI_INTERPOLATION::getNfaNameIN_MULTI_INTERPOLATIONIndex4};
            functionTableMap.put(LexicalState.IN_MULTI_INTERPOLATION, functions);
        }
    }

    private static class IN_IGNORED_SECTION {
        private static final int[] NFA_MOVES_IN_IGNORED_SECTION_0 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_0_init();
        private static final int[] NFA_MOVES_IN_IGNORED_SECTION_4 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_4_init();
        private static final int[] NFA_MOVES_IN_IGNORED_SECTION_6 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_6_init();
        private static final int[] NFA_MOVES_IN_IGNORED_SECTION_7 = IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_7_init();

        private IN_IGNORED_SECTION() {
        }

        private static CSToken.TokenType getNfaNameIN_IGNORED_SECTIONIndex0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch == 12 || ch >= 14 && ch <= 31 || ch == 33 || ch == 34 || ch >= 36 && ch <= 132 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_7, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IGNORED_LINE)) {
                    nextStates.set(2);
                }
            } else if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_0, ch)) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PP_LINE)) {
                    nextStates.set(4);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.WHITESPACE_LINE)) {
                    nextStates.set(3);
                }
                if (validTypes == null || validTypes.contains(CSToken.TokenType.IGNORED_LINE)) {
                    nextStates.set(5);
                }
            } else if (ch == 35) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.PP_LINE)) {
                    nextStates.set(1);
                }
            } else if (!(ch != 10 && ch != 13 && ch != 133 && ch != 8232 && ch != 8233 || validTypes != null && !validTypes.contains(CSToken.TokenType.WHITESPACE_LINE))) {
                type = CSToken.TokenType.WHITESPACE_LINE;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_IGNORED_SECTIONIndex1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(1);
            } else if (ch == 10 || ch == 13 || ch == 133 || ch == 8232 || ch == 8233) {
                type = CSToken.TokenType.PP_LINE;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_IGNORED_SECTIONIndex2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14 && ch <= 132 || ch >= 134 && ch <= 8231 || ch >= 8234) {
                nextStates.set(2);
            } else if (ch == 10 || ch == 13 || ch == 133 || ch == 8232 || ch == 8233) {
                type = CSToken.TokenType.IGNORED_LINE;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_IGNORED_SECTIONIndex3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_4, ch)) {
                nextStates.set(3);
            } else if (ch == 10 || ch == 13 || ch == 133 || ch == 8232 || ch == 8233) {
                type = CSToken.TokenType.WHITESPACE_LINE;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_IGNORED_SECTIONIndex4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_0, ch)) {
                nextStates.set(4);
            } else if (ch == 35) {
                nextStates.set(1);
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_IGNORED_SECTIONIndex5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 8 || ch == 12 || ch >= 14 && ch <= 31 || ch == 33 || ch == 34 || ch >= 36 && ch <= 132 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_7, ch)) {
                nextStates.set(2);
            } else if (ch == 9 || ch == 11 || ch == 32 || ch >= 128 && CSLexer.checkIntervals(IN_IGNORED_SECTION.NFA_MOVES_IN_IGNORED_SECTION_6, ch)) {
                nextStates.set(5);
            }
            return null;
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_0_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_4_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_6_init() {
            return new int[]{9, 9, 11, 11, 32, 32, 160, 160, 5760, 5760, 8192, 8202, 8239, 8239, 8287, 8287, 12288, 12288};
        }

        private static int[] NFA_MOVES_IN_IGNORED_SECTION_7_init() {
            return new int[]{0, 8, 12, 12, 14, 31, 33, 34, 36, 132, 134, 159, 161, 5759, 5761, 8191, 8203, 8231, 8234, 8238, 8240, 8286, 8288, 12287, 12289, 0x10FFFF};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_IGNORED_SECTION::getNfaNameIN_IGNORED_SECTIONIndex0, IN_IGNORED_SECTION::getNfaNameIN_IGNORED_SECTIONIndex1, IN_IGNORED_SECTION::getNfaNameIN_IGNORED_SECTIONIndex2, IN_IGNORED_SECTION::getNfaNameIN_IGNORED_SECTIONIndex3, IN_IGNORED_SECTION::getNfaNameIN_IGNORED_SECTIONIndex4, IN_IGNORED_SECTION::getNfaNameIN_IGNORED_SECTIONIndex5};
            functionTableMap.put(LexicalState.IN_IGNORED_SECTION, functions);
        }
    }

    private static class IN_INTERPOLATED_RAW_STRING {
        private IN_INTERPOLATED_RAW_STRING() {
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.INTERPOLATED_RAW_STRING_END)) {
                    nextStates.set(7);
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.END_RAW_INTERPOLATION)) {
                    nextStates.set(6);
                    type = CSToken.TokenType.END_RAW_INTERPOLATION;
                }
            } else if ((ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) && (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT3))) {
                nextStates.set(3);
                type = CSToken.TokenType.NON_INTERPOLATED_TEXT3;
            }
            if (ch == 34) {
                if (validTypes == null || validTypes.contains(CSToken.TokenType.NON_INTERPOLATED_TEXT3)) {
                    nextStates.set(1);
                    type = CSToken.TokenType.NON_INTERPOLATED_TEXT3;
                }
            } else if (ch == 123 && (validTypes == null || validTypes.contains(CSToken.TokenType.START_INTERPOLATION))) {
                nextStates.set(2);
                type = CSToken.TokenType.START_INTERPOLATION;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                return CSToken.TokenType.NON_INTERPOLATED_TEXT3;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 123) {
                nextStates.set(2);
                return CSToken.TokenType.START_INTERPOLATION;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 122 || ch == 124 || ch >= 126) {
                nextStates.set(3);
                return CSToken.TokenType.NON_INTERPOLATED_TEXT3;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(5);
                return CSToken.TokenType.INTERPOLATED_RAW_STRING_END;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex5(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(5);
                return CSToken.TokenType.INTERPOLATED_RAW_STRING_END;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex6(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 125) {
                nextStates.set(6);
                return CSToken.TokenType.END_RAW_INTERPOLATION;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_INTERPOLATED_RAW_STRINGIndex7(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(4);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex0, IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex1, IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex2, IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex3, IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex4, IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex5, IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex6, IN_INTERPOLATED_RAW_STRING::getNfaNameIN_INTERPOLATED_RAW_STRINGIndex7};
            functionTableMap.put(LexicalState.IN_INTERPOLATED_RAW_STRING, functions);
        }
    }

    private static class IN_RAW_STRING {
        private IN_RAW_STRING() {
        }

        private static CSToken.TokenType getNfaNameIN_RAW_STRINGIndex0(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 34 && (validTypes == null || validTypes.contains(CSToken.TokenType.RAW_STRING_LITERAL))) {
                nextStates.set(4);
            }
            if (ch >= 0 && (validTypes == null || validTypes.contains(CSToken.TokenType.ANY_CHAR))) {
                type = CSToken.TokenType.ANY_CHAR;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_RAW_STRINGIndex1(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(2);
                return CSToken.TokenType.RAW_STRING_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_RAW_STRINGIndex2(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            CSToken.TokenType type = null;
            if (ch == 117) {
                nextStates.set(3);
            } else if (ch == 34) {
                nextStates.set(2);
                type = CSToken.TokenType.RAW_STRING_LITERAL;
            }
            return type;
        }

        private static CSToken.TokenType getNfaNameIN_RAW_STRINGIndex3(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 56) {
                return CSToken.TokenType.RAW_STRING_LITERAL;
            }
            return null;
        }

        private static CSToken.TokenType getNfaNameIN_RAW_STRINGIndex4(int ch, BitSet nextStates, EnumSet<CSToken.TokenType> validTypes, EnumSet<CSToken.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(1);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{IN_RAW_STRING::getNfaNameIN_RAW_STRINGIndex0, IN_RAW_STRING::getNfaNameIN_RAW_STRINGIndex1, IN_RAW_STRING::getNfaNameIN_RAW_STRINGIndex2, IN_RAW_STRING::getNfaNameIN_RAW_STRINGIndex3, IN_RAW_STRING::getNfaNameIN_RAW_STRINGIndex4};
            functionTableMap.put(LexicalState.IN_RAW_STRING, functions);
        }
    }
}

