/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core.nfa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.congocc.core.Grammar;
import org.congocc.core.LexerData;
import org.congocc.core.RegexpSpec;
import org.congocc.core.RegularExpression;
import org.congocc.core.nfa.CompositeStateSet;
import org.congocc.core.nfa.NfaBuilder;
import org.congocc.core.nfa.NfaState;
import org.congocc.parser.tree.RegexpStringLiteral;
import org.congocc.parser.tree.TokenProduction;

public class LexicalStateData {
    final Grammar grammar;
    private final String name;
    private final List<TokenProduction> tokenProductions = new ArrayList<TokenProduction>();
    private List<CompositeStateSet> compositeSets;
    private final List<NfaState> simpleStates = new ArrayList<NfaState>();
    private final Map<Set<NfaState>, CompositeStateSet> canonicalSetLookup = new HashMap<Set<NfaState>, CompositeStateSet>();
    private final Map<String, RegexpStringLiteral> caseSensitiveTokenTable = new HashMap<String, RegexpStringLiteral>();
    private final Map<String, RegexpStringLiteral> caseInsensitiveTokenTable = new HashMap<String, RegexpStringLiteral>();
    private final Set<RegularExpression> regularExpressions = new LinkedHashSet<RegularExpression>();
    private final NfaState initialState;
    private final Set<NfaState> allStates = new LinkedHashSet<NfaState>();

    public LexicalStateData(Grammar grammar, String name) {
        this.grammar = grammar;
        this.name = name;
        this.initialState = new NfaState(this, null);
    }

    public LexerData getLexerData() {
        return this.grammar.getLexerData();
    }

    public List<CompositeStateSet> getCanonicalSets() {
        return this.compositeSets;
    }

    public String getName() {
        return this.name;
    }

    public List<NfaState> getAllNfaStates() {
        return this.simpleStates;
    }

    void addState(NfaState state) {
        this.allStates.add(state);
    }

    NfaState getInitialState() {
        return this.initialState;
    }

    public void addTokenProduction(TokenProduction tokenProduction) {
        this.tokenProductions.add(tokenProduction);
    }

    public boolean containsRegularExpression(RegularExpression re) {
        return this.regularExpressions.contains(re);
    }

    public void addStringLiteral(RegexpStringLiteral re) {
        if (re.getIgnoreCase()) {
            this.caseInsensitiveTokenTable.putIfAbsent(re.getLiteralString().toUpperCase(), re);
        } else {
            this.caseSensitiveTokenTable.putIfAbsent(re.getLiteralString(), re);
        }
    }

    public RegexpStringLiteral getStringLiteral(String image) {
        RegexpStringLiteral result = this.caseSensitiveTokenTable.get(image);
        if (result == null) {
            result = this.caseInsensitiveTokenTable.get(image.toUpperCase());
        }
        return result;
    }

    CompositeStateSet getCanonicalComposite(Set<NfaState> stateSet) {
        CompositeStateSet result = this.canonicalSetLookup.get(stateSet);
        if (result == null) {
            result = new CompositeStateSet(stateSet, this);
            this.canonicalSetLookup.put(stateSet, result);
        }
        return result;
    }

    public void process() {
        this.processUnspecifiedStringLiterals();
        for (TokenProduction tp : this.tokenProductions) {
            this.processTokenProduction(tp);
        }
        if (this.regularExpressions.isEmpty()) {
            // empty if block
        }
        this.generateData();
    }

    private void generateData() {
        HashSet<NfaState> alreadyVisited = new HashSet<NfaState>();
        for (NfaState state2 : this.allStates) {
            state2.doEpsilonClosure(alreadyVisited);
        }
        this.allStates.removeIf(state -> !state.isMoveCodeNeeded());
        for (NfaState state2 : this.allStates) {
            state2.setMovesArrayName(this.simpleStates.size());
            this.simpleStates.add(state2);
        }
        LinkedHashSet<CompositeStateSet> allComposites = new LinkedHashSet<CompositeStateSet>();
        CompositeStateSet initialComposite = this.initialState.getComposite();
        initialComposite.findWhatIsUsed(new HashSet<CompositeStateSet>(), allComposites);
        this.compositeSets = new ArrayList<CompositeStateSet>(allComposites);
        int indexInList = this.compositeSets.indexOf(initialComposite);
        if (indexInList == -1) {
            this.compositeSets.clear();
            this.compositeSets.add(initialComposite);
        }
        this.compositeSets.sort(this::comparator);
        for (int i = 0; i < this.compositeSets.size(); ++i) {
            this.compositeSets.get(i).setIndex(i);
        }
    }

    private int comparator(CompositeStateSet set1, CompositeStateSet set2) {
        if (set1 == this.initialState.getComposite()) {
            return -1;
        }
        if (set2 == this.initialState.getComposite()) {
            return 1;
        }
        if (set1.getHasFinalState() && !set2.getHasFinalState()) {
            return -1;
        }
        if (set2.getHasFinalState() && !set1.getHasFinalState()) {
            return 1;
        }
        return 0;
    }

    private void processTokenProduction(TokenProduction tp) {
        boolean ignore = tp.isIgnoreCase() || this.grammar.getAppSettings().isIgnoreCase();
        for (RegexpSpec regexpSpec : tp.getRegexpSpecs()) {
            RegularExpression currentRegexp = regexpSpec.getRegexp();
            if (currentRegexp.isPrivate() || this.grammar.getLexerData().isOverridden(currentRegexp)) continue;
            this.regularExpressions.add(currentRegexp);
            new NfaBuilder(this, currentRegexp, ignore).buildStates();
            if (regexpSpec.getNextLexicalState() == null || regexpSpec.getNextLexicalState().equals(this.name)) continue;
            currentRegexp.setNewLexicalState(this.grammar.getLexerData().getLexicalState(regexpSpec.getNextLexicalState()));
        }
    }

    private void processUnspecifiedStringLiterals() {
        for (RegexpStringLiteral rsl : this.caseInsensitiveTokenTable.values()) {
            if (rsl.getTokenProduction() != null) continue;
            this.regularExpressions.add(rsl);
            new NfaBuilder(this, rsl, true).buildStates();
        }
        for (RegexpStringLiteral rsl : this.caseSensitiveTokenTable.values()) {
            if (rsl.getTokenProduction() != null) continue;
            this.regularExpressions.add(rsl);
            new NfaBuilder(this, rsl, false).buildStates();
        }
    }
}

