/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core.nfa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.congocc.core.RegularExpression;
import org.congocc.core.nfa.LexicalStateData;
import org.congocc.core.nfa.NfaState;

public class CompositeStateSet {
    private final Set<NfaState> states;
    final LexicalStateData lexicalState;
    private int index = -1;

    CompositeStateSet(Set<NfaState> states, LexicalStateData lsd) {
        this.states = new HashSet<NfaState>(states);
        this.lexicalState = lsd;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public String getLabel() {
        Iterator<NfaState> iterator = this.states.iterator();
        if (iterator.hasNext()) {
            NfaState state = iterator.next();
            return state.getType().getLabel();
        }
        return null;
    }

    public RegularExpression getType() {
        assert (this.index != 0);
        return this.states.iterator().next().getType();
    }

    public int getNumStates() {
        return this.states.size();
    }

    public NfaState getSingleState() {
        return this.states.iterator().next();
    }

    public boolean getHasFinalState() {
        return this.states.stream().anyMatch(state -> state.getNextState().isFinal());
    }

    public String getMethodName() {
        String lexicalStateName = this.lexicalState.getName();
        if (lexicalStateName.equals("DEFAULT")) {
            return "NfaIndex" + this.index;
        }
        return "NfaName" + lexicalStateName + "Index" + this.index;
    }

    public String checkAllSameType() {
        String label = this.getLabel();
        for (NfaState state : this.states) {
            assert (state.getType().getLabel().equals(label));
        }
        return "";
    }

    public boolean equals(Object other) {
        return other instanceof CompositeStateSet && ((CompositeStateSet)other).states.equals(this.states);
    }

    public List<NfaState> getOrderedStates() {
        ArrayList<NfaState> result = new ArrayList<NfaState>(this.states);
        result.sort(this::nfaComparator);
        return result;
    }

    private int nfaComparator(NfaState state1, NfaState state2) {
        int result = CompositeStateSet.getOrdinal(state2.getNextState()) - CompositeStateSet.getOrdinal(state1.getNextState());
        if (result == 0) {
            result = state1.getMoveRanges().get(0) - state2.getMoveRanges().get(0);
        }
        if (result == 0) {
            result = state1.getMoveRanges().get(1) - state2.getMoveRanges().get(1);
        }
        if (result == 0) {
            result = state1.getMoveRanges().size() - state2.getMoveRanges().size();
        }
        return result;
    }

    private static int getOrdinal(NfaState state) {
        return !state.isFinal() ? Integer.MAX_VALUE : state.getType().getOrdinal();
    }

    void findWhatIsUsed(Set<CompositeStateSet> alreadyVisited, Set<CompositeStateSet> usedStates) {
        if (alreadyVisited.contains(this)) {
            return;
        }
        alreadyVisited.add(this);
        if (this.states.isEmpty()) {
            return;
        }
        usedStates.add(this);
        for (NfaState state : this.states) {
            state.getNextState().getComposite().findWhatIsUsed(alreadyVisited, usedStates);
        }
    }
}

