/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.python;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.congocc.parser.Node;
import org.congocc.parser.python.ast.Assignment;
import org.congocc.parser.python.ast.Block;
import org.congocc.parser.python.ast.ClassDefinition;
import org.congocc.parser.python.ast.DotName;
import org.congocc.parser.python.ast.FunctionDefinition;
import org.congocc.parser.python.ast.Module;
import org.congocc.parser.python.ast.Name;
import org.congocc.parser.python.ast.Statement;

public class Reaper {
    private static final Logger logger = Logger.getLogger("reaper");
    private final Module module;
    private static final Pattern parserSetPattern = Pattern.compile("(first|follow)_set", 2);
    private static final Pattern methodPattern = Pattern.compile("^(parse_|(backscan|scan|check|assert|recover)\u03a3)");

    public Reaper(Module module) {
        this.module = module;
    }

    private static boolean isAssignment(Statement stmt) {
        return stmt.getFirstChild() instanceof Assignment;
    }

    private static boolean isParserClass(ClassDefinition cd) {
        Name name = cd.firstChildOfType(Name.class);
        return name != null && name.toString().equals("Parser");
    }

    /*
     * WARNING - void declaration
     */
    public void reap() {
        ArrayList<Object> keyList;
        logger.fine("Reaping started");
        if ("true".equals(System.getenv("CONGOCC_PYTHON_REAPER_OFF"))) {
            logger.fine("Reaping disabled via environment variable, aborting");
            return;
        }
        ClassDefinition pc = this.module.firstDescendantOfType(ClassDefinition.class, Reaper::isParserClass);
        if (pc == null) {
            logger.fine("Parser class not found, aborting");
            return;
        }
        Node block = pc.getLastChild();
        assert (block instanceof Block);
        List<Statement> statements = block.childrenOfType(Statement.class);
        List assignments = statements.stream().filter(Reaper::isAssignment).collect(Collectors.toList());
        HashMap<String, Statement> parserSets = new HashMap<String, Statement>();
        for (Statement a : assignments) {
            String name = a.getFirstChild().getFirstChild().toString();
            if (!parserSetPattern.matcher(name).find()) continue;
            logger.fine(String.format("Adding parser set: %s", name));
            parserSets.put(name, a);
        }
        HashMap<String, FunctionDefinition> wantedMethods = new HashMap<String, FunctionDefinition>();
        HashMap<String, FunctionDefinition> otherMethods = new HashMap<String, FunctionDefinition>();
        List<FunctionDefinition> functions = block.childrenOfType(FunctionDefinition.class);
        for (FunctionDefinition f : functions) {
            String string = f.firstChildOfType(Name.class).toString();
            if (!methodPattern.matcher(string).find()) continue;
            if (string.startsWith("parse_")) {
                logger.fine(String.format("Adding wanted method: %s", string));
                wantedMethods.put(string, f);
                continue;
            }
            logger.fine(String.format("Adding other method: %s", string));
            otherMethods.put(string, f);
        }
        logger.fine(String.format("Found %d parser sets and %d methods", parserSets.size(), functions.size()));
        HashMap<String, FunctionDefinition> toInspect = wantedMethods;
        while (!toInspect.isEmpty()) {
            HashMap<String, FunctionDefinition> inspectNext = new HashMap<String, FunctionDefinition>();
            HashSet<String> hashSet = new HashSet<String>();
            keyList = new ArrayList(toInspect.keySet());
            Collections.sort(keyList);
            for (String string : keyList) {
                logger.fine(String.format("Inspecting method %s", string));
                FunctionDefinition method = (FunctionDefinition)toInspect.get(string);
                block = method.getLastChild();
                assert (block instanceof Block);
                for (DotName dn : block.descendantsOfType(DotName.class)) {
                    Node last = dn.getLastChild();
                    hashSet.add(last.toString());
                }
            }
            keyList = new ArrayList(hashSet);
            Collections.sort(keyList);
            for (String string : keyList) {
                if (parserSets.containsKey(string)) {
                    logger.fine(String.format("Found reference to parser set %s", string));
                    parserSets.remove(string);
                    continue;
                }
                if (!otherMethods.containsKey(string)) continue;
                logger.fine(String.format("Found reference to method %s", string));
                inspectNext.put(string, (FunctionDefinition)otherMethods.get(string));
                otherMethods.remove(string);
            }
            wantedMethods.putAll(inspectNext);
            toInspect = inspectNext;
        }
        logger.fine(String.format("Found %d parser sets and %d methods to remove", parserSets.size(), otherMethods.size()));
        keyList = new ArrayList(parserSets.keySet());
        Collections.sort(keyList);
        for (String string : keyList) {
            Statement stmt = (Statement)parserSets.get(string);
            stmt.getParent().remove(stmt);
            logger.fine(String.format("Removed parser set %s", string));
        }
        keyList = new ArrayList(otherMethods.keySet());
        Collections.sort(keyList);
        for (String string : keyList) {
            FunctionDefinition fd = (FunctionDefinition)otherMethods.get(string);
            fd.getParent().remove(fd);
            logger.fine(String.format("Removed method %s", string));
        }
        for (FunctionDefinition functionDefinition : wantedMethods.values()) {
            void var14_27;
            block = functionDefinition.firstChildOfType(Block.class);
            List<Node> stmts = block.children();
            Object var14_26 = null;
            for (Node statement : stmts) {
                if (var14_27 == null) {
                    if (!statement.toString().equals("scan_to_end = False\n")) continue;
                    Node node = statement;
                    continue;
                }
                List<Name> idents = statement.descendantsOfType(Name.class);
                for (Name ident : idents) {
                    if (!ident.toString().equals("scan_to_end")) continue;
                    Object var14_29 = null;
                    break;
                }
                if (var14_27 != null) continue;
                break;
            }
            if (var14_27 == null) continue;
            var14_27.getParent().remove(var14_27);
        }
    }
}

