/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.python;

import java.util.List;
import java.util.regex.Pattern;
import org.congocc.parser.Node;
import org.congocc.parser.python.ast.Block;
import org.congocc.parser.python.ast.ClassDefinition;
import org.congocc.parser.python.ast.DedentToken;
import org.congocc.parser.python.ast.Delimiter;
import org.congocc.parser.python.ast.ExceptBlock;
import org.congocc.parser.python.ast.FinallyBlock;
import org.congocc.parser.python.ast.ForStatement;
import org.congocc.parser.python.ast.FunctionDefinition;
import org.congocc.parser.python.ast.IfStatement;
import org.congocc.parser.python.ast.IndentToken;
import org.congocc.parser.python.ast.Keyword;
import org.congocc.parser.python.ast.Module;
import org.congocc.parser.python.ast.Newline;
import org.congocc.parser.python.ast.SimpleStatement;
import org.congocc.parser.python.ast.Statement;
import org.congocc.parser.python.ast.TryStatement;
import org.congocc.parser.python.ast.WhileStatement;

public class PythonFormatter {
    private final Module module;
    private static final String defaultIndent = "    ";
    private String currentIndent = "";
    private int indentLevel;
    private int lineNumber;
    private StringBuilder buffer;
    private final Pattern newLines = Pattern.compile("\\n{3,10000}");

    public PythonFormatter(Module module) {
        this.module = module;
    }

    protected void outputNode(Node node) {
        List<Node> kids = node.children();
        if (kids.isEmpty()) {
            String s = node.toString();
            if (!s.isEmpty()) {
                this.buffer.append(s);
            }
        } else {
            for (Node kid : kids) {
                String s;
                int n = kid.getBeginLine();
                if (n != this.lineNumber) {
                    assert (n > this.lineNumber);
                    n -= this.lineNumber;
                    while (n > 0) {
                        this.buffer.append('\n');
                        --n;
                        ++this.lineNumber;
                    }
                }
                if (kid instanceof Newline) {
                    this.buffer.append('\n');
                    ++this.lineNumber;
                    continue;
                }
                if (kid instanceof Statement || kid instanceof SimpleStatement) {
                    s = kid.toString();
                    this.buffer.append(this.currentIndent).append(s);
                    this.lineNumber = (int)((long)this.lineNumber + s.chars().filter(ch -> ch == 10).count());
                    continue;
                }
                if (kid instanceof ClassDefinition || kid instanceof FunctionDefinition || kid instanceof IfStatement || kid instanceof WhileStatement || kid instanceof ForStatement || kid instanceof TryStatement) {
                    List<Node> grandKids = kid.children();
                    int so = grandKids.get(0).getBeginOffset();
                    int eo = grandKids.get(grandKids.size() - 2).getEndOffset();
                    s = kid.getTokenSource().getText(so, eo);
                    this.buffer.append(this.currentIndent).append(s);
                    this.lineNumber = (int)((long)this.lineNumber + s.chars().filter(ch -> ch == 10).count());
                    Node block = kid.getLastChild();
                    if (kid instanceof TryStatement ? !$assertionsDisabled && !(block instanceof Block) && !(block instanceof ExceptBlock) && !(block instanceof FinallyBlock) : !$assertionsDisabled && !(block instanceof Block)) {
                        throw new AssertionError();
                    }
                    if (!(block instanceof ExceptBlock)) {
                        this.outputNode(block);
                        continue;
                    }
                    grandKids = block.children();
                    so = grandKids.get(0).getBeginOffset();
                    eo = grandKids.get(grandKids.size() - 2).getEndOffset();
                    s = kid.getTokenSource().getText(so, eo);
                    this.buffer.append(s);
                    this.lineNumber = (int)((long)this.lineNumber + s.chars().filter(ch -> ch == 10).count());
                    this.outputNode(block.getLastChild());
                    continue;
                }
                if (kid instanceof IndentToken) {
                    ++this.indentLevel;
                    this.currentIndent = this.currentIndent + defaultIndent;
                    continue;
                }
                if (kid instanceof DedentToken) {
                    assert (this.indentLevel > 0);
                    --this.indentLevel;
                    this.currentIndent = this.currentIndent.substring(defaultIndent.length());
                    continue;
                }
                if (kid instanceof Keyword || kid instanceof Delimiter) {
                    s = kid.toString();
                    this.buffer.append(s);
                    continue;
                }
                this.outputNode(kid);
            }
        }
    }

    public String format() {
        this.buffer = new StringBuilder();
        this.indentLevel = 0;
        this.lineNumber = 1;
        this.currentIndent = "";
        this.outputNode(this.module);
        String result = this.buffer.toString();
        result = this.newLines.matcher(result).replaceAll("\n\n");
        return result;
    }
}

