/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.java;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Annotation;
import org.congocc.parser.tree.CompilationUnit;
import org.congocc.parser.tree.DotName;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.ImportDeclaration;
import org.congocc.parser.tree.InvocationArguments;
import org.congocc.parser.tree.MethodCall;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.MethodReference;
import org.congocc.parser.tree.Modifiers;
import org.congocc.parser.tree.Name;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.PackageDeclaration;
import org.congocc.parser.tree.TypeDeclaration;
import org.congocc.parser.tree.VariableDeclarator;

class Reaper
extends Node.Visitor {
    private static Logger logger = Logger.getLogger("reaper");
    private final Set<String> usedMethodNames = new HashSet<String>();
    private final Set<String> usedTypeNames = new HashSet<String>();
    private final Set<String> usedVarNames = new HashSet<String>();
    private final Set<String> usedImportDeclarations = new HashSet<String>();
    private final CompilationUnit jcu;
    private boolean onSecondPass;

    Reaper(CompilationUnit jcu) {
        this.jcu = jcu;
    }

    void stripUnused() {
        int prevNameCount;
        int nameCount;
        do {
            prevNameCount = this.usedMethodNames.size() + this.usedTypeNames.size() + this.usedVarNames.size();
            this.visit(this.jcu);
            logger.fine(String.format("used methods: %d", this.usedMethodNames.size()));
            logger.fine(String.format("used types: %d", this.usedTypeNames.size()));
            logger.fine(String.format("used vars: %d", this.usedVarNames.size()));
        } while ((nameCount = this.usedMethodNames.size() + this.usedTypeNames.size() + this.usedVarNames.size()) > prevNameCount);
        for (MethodDeclaration md2 : this.jcu.descendants(MethodDeclaration.class, md -> !this.usedMethodNames.contains(md.getName()))) {
            logger.fine(String.format("removing method: %s", md2.getName()));
            md2.getParent().remove(md2);
        }
        for (FieldDeclaration fd : this.jcu.descendants(FieldDeclaration.class, this::isPrivate)) {
            this.stripUnusedVars(fd);
        }
        for (TypeDeclaration td : this.jcu.descendants(TypeDeclaration.class, this::isPrivate)) {
            if (this.usedTypeNames.contains(td.getName())) continue;
            logger.fine(String.format("removing type: %s", td.getName()));
            td.getParent().remove(td);
        }
        this.usedMethodNames.clear();
        this.usedTypeNames.clear();
        this.usedVarNames.clear();
        this.onSecondPass = true;
        this.visit(this.jcu);
        for (ImportDeclaration imp : this.jcu.childrenOfType(ImportDeclaration.class)) {
            if (!this.usedImportDeclarations.add(this.getKey(imp))) {
                logger.fine(String.format("removing import: %s", imp));
                this.jcu.remove(imp);
                continue;
            }
            if (imp.firstChildOfType(Token.TokenType.STAR) != null) continue;
            List<Identifier> names = imp.descendants(Identifier.class);
            String name = names.get(names.size() - 1).toString();
            if (imp.firstChildOfType(Token.TokenType.STATIC) != null && this.usedMethodNames.contains(name) || this.usedTypeNames.contains(name)) continue;
            logger.fine(String.format("removing import: %s", imp));
            this.jcu.remove(imp);
        }
    }

    private String getKey(ImportDeclaration decl) {
        StringBuilder result = new StringBuilder();
        for (Node node : decl.descendants(Token.class)) {
            result.append(node);
        }
        return result.toString();
    }

    private boolean isPrivate(Node node) {
        if (this.onSecondPass) {
            return false;
        }
        if (node.firstChildOfType(Token.TokenType.PRIVATE) != null) {
            return true;
        }
        Modifiers mods = node.firstChildOfType(Modifiers.class);
        return mods != null && mods.firstChildOfType(Token.TokenType.PRIVATE) != null;
    }

    void visit(MethodDeclaration md) {
        if (!this.isPrivate(md)) {
            this.usedMethodNames.add(md.getName());
        }
        if (this.usedMethodNames.contains(md.getName())) {
            this.recurse(md);
        }
    }

    void visit(ObjectType ot) {
        Identifier firstID = ot.firstChildOfType(Identifier.class);
        this.usedTypeNames.add(firstID.toString());
        this.recurse(ot);
    }

    void visit(Annotation ann) {
        String firstID = ann.firstDescendantOfType(Identifier.class).toString();
        this.usedTypeNames.add(firstID);
        this.recurse(ann);
    }

    void visit(MethodCall mc) {
        String lhs = mc.firstChildOfType(InvocationArguments.class).previousSibling().getImage();
        this.usedMethodNames.add(lhs.substring(lhs.lastIndexOf(46) + 1));
        this.recurse(mc);
    }

    void visit(MethodReference mr) {
        this.usedMethodNames.add(mr.firstChildOfType(Identifier.class).toString());
        this.recurse(mr);
    }

    void visit(Name name) {
        if (name.size() > 1 || !(name.getParent() instanceof MethodCall)) {
            this.usedVarNames.add(name.get(0).toString());
            this.usedTypeNames.add(name.get(0).toString());
        }
    }

    void visit(DotName dotName) {
        this.usedVarNames.add(dotName.getLastChild().toString());
        this.recurse(dotName);
    }

    void visit(VariableDeclarator vd) {
        if (!this.isPrivate(vd.getParent()) || this.usedVarNames.contains(vd.getName())) {
            this.recurse(vd);
        }
    }

    void visit(TypeDeclaration td) {
        if (!this.isPrivate(td) || this.usedTypeNames.contains(td.getName())) {
            this.recurse(td);
        }
    }

    void visit(ImportDeclaration decl) {
    }

    void visit(PackageDeclaration decl) {
    }

    void visit(FieldDeclaration fd) {
        if (this.isUsed(fd)) {
            this.recurse(fd);
        }
    }

    private boolean isUsed(FieldDeclaration fd) {
        if (!this.isPrivate(fd)) {
            return true;
        }
        for (VariableDeclarator vd : fd.childrenOfType(VariableDeclarator.class)) {
            if (!this.usedVarNames.contains(vd.getName())) continue;
            return true;
        }
        return false;
    }

    private void stripUnusedVars(FieldDeclaration fd) {
        HashSet<Node> toBeRemoved = new HashSet<Node>();
        for (VariableDeclarator vd : fd.childrenOfType(VariableDeclarator.class)) {
            if (this.usedVarNames.contains(vd.getName())) continue;
            toBeRemoved.add(vd);
            Node prev = vd.previousSibling();
            Node next = vd.nextSibling();
            if (prev.getType() == Token.TokenType.COMMA) {
                toBeRemoved.add(prev);
                continue;
            }
            if (next.getType() != Token.TokenType.COMMA) continue;
            toBeRemoved.add(next);
        }
        for (Node n : toBeRemoved) {
            logger.fine(String.format("removing field %s from declaration at %s", n.firstChildOfType(Identifier.class), n.getLocation()));
            fd.remove(n);
        }
        if (fd.firstChildOfType(VariableDeclarator.class) == null) {
            logger.fine(String.format("removing field declaration at %s", fd.getLocation()));
            fd.getParent().remove(fd);
        }
    }
}

