/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.congocc.app.AppSettings;
import org.congocc.core.Grammar;
import org.congocc.parser.Node;
import org.congocc.parser.tree.Annotation;
import org.congocc.parser.tree.ClassOrInterfaceBodyDeclaration;
import org.congocc.parser.tree.CodeInjection;
import org.congocc.parser.tree.CompilationUnit;
import org.congocc.parser.tree.ImportDeclaration;
import org.congocc.parser.tree.InterfaceDeclaration;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.Modifiers;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.TypeDeclaration;
import org.congocc.parser.tree.TypeParameters;

public class CodeInjector {
    private final Map<String, TypeDeclaration> types = new HashMap<String, TypeDeclaration>();
    private final Map<String, Set<ImportDeclaration>> injectedImportsMap = new HashMap<String, Set<ImportDeclaration>>();
    private final Map<String, Set<Annotation>> injectedAnnotationsMap = new HashMap<String, Set<Annotation>>();
    private final Map<String, Set<ObjectType>> extendsLists = new HashMap<String, Set<ObjectType>>();
    private final Map<String, Set<ObjectType>> implementsLists = new HashMap<String, Set<ObjectType>>();
    private final Map<String, Set<ObjectType>> permitsLists = new HashMap<String, Set<ObjectType>>();
    private final Map<String, TypeParameters> typeParameterLists = new HashMap<String, TypeParameters>();
    private final Map<String, List<ClassOrInterfaceBodyDeclaration>> bodyDeclarations = new HashMap<String, List<ClassOrInterfaceBodyDeclaration>>();
    private final Set<String> overriddenMethods = new LinkedHashSet<String>();
    private final Set<String> typeNames = new LinkedHashSet<String>();
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Set<String> abstractClasses = new LinkedHashSet<String>();
    private final Set<String> finalClasses = new LinkedHashSet<String>();
    private final Set<String> sealedClasses = new LinkedHashSet<String>();
    private final Set<String> nonsealedClasses = new LinkedHashSet<String>();
    private final Grammar grammar;
    private final AppSettings appSettings;

    public CodeInjector(Grammar grammar, List<Node> codeInjections) {
        this.grammar = grammar;
        this.appSettings = grammar.getAppSettings();
        for (Node n : codeInjections) {
            if (n instanceof CompilationUnit) {
                this.inject((CompilationUnit)n);
                continue;
            }
            if (!(n instanceof CodeInjection)) continue;
            this.inject((CodeInjection)n);
        }
    }

    private boolean isInNodePackage(String classname) {
        return !classname.equals(this.appSettings.getParserClassName()) && !classname.equals(this.appSettings.getLexerClassName()) && !classname.equals("ParseException") && !classname.equals("TokenSource") && !classname.equals("NonTerminalCall") && !classname.equals(this.appSettings.getBaseTokenClassName()) && !classname.equals("InvalidToken") && !classname.equals("Node");
    }

    public boolean isFinal(String classname) {
        return this.finalClasses.contains(classname);
    }

    public boolean isSealed(String classname) {
        return this.sealedClasses.contains(classname);
    }

    public boolean isNonSealed(String classname) {
        return this.nonsealedClasses.contains(classname);
    }

    public Set<ObjectType> getPermitsList(String classname) {
        return this.permitsLists.get(classname);
    }

    private void inject(CompilationUnit jcu) {
        ArrayList<Node> importDecls = new ArrayList<Node>(jcu.getImportDeclarations());
        for (TypeDeclaration dec : jcu.getTypeDeclarations()) {
            String packageName;
            String name = dec.getName();
            this.typeNames.add(name);
            String string = packageName = this.isInNodePackage(name) ? this.appSettings.getNodePackage() : this.appSettings.getParserPackage();
            if (packageName.length() > 0) {
                name = packageName + "." + name;
            }
            this.types.put(name, dec);
            if (dec instanceof InterfaceDeclaration) {
                this.interfaces.add(name);
            }
            if (!importDecls.isEmpty()) {
                Set injectedImports = this.injectedImportsMap.computeIfAbsent(name, k -> new LinkedHashSet());
                injectedImports.addAll(importDecls);
            }
            LinkedHashSet extendsList = dec.getExtendsList() == null ? new LinkedHashSet() : new LinkedHashSet<ObjectType>(dec.getExtendsList().getTypes());
            Set<ObjectType> existingOne = this.extendsLists.get(name);
            if (existingOne == null) {
                this.extendsLists.put(name, extendsList);
            } else {
                existingOne.addAll(extendsList);
            }
            LinkedHashSet implementsList = dec.getImplementsList() == null ? new LinkedHashSet() : new LinkedHashSet<ObjectType>(dec.getImplementsList().getTypes());
            Set<ObjectType> existing = this.implementsLists.get(name);
            if (existing == null) {
                this.implementsLists.put(name, implementsList);
            } else {
                existing.addAll(implementsList);
            }
            TypeParameters typeParameters = dec.getTypeParameters();
            if (typeParameters != null) {
                TypeParameters injectedList = this.typeParameterLists.get(name);
                if (injectedList == null) {
                    this.typeParameterLists.put(name, typeParameters);
                } else {
                    injectedList.add(typeParameters);
                }
            }
            ArrayList<ClassOrInterfaceBodyDeclaration> injectedCode = new ArrayList<ClassOrInterfaceBodyDeclaration>();
            for (Node n : dec.getBody()) {
                if (!(n instanceof ClassOrInterfaceBodyDeclaration)) continue;
                injectedCode.add((ClassOrInterfaceBodyDeclaration)n);
            }
            List<ClassOrInterfaceBodyDeclaration> existingCode = this.bodyDeclarations.get(name);
            if (existingCode == null) {
                this.bodyDeclarations.put(name, injectedCode);
            } else {
                existingCode.addAll(injectedCode);
            }
            for (ClassOrInterfaceBodyDeclaration decl : injectedCode) {
                String key = null;
                if (decl instanceof MethodDeclaration) {
                    key = ((MethodDeclaration)decl).getFullSignature();
                }
                if (key == null) continue;
                this.overriddenMethods.add(key);
            }
        }
    }

    public boolean isDeclaredAbstract(String name) {
        return this.abstractClasses.contains(name);
    }

    public boolean isDeclaredInterface(String name) {
        return this.interfaces.contains(name);
    }

    private void addToDependencies(String name, List<ObjectType> listToAdd, Map<String, Set<ObjectType>> mapOfExistingLists) {
        Set<ObjectType> existingList = mapOfExistingLists.get(name);
        if (existingList == null) {
            mapOfExistingLists.put(name, new LinkedHashSet<ObjectType>(listToAdd));
        } else {
            existingList.addAll(listToAdd);
        }
    }

    void inject(CodeInjection injection) {
        List<ImportDeclaration> importDeclarations;
        String packageName;
        String name = injection.getName();
        Modifiers mods = injection.firstChildOfType(Modifiers.class);
        this.typeNames.add(name);
        if (injection.isMarkedInterface()) {
            assert (!injection.isMarkedFinal());
            this.interfaces.add(name);
        }
        if (injection.isMarkedClass()) {
            this.interfaces.remove(name);
        }
        if (injection.isMarkedAbstract()) {
            assert (!injection.isMarkedFinal());
            this.abstractClasses.add(name);
        }
        if (injection.isMarkedFinal()) {
            this.finalClasses.add(name);
        }
        if (injection.isSealed()) {
            this.sealedClasses.add(name);
        }
        if (injection.isNonSealed()) {
            this.nonsealedClasses.add(name);
        }
        String string = packageName = this.isInNodePackage(name) ? this.appSettings.getNodePackage() : this.appSettings.getParserPackage();
        if (packageName.length() > 0) {
            name = packageName + "." + name;
        }
        if ((importDeclarations = injection.childrenOfType(ImportDeclaration.class)) != null && !importDeclarations.isEmpty()) {
            Set existingImports = this.injectedImportsMap.computeIfAbsent(name, k -> new LinkedHashSet());
            existingImports.addAll(importDeclarations);
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (mods != null) {
            annotations.addAll(mods.childrenOfType(Annotation.class));
        }
        annotations.addAll(injection.childrenOfType(Annotation.class));
        if (!annotations.isEmpty()) {
            Set existingAnnotations = this.injectedAnnotationsMap.computeIfAbsent(name, k -> new LinkedHashSet());
            existingAnnotations.addAll(annotations);
        }
        if (injection.extendsList != null) {
            this.addToDependencies(name, injection.extendsList, this.extendsLists);
        }
        if (injection.implementsList != null) {
            this.addToDependencies(name, injection.implementsList, this.implementsLists);
        }
        if (injection.getPermitsList() != null) {
            this.addToDependencies(name, injection.getPermitsList().childrenOfType(ObjectType.class), this.permitsLists);
        }
        List existingDecls = this.bodyDeclarations.computeIfAbsent(name, k -> new ArrayList());
        if (injection.body != null) {
            existingDecls.addAll(injection.body.childrenOfType(ClassOrInterfaceBodyDeclaration.class));
        }
    }

    public void add(CodeInjection ci) {
        this.inject(ci);
    }

    public void injectCode(CompilationUnit jcu) {
        String packageName = jcu.getPackageName();
        LinkedHashSet<ImportDeclaration> allInjectedImports = new LinkedHashSet<ImportDeclaration>();
        for (TypeDeclaration typeDecl : jcu.getTypeDeclarations()) {
            List<ClassOrInterfaceBodyDeclaration> injectedCode;
            Set<Annotation> annotations;
            TypeParameters typeParameters;
            Set<ObjectType> injectedImplements;
            Set<ObjectType> injectedExtends;
            Set<ImportDeclaration> injectedImports;
            String fullName = typeDecl.getName();
            if (packageName != null) {
                fullName = packageName + "." + fullName;
            }
            if ((injectedImports = this.injectedImportsMap.get(fullName)) != null) {
                allInjectedImports.addAll(injectedImports);
            }
            if ((injectedExtends = this.extendsLists.get(fullName)) != null) {
                for (ObjectType objectType : injectedExtends) {
                    typeDecl.addExtends(objectType);
                }
            }
            if ((injectedImplements = this.implementsLists.get(fullName)) != null) {
                for (ObjectType type2 : injectedImplements) {
                    typeDecl.addImplements(type2);
                }
            }
            if ((typeParameters = this.typeParameterLists.get(fullName)) != null) {
                TypeParameters typeParameters2 = typeDecl.getTypeParameters();
                typeParameters2.add(typeParameters);
            }
            if ((annotations = this.injectedAnnotationsMap.get(fullName)) != null) {
                typeDecl.addAnnotations(annotations);
            }
            if ((injectedCode = this.bodyDeclarations.get(fullName)) == null) continue;
            typeDecl.addElements(injectedCode);
        }
        this.injectImportDeclarations(jcu, allInjectedImports);
    }

    private void injectImportDeclarations(CompilationUnit jcu, Collection<ImportDeclaration> importDecls) {
        List<Node> importDeclarations = jcu.getImportDeclarations();
        for (ImportDeclaration importDecl : importDecls) {
            if (importDeclarations.contains(importDecl)) continue;
            jcu.addImportDeclaration(importDecl);
        }
    }

    public boolean hasInjectedCode(String typename) {
        return this.typeNames.contains(typename);
    }

    public Set<ObjectType> getExtendsList(String qualifiedName) {
        return this.extendsLists.get(qualifiedName);
    }

    public Set<ObjectType> getImplementsList(String qualifiedName) {
        return this.implementsLists.get(qualifiedName);
    }

    public Set<ImportDeclaration> getImportDeclarations(String qualifiedName) {
        return this.injectedImportsMap.get(qualifiedName);
    }

    public Map<String, List<ClassOrInterfaceBodyDeclaration>> getBodyDeclarations() {
        return this.bodyDeclarations;
    }

    public List<ClassOrInterfaceBodyDeclaration> getBodyDeclarations(String qualifiedName) {
        return this.bodyDeclarations.get(qualifiedName);
    }

    public List<String> getParentClasses(String qualifiedName) {
        ArrayList<String> result = new ArrayList<String>();
        Set<ObjectType> extendsList = this.getExtendsList(qualifiedName);
        Set<ObjectType> implementsList = this.getImplementsList(qualifiedName);
        String name = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        if (extendsList.isEmpty() && implementsList.isEmpty()) {
            if (this.grammar.nodeIsInterface(name)) {
                result.add("Node");
            } else {
                result.add(this.appSettings.getBaseNodeClassName());
                result.add("Node");
            }
        } else {
            if (extendsList.isEmpty()) {
                result.add(this.appSettings.getBaseNodeClassName());
            } else {
                for (ObjectType ot : extendsList) {
                    result.add(ot.toString());
                }
            }
            for (ObjectType ot : implementsList) {
                result.add(ot.toString());
            }
        }
        return result;
    }
}

