/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.csharp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.congocc.parser.Node;
import org.congocc.parser.csharp.ast.Block;
import org.congocc.parser.csharp.ast.CSNode;
import org.congocc.parser.csharp.ast.ClassDeclaration;
import org.congocc.parser.csharp.ast.CompilationUnit;
import org.congocc.parser.csharp.ast.FieldDeclaration;
import org.congocc.parser.csharp.ast.Identifier;
import org.congocc.parser.csharp.ast.MethodDeclaration;
import org.congocc.parser.csharp.ast.PropertyDeclaration;
import org.congocc.parser.csharp.ast.VariableDeclarator;

public class Reaper {
    private static final Logger logger = Logger.getLogger("reaper");
    private final CompilationUnit cu;
    private static final Pattern parserSetPattern = Pattern.compile("(first|follow)_set", 2);
    private static final Pattern methodPattern = Pattern.compile("^(Parse|(backscan|scan|check|assert|recover)\u03a3)");

    public Reaper(CompilationUnit cu) {
        this.cu = cu;
    }

    private static boolean isParserClass(ClassDeclaration cd) {
        Identifier ident = cd.firstChildOfType(Identifier.class);
        return ident != null && ident.toString().equals("Parser");
    }

    public void reap() {
        FieldDeclaration fd;
        Object block;
        ArrayList<Object> keyList;
        logger.fine("Reaping started");
        if ("true".equals(System.getenv("CONGOCC_CSHARP_REAPER_OFF"))) {
            logger.fine("Reaping disabled via environment variable, aborting");
            return;
        }
        ClassDeclaration pc = this.cu.firstDescendantOfType(ClassDeclaration.class, Reaper::isParserClass);
        if (pc == null) {
            logger.fine("Parser class not found, aborting");
            return;
        }
        List<FieldDeclaration> fieldDecls = pc.childrenOfType(FieldDeclaration.class);
        List<PropertyDeclaration> propDecls = pc.childrenOfType(PropertyDeclaration.class);
        HashMap<Object, FieldDeclaration> parserSets = new HashMap<Object, FieldDeclaration>();
        HashMap<Object, FieldDeclaration> otherFields = new HashMap<Object, FieldDeclaration>();
        for (FieldDeclaration fd2 : fieldDecls) {
            List<VariableDeclarator> varDecls = fd2.childrenOfType(VariableDeclarator.class);
            HashSet<Object> idents = new HashSet<Object>();
            if (varDecls.size() == 0) {
                Iterator identifiers = fd2.childrenOfType(Identifier.class);
                Object name = ((Identifier)identifiers.get(identifiers.size() - 1)).toString();
                idents.add(name);
            } else {
                for (VariableDeclarator vd : varDecls) {
                    String name = vd.firstChildOfType(Identifier.class).toString();
                    idents.add(name);
                }
            }
            for (Object name : idents) {
                if (parserSetPattern.matcher((CharSequence)name).find()) {
                    logger.fine(String.format("Adding parser set: %s", name));
                    parserSets.put(name, fd2);
                    continue;
                }
                logger.fine(String.format("Adding other field: %s", name));
                otherFields.put(name, fd2);
            }
        }
        List<MethodDeclaration> methods = pc.childrenOfType(MethodDeclaration.class);
        HashMap<String, MethodDeclaration> wantedMethods = new HashMap<String, MethodDeclaration>();
        HashMap<String, MethodDeclaration> otherMethods = new HashMap<String, MethodDeclaration>();
        HashMap<String, MethodDeclaration> internalMethods = new HashMap<String, MethodDeclaration>();
        for (MethodDeclaration m : methods) {
            List<Identifier> idents = m.childrenOfType(Identifier.class);
            String string = idents.get(idents.size() - 1).toString();
            if (!methodPattern.matcher(string).find()) {
                internalMethods.put(string, m);
                continue;
            }
            if (string.startsWith("Parse")) {
                logger.fine(String.format("Adding wanted method: %s", string));
                wantedMethods.put(string, m);
                continue;
            }
            logger.fine(String.format("Adding other method: %s", string));
            otherMethods.put(string, m);
        }
        logger.fine(String.format("Found %d parser sets and %d methods", parserSets.size(), methods.size()));
        HashMap<String, MethodDeclaration> toInspect = wantedMethods;
        HashSet allNames = new HashSet();
        while (!toInspect.isEmpty()) {
            HashMap<String, MethodDeclaration> inspectNext = new HashMap<String, MethodDeclaration>();
            HashSet<String> hashSet = new HashSet<String>();
            keyList = new ArrayList(toInspect.keySet());
            Collections.sort(keyList);
            for (String string : keyList) {
                logger.fine(String.format("Inspecting method %s", string));
                MethodDeclaration method = (MethodDeclaration)toInspect.get(string);
                Block block2 = method.firstChildOfType(Block.class);
                for (Identifier ident : block2.descendantsOfType(Identifier.class)) {
                    hashSet.add(ident.toString());
                }
            }
            allNames.addAll(hashSet);
            keyList = new ArrayList(hashSet);
            Collections.sort(keyList);
            for (String string : keyList) {
                if (parserSets.containsKey(string)) {
                    logger.fine(String.format("Found reference to parser set %s", string));
                    parserSets.remove(string);
                    continue;
                }
                if (!otherMethods.containsKey(string)) continue;
                logger.fine(String.format("Found reference to method %s", string));
                inspectNext.put(string, (MethodDeclaration)otherMethods.get(string));
                otherMethods.remove(string);
            }
            wantedMethods.putAll(inspectNext);
            toInspect = inspectNext;
        }
        for (MethodDeclaration methodDeclaration : internalMethods.values()) {
            block = methodDeclaration.firstChildOfType(Block.class);
            for (Identifier ident : block.descendantsOfType(Identifier.class)) {
                allNames.add(ident.toString());
            }
        }
        for (PropertyDeclaration propertyDeclaration : propDecls) {
            for (Identifier identifier : propertyDeclaration.descendantsOfType(Identifier.class)) {
                allNames.add(identifier.toString());
            }
        }
        for (String string : otherFields.keySet()) {
            if (allNames.contains(string)) continue;
            fd = (FieldDeclaration)otherFields.get(string);
            fd.getParent().remove(fd);
            logger.fine(String.format("Removed unused field %s", string));
        }
        logger.fine(String.format("Found %d parser sets and %d methods to remove", parserSets.size(), otherMethods.size()));
        keyList = new ArrayList(parserSets.keySet());
        Collections.sort(keyList);
        for (String string : keyList) {
            fd = (FieldDeclaration)parserSets.get(string);
            fd.getParent().remove(fd);
            logger.fine(String.format("Removed parser set %s", string));
        }
        keyList = new ArrayList(otherMethods.keySet());
        Collections.sort(keyList);
        for (String string : keyList) {
            MethodDeclaration meth = (MethodDeclaration)otherMethods.get(string);
            meth.getParent().remove(meth);
            logger.fine(String.format("Removed method %s", string));
        }
        for (MethodDeclaration methodDeclaration : wantedMethods.values()) {
            block = methodDeclaration.firstChildOfType(Block.class);
            List<Node> list = ((CSNode)block).children();
            Node found = null;
            for (Node statement : list) {
                if (found == null) {
                    if (!statement.toString().equals("var scanToEnd = false;")) continue;
                    found = statement;
                    continue;
                }
                List<Identifier> idents = statement.descendantsOfType(Identifier.class);
                for (Identifier ident : idents) {
                    if (!ident.toString().equals("scanToEnd")) continue;
                    found = null;
                    break;
                }
                if (found != null) continue;
                break;
            }
            if (found == null) continue;
            found.getParent().remove(found);
        }
    }
}

