/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.csharp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.congocc.codegen.Translator;
import org.congocc.codegen.java.CodeInjector;
import org.congocc.core.Grammar;
import org.congocc.parser.tree.ClassOrInterfaceBodyDeclaration;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.FormalParameter;
import org.congocc.parser.tree.MethodDeclaration;

public class CSharpTranslator
extends Translator {
    private static final Set<String> specialPrefixes = new HashSet<String>();
    private static final Set<String> propertyIdentifiers = CSharpTranslator.makeSet("image", "lastConsumedToken");
    private static final Set<String> propertyNames = CSharpTranslator.makeSet("getImage", "getType", "getBeginLine", "getBeginColumn", "getEndLine", "getEndColumn", "getBeginOffset", "getEndOffset", "getLocation", "getTokenSource", "getPreviousToken");
    protected static final HashSet<String> accessModifiers = new LinkedHashSet<String>(Arrays.asList("public", "protected", "private"));

    public CSharpTranslator(Grammar grammar) {
        super(grammar);
        this.methodIndent = 8;
        this.fieldIndent = 8;
        this.isTyped = true;
    }

    public String translateOperator(String operator) {
        return operator;
    }

    private static boolean isSpecialPrefix(String ident) {
        boolean result = false;
        for (String p : specialPrefixes) {
            if (!ident.startsWith(p)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String translateIdentifier(String ident, Translator.TranslationContext kind) {
        if (kind == Translator.TranslationContext.TYPE) {
            return this.translateTypeName(ident);
        }
        String result = ident;
        if (specialPrefixes.isEmpty()) {
            specialPrefixes.add(this.grammar.getAppSettings().generateIdentifierPrefix("tokenHook"));
        }
        if (ident.equals("toString")) {
            result = "ToString";
        } else if (ident.equals("addAll")) {
            result = "AddRange";
        } else if (ident.equals("preInsert")) {
            result = "PreInsert";
        } else if (ident.equals("size")) {
            result = "Count";
        } else if (ident.equals("String")) {
            result = "string";
        } else if (ident.equals("isUnparsed")) {
            result = "IsUnparsed";
        } else if (ident.equals("token_source")) {
            result = "tokenSource";
        } else if (ident.equals("LEXER_CLASS") || ident.equals(this.appSettings.getLexerClassName())) {
            result = "Lexer";
        } else if (ident.equals("PARSER_CLASS") || ident.equals(this.appSettings.getParserClassName())) {
            result = "Parser";
        } else if (ident.equals("THIS_PRODUCTION")) {
            result = "thisProduction";
        } else if (ident.equals("BASE_TOKEN_CLASS") || ident.equals(this.appSettings.getBaseTokenClassName())) {
            result = "Token";
        } else if (ident.startsWith("NODE_PACKAGE.")) {
            result = ident.substring(13);
        } else if (ident.startsWith(this.appSettings.getNodePackage().concat("."))) {
            int prefixLength = this.appSettings.getNodePackage().length() + 1;
            result = ident.substring(prefixLength);
        } else if ((kind != Translator.TranslationContext.VARIABLE || propertyIdentifiers.contains(ident)) && kind != Translator.TranslationContext.PARAMETER && Character.isLowerCase(ident.charAt(0)) && !CSharpTranslator.isSpecialPrefix(ident)) {
            result = Character.toUpperCase(ident.charAt(0)) + ident.substring(1);
        }
        return result;
    }

    public String translateGetter(String getterName) {
        if (getterName.startsWith("is")) {
            return this.translateIdentifier(getterName, Translator.TranslationContext.METHOD);
        }
        String result = Character.toLowerCase(getterName.charAt(3)) + getterName.substring(4);
        return this.translateIdentifier(result, Translator.TranslationContext.METHOD);
    }

    @Override
    protected void translatePrimaryExpression(Translator.ASTPrimaryExpression expr, Translator.TranslationContext ctx, StringBuilder result) {
        String s = expr.getLiteral();
        String n = expr.getName();
        boolean isName = false;
        if (s == null) {
            s = this.translateIdentifier(n, Translator.TranslationContext.VARIABLE);
            isName = true;
        }
        if (isName && this.fields.containsKey(n) && this.properties.containsKey(n)) {
            result.append('_');
        }
        if (ctx == Translator.TranslationContext.PARAMETER && expr instanceof Translator.ASTTypeExpression) {
            result.append("typeof(");
            result.append(s);
            result.append(')');
        } else {
            result.append(s);
        }
    }

    @Override
    protected void translateUnaryExpression(Translator.ASTUnaryExpression expr, Translator.TranslationContext ctx, StringBuilder result) {
        String xop = this.translateOperator(expr.getOp());
        boolean parens = this.needsParentheses(expr);
        if (xop.equals("++") || xop.equals("--")) {
            this.internalTranslateExpression(expr.getOperand(), ctx, result);
            result.append(' ');
            result.append(xop.charAt(0));
            result.append("= 1");
        } else {
            if (parens) {
                result.append('(');
            }
            result.append(xop);
            this.internalTranslateExpression(expr.getOperand(), ctx, result);
            if (parens) {
                result.append(')');
            }
        }
    }

    @Override
    protected void translateBinaryExpression(Translator.ASTBinaryExpression expr, StringBuilder result) {
        String xop = this.translateOperator(expr.getOp());
        boolean parens = this.needsParentheses(expr);
        Translator.ASTExpression lhs = expr.getLhs();
        Translator.ASTExpression rhs = expr.getRhs();
        this.processBinaryExpression(parens, lhs, xop, rhs, result);
    }

    @Override
    protected void translateInstanceofExpression(Translator.ASTInstanceofExpression expr, StringBuilder result) {
        boolean parens;
        boolean bl = parens = expr.getParent() != null;
        if (parens) {
            result.append('(');
        }
        this.internalTranslateExpression(expr.getInstance(), Translator.TranslationContext.UNKNOWN, result);
        result.append(" is ");
        this.internalTranslateExpression(expr.getTypeExpression(), Translator.TranslationContext.UNKNOWN, result);
        if (parens) {
            result.append(')');
        }
    }

    @Override
    protected void translateTernaryExpression(Translator.ASTTernaryExpression expr, StringBuilder result) {
        boolean parens = this.needsParentheses(expr);
        Translator.ASTExpression condition = expr.getCondition();
        Translator.ASTExpression trueValue = expr.getTrueValue();
        Translator.ASTExpression falseValue = expr.getFalseValue();
        if (parens) {
            result.append('(');
        }
        this.internalTranslateExpression(condition, Translator.TranslationContext.UNKNOWN, result);
        result.append(" ? ");
        this.internalTranslateExpression(trueValue, Translator.TranslationContext.UNKNOWN, result);
        result.append(" : ");
        this.internalTranslateExpression(falseValue, Translator.TranslationContext.UNKNOWN, result);
        if (parens) {
            result.append(')');
        }
    }

    boolean renderReceiver(Translator.ASTExpression expr, StringBuilder result) {
        boolean rendered;
        if (expr instanceof Translator.ASTBinaryExpression) {
            this.internalTranslateExpression(((Translator.ASTBinaryExpression)expr).getLhs(), Translator.TranslationContext.UNKNOWN, result);
            rendered = true;
        } else if (expr instanceof Translator.ASTPrimaryExpression) {
            rendered = false;
        } else {
            String s = String.format("Cannot render receiver %s", CSharpTranslator.getSimpleName(expr));
            throw new UnsupportedOperationException(s);
        }
        return rendered;
    }

    protected void translateArguments(List<Translator.ASTExpression> arguments, StringBuilder result) {
        int nargs;
        if (arguments == null || (nargs = arguments.size()) == 0) {
            result.append("()");
        } else {
            result.append('(');
            for (int i = 0; i < nargs; ++i) {
                this.internalTranslateExpression(arguments.get(i), Translator.TranslationContext.PARAMETER, result);
                if (i >= nargs - 1) continue;
                result.append(", ");
            }
            result.append(')');
        }
    }

    @Override
    protected void translateInvocation(Translator.ASTInvocation expr, StringBuilder result) {
        String methodName = expr.getMethodName();
        int nargs = expr.getArgCount();
        Translator.ASTExpression receiver = expr.getReceiver();
        boolean treatAsProperty = propertyNames.contains(methodName);
        Translator.ASTExpression firstArg = nargs != 1 ? null : expr.getArguments().get(0);
        boolean needsGeneric = methodName.equals("firstChildOfType") || methodName.equals("childrenOfType") || methodName.equals("descendantsOfType") || methodName.equals("descendants");
        boolean bl = needsGeneric = needsGeneric && firstArg instanceof Translator.ASTPrimaryExpression;
        if (methodName.equals("size") && nargs == 0) {
            if (this.renderReceiver(receiver, result)) {
                result.append('.');
            }
            result.append("Count");
        } else if (methodName.equals("length") && nargs == 0) {
            if (this.renderReceiver(receiver, result)) {
                result.append('.');
            }
            result.append("Length");
        } else if (methodName.equals("children") && nargs == 0) {
            if (this.renderReceiver(receiver, result)) {
                result.append('.');
            }
            result.append("Children");
        } else if ((methodName.equals("charAt") || methodName.equals("codePointAt")) && nargs == 1) {
            this.renderReceiver(receiver, result);
            result.append('[');
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
            result.append(']');
        } else if (methodName.equals("isParserTolerant") && nargs == 0) {
            int n = result.length();
            this.renderReceiver(receiver, result);
            if (n < result.length()) {
                result.append('.');
            }
            result.append("IsTolerant");
        } else if (methodName.equals("previousCachedToken") && nargs == 0) {
            int n = result.length();
            this.renderReceiver(receiver, result);
            if (n < result.length()) {
                result.append('.');
            }
            result.append("PreviousCachedToken");
        } else if (methodName.equals("get") && nargs == 1 && !(receiver instanceof Translator.ASTPrimaryExpression)) {
            this.renderReceiver(receiver, result);
            result.append('[');
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
            result.append(']');
        } else if (treatAsProperty && this.isGetter(methodName) && nargs == 0) {
            int n = result.length();
            this.renderReceiver(receiver, result);
            if (n < result.length()) {
                result.append('.');
            }
            result.append(this.translateGetter(methodName));
        } else if (methodName.equals("nodeArity") && nargs == 0) {
            this.renderReceiver(receiver, result);
            result.append(".NodeArity");
        } else if (methodName.equals("isUnparsed") && nargs == 0) {
            this.renderReceiver(receiver, result);
            result.append(".IsUnparsed");
        } else if (methodName.equals("getSimpleName") && nargs == 0 && this.belongsToClass(expr)) {
            this.renderReceiver(receiver, result);
            result.append(".Name");
        } else if (methodName.equals("setUnparsed") && nargs == 1) {
            this.renderReceiver(receiver, result);
            result.append(".IsUnparsed = ");
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
        } else if (methodName.equals("of") && this.isEnumSet(receiver)) {
            result.append("Utils.EnumSet(");
            if (nargs > 0) {
                this.translateArguments(expr.getArguments(), false, result);
            }
            result.append(")");
        } else if (this.isSetter(methodName) && nargs == 1) {
            String s = this.translateIdentifier(methodName, Translator.TranslationContext.METHOD);
            this.renderReceiver(receiver, result);
            result.append('.');
            result.append(s.substring(3));
            result.append(" = ");
            this.internalTranslateExpression(firstArg, Translator.TranslationContext.UNKNOWN, result);
        } else if (expr instanceof Translator.ASTAllocation) {
            if (this.isList(receiver)) {
                result.append("new ListAdapter<");
                List<Translator.ASTTypeExpression> tps = ((Translator.ASTTypeExpression)receiver).getTypeParameters();
                if (tps != null) {
                    this.translateType(tps.get(0), result);
                }
                result.append(">");
            } else if (this.isSet(receiver)) {
                result.append("new HashSet<");
                List<Translator.ASTTypeExpression> tps = ((Translator.ASTTypeExpression)receiver).getTypeParameters();
                if (tps != null) {
                    this.translateType(tps.get(0), result);
                }
                result.append(">");
            } else if (this.isMap(receiver)) {
                result.append("new MapAdapter<");
                List<Translator.ASTTypeExpression> tps = ((Translator.ASTTypeExpression)receiver).getTypeParameters();
                if (tps != null) {
                    this.translateType(tps.get(0), result);
                    result.append(", ");
                    this.translateType(tps.get(1), result);
                }
                result.append(">");
            } else {
                result.append("new ");
                this.internalTranslateExpression(receiver, Translator.TranslationContext.UNKNOWN, result);
            }
            this.translateArguments(expr.getArguments(), result);
        } else {
            String ident;
            if (!methodName.equals("newToken")) {
                int n = result.length();
                this.renderReceiver(receiver, result);
                if (n < result.length()) {
                    result.append('.');
                }
            } else {
                result.append("Token.");
            }
            if (methodName.equals("getClass")) {
                methodName = "GetType";
            }
            if ((ident = this.translateIdentifier(methodName, Translator.TranslationContext.METHOD)).equals("DirectiveLine")) {
                ident = "Parse" + ident;
            }
            result.append(ident);
            if (needsGeneric) {
                result.append('<');
                result.append(((Translator.ASTPrimaryExpression)firstArg).getName());
                result.append('>');
            }
            this.translateArguments(expr.getArguments(), result);
        }
    }

    @Override
    public String translateTypeName(String name) {
        String result = name;
        switch (name) {
            case "List": 
            case "java.util.List": {
                result = "ListAdapter";
                break;
            }
            case "Map": 
            case "java.util.Map": 
            case "java.util.HashMap": {
                result = "MapAdapter";
                break;
            }
            case "Set": 
            case "HashSet": 
            case "EnumSet": {
                result = "HashSet";
                break;
            }
            case "Iterator": 
            case "java.util.Iterator": {
                result = "Iterator";
                break;
            }
            case "boolean": {
                result = "bool";
                break;
            }
            case "Integer": {
                result = "int";
                break;
            }
            case "BASE_TOKEN_CLASS": {
                result = "Token";
                break;
            }
            case "LEXER_CLASS": {
                result = "Lexer";
                break;
            }
            case "PARSER_CLASS": {
                result = "Parser";
                break;
            }
            default: {
                if (name.equals(this.appSettings.getLexerClassName())) {
                    result = "Lexer";
                    break;
                }
                if (name.equals(this.appSettings.getParserClassName())) {
                    result = "Parser";
                    break;
                }
                if (name.equals(this.appSettings.getBaseTokenClassName())) {
                    result = "Token";
                    break;
                }
                if (!name.startsWith(this.appSettings.getNodePackage().concat("."))) break;
                int prefixLength = this.appSettings.getNodePackage().length() + 1;
                result = name.substring(prefixLength);
            }
        }
        return result;
    }

    @Override
    protected void translateType(Translator.ASTTypeExpression expr, StringBuilder result) {
        String s = expr.getName();
        if (s == null) {
            s = expr.getLiteral();
        }
        String tn = this.translateTypeName(s);
        result.append(tn);
        List<Translator.ASTTypeExpression> tp = expr.getTypeParameters();
        if (tp != null) {
            result.append('<');
            int n = tp.size();
            for (int i = 0; i < n; ++i) {
                this.translateType(tp.get(i), result);
                if (i >= n - 1) continue;
                result.append(", ");
            }
            result.append('>');
        }
    }

    protected void translateModifiers(List<String> modifiers, StringBuilder result) {
        LinkedHashSet<String> mods = new LinkedHashSet<String>(modifiers);
        ArrayList<String> translated_mods = new ArrayList<String>();
        boolean accessModifierAdded = false;
        mods.remove("default");
        mods.remove("final");
        for (String s : accessModifiers) {
            if (!mods.contains(s)) continue;
            mods.remove(s);
            translated_mods.add(s);
            accessModifierAdded = true;
        }
        if (!accessModifierAdded && !this.inInterface) {
            translated_mods.add("internal");
        }
        if (mods.contains("static")) {
            translated_mods.add("static");
            mods.remove("static");
        }
        if (mods.size() > 0) {
            String s = String.format("Unable to translate modifier %s", String.join((CharSequence)", ", mods));
            throw new UnsupportedOperationException(s);
        }
        for (String mod : translated_mods) {
            result.append(mod);
            result.append(' ');
        }
    }

    protected boolean isNullable(Translator.ASTTypeExpression expr) {
        return false;
    }

    protected void closeBrace(int indent, StringBuilder result) {
        this.addIndent(indent, result);
        result.append("}\n");
    }

    @Override
    protected void internalTranslateStatement(Translator.ASTStatement stmt, int indent, StringBuilder result) {
        boolean addNewline = false;
        if (!(stmt instanceof Translator.ASTStatementList)) {
            this.addIndent(indent, result);
        }
        if (stmt instanceof Translator.ASTExpressionStatement) {
            if (stmt instanceof Translator.ASTThrowStatement) {
                result.append("throw ");
            }
            this.internalTranslateExpression(((Translator.ASTExpressionStatement)stmt).getValue(), Translator.TranslationContext.UNKNOWN, result);
            result.append(';');
            addNewline = true;
        } else if (stmt instanceof Translator.ASTStatementList) {
            boolean isInitializer = ((Translator.ASTStatementList)stmt).isInitializer();
            List<Translator.ASTStatement> statements = ((Translator.ASTStatementList)stmt).getStatements();
            if (isInitializer) {
                this.addIndent(indent, result);
                result.append("{\n");
                indent += 4;
            }
            if (statements != null) {
                for (Translator.ASTStatement s : statements) {
                    this.internalTranslateStatement(s, indent, result);
                }
            }
            if (isInitializer) {
                this.closeBrace(indent -= 4, result);
            }
        } else if (stmt instanceof Translator.ASTVariableOrFieldDeclaration) {
            Translator.ASTVariableOrFieldDeclaration vd = (Translator.ASTVariableOrFieldDeclaration)stmt;
            List<Translator.ASTPrimaryExpression> names = vd.getNames();
            List<Translator.ASTExpression> initializers = vd.getInitializers();
            Translator.ASTTypeExpression type = vd.getTypeExpression();
            int n = names.size();
            boolean isProperty = vd.hasAnnotation("Property");
            boolean isField = vd.isField();
            List<String> modifiers = vd.getModifiers();
            if (modifiers == null) {
                if (isField) {
                    result.append("internal ");
                }
            } else {
                this.translateModifiers(modifiers, result);
            }
            this.translateType(type, result);
            if (this.isNullable(type)) {
                result.append('?');
            }
            result.append(' ');
            for (int i = 0; i < n; ++i) {
                Translator.ASTPrimaryExpression name = names.get(i);
                Translator.ASTExpression initializer = initializers.get(i);
                this.processVariableDeclaration(type, name, isField, isProperty);
                Translator.TranslationContext ctx = isField ? Translator.TranslationContext.FIELD : Translator.TranslationContext.VARIABLE;
                this.internalTranslateExpression(name, ctx, result);
                if (initializer != null) {
                    result.append(" = ");
                    this.internalTranslateExpression(initializer, Translator.TranslationContext.UNKNOWN, result);
                }
                if (i < n - 1) {
                    result.append(", ");
                }
                addNewline = true;
            }
            result.append(';');
        } else if (stmt instanceof Translator.ASTReturnStatement) {
            result.append("return");
            Translator.ASTExpression value = ((Translator.ASTReturnStatement)stmt).getValue();
            if (value != null) {
                result.append(' ');
                this.internalTranslateExpression(value, Translator.TranslationContext.UNKNOWN, result);
            }
            result.append(';');
            addNewline = true;
        } else if (stmt instanceof Translator.ASTIfStatement) {
            Translator.ASTIfStatement s = (Translator.ASTIfStatement)stmt;
            result.append("if (");
            this.internalTranslateExpression(s.getCondition(), Translator.TranslationContext.UNKNOWN, result);
            result.append(") {\n");
            this.internalTranslateStatement(s.getThenStmts(), indent + 4, result);
            if (s.getElseStmts() != null) {
                this.closeBrace(indent, result);
                this.addIndent(indent, result);
                result.append("else {\n");
                this.internalTranslateStatement(s.getElseStmts(), indent + 4, result);
            }
            this.closeBrace(indent, result);
        } else if (stmt instanceof Translator.ASTWhileStatement) {
            Translator.ASTWhileStatement s = (Translator.ASTWhileStatement)stmt;
            result.append("while (");
            this.internalTranslateExpression(s.getCondition(), Translator.TranslationContext.UNKNOWN, result);
            result.append(") {\n");
            this.internalTranslateStatement(s.getStatements(), indent + 4, result);
            this.closeBrace(indent, result);
        } else if (stmt instanceof Translator.ASTForStatement) {
            Translator.ASTForStatement s = (Translator.ASTForStatement)stmt;
            Translator.ASTVariableOrFieldDeclaration decl = s.getVariable();
            Translator.ASTExpression iterable = s.getIterable();
            if (iterable != null) {
                Translator.ASTVariableOrFieldDeclaration vd = s.getVariable();
                result.append("foreach (var ");
                this.internalTranslateExpression(vd.getNames().get(0), Translator.TranslationContext.UNKNOWN, result);
                result.append(" in ");
                this.internalTranslateExpression(iterable, Translator.TranslationContext.UNKNOWN, result);
                result.append(") {\n");
                this.internalTranslateStatement(s.getStatements(), indent + 4, result);
            } else {
                List<Translator.ASTPrimaryExpression> names = decl.getNames();
                List<Translator.ASTExpression> initializers = decl.getInitializers();
                int n = names.size();
                for (int i = 0; i < n; ++i) {
                    Translator.ASTExpression name = names.get(i);
                    Translator.ASTExpression initializer = initializers.get(i);
                    if (initializer == null) {
                        String msg = String.format("Unexpected null initializer for %s", CSharpTranslator.getSimpleName(name));
                        throw new UnsupportedOperationException(msg);
                    }
                    this.translateType(decl.getTypeExpression(), result);
                    result.append(' ');
                    this.internalTranslateExpression(name, Translator.TranslationContext.UNKNOWN, result);
                    result.append(" = ");
                    this.internalTranslateExpression(initializer, Translator.TranslationContext.UNKNOWN, result);
                    if (i >= n - 1) continue;
                    result.append("; ");
                }
                result.append(";\n");
                this.addIndent(indent, result);
                result.append("while (");
                this.internalTranslateExpression(s.getCondition(), Translator.TranslationContext.UNKNOWN, result);
                result.append(") {\n");
                this.internalTranslateStatement(s.getStatements(), indent + 4, result);
                List<Translator.ASTExpression> iteration = s.getIteration();
                if (iteration != null) {
                    this.processForIteration(iteration, indent + 4, result);
                    result.append(";\n");
                }
            }
            this.closeBrace(indent, result);
        } else if (stmt instanceof Translator.ASTSwitchStatement) {
            Translator.ASTSwitchStatement s = (Translator.ASTSwitchStatement)stmt;
            String tv = this.getTempVarName();
            Translator.ASTExpression expr = s.getVariable();
            boolean isTT = this.isTokenType(expr);
            result.append("var ");
            result.append(tv);
            result.append(" = ");
            this.internalTranslateExpression(expr, Translator.TranslationContext.UNKNOWN, result);
            result.append(";\n");
            this.addIndent(indent, result);
            result.append("switch (");
            result.append(tv);
            result.append(") {\n");
            for (Translator.ASTCaseStatement c : s.getCases()) {
                List<Translator.ASTExpression> labels = c.getCaseLabels();
                int lc = labels.size();
                if (lc == 0) {
                    this.addIndent(indent, result);
                    result.append("default:\n");
                } else {
                    for (Translator.ASTExpression label : labels) {
                        this.addIndent(indent, result);
                        result.append("case ");
                        if (isTT) {
                            result.append("TokenType.");
                        }
                        this.internalTranslateExpression(label, Translator.TranslationContext.UNKNOWN, result);
                        result.append(":\n");
                    }
                }
                this.internalTranslateStatement(c.getStatements(), indent + 4, result);
                if (this.hasUnconditionalExit(c.getStatements())) continue;
                this.addIndent(indent + 4, result);
                result.append("break;\n");
            }
            this.closeBrace(indent, result);
        } else if (stmt instanceof Translator.ASTMethodDeclaration) {
            Translator.ASTMethodDeclaration decl = (Translator.ASTMethodDeclaration)stmt;
            String methodName = this.translateIdentifier(decl.getName(), Translator.TranslationContext.METHOD);
            List<Translator.ASTFormalParameter> formals = decl.getParameters();
            Translator.SymbolTable symbols = new Translator.SymbolTable();
            List<String> modifiers = decl.getModifiers();
            boolean isOverride = methodName.equals("Equals") || methodName.equals("ToString");
            this.pushSymbols(symbols);
            if (modifiers == null) {
                result.append("internal ");
            } else {
                if (methodName.equals("GetIndents") || methodName.equals("IsVirtual")) {
                    if ("Token".equals(this.currentClass)) {
                        result.append("virtual ");
                    } else {
                        result.append("override ");
                    }
                }
                if (methodName.equals("IsAssignableTo")) {
                    if ("UnaryExpression".equals(this.currentClass) || "ElementAccess".equals(this.currentClass) || "SimpleName".equals(this.currentClass) || "BaseAccess".equals(this.currentClass) || "This".equals(this.currentClass) || "Tuple".equals(this.currentClass) || "ParenthesizedExpression".equals(this.currentClass) || "InvocationExpression".equals(this.currentClass) || "LiteralExpression".equals(this.currentClass) || "MemberAccess".equals(this.currentClass) || "PointerMemberAccess".equals(this.currentClass)) {
                        result.append("virtual ");
                    } else if ("Parentheses".equals(this.currentClass) || "Name".equals(this.currentClass) || "DotName".equals(this.currentClass) || "ArrayAccess".equals(this.currentClass)) {
                        result.append("virtual ");
                    } else if (!"Expression".equals(this.currentClass)) {
                        result.append("override ");
                    }
                }
                this.translateModifiers(modifiers, result);
            }
            if (isOverride) {
                result.append("override ");
            }
            if (!((Translator.ASTMethodDeclaration)stmt).isConstructor()) {
                this.translateType(((Translator.ASTMethodDeclaration)stmt).getReturnType(), result);
                result.append(' ');
            }
            result.append(methodName);
            result.append('(');
            if (formals != null) {
                this.translateFormals(formals, symbols, true, true, result);
            }
            result.append(") {\n");
            this.internalTranslateStatement(decl.getStatements(), indent + 4, result);
            this.addIndent(indent, result);
            result.append("}\n\n");
            this.popSymbols();
        } else if (stmt instanceof Translator.ASTAssertStatement) {
            Translator.ASTAssertStatement s = (Translator.ASTAssertStatement)stmt;
            result.append("Debug.Assert(");
            this.internalTranslateExpression(s.getCondition(), Translator.TranslationContext.UNKNOWN, result);
            result.append(", ");
            Translator.ASTExpression m = s.getMessage();
            if (m == null) {
                result.append("\"Assertion failed\"");
            } else {
                this.internalTranslateExpression(m, Translator.TranslationContext.UNKNOWN, result);
                if (!(m instanceof Translator.ASTPrimaryExpression) || ((Translator.ASTPrimaryExpression)m).getLiteral() == null) {
                    result.append(".ToString()");
                }
                result.append(");\n");
            }
        } else if (stmt instanceof Translator.ASTTryStatement) {
            Translator.ASTStatement fb;
            Translator.ASTTryStatement tryStmt = (Translator.ASTTryStatement)stmt;
            result.append("try {\n");
            this.internalTranslateStatement(tryStmt.getBlock(), indent + 4, result);
            this.closeBrace(indent, result);
            List<Translator.ASTExceptionInfo> catchBlocks = tryStmt.getCatchBlocks();
            if (catchBlocks != null) {
                for (Translator.ASTExceptionInfo cb : catchBlocks) {
                    Translator.ASTTypeExpression te;
                    boolean multiple;
                    this.addIndent(indent, result);
                    result.append("catch (");
                    List<Translator.ASTTypeExpression> infos = cb.getExceptionTypes();
                    int n = infos.size();
                    boolean bl = multiple = n > 1;
                    if (multiple) {
                        result.append("Exception ");
                    } else {
                        te = infos.get(0);
                        this.internalTranslateExpression(te, Translator.TranslationContext.TYPE, result);
                    }
                    String excVar = cb.getVariable();
                    result.append(' ').append(excVar).append(')');
                    if (multiple) {
                        result.append(" when (");
                        for (int i = 0; i < n; ++i) {
                            te = infos.get(i);
                            result.append(excVar).append(" is ");
                            this.internalTranslateExpression(te, Translator.TranslationContext.TYPE, result);
                            if (i >= n - 1) continue;
                            result.append(" || ");
                        }
                        result.append(')');
                    }
                    result.append(" {\n");
                    this.internalTranslateStatement(cb.getBlock(), indent + 4, result);
                    this.closeBrace(indent, result);
                }
            }
            if ((fb = tryStmt.getFinallyBlock()) != null) {
                this.addIndent(indent, result);
                result.append("finally {\n");
                this.internalTranslateStatement(fb, indent + 4, result);
                this.closeBrace(indent, result);
            }
        } else if (stmt instanceof Translator.ASTEnumDeclaration) {
            Translator.ASTEnumDeclaration enumDecl = (Translator.ASTEnumDeclaration)stmt;
            result.append("public enum ");
            result.append(enumDecl.getName());
            result.append(" {\n");
            List<String> values = enumDecl.getValues();
            if (values != null) {
                int n = values.size();
                for (int i = 0; i < n; ++i) {
                    this.addIndent(indent + 4, result);
                    result.append(values.get(i));
                    if (i < n - 1) {
                        result.append(',');
                    }
                    result.append('\n');
                }
                this.closeBrace(indent, result);
            }
        } else if (stmt instanceof Translator.ASTClassDeclaration) {
            Translator.ASTClassDeclaration classDecl = (Translator.ASTClassDeclaration)stmt;
            List<Translator.ASTStatement> decls = classDecl.getDeclarations();
            result.append("public class ");
            result.append(classDecl.getName());
            result.append(" {\n");
            if (decls != null) {
                for (Translator.ASTStatement decl : decls) {
                    this.internalTranslateStatement(decl, indent + 4, result);
                }
            }
            this.closeBrace(indent, result);
        } else if (stmt instanceof Translator.ASTBreakOrContinueStatement) {
            String s = ((Translator.ASTBreakOrContinueStatement)stmt).isBreak() ? "break" : "continue";
            result.append(s).append(";\n");
        } else {
            throw new UnsupportedOperationException("Cannot translate node of type " + CSharpTranslator.getSimpleName(stmt));
        }
        if (addNewline) {
            result.append('\n');
        }
    }

    @Override
    public void translateProperties(String name, int indent, StringBuilder result) {
        super.translateProperties(name, indent, result);
        if (!this.properties.isEmpty()) {
            for (Map.Entry prop : this.properties.entrySet()) {
                String k = (String)prop.getKey();
                String s = this.translateIdentifier(k, Translator.TranslationContext.FIELD);
                this.addIndent(indent, result);
                result.append("public ");
                this.translateType((Translator.ASTTypeExpression)prop.getValue(), result);
                result.append(' ');
                result.append(s);
                result.append(" { get { return _");
                result.append(k);
                result.append("; } set { _");
                result.append(k);
                result.append(" = value; } }\n\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String translateInjectedClass(CodeInjector injector, String name) {
        String qualifiedName = String.format("%s.%s", this.appSettings.getNodePackage(), name);
        List<String> nameList = injector.getParentClasses(qualifiedName);
        List<ClassOrInterfaceBodyDeclaration> decls = injector.getBodyDeclarations(qualifiedName);
        int n = decls.size();
        int indent = 4;
        StringBuilder result = new StringBuilder();
        this.inInterface = this.grammar.nodeIsInterface(name);
        try {
            this.addIndent(indent, result);
            result.append("public ").append(this.inInterface ? "interface" : "class").append(' ').append(name).append(" : ");
            result.append(String.join((CharSequence)", ", nameList));
            result.append(" {\n");
            if (n > 0) {
                result.append('\n');
                ArrayList<FieldDeclaration> fieldDecls = new ArrayList<FieldDeclaration>();
                for (ClassOrInterfaceBodyDeclaration decl : decls) {
                    if (!(decl instanceof FieldDeclaration)) continue;
                    fieldDecls.add((FieldDeclaration)decl);
                }
                this.clearFields();
                if (!fieldDecls.isEmpty()) {
                    for (FieldDeclaration fd : fieldDecls) {
                        this.translateStatement(fd, 8, result);
                    }
                }
                this.translateProperties(name, indent + 4, result);
                for (ClassOrInterfaceBodyDeclaration decl : decls) {
                    if (decl instanceof FieldDeclaration) continue;
                    if (decl instanceof MethodDeclaration) {
                        this.translateStatement(decl, indent + 4, result);
                        continue;
                    }
                    String s = String.format("Cannot translate %s at %s", CSharpTranslator.getSimpleName(decl), decl.getLocation());
                    throw new UnsupportedOperationException(s);
                }
            }
            if (!this.inInterface) {
                this.addIndent(indent + 4, result);
                result.append(String.format("public %s(Lexer tokenSource) : base(tokenSource) {}\n", name));
            }
            this.closeBrace(indent, result);
            String string = result.toString();
            return string;
        }
        finally {
            this.inInterface = false;
        }
    }

    @Override
    protected void translateCast(Translator.ASTTypeExpression cast, StringBuilder result) {
        result.append('(');
        this.translateType(cast, result);
        result.append(") ");
    }

    @Override
    public void translateFormals(List<FormalParameter> formals, Translator.SymbolTable symbols, StringBuilder result) {
        this.translateFormals(this.transformFormals(formals), symbols, true, true, result);
    }

    @Override
    public void translateImport(String javaName, StringBuilder result) {
        String prefix = String.format("%s.", this.appSettings.getParserPackage());
        List<String> parts = this.getImportParts(javaName, prefix);
        int n = parts.size();
        String aliasName = null;
        for (int i = 0; i < n; ++i) {
            String s = parts.get(i);
            if (s.endsWith("Parser")) {
                if (i == n - 1) {
                    if (aliasName != null) {
                        s = String.format("Unexpected alias %s", aliasName);
                        throw new UnsupportedOperationException(s);
                    }
                    aliasName = s;
                }
                parts.set(i, "Parser");
                continue;
            }
            if (!s.endsWith("Lexer")) continue;
            if (i == n - 1) {
                if (aliasName != null) {
                    s = String.format("Unexpected alias %s", aliasName);
                    throw new UnsupportedOperationException(s);
                }
                aliasName = s;
            }
            parts.set(i, "Lexer");
        }
        result.append("    using ");
        String s = String.join((CharSequence)".", parts);
        if (aliasName == null) {
            aliasName = parts.get(n - 1);
        }
        if (aliasName != null) {
            result.append(aliasName).append(" = ");
        }
        result.append(prefix).append(s).append(";\n");
    }
}

