/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.csharp;

import org.congocc.parser.Node;
import org.congocc.parser.csharp.CSToken;
import org.congocc.parser.csharp.ast.Block;
import org.congocc.parser.csharp.ast.BreakStatement;
import org.congocc.parser.csharp.ast.CatchClause;
import org.congocc.parser.csharp.ast.Comment;
import org.congocc.parser.csharp.ast.ConstantDeclaration;
import org.congocc.parser.csharp.ast.ContinueStatement;
import org.congocc.parser.csharp.ast.Delimiter;
import org.congocc.parser.csharp.ast.FieldDeclaration;
import org.congocc.parser.csharp.ast.FinallyClause;
import org.congocc.parser.csharp.ast.ForStatement;
import org.congocc.parser.csharp.ast.ForeachStatement;
import org.congocc.parser.csharp.ast.Identifier;
import org.congocc.parser.csharp.ast.IfStatement;
import org.congocc.parser.csharp.ast.InterpolatedString;
import org.congocc.parser.csharp.ast.KeyWord;
import org.congocc.parser.csharp.ast.Literal;
import org.congocc.parser.csharp.ast.Operator;
import org.congocc.parser.csharp.ast.PropertyBody;
import org.congocc.parser.csharp.ast.PropertyDeclaration;
import org.congocc.parser.csharp.ast.ReturnStatement;
import org.congocc.parser.csharp.ast.SwitchStatement;
import org.congocc.parser.csharp.ast.This;
import org.congocc.parser.csharp.ast.TryStatement;
import org.congocc.parser.csharp.ast.Type;
import org.congocc.parser.csharp.ast.TypeArgumentList;
import org.congocc.parser.csharp.ast.TypeDeclaration;
import org.congocc.parser.csharp.ast.TypeParameterConstraint;
import org.congocc.parser.csharp.ast.TypeParameterList;
import org.congocc.parser.csharp.ast.UnaryExpression;
import org.congocc.parser.csharp.ast.WhileStatement;

public class CSharpFormatter
extends Node.Visitor {
    private final StringBuilder buffer;
    private int currentIndentation;
    private final int indentAmount = 4;
    private final String eol = "\n";

    public CSharpFormatter() {
        this.visitUnparsedTokens = true;
        this.buffer = new StringBuilder();
        this.indentAmount = 4;
        this.eol = "\n";
    }

    public String getText() {
        if (this.buffer.charAt(this.buffer.length() - 1) != '\n') {
            this.buffer.append('\n');
        }
        return this.buffer.toString();
    }

    void visit(TypeDeclaration decl) {
        this.newLine(true);
        this.recurse(decl);
        this.newLine(true);
    }

    void visit(FieldDeclaration fd) {
        this.recurse(fd);
        if (!(fd.nextSibling() instanceof FieldDeclaration)) {
            this.newLine(true);
        }
    }

    void visit(ConstantDeclaration cd) {
        this.recurse(cd);
        if (!(cd.nextSibling() instanceof ConstantDeclaration)) {
            this.newLine(true);
        }
    }

    void visit(PropertyDeclaration pd) {
        this.recurse(pd);
        if (!(pd.nextSibling() instanceof PropertyDeclaration)) {
            this.newLine(true);
        }
    }

    void visit(Type type) {
        this.recurse(type);
        this.addSpaceIfNecessary();
    }

    void visit(CSToken tok) {
        this.buffer.append(tok.toString());
    }

    void visit(Block block) {
        this.recurse(block);
        if (block.getParent().getParent() instanceof TypeDeclaration) {
            this.newLine(true);
        }
    }

    void visit(Delimiter delimiter) {
        CSToken.TokenType type = delimiter.getType();
        if (type == CSToken.TokenType.LBRACE) {
            this.addSpaceIfNecessary();
            this.buffer.append('{');
            this.indent();
        } else if (type == CSToken.TokenType.RBRACE) {
            boolean controlStatement;
            this.dedent();
            this.buffer.append('}');
            Node parent = delimiter.getParent();
            Node gp = parent.getParent();
            boolean bl = controlStatement = gp instanceof IfStatement || gp instanceof ForStatement || gp instanceof ForeachStatement || gp instanceof WhileStatement || gp instanceof SwitchStatement || gp instanceof TryStatement || gp instanceof CatchClause || gp instanceof FinallyClause;
            if (gp instanceof TypeDeclaration || controlStatement || parent instanceof PropertyBody) {
                this.newLine(!controlStatement);
            }
        } else if (type == CSToken.TokenType.LBRACKET) {
            this.trimTrailingWhitespace();
            this.buffer.append('[');
        } else if (type == CSToken.TokenType.COMMA) {
            this.trimTrailingWhitespace();
            this.buffer.append(", ");
        } else if (type == CSToken.TokenType.RPAREN) {
            this.trimTrailingWhitespace();
            this.buffer.append(')');
        } else if (type == CSToken.TokenType.SEMICOLON) {
            this.buffer.append(';');
            if (!(delimiter.getParent() instanceof ForStatement)) {
                this.newLine();
            } else {
                this.buffer.append(' ');
            }
        } else {
            this.buffer.append(delimiter);
        }
    }

    void visit(Literal literal) {
        int precedingChar;
        if (this.buffer.length() > 0 && (Character.isLetterOrDigit(precedingChar = this.buffer.codePointBefore(this.buffer.length())) || precedingChar == 125)) {
            this.buffer.append(' ');
        }
        this.buffer.append(literal.toString());
    }

    void visit(Operator op) {
        CSToken.TokenType type = op.getType();
        if (type == CSToken.TokenType.DOT) {
            this.trimTrailingWhitespace();
            this.buffer.append('.');
        } else if ((type == CSToken.TokenType.LT || type == CSToken.TokenType.GT) && (op.getParent() instanceof TypeParameterList || op.getParent() instanceof TypeArgumentList)) {
            this.trimTrailingWhitespace();
            this.buffer.append(op);
        } else if (op.getParent() instanceof UnaryExpression) {
            this.buffer.append(op);
        } else {
            this.addSpaceIfNecessary();
            this.buffer.append(op);
            this.buffer.append(' ');
        }
    }

    void visit(Comment comment) {
        this.buffer.append(comment.toString());
        this.newLine();
    }

    void visit(KeyWord kw) {
        if (this.buffer.length() > 0) {
            int precedingChar = this.buffer.codePointBefore(this.buffer.length());
            if (Character.isLetterOrDigit(precedingChar) || precedingChar == 125) {
                this.buffer.append(' ');
            } else if (precedingChar == 41) {
                String s;
                boolean space;
                Node parent = kw.getParent();
                boolean bl = space = parent instanceof BreakStatement || parent instanceof ContinueStatement || parent instanceof TypeParameterConstraint || parent instanceof ReturnStatement || parent instanceof This || (s = kw.toString()).equals("is") || s.equals("throw");
                if (space) {
                    this.buffer.append(' ');
                }
            }
        }
        this.buffer.append(kw.toString());
        CSToken.TokenType type = kw.getType();
        if (type == CSToken.TokenType.IF || type == CSToken.TokenType.WHILE || type == CSToken.TokenType.FOR || type == CSToken.TokenType.FOREACH || type == CSToken.TokenType.WHEN) {
            this.buffer.append(' ');
        }
    }

    void visit(Identifier id) {
        int precedingChar;
        if (this.buffer.length() > 0 && (Character.isLetterOrDigit(precedingChar = this.buffer.codePointBefore(this.buffer.length())) || precedingChar == 125 || precedingChar == 41)) {
            this.buffer.append(' ');
        }
        this.buffer.append(id.toString());
    }

    void visit(InterpolatedString irs) {
        this.buffer.append(irs.getSource());
    }

    private void addSpaceIfNecessary() {
        if (this.buffer.length() == 0) {
            return;
        }
        int lastChar = this.buffer.codePointBefore(this.buffer.length());
        if (!Character.isWhitespace(lastChar)) {
            this.buffer.append(' ');
        }
    }

    private void indent() {
        this.currentIndentation += 4;
        this.newLine();
    }

    private void dedent() {
        this.currentIndentation -= 4;
        this.newLine();
    }

    private void newLine() {
        this.newLine(false);
    }

    private void newLine(boolean ensureBlankLine) {
        this.trimTrailingWhitespace();
        this.buffer.append("\n");
        if (ensureBlankLine) {
            this.buffer.append("\n");
        }
        for (int i = 0; i < this.currentIndentation; ++i) {
            this.buffer.append(' ');
        }
    }

    private void trimTrailingWhitespace() {
        if (this.buffer.length() == 0) {
            return;
        }
        int lastChar = this.buffer.codePointBefore(this.buffer.length());
        while (Character.isWhitespace(lastChar)) {
            this.buffer.setLength(this.buffer.length() - 1);
            if (lastChar > 65535) {
                this.buffer.setLength(this.buffer.length() - 1);
            }
            if (this.buffer.length() == 0) break;
            lastChar = this.buffer.codePointBefore(this.buffer.length());
        }
    }

    private boolean atLineStart() {
        int pos = this.buffer.length() - 1;
        while (pos >= 0) {
            char ch;
            if ((ch = this.buffer.charAt(pos--)) == '\n') {
                return true;
            }
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    private int currentLineLength() {
        return this.buffer.length() - this.buffer.lastIndexOf("\n") - "\n".length();
    }
}

