/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.congocc.app.AppSettings;
import org.congocc.codegen.csharp.CSharpTranslator;
import org.congocc.codegen.java.CodeInjector;
import org.congocc.codegen.python.PythonTranslator;
import org.congocc.core.Grammar;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.AdditiveExpression;
import org.congocc.parser.tree.AllocationExpression;
import org.congocc.parser.tree.AndExpression;
import org.congocc.parser.tree.ArrayAccess;
import org.congocc.parser.tree.AssertStatement;
import org.congocc.parser.tree.AssignmentExpression;
import org.congocc.parser.tree.BaseNode;
import org.congocc.parser.tree.BasicForStatement;
import org.congocc.parser.tree.BreakStatement;
import org.congocc.parser.tree.ClassDeclaration;
import org.congocc.parser.tree.ClassLiteral;
import org.congocc.parser.tree.ClassicCaseStatement;
import org.congocc.parser.tree.ClassicSwitchLabel;
import org.congocc.parser.tree.ClassicSwitchStatement;
import org.congocc.parser.tree.ClassicTryStatement;
import org.congocc.parser.tree.CodeBlock;
import org.congocc.parser.tree.ConditionalAndExpression;
import org.congocc.parser.tree.ConditionalOrExpression;
import org.congocc.parser.tree.ConstructorDeclaration;
import org.congocc.parser.tree.ContinueStatement;
import org.congocc.parser.tree.Delimiter;
import org.congocc.parser.tree.DoStatement;
import org.congocc.parser.tree.DotName;
import org.congocc.parser.tree.EmptyStatement;
import org.congocc.parser.tree.EnhancedForStatement;
import org.congocc.parser.tree.EnumDeclaration;
import org.congocc.parser.tree.EqualityExpression;
import org.congocc.parser.tree.ExclusiveOrExpression;
import org.congocc.parser.tree.ExplicitConstructorInvocation;
import org.congocc.parser.tree.Expression;
import org.congocc.parser.tree.ExpressionStatement;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.FinallyBlock;
import org.congocc.parser.tree.FormalParameter;
import org.congocc.parser.tree.FormalParameters;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.IfStatement;
import org.congocc.parser.tree.InclusiveOrExpression;
import org.congocc.parser.tree.Initializer;
import org.congocc.parser.tree.InstanceOfExpression;
import org.congocc.parser.tree.InvocationArguments;
import org.congocc.parser.tree.KeyWord;
import org.congocc.parser.tree.LiteralExpression;
import org.congocc.parser.tree.LocalVariableDeclaration;
import org.congocc.parser.tree.MarkerAnnotation;
import org.congocc.parser.tree.MethodCall;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.MethodReference;
import org.congocc.parser.tree.Modifiers;
import org.congocc.parser.tree.MultiplicativeExpression;
import org.congocc.parser.tree.Name;
import org.congocc.parser.tree.ObjectCastExpression;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.Operator;
import org.congocc.parser.tree.Parentheses;
import org.congocc.parser.tree.PostfixExpression;
import org.congocc.parser.tree.PreDecrementExpression;
import org.congocc.parser.tree.PreIncrementExpression;
import org.congocc.parser.tree.Primitive;
import org.congocc.parser.tree.PrimitiveArrayType;
import org.congocc.parser.tree.PrimitiveType;
import org.congocc.parser.tree.ReferenceType;
import org.congocc.parser.tree.RelationalExpression;
import org.congocc.parser.tree.ReturnStatement;
import org.congocc.parser.tree.ReturnType;
import org.congocc.parser.tree.ShiftExpression;
import org.congocc.parser.tree.Statement;
import org.congocc.parser.tree.StatementExpression;
import org.congocc.parser.tree.TernaryExpression;
import org.congocc.parser.tree.ThrowStatement;
import org.congocc.parser.tree.TypeArguments;
import org.congocc.parser.tree.UnaryExpression;
import org.congocc.parser.tree.UnaryExpressionNotPlusMinus;
import org.congocc.parser.tree.VariableDeclarator;
import org.congocc.parser.tree.WhileStatement;

public class Translator {
    protected final Grammar grammar;
    protected final AppSettings appSettings;
    protected int tempVarCounter;
    protected int fieldIndent;
    protected int methodIndent;
    protected boolean isTyped;
    protected boolean includeInitializers;
    protected boolean inInterface;
    protected String currentClass;
    protected final List<SymbolTable> symbolStack = new ArrayList<SymbolTable>();
    protected final Map<String, ASTTypeExpression> properties = new HashMap<String, ASTTypeExpression>();
    protected final SymbolTable fields = new SymbolTable();
    protected final Map<String, Set<String>> propertyMap = new HashMap<String, Set<String>>();
    protected final Set<String> parameterNames = new LinkedHashSet<String>();
    protected final Set<String> notSetters = new LinkedHashSet<String>(Collections.singletonList("setLineSkipped"));
    protected Map<String, Set<String>> nestedDeclarations;

    @SafeVarargs
    public static <T> Set<T> makeSet(T ... objs) {
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, objs);
        return set;
    }

    public boolean isIncludeInitializers() {
        return this.includeInitializers;
    }

    protected static String getSimpleName(Object o) {
        return o.getClass().getSimpleName();
    }

    public void clearFields() {
        this.fields.clear();
        this.properties.clear();
    }

    public void pushSymbols(SymbolTable symbols) {
        this.symbolStack.add(symbols);
    }

    public void popSymbols() {
        this.symbolStack.remove(this.symbolStack.size() - 1);
    }

    public SymbolTable topSymbols() {
        return this.symbolStack.get(this.symbolStack.size() - 1);
    }

    public void addSymbol(String name, ASTTypeExpression typeExpression) {
        SymbolTable latest = this.symbolStack.get(this.symbolStack.size() - 1);
        latest.put(name, typeExpression);
    }

    public boolean isParameterName(String name) {
        return this.parameterNames.contains(name);
    }

    public void clearParameterNames() {
        this.parameterNames.clear();
    }

    public ASTTypeExpression findSymbol(String name) {
        ASTTypeExpression result = null;
        for (int n = this.symbolStack.size() - 1; result == null && n >= 0; --n) {
            SymbolTable symbols = this.symbolStack.get(n);
            result = (ASTTypeExpression)symbols.get(name);
        }
        return result;
    }

    public Translator(Grammar grammar) {
        this.grammar = grammar;
        this.appSettings = grammar.getAppSettings();
    }

    public int getFieldIndent() {
        return this.fieldIndent;
    }

    public int getMethodIndent() {
        return this.methodIndent;
    }

    public static Translator getTranslatorFor(Grammar grammar) {
        String codeLang = grammar.getAppSettings().getCodeLang();
        if (codeLang.equals("python")) {
            return new PythonTranslator(grammar);
        }
        if (codeLang.equals("csharp")) {
            return new CSharpTranslator(grammar);
        }
        return new Translator(grammar);
    }

    protected String getTempVarName() {
        return String.format("_tv_%s", ++this.tempVarCounter);
    }

    public static String camelToSnake(String ident) {
        StringBuilder sb = new StringBuilder();
        sb.append(ident.charAt(0));
        ident = ident.substring(1);
        for (int i = 0; i < ident.length(); ++i) {
            char c = ident.charAt(i);
            if (!Character.isUpperCase(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public String translateIdentifier(String ident, TranslationContext kind) {
        return ident;
    }

    public boolean isGetter(String name) {
        int n = name.length();
        if (n < 3 || !name.startsWith("get") && !name.startsWith("is")) {
            return false;
        }
        int idx = name.startsWith("is") ? 2 : 3;
        return idx < n && Character.isUpperCase(name.charAt(idx));
    }

    public boolean isSetter(String name) {
        if (name.length() <= 3 || !name.startsWith("set") || this.notSetters.contains(name)) {
            return false;
        }
        return Character.isUpperCase(name.charAt(3));
    }

    ASTExpression transformName(Node name) {
        ASTExpression result;
        int m = name.size();
        if (m == 1) {
            ASTPrimaryExpression resultNode;
            result = resultNode = new ASTPrimaryExpression();
            resultNode.name = ((Identifier)name.getFirstChild()).toString();
        } else {
            ASTBinaryExpression lhs = new ASTBinaryExpression();
            lhs.op = ".";
            ASTPrimaryExpression pe = new ASTPrimaryExpression(lhs);
            pe.name = ((Identifier)name.get(0)).toString();
            lhs.setLhs(pe);
            pe = new ASTPrimaryExpression(lhs);
            pe.name = ((Identifier)name.get(2)).toString();
            lhs.setRhs(pe);
            result = lhs;
            for (int j = 4; j < m; j += 2) {
                ASTBinaryExpression newNode = new ASTBinaryExpression();
                newNode.setLhs(lhs);
                pe = new ASTPrimaryExpression();
                pe.name = ((Identifier)name.get(j)).toString();
                newNode.op = ".";
                newNode.setRhs(pe);
                lhs = newNode;
                result = newNode;
            }
        }
        return result;
    }

    protected void processArguments(ASTInvocation invocation, Node args) {
        int m = args.size();
        for (int j = 1; j < m - 1; ++j) {
            Node child = (Node)args.get(j);
            if (child instanceof Delimiter) continue;
            ASTExpression arg = (ASTExpression)this.transformTree(child);
            invocation.add(arg);
        }
    }

    ASTInvocation transformMethodCall(Node node) {
        if (node.size() != 2) {
            throw new UnsupportedOperationException("node is '" + node + "' class " + Translator.getSimpleName(node));
        }
        ASTInvocation result = new ASTInvocation();
        result.receiver = (ASTExpression)this.transformTree(node.getFirstChild());
        Node args = node.getLastChild();
        this.processArguments(result, args);
        return result;
    }

    private void transformArgs(Node args, ASTInvocation resultNode) {
        int m = args.size();
        for (int j = 1; j < m - 1; ++j) {
            Node arg = (Node)args.get(j);
            if (arg instanceof Delimiter) continue;
            resultNode.add((ASTExpression)this.transformTree(arg));
        }
    }

    protected ASTFormalParameter transformFormal(FormalParameter fp) {
        ASTFormalParameter result = new ASTFormalParameter();
        Node ac = fp.getFirstChild();
        boolean bl = result.isFinal = ac instanceof Token && ((Token)ac).toString().equals("final");
        if (result.isFinal) {
            ac = fp.get(1);
        }
        result.typeExpression = (ASTTypeExpression)this.transformTree(ac, true);
        result.name = fp.getLastChild().toString();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Node transformType(Node node, boolean forType) {
        ASTTypeExpression result = new ASTTypeExpression();
        int n = node.size();
        if (n == 1) {
            Node child = node.getFirstChild();
            if (child instanceof ObjectType) {
                return this.transformTree(child, forType);
            }
            if (!(child instanceof Identifier)) throw new UnsupportedOperationException("node is '" + child + "' class " + Translator.getSimpleName(child));
            result.name = ((Identifier)child).toString();
            return result;
        } else {
            StringBuilder sb = new StringBuilder();
            for (Node child : node.children()) {
                if (child instanceof Token) {
                    sb.append((Token)child);
                    continue;
                }
                if (!(child instanceof TypeArguments)) {
                    throw new UnsupportedOperationException("node is '" + child + "' class " + Translator.getSimpleName(child));
                }
                for (Node gc : child.children()) {
                    if (gc instanceof Operator || gc instanceof Delimiter) continue;
                    if (!(gc instanceof ObjectType)) {
                        throw new UnsupportedOperationException("node is '" + gc + "' class " + Translator.getSimpleName(gc));
                    }
                    ASTTypeExpression tp = (ASTTypeExpression)this.transformTree(gc, true);
                    result.add(tp);
                }
            }
            result.name = sb.toString();
        }
        return result;
    }

    protected Node transformLocalVariableDeclaration(Node node, boolean forType) {
        if (node.size() == 1) {
            return this.transformTree((Node)node.get(0));
        }
        ASTVariableOrFieldDeclaration result = new ASTVariableOrFieldDeclaration();
        for (Node child : node) {
            ASTPrimaryExpression name;
            if (child instanceof Delimiter || child instanceof KeyWord) continue;
            if (child instanceof Primitive || child instanceof PrimitiveType || child instanceof ObjectType || child instanceof PrimitiveArrayType) {
                result.typeExpression = (ASTTypeExpression)this.transformTree(child, true);
                continue;
            }
            if (child instanceof Identifier) {
                name = (ASTPrimaryExpression)this.transformTree(child);
                result.addNameAndInitializer(name, null);
                continue;
            }
            if (child instanceof VariableDeclarator) {
                name = (ASTPrimaryExpression)this.transformTree(child.getFirstChild());
                ASTExpression initializer = child.size() == 1 ? null : (ASTExpression)this.transformTree(child.getLastChild());
                result.addNameAndInitializer(name, initializer);
                continue;
            }
            if (child instanceof LocalVariableDeclaration) {
                return this.transformTree(child, forType);
            }
            throw new UnsupportedOperationException("node is '" + child + "' class " + Translator.getSimpleName(child));
        }
        return result;
    }

    protected Node transformFieldDeclaration(Node node) {
        ASTVariableOrFieldDeclaration result = new ASTVariableOrFieldDeclaration();
        result.field = true;
        for (Node child : node) {
            ASTPrimaryExpression name;
            if (child instanceof Delimiter) continue;
            if (child instanceof Primitive || child instanceof PrimitiveType || child instanceof ObjectType) {
                result.typeExpression = (ASTTypeExpression)this.transformTree(child, true);
                continue;
            }
            if (child instanceof KeyWord) {
                result.addModifier(child.toString());
                continue;
            }
            if (child instanceof Identifier) {
                name = (ASTPrimaryExpression)this.transformTree(child);
                result.addNameAndInitializer(name, null);
                continue;
            }
            if (child instanceof VariableDeclarator) {
                name = (ASTPrimaryExpression)this.transformTree(child.getFirstChild());
                ASTExpression initializer = child.size() == 1 ? null : (ASTExpression)this.transformTree(child.getLastChild());
                result.addNameAndInitializer(name, initializer);
                continue;
            }
            if (child instanceof MarkerAnnotation) {
                result.addAnnotation(child.getLastChild().toString());
                continue;
            }
            if (child instanceof Modifiers) {
                for (Node gc : child.children()) {
                    result.addModifier(gc.toString());
                }
                continue;
            }
            throw new UnsupportedOperationException("node is '" + child + "' class " + Translator.getSimpleName(child));
        }
        return result;
    }

    protected Node transformBasicForStatement(Node node, boolean forType) {
        ASTForStatement result = new ASTForStatement();
        Node child = (Node)node.get(2);
        if (child instanceof LocalVariableDeclaration) {
            result.variable = (ASTVariableOrFieldDeclaration)this.transformTree(child, forType);
            result.condition = (ASTExpression)this.transformTree((Node)node.get(4));
        } else {
            ASTVariableOrFieldDeclaration vd = new ASTVariableOrFieldDeclaration();
            vd.typeExpression = (ASTTypeExpression)this.transformTree(child, true);
            VariableDeclarator d = (VariableDeclarator)node.get(3);
            ASTPrimaryExpression name = (ASTPrimaryExpression)this.transformTree(d.getFirstChild());
            ASTExpression initializer = d.size() == 1 ? null : (ASTExpression)this.transformTree(d.getLastChild());
            vd.addNameAndInitializer(name, initializer);
            result.variable = vd;
            result.condition = (ASTExpression)this.transformTree((Node)node.get(5));
        }
        int n = node.size();
        for (int i = 6; i < n - 1; ++i) {
            child = (Node)node.get(i);
            if (!(child instanceof Expression)) continue;
            result.add((ASTExpression)this.transformTree(child));
        }
        result.statements = (ASTStatement)this.transformTree(node.getLastChild());
        return result;
    }

    protected Node transformEnhancedForStatement(Node node, boolean forType) {
        ASTForStatement result = new ASTForStatement();
        ASTVariableOrFieldDeclaration decl = new ASTVariableOrFieldDeclaration();
        Node child = (Node)node.get(2);
        if (child instanceof LocalVariableDeclaration) {
            result.variable = (ASTVariableOrFieldDeclaration)this.transformTree(child, forType);
            result.iterable = (ASTExpression)this.transformTree((Node)node.get(4));
        } else {
            decl.typeExpression = (ASTTypeExpression)this.transformTree((Node)node.get(2), true);
            Node vd = (Node)node.get(3);
            ASTPrimaryExpression name = (ASTPrimaryExpression)this.transformTree(vd.getFirstChild());
            ASTExpression initializer = vd.size() == 1 ? null : (ASTExpression)this.transformTree(vd.getLastChild());
            decl.addNameAndInitializer(name, initializer);
            result.variable = decl;
            result.iterable = (ASTExpression)this.transformTree((Node)node.get(5));
        }
        result.statements = (ASTStatement)this.transformTree(node.getLastChild());
        return result;
    }

    protected Node transformClassicSwitchStatement(Node node) {
        int n = node.size();
        ArrayList<ASTExpression> pendingLabels = new ArrayList<ASTExpression>();
        ASTCaseStatement currentCase = null;
        ASTSwitchStatement result = new ASTSwitchStatement();
        result.variable = (ASTExpression)this.transformTree((Node)node.get(2));
        for (int i = 5; i < n; ++i) {
            Node child = (Node)node.get(i);
            if (child instanceof Delimiter) continue;
            if (child instanceof ClassicSwitchLabel) {
                if (child.getFirstChild().toString().equals("case")) {
                    pendingLabels.add((ASTExpression)this.transformTree((Node)child.get(1)));
                    continue;
                }
                if (currentCase == null) continue;
                continue;
            }
            if (!(child instanceof ClassicCaseStatement)) {
                throw new UnsupportedOperationException("node is '" + child + "' class " + Translator.getSimpleName(child));
            }
            currentCase = new ASTCaseStatement();
            Node label = (Node)child.get(0);
            if (label.size() >= 3) {
                pendingLabels.add((ASTExpression)this.transformTree((Node)label.get(1)));
            }
            currentCase.caseLabels = new ArrayList(pendingLabels);
            pendingLabels.clear();
            int m = child.size();
            for (int j = 1; j < m; ++j) {
                ASTStatement s = (ASTStatement)this.transformTree((Node)child.get(j));
                if (s instanceof ASTBreakOrContinueStatement) {
                    currentCase.hasBreak = ((ASTBreakOrContinueStatement)s).isBreak();
                    continue;
                }
                currentCase.add(s);
            }
            result.add(currentCase);
            currentCase = null;
        }
        return result;
    }

    protected Node transformMethodOrConstructor(Node node) {
        ASTMethodDeclaration result = new ASTMethodDeclaration();
        result.constructor = node instanceof ConstructorDeclaration;
        int n = node.size();
        for (int i = 0; i < n - 1; ++i) {
            Node child = (Node)node.get(i);
            if (child instanceof KeyWord) {
                result.addModifier(child.toString());
                continue;
            }
            if (child instanceof ReturnType) {
                result.returnType = (ASTTypeExpression)this.transformTree(child, true);
                continue;
            }
            if (child instanceof Identifier) {
                result.name = child.toString();
                continue;
            }
            if (child instanceof FormalParameters) {
                int m = child.size();
                if (m <= 2) continue;
                for (int j = 1; j < m - 1; ++j) {
                    Node arg = (Node)child.get(j);
                    if (arg instanceof Delimiter) continue;
                    ASTFormalParameter formal = this.transformFormal((FormalParameter)arg);
                    result.addParameter(formal);
                }
                continue;
            }
            if (child instanceof Modifiers) {
                for (Node gc : child.children()) {
                    result.addModifier(gc.toString());
                }
                continue;
            }
            if (!(child instanceof Delimiter)) continue;
        }
        if (node instanceof MethodDeclaration) {
            CodeBlock statements = ((MethodDeclaration)node).getStatements();
            if (statements != null) {
                result.statements = (ASTStatementList)this.transformTree(statements);
            }
        } else {
            List<Node> statements = ((ConstructorDeclaration)node).getStatements();
            if (statements != null) {
                result.statements = new ASTStatementList();
                for (Node child : statements) {
                    ASTStatement stmt = (ASTStatement)this.transformTree(child);
                    result.statements.add(stmt);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    protected Node transformTree(Node node, boolean forType) {
        block70: {
            void var3_15;
            block65: {
                block69: {
                    ASTBinaryExpression aSTBinaryExpression;
                    block68: {
                        ASTBinaryExpression aSTBinaryExpression2;
                        block67: {
                            ASTBinaryExpression aSTBinaryExpression3;
                            block66: {
                                ASTTernaryExpression aSTTernaryExpression;
                                block64: {
                                    ASTUnaryExpression aSTUnaryExpression;
                                    Object var3_3 = null;
                                    if (node instanceof Delimiter) throw new IllegalArgumentException("internal error");
                                    if (node instanceof Operator) {
                                        throw new IllegalArgumentException("internal error");
                                    }
                                    if (node instanceof Name) {
                                        return this.transformName(node);
                                    }
                                    if (node instanceof Parentheses) {
                                        return this.transformTree((Node)node.get(1));
                                    }
                                    if (node instanceof ClassLiteral) {
                                        ASTTypeExpression aSTTypeExpression = new ASTTypeExpression();
                                        aSTTypeExpression.name = node.getFirstChild().toString();
                                        return aSTTypeExpression;
                                    }
                                    if (node instanceof Initializer) {
                                        ASTStatementList aSTStatementList = (ASTStatementList)this.transformTree(node.getFirstChild());
                                        aSTStatementList.initializer = true;
                                        return aSTStatementList;
                                    }
                                    if (node instanceof MethodCall) {
                                        ASTInvocation aSTInvocation = new ASTInvocation();
                                        aSTInvocation.receiver = (ASTExpression)this.transformTree(node.getFirstChild());
                                        this.transformArgs(node.getLastChild(), aSTInvocation);
                                        return aSTInvocation;
                                    }
                                    if (node instanceof DotName) {
                                        ASTBinaryExpression aSTBinaryExpression4 = new ASTBinaryExpression();
                                        aSTBinaryExpression4.op = ".";
                                        aSTBinaryExpression4.setLhs((ASTExpression)this.transformTree(node.getFirstChild()));
                                        aSTBinaryExpression4.setRhs((ASTExpression)this.transformTree(node.getLastChild()));
                                        return aSTBinaryExpression4;
                                    }
                                    if (node instanceof AllocationExpression) {
                                        ASTAllocation aSTAllocation = new ASTAllocation();
                                        aSTAllocation.setReceiver((ASTExpression)this.transformTree((Node)node.get(1)));
                                        this.transformArgs(node.getLastChild(), aSTAllocation);
                                        return aSTAllocation;
                                    }
                                    if (node instanceof Identifier) {
                                        ASTPrimaryExpression aSTPrimaryExpression = forType ? new ASTTypeExpression() : new ASTPrimaryExpression();
                                        aSTPrimaryExpression.name = ((Token)node).toString();
                                        return aSTPrimaryExpression;
                                    }
                                    if (node instanceof Token) {
                                        ASTPrimaryExpression aSTPrimaryExpression = forType ? new ASTTypeExpression() : new ASTPrimaryExpression();
                                        aSTPrimaryExpression.literal = ((Token)node).toString();
                                        if (!forType) return aSTPrimaryExpression;
                                        if (!(node.getParent() instanceof PrimitiveType)) return aSTPrimaryExpression;
                                        if (!(node.getParent().getParent() instanceof PrimitiveArrayType)) return aSTPrimaryExpression;
                                        aSTPrimaryExpression.isArray = true;
                                        return aSTPrimaryExpression;
                                    }
                                    if (node instanceof LiteralExpression) {
                                        ASTPrimaryExpression aSTPrimaryExpression = forType ? new ASTTypeExpression() : new ASTPrimaryExpression();
                                        aSTPrimaryExpression.literal = ((Token)node.getFirstChild()).toString();
                                        return aSTPrimaryExpression;
                                    }
                                    if (node instanceof PrimitiveType || node instanceof PrimitiveArrayType) {
                                        if (node instanceof PrimitiveType && node.size() != 1) {
                                            String string = String.format("Cannot transform %s at %s", Translator.getSimpleName(node), node.getLocation());
                                            throw new UnsupportedOperationException(string);
                                        }
                                        Node node2 = node.getFirstChild();
                                        return this.transformTree(node2, forType);
                                    }
                                    if (node instanceof ObjectType) {
                                        return this.transformType(node, forType);
                                    }
                                    if (node instanceof ReturnType) {
                                        return this.transformTree(node.getFirstChild(), true);
                                    }
                                    if (!(node instanceof UnaryExpressionNotPlusMinus) && !(node instanceof UnaryExpression)) break block64;
                                    ASTUnaryExpression aSTUnaryExpression2 = aSTUnaryExpression = new ASTUnaryExpression();
                                    aSTUnaryExpression.op = ((Operator)node.get(0)).toString();
                                    aSTUnaryExpression.setOperand((ASTExpression)this.transformTree((Node)node.get(1)));
                                    break block65;
                                }
                                if (node instanceof PostfixExpression) {
                                    if (node.getLastChild() instanceof MethodCall) {
                                        return this.transformMethodCall(node);
                                    }
                                    ASTPreOrPostfixExpression aSTPreOrPostfixExpression = new ASTPreOrPostfixExpression();
                                    aSTPreOrPostfixExpression.op = node.getLastChild().toString();
                                    aSTPreOrPostfixExpression.setOperand((ASTExpression)this.transformTree(node.getFirstChild()));
                                    return aSTPreOrPostfixExpression;
                                }
                                if (node instanceof PreDecrementExpression || node instanceof PreIncrementExpression) {
                                    ASTPreOrPostfixExpression aSTPreOrPostfixExpression = new ASTPreOrPostfixExpression();
                                    aSTPreOrPostfixExpression.op = node.getFirstChild().toString();
                                    aSTPreOrPostfixExpression.setOperand((ASTExpression)this.transformTree(node.getLastChild()));
                                    return aSTPreOrPostfixExpression;
                                }
                                if (node instanceof ArrayAccess) {
                                    ASTArrayAccess aSTArrayAccess = new ASTArrayAccess();
                                    aSTArrayAccess.array = (ASTExpression)this.transformTree(node.getFirstChild());
                                    aSTArrayAccess.index = (ASTExpression)this.transformTree((Node)node.get(2));
                                    return aSTArrayAccess;
                                }
                                if (node instanceof MethodReference) {
                                    ASTMethodReference aSTMethodReference = new ASTMethodReference();
                                    aSTMethodReference.typeExpression = (ASTTypeExpression)this.transformTree(node.getFirstChild(), true);
                                    aSTMethodReference.identifier = (ASTExpression)this.transformTree(node.getLastChild());
                                    return aSTMethodReference;
                                }
                                if (!(node instanceof TernaryExpression)) break block66;
                                ASTTernaryExpression aSTTernaryExpression2 = aSTTernaryExpression = new ASTTernaryExpression();
                                aSTTernaryExpression.condition = (ASTExpression)this.transformTree(node.getFirstChild());
                                aSTTernaryExpression.trueValue = (ASTExpression)this.transformTree((Node)node.get(2));
                                aSTTernaryExpression.falseValue = (ASTExpression)this.transformTree(node.getLastChild());
                                break block65;
                            }
                            if (!(node instanceof ConditionalOrExpression) && !(node instanceof ConditionalAndExpression) && !(node instanceof InclusiveOrExpression) && !(node instanceof ExclusiveOrExpression) && !(node instanceof AndExpression) && !(node instanceof EqualityExpression) && !(node instanceof RelationalExpression) && !(node instanceof ShiftExpression) && !(node instanceof AdditiveExpression) && !(node instanceof MultiplicativeExpression)) break block67;
                            int n = node.size();
                            ASTBinaryExpression aSTBinaryExpression5 = aSTBinaryExpression3 = new ASTBinaryExpression();
                            aSTBinaryExpression3.op = ((Operator)node.get(1)).toString();
                            aSTBinaryExpression3.setLhs((ASTExpression)this.transformTree((Node)node.get(0)));
                            aSTBinaryExpression3.setRhs((ASTExpression)this.transformTree((Node)node.get(2)));
                            if (n > 3) {
                                for (int i = 3; i < n; i += 2) {
                                    void var5_53;
                                    ASTBinaryExpression newNode = new ASTBinaryExpression();
                                    newNode.op = ((Operator)node.get(i)).toString();
                                    newNode.setRhs((ASTExpression)this.transformTree((Node)node.get(i + 1)));
                                    newNode.setLhs((ASTExpression)var5_53);
                                    ASTBinaryExpression aSTBinaryExpression6 = newNode;
                                    ASTBinaryExpression aSTBinaryExpression7 = newNode;
                                }
                            }
                            break block65;
                        }
                        if (node instanceof ObjectCastExpression) {
                            ASTExpression aSTExpression = (ASTExpression)this.transformTree((Node)node.get(3));
                            aSTExpression.cast = (ASTTypeExpression)this.transformTree((Node)node.get(1), true);
                            return aSTExpression;
                        }
                        if (node instanceof InstanceOfExpression) {
                            ASTInstanceofExpression aSTInstanceofExpression = new ASTInstanceofExpression();
                            aSTInstanceofExpression.instance = (ASTExpression)this.transformTree(node.getFirstChild());
                            aSTInstanceofExpression.typeExpression = (ASTTypeExpression)this.transformTree(node.getLastChild(), true);
                            return aSTInstanceofExpression;
                        }
                        if (!(node instanceof AssignmentExpression)) break block68;
                        ASTBinaryExpression aSTBinaryExpression8 = aSTBinaryExpression2 = new ASTBinaryExpression();
                        aSTBinaryExpression2.op = "=";
                        aSTBinaryExpression2.setLhs((ASTExpression)this.transformTree(node.getFirstChild()));
                        aSTBinaryExpression2.setRhs((ASTExpression)this.transformTree(node.getLastChild()));
                        break block65;
                    }
                    if (node instanceof BreakStatement) {
                        return new ASTBreakOrContinueStatement(true);
                    }
                    if (node instanceof ContinueStatement) {
                        return new ASTBreakOrContinueStatement(false);
                    }
                    if (node instanceof ExpressionStatement) {
                        ASTExpressionStatement aSTExpressionStatement = new ASTExpressionStatement();
                        aSTExpressionStatement.setValue((ASTExpression)this.transformTree((Node)node.get(0)));
                        return aSTExpressionStatement;
                    }
                    if (node instanceof ThrowStatement) {
                        ASTThrowStatement aSTThrowStatement = new ASTThrowStatement();
                        aSTThrowStatement.setValue((ASTExpression)this.transformTree((Node)node.get(1)));
                        return aSTThrowStatement;
                    }
                    if (node instanceof LocalVariableDeclaration) {
                        return this.transformLocalVariableDeclaration(node, forType);
                    }
                    if (node instanceof CodeBlock) {
                        ASTStatementList aSTStatementList = new ASTStatementList();
                        Iterator iterator = node.iterator();
                        while (iterator.hasNext()) {
                            Node child = (Node)iterator.next();
                            if (child instanceof Delimiter) continue;
                            aSTStatementList.add((ASTStatement)this.transformTree(child));
                        }
                        return aSTStatementList;
                    }
                    if (node instanceof FieldDeclaration) {
                        return this.transformFieldDeclaration(node);
                    }
                    if (node instanceof ReturnStatement) {
                        ASTReturnStatement aSTReturnStatement = new ASTReturnStatement();
                        if (node.size() <= 2) return aSTReturnStatement;
                        aSTReturnStatement.value = (ASTExpression)this.transformTree((Node)node.get(1));
                        return aSTReturnStatement;
                    }
                    if (node instanceof IfStatement) {
                        ASTIfStatement aSTIfStatement = new ASTIfStatement();
                        Expression expression = ((IfStatement)node).getCondition();
                        aSTIfStatement.condition = (ASTExpression)this.transformTree(expression);
                        Statement statement = ((IfStatement)node).getThenBlock();
                        aSTIfStatement.thenStmts = (ASTStatement)this.transformTree(statement);
                        Statement statement2 = ((IfStatement)node).getElseBlock();
                        if (statement2 == null) return aSTIfStatement;
                        aSTIfStatement.elseStmts = (ASTStatement)this.transformTree(statement2);
                        return aSTIfStatement;
                    }
                    if (node instanceof WhileStatement) {
                        ASTWhileStatement aSTWhileStatement = new ASTWhileStatement();
                        aSTWhileStatement.condition = (ASTExpression)this.transformTree((Node)node.get(2));
                        aSTWhileStatement.statements = (ASTStatement)this.transformTree(node.getLastChild());
                        return aSTWhileStatement;
                    }
                    if (node instanceof DoStatement) {
                        ASTDoStatement aSTDoStatement = new ASTDoStatement();
                        int n = node.size();
                        aSTDoStatement.condition = (ASTExpression)this.transformTree((Node)node.get(n - 3));
                        aSTDoStatement.statements = (ASTStatement)this.transformTree(node.firstChildOfType(CodeBlock.class));
                        return aSTDoStatement;
                    }
                    if (node instanceof BasicForStatement) {
                        return this.transformBasicForStatement(node, forType);
                    }
                    if (node instanceof EnhancedForStatement) {
                        return this.transformEnhancedForStatement(node, forType);
                    }
                    if (node instanceof ClassicSwitchStatement) {
                        return this.transformClassicSwitchStatement(node);
                    }
                    if (node instanceof MethodDeclaration) return this.transformMethodOrConstructor(node);
                    if (node instanceof ConstructorDeclaration) {
                        return this.transformMethodOrConstructor(node);
                    }
                    if (!(node instanceof StatementExpression)) break block69;
                    Node node3 = node.getLastChild();
                    if (node3 instanceof MethodCall) {
                        return this.transformMethodCall(node3);
                    }
                    if (!(node3 instanceof AssignmentExpression)) {
                        if (node3 instanceof PostfixExpression) return this.transformTree(node3);
                        if (node3 instanceof PreDecrementExpression) return this.transformTree(node3);
                        if (!(node3 instanceof PreIncrementExpression)) throw new UnsupportedOperationException("node is '" + node3 + "' class " + Translator.getSimpleName(node3));
                        return this.transformTree(node3);
                    }
                    ASTBinaryExpression aSTBinaryExpression9 = aSTBinaryExpression = new ASTBinaryExpression();
                    aSTBinaryExpression.op = ((Node)node3.get(1)).toString();
                    aSTBinaryExpression.setLhs((ASTExpression)this.transformTree(node3.getFirstChild()));
                    aSTBinaryExpression.setRhs((ASTExpression)this.transformTree(node3.getLastChild()));
                    break block65;
                }
                if (node instanceof AssertStatement) {
                    ASTAssertStatement aSTAssertStatement = new ASTAssertStatement();
                    aSTAssertStatement.condition = (ASTExpression)this.transformTree((Node)node.get(1));
                    if (node.size() < 4) return aSTAssertStatement;
                    aSTAssertStatement.message = (ASTExpression)this.transformTree((Node)node.get(3));
                    return aSTAssertStatement;
                }
                if (node instanceof ExplicitConstructorInvocation) {
                    ASTExplicitConstructorInvocation aSTExplicitConstructorInvocation = new ASTExplicitConstructorInvocation();
                    aSTExplicitConstructorInvocation.receiver = (ASTExpression)this.transformTree(node.getFirstChild());
                    this.processArguments(aSTExplicitConstructorInvocation, node.firstChildOfType(InvocationArguments.class));
                    return aSTExplicitConstructorInvocation;
                }
                if (node instanceof ClassicTryStatement) break block70;
                if (node instanceof EnumDeclaration) {
                    ASTEnumDeclaration aSTEnumDeclaration = new ASTEnumDeclaration();
                    aSTEnumDeclaration.name = ((Token)node.getNamedChild("name")).toString();
                    this.addNestedDeclaration(aSTEnumDeclaration.name);
                    List<Node> list = node.getNamedChild("body").getNamedChildList("values");
                    Iterator<Node> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Node child = iterator.next();
                        aSTEnumDeclaration.addValue(((Token)child).toString());
                    }
                    return aSTEnumDeclaration;
                }
                if (node instanceof ClassDeclaration) {
                    ASTClassDeclaration aSTClassDeclaration = new ASTClassDeclaration();
                    aSTClassDeclaration.name = ((Token)node.getNamedChild("name")).toString();
                    this.addNestedDeclaration(aSTClassDeclaration.name);
                    List<Node> list = node.getLastChild().getNamedChildList("decls");
                    Iterator<Node> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Node decl = iterator.next();
                        aSTClassDeclaration.addDeclaration((ASTStatement)this.transformTree(decl));
                    }
                    return aSTClassDeclaration;
                }
                if (node instanceof FinallyBlock) {
                    Node node4 = this.transformTree((Node)node.get(1), forType);
                } else if (node instanceof EmptyStatement) {
                    ASTStatementList aSTStatementList = new ASTStatementList();
                } else if (node instanceof ReferenceType) {
                    Node node5 = node.firstChildOfType(PrimitiveArrayType.class);
                    if (node5 != null) {
                        Node node6 = this.transformTree(node5, forType);
                    } else {
                        Node node7 = node.firstChildOfType(ObjectType.class);
                        if (node7 != null) {
                            Node node8 = this.transformTree(node7, forType);
                            if (node.toString().contains("[")) {
                                ((ASTTypeExpression)node8).isArray = true;
                            }
                        }
                    }
                }
            }
            if (var3_15 != null) return var3_15;
            String string = String.format("Cannot transform %s at %s", Translator.getSimpleName(node), node.getLocation());
            throw new UnsupportedOperationException(string);
        }
        ASTTryStatement aSTTryStatement = new ASTTryStatement();
        aSTTryStatement.block = (ASTStatement)this.transformTree(node.getNamedChild("block"));
        List<Node> list = node.getNamedChildList("catchBlocks");
        Iterator<Node> child = list.iterator();
        while (true) {
            if (!child.hasNext()) {
                Node fb = node.getNamedChild("finallyBlock");
                if (fb == null) return aSTTryStatement;
                aSTTryStatement.finallyBlock = (ASTStatement)this.transformTree(fb);
                return aSTTryStatement;
            }
            Node cb = child.next();
            ASTExceptionInfo info = new ASTExceptionInfo();
            List<Node> excTypes = cb.getNamedChildList("exceptionTypes");
            for (Node et : excTypes) {
                info.addExceptionType((ASTTypeExpression)this.transformTree(et, true));
            }
            info.variable = ((Token)cb.getNamedChild("varDecl")).toString();
            info.block = (ASTStatement)this.transformTree(cb.getLastChild());
            aSTTryStatement.addCatchBlock(info);
        }
    }

    protected Node transformTree(Node node) {
        return this.transformTree(node, false);
    }

    public void fail() throws UnsupportedOperationException {
        String message = String.format("not supported by translator for the '%s' language", this.appSettings.getCodeLang());
        throw new UnsupportedOperationException(message);
    }

    public boolean isNull(ASTExpression expr) {
        String literal;
        return expr instanceof ASTPrimaryExpression && (literal = ((ASTPrimaryExpression)expr).getLiteral()) != null && literal.equals("null");
    }

    protected void translatePrimaryExpression(ASTPrimaryExpression expr, TranslationContext ctx, StringBuilder result) {
        this.fail();
    }

    protected void translateUnaryExpression(ASTUnaryExpression expr, TranslationContext ctx, StringBuilder result) {
        this.fail();
    }

    protected List<String> getImportParts(String javaName, String prefix) {
        if (!javaName.startsWith(prefix)) {
            String s = String.format("Cannot translate import %s", javaName);
            throw new UnsupportedOperationException(s);
        }
        javaName = javaName.substring(prefix.length());
        return new ArrayList<String>(Arrays.asList(javaName.split("\\.")));
    }

    public void translateImport(String javaName, StringBuilder result) {
        this.fail();
    }

    protected void translateBinaryExpression(ASTBinaryExpression expr, StringBuilder result) {
        this.fail();
    }

    protected void translateTernaryExpression(ASTTernaryExpression expr, StringBuilder result) {
        this.fail();
    }

    protected void translateInstanceofExpression(ASTInstanceofExpression expr, StringBuilder result) {
        this.fail();
    }

    protected void translateArrayAccess(ASTArrayAccess expr, StringBuilder result) {
        this.fail();
    }

    protected boolean belongsToClass(ASTInvocation expr) {
        ASTExpression rhs;
        ASTExpression lhs;
        boolean result = false;
        ASTExpression receiver = expr.getReceiver();
        if (receiver instanceof ASTBinaryExpression && (lhs = ((ASTBinaryExpression)receiver).getLhs()) instanceof ASTInvocation && (receiver = ((ASTInvocation)lhs).getReceiver()) instanceof ASTBinaryExpression && ((ASTBinaryExpression)receiver).getOp().equals(".") && (rhs = ((ASTBinaryExpression)receiver).getRhs()) instanceof ASTPrimaryExpression && ((ASTPrimaryExpression)rhs).getName().equals("getClass")) {
            result = true;
        }
        return result;
    }

    protected void translateInvocation(ASTInvocation expr, StringBuilder result) {
        this.fail();
    }

    protected final void internalTranslateExpression(ASTExpression expr, TranslationContext ctx, StringBuilder result) {
        ASTTypeExpression cast = expr.getCast();
        if (this.isTyped && cast != null) {
            result.append('(');
            this.translateCast(cast, result);
        }
        if (expr instanceof ASTPrimaryExpression) {
            this.translatePrimaryExpression((ASTPrimaryExpression)expr, ctx, result);
        } else if (expr instanceof ASTUnaryExpression) {
            this.translateUnaryExpression((ASTUnaryExpression)expr, ctx, result);
        } else if (expr instanceof ASTBinaryExpression) {
            this.translateBinaryExpression((ASTBinaryExpression)expr, result);
        } else if (expr instanceof ASTTernaryExpression) {
            this.translateTernaryExpression((ASTTernaryExpression)expr, result);
        } else if (expr instanceof ASTInvocation) {
            this.translateInvocation((ASTInvocation)expr, result);
        } else if (expr instanceof ASTInstanceofExpression) {
            this.translateInstanceofExpression((ASTInstanceofExpression)expr, result);
        } else if (expr instanceof ASTArrayAccess) {
            this.translateArrayAccess((ASTArrayAccess)expr, result);
        } else if (expr instanceof ASTMethodReference) {
            this.internalTranslateExpression(((ASTMethodReference)expr).getTypeExpression(), TranslationContext.UNKNOWN, result);
            result.append('.');
            this.internalTranslateExpression(((ASTMethodReference)expr).getIdentifier(), TranslationContext.UNKNOWN, result);
        } else {
            throw new UnsupportedOperationException("node is '" + expr + "' class " + Translator.getSimpleName(expr));
        }
        if (this.isTyped && cast != null) {
            result.append(')');
        }
    }

    protected void translateCast(ASTTypeExpression cast, StringBuilder result) {
        this.fail();
    }

    public void translateExpression(Node expr, StringBuilder result) {
        ASTExpression node = (ASTExpression)this.transformTree(expr);
        this.internalTranslateExpression(node, TranslationContext.UNKNOWN, result);
    }

    protected void addIndent(int amount, StringBuilder result) {
        for (int i = 0; i < amount; ++i) {
            result.append(' ');
        }
    }

    protected void internalTranslateStatement(ASTStatement stmt, int indent, StringBuilder result) {
        this.fail();
    }

    public void translateStatement(Node stmt, int indent, StringBuilder result) {
        ASTStatement node = (ASTStatement)this.transformTree(stmt);
        this.internalTranslateStatement(node, indent, result);
    }

    public void translateProperties(String name, int indent, StringBuilder result) {
        if (!this.properties.isEmpty()) {
            this.propertyMap.put(name, this.properties.keySet());
        }
    }

    public String translateNonterminalArgs(InvocationArguments args) {
        StringBuilder result = new StringBuilder();
        for (Node child : args) {
            if (!(child instanceof Expression)) continue;
            ASTExpression expr = (ASTExpression)this.transformTree(child);
            this.internalTranslateExpression(expr, TranslationContext.UNKNOWN, result);
            result.append(", ");
        }
        result.setLength(result.length() - 2);
        return result.toString();
    }

    public String translateTypeName(String name) {
        this.fail();
        return null;
    }

    protected void translateType(ASTTypeExpression expr, StringBuilder result) {
        this.fail();
    }

    protected void translateFormals(List<ASTFormalParameter> formals, SymbolTable symbols, boolean withType, boolean typeFirst, StringBuilder result) {
        int n = formals.size();
        if (symbols == null) {
            symbols = this.topSymbols();
        }
        for (int i = 0; i < n; ++i) {
            ASTFormalParameter formal = formals.get(i);
            String name = formal.getName();
            String ident = this.translateIdentifier(name, TranslationContext.PARAMETER);
            ASTTypeExpression type = formal.getTypeExpression();
            if (!withType) {
                result.append(ident);
            } else if (typeFirst) {
                this.translateType(type, result);
                result.append(' ');
                result.append(ident);
            } else {
                result.append(ident);
                result.append(' ');
                this.translateType(type, result);
            }
            if (i < n - 1) {
                result.append(", ");
            }
            symbols.put(name, type);
        }
    }

    protected List<ASTFormalParameter> transformFormals(List<FormalParameter> formals) {
        ArrayList<ASTFormalParameter> result = new ArrayList<ASTFormalParameter>();
        for (FormalParameter fp : formals) {
            result.add(this.transformFormal(fp));
        }
        return result;
    }

    public void translateFormals(List<FormalParameter> formals, SymbolTable symbols, StringBuilder result) {
        this.fail();
    }

    public String translateInjectedClass(CodeInjector injector, String name) {
        this.fail();
        return null;
    }

    protected void processVariableDeclaration(ASTTypeExpression type, ASTPrimaryExpression name, boolean isField, boolean isProperty) {
        String s = name.getName();
        if (!isField) {
            this.addSymbol(s, type);
        } else {
            this.fields.put(s, type);
            if (isProperty) {
                this.properties.put(s, type);
            }
        }
    }

    protected boolean isList(ASTExpression node) {
        if (!(node instanceof ASTPrimaryExpression)) {
            return false;
        }
        ASTPrimaryExpression pe = (ASTPrimaryExpression)node;
        String name = pe.getName();
        if (name == null) {
            return false;
        }
        return name.equals("ArrayList");
    }

    protected boolean isSet(ASTExpression node) {
        if (!(node instanceof ASTPrimaryExpression)) {
            return false;
        }
        ASTPrimaryExpression pe = (ASTPrimaryExpression)node;
        String name = pe.getName();
        if (name == null) {
            return false;
        }
        return name.equals("HashSet");
    }

    protected boolean isMap(ASTExpression node) {
        if (!(node instanceof ASTPrimaryExpression)) {
            return false;
        }
        ASTPrimaryExpression pe = (ASTPrimaryExpression)node;
        String name = pe.getName();
        if (name == null) {
            return false;
        }
        return name.equals("HashMap");
    }

    protected void processForIteration(List<ASTExpression> iteration, int indent, StringBuilder result) {
        this.addIndent(indent, result);
        int n = iteration.size();
        for (int i = 0; i < n; ++i) {
            ASTExpression e = iteration.get(i);
            this.internalTranslateExpression(e, TranslationContext.UNKNOWN, result);
            if (i >= n - 1) continue;
            result.append("; ");
        }
    }

    protected boolean needsParentheses(ASTExpression expr) {
        boolean result = true;
        if (expr instanceof ASTPrimaryExpression || expr instanceof ASTInstanceofExpression) {
            result = false;
        } else if (expr instanceof ASTUnaryExpression) {
            result = this.needsParentheses(((ASTUnaryExpression)expr).getOperand());
        } else if (expr instanceof ASTBinaryExpression) {
            String op = ((ASTBinaryExpression)expr).getOp();
            result = op.equals(".") || op.equals("=") ? false : expr.getParent() != null;
        }
        return result;
    }

    protected void processBinaryExpression(boolean parens, ASTExpression lhs, String xop, ASTExpression rhs, StringBuilder result) {
        boolean isDot = xop.equals(".");
        if (parens) {
            result.append('(');
        }
        this.internalTranslateExpression(lhs, TranslationContext.UNKNOWN, result);
        if (!isDot) {
            result.append(' ');
        }
        result.append(xop);
        if (!isDot) {
            result.append(' ');
        }
        this.internalTranslateExpression(rhs, TranslationContext.UNKNOWN, result);
        if (parens) {
            result.append(')');
        }
    }

    protected boolean hasUnconditionalExit(ASTStatementList statementList) {
        boolean result = false;
        for (ASTStatement stmt : statementList.statements) {
            if (!(stmt instanceof ASTReturnStatement) && !(stmt instanceof ASTBreakOrContinueStatement)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected ASTTypeExpression getExpressionType(ASTExpression expr) {
        ASTExpression receiver;
        ASTTypeExpression result = null;
        if (expr instanceof ASTPrimaryExpression) {
            ASTPrimaryExpression pe = (ASTPrimaryExpression)expr;
            String s = pe.getName();
            result = this.findSymbol(s);
        } else if (expr instanceof ASTInvocation && (receiver = ((ASTInvocation)expr).receiver) instanceof ASTBinaryExpression) {
            ASTExpression lhs = ((ASTBinaryExpression)receiver).lhs;
            ASTExpression rhs = ((ASTBinaryExpression)receiver).rhs;
            ASTTypeExpression te = this.getExpressionType(lhs);
            if (te != null && te.name.equals("Token") && rhs instanceof ASTPrimaryExpression && ((ASTPrimaryExpression)rhs).name.equals("getType")) {
                result = new ASTTypeExpression();
                result.name = "TokenType";
            }
        }
        return result;
    }

    protected boolean isEnumSet(ASTExpression receiver) {
        ASTExpression lhs;
        boolean result = false;
        if (receiver instanceof ASTBinaryExpression && (lhs = ((ASTBinaryExpression)receiver).getLhs()) instanceof ASTPrimaryExpression) {
            result = ((ASTPrimaryExpression)lhs).getName().equals("EnumSet");
        }
        return result;
    }

    protected void translateArguments(List<ASTExpression> arguments, boolean parens, StringBuilder result) {
        int nargs;
        if (arguments == null || (nargs = arguments.size()) == 0) {
            result.append("()");
        } else {
            if (parens) {
                result.append('(');
            }
            for (int i = 0; i < nargs; ++i) {
                this.internalTranslateExpression(arguments.get(i), TranslationContext.PARAMETER, result);
                if (i >= nargs - 1) continue;
                result.append(", ");
            }
            if (parens) {
                result.append(')');
            }
        }
    }

    protected boolean isTokenType(ASTExpression expr) {
        boolean result = false;
        ASTTypeExpression te = this.getExpressionType(expr);
        if (te != null) {
            result = te.name.equals("TokenType");
        }
        return result;
    }

    protected void addNestedDeclaration(String name) {
        if (this.nestedDeclarations == null) {
            this.nestedDeclarations = new HashMap<String, Set<String>>();
        }
        Set existing = this.nestedDeclarations.computeIfAbsent(this.currentClass, k -> new LinkedHashSet());
        existing.add(name);
    }

    public void startClass(String name, boolean ignoredFields, StringBuilder ignoredResult) {
        this.currentClass = name;
    }

    public void endClass(String name, boolean fields, StringBuilder result) {
        if (!this.currentClass.equals(name)) {
            throw new IllegalStateException("Unexpected end of class");
        }
        this.currentClass = null;
    }

    public static class SymbolTable
    extends HashMap<String, ASTTypeExpression> {
    }

    protected static class ASTTypeExpression
    extends ASTPrimaryExpression {
        protected boolean isArray;
        protected List<ASTTypeExpression> typeParameters;
        private static final HashSet<String> classNames = new HashSet<String>(Arrays.asList("Integer", "Long", "Float", "Double", "BigInteger"));

        protected ASTTypeExpression() {
        }

        public boolean isBoolean() {
            return "boolean".equals(this.literal);
        }

        public boolean isNumeric() {
            return this.literal != null || classNames.contains(this.name);
        }

        void add(ASTTypeExpression tp) {
            if (this.typeParameters == null) {
                this.typeParameters = new ArrayList<ASTTypeExpression>();
            }
            this.typeParameters.add(tp);
        }

        public List<ASTTypeExpression> getTypeParameters() {
            return this.typeParameters;
        }
    }

    protected static class ASTPrimaryExpression
    extends ASTExpression {
        protected String name;
        protected String literal;

        public String getName() {
            return this.name;
        }

        public String getLiteral() {
            return this.literal;
        }

        protected ASTPrimaryExpression() {
        }

        protected ASTPrimaryExpression(Node parent) {
            this.setParent(parent);
        }
    }

    protected static class ASTBinaryExpression
    extends ASTExpression {
        private String op;
        private ASTExpression lhs;
        private ASTExpression rhs;

        protected ASTBinaryExpression() {
        }

        public String getOp() {
            return this.op;
        }

        public ASTExpression getLhs() {
            return this.lhs;
        }

        public ASTExpression getRhs() {
            return this.rhs;
        }

        private void setLhs(ASTExpression expr) {
            this.lhs = expr;
            expr.setParent(this);
        }

        private void setRhs(ASTExpression expr) {
            this.rhs = expr;
            this.rhs.setParent(this);
        }
    }

    protected static class ASTExpression
    extends BaseNode {
        ASTTypeExpression cast;

        public ASTTypeExpression getCast() {
            return this.cast;
        }
    }

    protected static class ASTInvocation
    extends ASTExpression {
        protected ASTExpression receiver;
        protected List<ASTExpression> arguments;

        protected ASTInvocation() {
        }

        void add(ASTExpression arg) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<ASTExpression>();
            }
            this.arguments.add(arg);
        }

        public int getArgCount() {
            int result = 0;
            if (this.arguments != null) {
                result = this.arguments.size();
            }
            return result;
        }

        public String getMethodName() {
            String result = null;
            ASTExpression node = this.receiver;
            while (result == null) {
                if (node instanceof ASTPrimaryExpression) {
                    result = ((ASTPrimaryExpression)node).name;
                    if (result != null) continue;
                    result = ((ASTPrimaryExpression)node).literal;
                    continue;
                }
                if (node instanceof ASTBinaryExpression) {
                    node = ((ASTBinaryExpression)node).rhs;
                    continue;
                }
                throw new UnsupportedOperationException("node is '" + node + "' class " + Translator.getSimpleName(node));
            }
            return result;
        }

        public ASTExpression getReceiver() {
            return this.receiver;
        }

        public List<ASTExpression> getArguments() {
            return this.arguments;
        }

        public void setReceiver(ASTExpression receiver) {
            this.receiver = receiver;
        }
    }

    protected static class ASTFormalParameter
    extends BaseNode {
        protected boolean isFinal;
        protected ASTTypeExpression typeExpression;
        protected String name;

        protected ASTFormalParameter() {
        }

        public ASTTypeExpression getTypeExpression() {
            return this.typeExpression;
        }

        public String getName() {
            return this.name;
        }
    }

    protected static class ASTVariableOrFieldDeclaration
    extends ASTStatement {
        ASTTypeExpression typeExpression;
        List<ASTPrimaryExpression> names;
        List<ASTExpression> initializers;
        Set<String> annotations;
        boolean field;
        List<String> modifiers;

        protected ASTVariableOrFieldDeclaration() {
        }

        public boolean isField() {
            return this.field;
        }

        public ASTTypeExpression getTypeExpression() {
            return this.typeExpression;
        }

        public List<ASTPrimaryExpression> getNames() {
            return this.names;
        }

        public List<ASTExpression> getInitializers() {
            return this.initializers;
        }

        public boolean hasAnnotation(String annotation) {
            return this.annotations != null && this.annotations.contains(annotation);
        }

        public List<String> getModifiers() {
            return this.modifiers;
        }

        private void addModifier(String modifier) {
            if (this.modifiers == null) {
                this.modifiers = new ArrayList<String>();
            }
            this.modifiers.add(modifier);
        }

        private void addAnnotation(String annotation) {
            if (this.annotations == null) {
                this.annotations = new LinkedHashSet<String>();
            }
            this.annotations.add(annotation);
        }

        private void addNameAndInitializer(ASTPrimaryExpression name, ASTExpression initializer) {
            if (this.names == null) {
                this.names = new ArrayList<ASTPrimaryExpression>();
                this.initializers = new ArrayList<ASTExpression>();
            }
            this.names.add(name);
            this.initializers.add(initializer);
        }

        public boolean hasInitializer() {
            if (this.initializers == null) {
                return false;
            }
            for (ASTExpression e : this.initializers) {
                if (e == null) continue;
                return true;
            }
            return false;
        }
    }

    protected static class ASTForStatement
    extends ASTStatement {
        private ASTVariableOrFieldDeclaration variable;
        private ASTExpression iterable;
        private ASTExpression condition;
        private ASTStatement statements;
        private List<ASTExpression> iteration;

        protected ASTForStatement() {
        }

        public ASTVariableOrFieldDeclaration getVariable() {
            return this.variable;
        }

        public ASTExpression getIterable() {
            return this.iterable;
        }

        public ASTExpression getCondition() {
            return this.condition;
        }

        public ASTStatement getStatements() {
            return this.statements;
        }

        public List<ASTExpression> getIteration() {
            return this.iteration;
        }

        void add(ASTExpression iter) {
            if (this.iteration == null) {
                this.iteration = new ArrayList<ASTExpression>();
            }
            this.iteration.add(iter);
        }
    }

    protected static class ASTStatement
    extends BaseNode {
        protected ASTStatement() {
        }
    }

    protected static class ASTSwitchStatement
    extends ASTStatement {
        protected ASTExpression variable;
        protected List<ASTCaseStatement> cases;

        protected ASTSwitchStatement() {
        }

        public ASTExpression getVariable() {
            return this.variable;
        }

        public List<ASTCaseStatement> getCases() {
            return this.cases;
        }

        void add(ASTCaseStatement c) {
            if (this.cases == null) {
                this.cases = new ArrayList<ASTCaseStatement>();
            }
            this.cases.add(c);
        }
    }

    protected static class ASTCaseStatement
    extends ASTStatement {
        private List<ASTExpression> caseLabels;
        private ASTStatementList statements;
        private boolean hasBreak;

        protected ASTCaseStatement() {
        }

        public List<ASTExpression> getCaseLabels() {
            return this.caseLabels;
        }

        public ASTStatementList getStatements() {
            return this.statements;
        }

        void add(ASTStatement stmt) {
            if (this.statements == null) {
                this.statements = new ASTStatementList();
            }
            this.statements.add(stmt);
        }

        public boolean hasBreak() {
            return this.hasBreak;
        }
    }

    protected static class ASTBreakOrContinueStatement
    extends ASTStatement {
        private final boolean isBreak;

        public ASTBreakOrContinueStatement(boolean isBreak) {
            this.isBreak = isBreak;
        }

        public boolean isBreak() {
            return this.isBreak;
        }
    }

    protected static class ASTMethodDeclaration
    extends ASTStatementWithName {
        protected List<String> modifiers;
        protected ASTTypeExpression returnType;
        protected List<ASTFormalParameter> parameters;
        protected ASTStatementList statements;
        protected boolean constructor;

        protected ASTMethodDeclaration() {
        }

        public List<String> getModifiers() {
            return this.modifiers;
        }

        void addModifier(String modifier) {
            if (this.modifiers == null) {
                this.modifiers = new ArrayList<String>();
            }
            this.modifiers.add(modifier);
        }

        public boolean isConstructor() {
            return this.constructor;
        }

        void addParameter(ASTFormalParameter parameter) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<ASTFormalParameter>();
            }
            this.parameters.add(parameter);
        }

        public List<ASTFormalParameter> getParameters() {
            return this.parameters;
        }

        public ASTStatementList getStatements() {
            return this.statements;
        }

        public ASTTypeExpression getReturnType() {
            return this.returnType;
        }
    }

    protected static class ASTStatementList
    extends ASTStatement {
        boolean initializer;
        private List<ASTStatement> statements;

        protected ASTStatementList() {
        }

        public List<ASTStatement> getStatements() {
            return this.statements;
        }

        public boolean isInitializer() {
            return this.initializer;
        }

        void add(ASTStatement stmt) {
            if (this.statements == null) {
                this.statements = new ArrayList<ASTStatement>();
            }
            this.statements.add(stmt);
        }
    }

    protected static class ASTAllocation
    extends ASTInvocation {
        protected ASTAllocation() {
        }
    }

    protected static class ASTUnaryExpression
    extends ASTExpression {
        protected String op;
        private ASTExpression operand;

        protected ASTUnaryExpression() {
        }

        public String getOp() {
            return this.op;
        }

        public ASTExpression getOperand() {
            return this.operand;
        }

        public void setOperand(ASTExpression expr) {
            this.operand = expr;
            expr.setParent(this);
        }
    }

    protected static class ASTPreOrPostfixExpression
    extends ASTUnaryExpression {
        protected ASTPreOrPostfixExpression() {
        }
    }

    protected static class ASTArrayAccess
    extends ASTExpression {
        protected ASTExpression array;
        protected ASTExpression index;

        protected ASTArrayAccess() {
        }

        public ASTExpression getArray() {
            return this.array;
        }

        public ASTExpression getIndex() {
            return this.index;
        }
    }

    protected static class ASTMethodReference
    extends ASTExpression {
        protected ASTTypeExpression typeExpression;
        protected ASTExpression identifier;

        protected ASTMethodReference() {
        }

        public ASTTypeExpression getTypeExpression() {
            return this.typeExpression;
        }

        public ASTExpression getIdentifier() {
            return this.identifier;
        }
    }

    protected static class ASTTernaryExpression
    extends ASTExpression {
        private ASTExpression condition;
        private ASTExpression trueValue;
        private ASTExpression falseValue;

        protected ASTTernaryExpression() {
        }

        public ASTExpression getCondition() {
            return this.condition;
        }

        public ASTExpression getTrueValue() {
            return this.trueValue;
        }

        public ASTExpression getFalseValue() {
            return this.falseValue;
        }
    }

    protected static class ASTInstanceofExpression
    extends ASTExpression {
        private ASTExpression instance;
        private ASTTypeExpression typeExpression;

        protected ASTInstanceofExpression() {
        }

        public ASTExpression getInstance() {
            return this.instance;
        }

        public ASTTypeExpression getTypeExpression() {
            return this.typeExpression;
        }
    }

    protected static class ASTExpressionStatement
    extends ASTStatement {
        private ASTExpression value;

        protected ASTExpressionStatement() {
        }

        public ASTExpression getValue() {
            return this.value;
        }

        public void setValue(ASTExpression value) {
            this.value = value;
        }
    }

    protected static class ASTThrowStatement
    extends ASTExpressionStatement {
        protected ASTThrowStatement() {
        }
    }

    protected static class ASTReturnStatement
    extends ASTStatement {
        private ASTExpression value;

        protected ASTReturnStatement() {
        }

        public ASTExpression getValue() {
            return this.value;
        }
    }

    protected static class ASTIfStatement
    extends ASTStatement {
        private ASTExpression condition;
        private ASTStatement thenStmts;
        private ASTStatement elseStmts;

        protected ASTIfStatement() {
        }

        public ASTExpression getCondition() {
            return this.condition;
        }

        public ASTStatement getThenStmts() {
            return this.thenStmts;
        }

        public ASTStatement getElseStmts() {
            return this.elseStmts;
        }
    }

    protected static class ASTWhileStatement
    extends ASTStatement {
        protected ASTExpression condition;
        protected ASTStatement statements;

        protected ASTWhileStatement() {
        }

        public ASTExpression getCondition() {
            return this.condition;
        }

        public ASTStatement getStatements() {
            return this.statements;
        }
    }

    protected static class ASTDoStatement
    extends ASTWhileStatement {
        protected ASTDoStatement() {
        }
    }

    protected static class ASTAssertStatement
    extends ASTStatement {
        protected ASTExpression condition;
        protected ASTExpression message;

        protected ASTAssertStatement() {
        }

        public ASTExpression getCondition() {
            return this.condition;
        }

        public ASTExpression getMessage() {
            return this.message;
        }
    }

    protected static class ASTExplicitConstructorInvocation
    extends ASTInvocation {
        protected ASTExplicitConstructorInvocation() {
        }
    }

    protected static class ASTTryStatement
    extends ASTStatement {
        protected ASTStatement block;
        protected List<ASTExceptionInfo> catchBlocks;
        protected ASTStatement finallyBlock;

        protected ASTTryStatement() {
        }

        protected void addCatchBlock(ASTExceptionInfo info) {
            if (this.catchBlocks == null) {
                this.catchBlocks = new ArrayList<ASTExceptionInfo>();
            }
            this.catchBlocks.add(info);
        }

        public ASTStatement getBlock() {
            return this.block;
        }

        public List<ASTExceptionInfo> getCatchBlocks() {
            return this.catchBlocks;
        }

        public ASTStatement getFinallyBlock() {
            return this.finallyBlock;
        }
    }

    protected static class ASTExceptionInfo {
        protected List<ASTTypeExpression> exceptionTypes;
        protected String variable;
        protected ASTStatement block;

        protected ASTExceptionInfo() {
        }

        protected void addExceptionType(ASTTypeExpression te) {
            if (this.exceptionTypes == null) {
                this.exceptionTypes = new ArrayList<ASTTypeExpression>();
            }
            this.exceptionTypes.add(te);
        }

        public String getVariable() {
            return this.variable;
        }

        public ASTStatement getBlock() {
            return this.block;
        }

        public List<ASTTypeExpression> getExceptionTypes() {
            return this.exceptionTypes;
        }
    }

    protected static class ASTEnumDeclaration
    extends ASTStatementWithName {
        protected List<String> values;

        protected ASTEnumDeclaration() {
        }

        public List<String> getValues() {
            return this.values;
        }

        protected void addValue(String v) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.add(v);
        }
    }

    protected static class ASTClassDeclaration
    extends ASTStatementWithName {
        protected List<ASTStatement> declarations;

        protected ASTClassDeclaration() {
        }

        public List<ASTStatement> getDeclarations() {
            return this.declarations;
        }

        protected void addDeclaration(ASTStatement decl) {
            if (this.declarations == null) {
                this.declarations = new ArrayList<ASTStatement>();
            }
            this.declarations.add(decl);
        }
    }

    public static enum TranslationContext {
        VARIABLE,
        PARAMETER,
        METHOD,
        FIELD,
        TYPE,
        UNKNOWN;

    }

    protected static class ASTStatementWithName
    extends ASTStatement {
        protected String name;

        protected ASTStatementWithName() {
        }

        public String getName() {
            return this.name;
        }
    }
}

