/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.app;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.congocc.app.Errors;
import org.congocc.core.Grammar;

public final class Main {
    private static Logger logger = Logger.getLogger("congocc");
    public static final String PROG_NAME = "CongoCC Parser Generator";
    public static final String URL = "Go to https://discuss.congocc.org for more information.";
    private static String manifestContent = "";
    private static String jarFileName = "congocc.jar";
    private static Path jarPath;
    private static final FileSystem fileSystem;
    private static final Pattern symbolPattern;
    private static final String[] otherSupportedLanguages;

    static void checkForNewer() {
        block8: {
            if (jarPath != null && Files.exists(jarPath, new LinkOption[0]) && (jarPath.endsWith("congocc.jar") || jarPath.endsWith("congocc-full.jar"))) {
                try {
                    int byteContent;
                    long jarLastModified = Files.getLastModifiedTime(jarPath, new LinkOption[0]).toMillis();
                    if (System.currentTimeMillis() - jarLastModified < 3600000L) {
                        return;
                    }
                    URL url = new URI("https://parsers.org/download/congocc.jar").toURL();
                    URLConnection connection = url.openConnection();
                    connection.setConnectTimeout(1000);
                    long lastUpdate = connection.getLastModified();
                    if (lastUpdate <= jarLastModified) break block8;
                    System.out.println("Found newer version of congocc at " + url);
                    System.out.println("Download it? (y/N)");
                    Scanner scanner = new Scanner(System.in);
                    String response = scanner.nextLine().trim().toLowerCase();
                    if (!response.equals("y") && !response.equals("yes")) break block8;
                    boolean renamedFileSuccessfully = false;
                    String oldFilename = jarPath.getFileName().toString().replace("congocc", "congocc-" + System.currentTimeMillis());
                    Path oldPath = jarPath.resolveSibling(oldFilename);
                    try {
                        Files.move(jarPath, oldPath, new CopyOption[0]);
                        renamedFileSuccessfully = true;
                    }
                    catch (Exception e) {
                        System.out.println("Failed to save older version of jarfile");
                        System.out.println("Possibly directory " + oldPath.getParent() + " is not writeable.");
                        scanner.close();
                        return;
                    }
                    System.out.println("Updating jarfile...");
                    InputStream inputStream = url.openStream();
                    OutputStream fileOS = Files.newOutputStream(jarPath, new OpenOption[0]);
                    byte[] data = new byte[1024];
                    while ((byteContent = inputStream.read(data, 0, 1024)) != -1) {
                        fileOS.write(data, 0, byteContent);
                    }
                    fileOS.close();
                    scanner.close();
                    System.out.println("Fetched newer jarfile from server.");
                    if (renamedFileSuccessfully) {
                        System.out.println("Older jarfile is at: " + oldPath);
                    }
                    System.out.println("Exiting...");
                    System.exit(-1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static void usage() {
        ArrayList<String> validChoices = new ArrayList<String>(Arrays.asList(otherSupportedLanguages));
        validChoices.add(0, "java");
        StringBuilder sb = new StringBuilder();
        int n = validChoices.size();
        for (int i = 0; i < n; ++i) {
            sb.append(String.format("'%s'", validChoices.get(i)));
            if (i < n - 2) {
                sb.append(", ");
                continue;
            }
            if (i != n - 2) continue;
            sb.append(" and ");
        }
        System.out.println("Usage:");
        System.out.println("    java -jar " + jarFileName + " grammarfile");
        System.out.println();
        System.out.println("The following command-line flags are available:");
        System.out.println(" -d <directory>    Specify the directory (absolute or relative to the grammarfile location) to place generated files");
        System.out.println("   For example:   -d ../../src/generated");
        System.out.println("   If this is unset, files are generated relative to the grammar file location.");
        System.out.println(" -lang <language>  Specify the language to generate code in (the default is 'java')");
        System.out.println("                     (valid choices are currently " + sb + ")");
        System.out.println(" -jdkN             Specify the target JDK version. N is a number from 8 to 19. (Default is 8)");
        System.out.println("                     (this is only useful when the code generation is in Java)");
        System.out.println(" -n                Suppress the check for a newer version");
        System.out.println(" -p                Define one or more comma-separated (no spaces) symbols to pass to the preprocessor.");
        System.out.println("   For example:   -p debug,strict");
        System.out.println(" -q                Quieter output");
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Main.bannerLine();
            Main.usage();
            Main.checkForNewer();
            System.exit(1);
        }
        logger.fine(String.format("CongoCC started with command line: %s", String.join((CharSequence)" ", args)));
        Path grammarFile = null;
        Path outputDirectory = null;
        String codeLang = "java";
        int jdkTarget = 0;
        HashMap<String, String> preprocessorSymbols = new HashMap<String, String>();
        boolean quiet = false;
        boolean noNewerCheck = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if (arg.startsWith("--")) {
                    arg = arg.substring(1);
                }
                if (arg.equalsIgnoreCase("-p")) {
                    if (i == args.length - 1) {
                        System.err.println("-p flag with no preprocessor symbols afterwards");
                        System.exit(-1);
                    }
                    String symbols = args[++i];
                    StringTokenizer st = new StringTokenizer(symbols, ",");
                    while (st.hasMoreTokens()) {
                        String s = st.nextToken().trim();
                        Matcher m = symbolPattern.matcher(s);
                        if (!m.find()) {
                            System.err.printf("-p flag with invalid argument '%s'%n", s);
                            System.exit(-1);
                        }
                        String name = m.group(1);
                        String value = m.group(4);
                        if (value == null) {
                            value = "1";
                        }
                        preprocessorSymbols.put(name, value);
                    }
                    continue;
                }
                if (arg.equalsIgnoreCase("-d")) {
                    if (i == args.length - 1) {
                        System.err.println("-d flag with no output directory");
                        System.exit(-1);
                    }
                    outputDirectory = Paths.get(args[++i], new String[0]);
                    continue;
                }
                if (arg.equalsIgnoreCase("-n")) {
                    noNewerCheck = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-q") || arg.equalsIgnoreCase("-quiet")) {
                    quiet = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-lang")) {
                    String candidate;
                    if ((candidate = args[++i]).equals("java")) continue;
                    if (!Arrays.asList(otherSupportedLanguages).contains(candidate.toLowerCase())) {
                        System.err.printf("Not a supported code generation language: '%s'%n", candidate);
                        System.exit(-1);
                    }
                    codeLang = candidate.toLowerCase();
                    if (jdkTarget == 0) continue;
                    System.err.println("The -jdk flag is only compatible with a Java target.");
                    System.exit(-1);
                    continue;
                }
                if (arg.toLowerCase().startsWith("-jdk")) {
                    if (!codeLang.equals("java")) {
                        System.err.println("The -jdk flag is only compatible with a Java target.");
                        System.exit(-1);
                    }
                    String number = arg.substring(4);
                    try {
                        jdkTarget = Integer.parseInt(number);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Expecting a number after 'jdk', like -jdk11");
                    }
                    if (jdkTarget >= 8 && jdkTarget <= 19) continue;
                    System.err.println("The JDK Target currently must be between 8 and 19.");
                    continue;
                }
                System.err.println("Ignoring unknown flag: " + arg);
                continue;
            }
            if (grammarFile == null) {
                grammarFile = Paths.get(arg, new String[0]);
                if (Files.exists(grammarFile, new LinkOption[0])) continue;
                System.err.println("File " + grammarFile + " does not exist!");
                System.exit(-1);
                continue;
            }
            System.err.println("Extraneous argument " + arg);
            System.exit(-1);
        }
        if (!noNewerCheck) {
            Main.checkForNewer();
        }
        if (grammarFile == null) {
            System.err.println("No input file specified");
            System.exit(-1);
        }
        if (!Files.exists(grammarFile, new LinkOption[0])) {
            System.err.println("File " + grammarFile + " does not exist!");
            System.exit(-1);
        }
        if (outputDirectory != null && !Files.exists(outputDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(outputDirectory, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                System.err.println("Cannot create directory " + outputDirectory);
                System.exit(-1);
            }
            if (!Files.isWritable(outputDirectory)) {
                System.err.println("Cannot write to directory " + outputDirectory);
                System.exit(-1);
            }
        }
        int errorcode = Main.mainProgram(grammarFile, outputDirectory, codeLang, jdkTarget, quiet, preprocessorSymbols);
        System.exit(errorcode);
    }

    public static int mainProgram(Path grammarFile, Path outputDir, String codeLang, int jdkTarget, boolean quiet, Map<String, String> symbols) throws IOException {
        if (!quiet) {
            Main.bannerLine();
        }
        Grammar grammar = new Grammar(outputDir, codeLang, jdkTarget, quiet, symbols);
        grammar.parse(grammarFile, true);
        grammar.createOutputDir();
        Errors errors = grammar.getErrors();
        grammar.doSanityChecks();
        if (errors.getErrorCount() > 0) {
            Main.outputErrors(grammar, quiet);
            return 1;
        }
        grammar.generateLexer();
        if (errors.getErrorCount() > 0) {
            Main.outputErrors(grammar, quiet);
            return 1;
        }
        grammar.generateFiles();
        if (errors.getWarningCount() == 0 && !quiet) {
            System.out.println("Parser generated successfully.");
        } else if (errors.getWarningCount() > 0) {
            System.out.println("Parser generated with 0 errors and " + errors.getWarningCount() + " warnings.");
        }
        Main.outputErrors(grammar, quiet);
        return errors.getErrorCount() == 0 ? 0 : 1;
    }

    static void outputErrors(Grammar grammar, boolean quiet) {
        Errors errors = grammar.getErrors();
        for (String error : errors.getErrorMessages()) {
            System.err.println(error);
        }
        for (String warning : errors.getWarningMessages()) {
            System.err.println(warning);
        }
        if (!quiet && !errors.getErrorMessages().isEmpty()) {
            for (String info : errors.getInfoMessages()) {
                System.err.println(info);
            }
        }
    }

    public static void bannerLine() {
        System.out.println();
        System.out.println(PROG_NAME + Main.getBuiltOnString());
        System.out.println(URL);
        System.out.println("(type \"java -jar congocc.jar\" with no arguments for help)\n");
        System.out.println();
    }

    private static String getBuiltOnString() {
        if (manifestContent.equals("")) {
            return "";
        }
        String buildDate = "unknown date";
        String builtBy = "somebody";
        StringTokenizer st = new StringTokenizer(manifestContent, ": \t\n\r", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("Build-Date")) {
                buildDate = st.nextToken();
            }
            if (!s.equals("Built-By")) continue;
            builtBy = st.nextToken();
        }
        return " (" + jarFileName + " built by " + builtBy + " on " + buildDate + ")";
    }

    static {
        fileSystem = FileSystems.getDefault();
        symbolPattern = Pattern.compile("^(\\w+(\\.\\w+)*)(=(\\w+(\\.\\w+)*))?$");
        try {
            Enumeration<URL> urls = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                int exclamIndex;
                URL url = urls.nextElement();
                InputStream is = url.openStream();
                int available = is.available();
                byte[] bytes = new byte[available];
                is.read(bytes);
                is.close();
                String content = new String(bytes);
                if (!content.contains("congocc.app.Main")) continue;
                String path = url.getFile();
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if ((exclamIndex = path.lastIndexOf(33)) > 0) {
                    path = path.substring(0, exclamIndex);
                }
                jarPath = fileSystem.getPath(path, new String[0]);
                jarFileName = jarPath.getFileName().toString();
                manifestContent = content;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        otherSupportedLanguages = new String[]{"python", "csharp"};
    }
}

