/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.app;

import java.util.ArrayList;
import java.util.List;
import org.congocc.parser.Node;

public class Errors {
    private int parseErrorCount;
    private int warningCount;
    private final List<String> errorMessages = new ArrayList<String>();
    private final List<String> warningMessages = new ArrayList<String>();
    private final List<String> infoMessages = new ArrayList<String>();

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getParseErrorCount() {
        return this.parseErrorCount;
    }

    public void addError(String errorMessage) {
        this.errorMessages.add(errorMessage);
    }

    public void addError(Node location, String errorMessage) {
        String locationString = location == null ? "" : location.getLocation();
        this.errorMessages.add("Error: " + locationString + ":" + errorMessage);
    }

    public void addWarning(String warningMessage) {
        this.warningMessages.add(warningMessage);
    }

    public void addWarning(Node location, String warningMessage) {
        String locationString = location == null ? "" : location.getLocation();
        this.warningMessages.add("Warning: " + locationString + ":" + warningMessage);
    }

    public void addInfo(String infoMessage) {
        this.infoMessages.add(infoMessage);
    }

    public void addInfo(Node location, String infoMessage) {
        String locationString = location == null ? "" : location.getLocation();
        this.infoMessages.add("Info: " + locationString + ":" + infoMessage);
    }

    public int getErrorCount() {
        return this.errorMessages.size();
    }

    public List<String> getInfoMessages() {
        return this.infoMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }
}

