/*
 * Decompiled with CFR 0.152.
 */
package freemarker.xml;

import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.WrappedNode;
import freemarker.log.Logger;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.xml.AttributeNodeModel;
import freemarker.xml.CharacterDataNodeModel;
import freemarker.xml.DefaultXPathSupport;
import freemarker.xml.DocumentModel;
import freemarker.xml.DocumentTypeModel;
import freemarker.xml.ElementModel;
import freemarker.xml.NodeOutputter;
import freemarker.xml.PINodeModel;
import freemarker.xml.XPathSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class WrappedDomNode
implements WrappedNode,
TemplateHashModel,
TemplateSequenceModel {
    static final Logger logger = Logger.getLogger("freemarker.dom");
    private static ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (logger.isWarnEnabled()) {
                logger.warn(exception.getMessage(), exception);
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (logger.isErrorEnabled()) {
                logger.error(exception.getMessage(), exception);
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.error(exception);
            throw exception;
        }
    };
    private static DocumentBuilderFactory docBuilderFactory;
    final Node node;
    private NodeList children;
    private WrappedDomNode parent;

    public static void setDocumentBuilderFactory(DocumentBuilderFactory docBuilderFactory) {
        WrappedDomNode.docBuilderFactory = docBuilderFactory;
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
        }
        return docBuilderFactory;
    }

    public static void setErrorHandler(ErrorHandler errorHandler) {
        WrappedDomNode.errorHandler = errorHandler;
    }

    public static WrappedDomNode parse(InputSource is, boolean removeComments, boolean removePIs) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = WrappedDomNode.getDocumentBuilderFactory().newDocumentBuilder();
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        Document doc = builder.parse(is);
        if (removeComments && removePIs) {
            WrappedDomNode.simplify(doc);
        } else {
            if (removeComments) {
                WrappedDomNode.removeComments(doc);
            }
            if (removePIs) {
                WrappedDomNode.removePIs(doc);
            }
            WrappedDomNode.mergeAdjacentText(doc);
        }
        return WrappedDomNode.wrapNode(doc);
    }

    public static WrappedDomNode parse(InputSource is) throws SAXException, IOException, ParserConfigurationException {
        return WrappedDomNode.parse(is, true, true);
    }

    public static WrappedDomNode parse(File f, boolean removeComments, boolean removePIs) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = WrappedDomNode.getDocumentBuilderFactory().newDocumentBuilder();
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        Document doc = builder.parse(f);
        if (removeComments) {
            WrappedDomNode.removeComments(doc);
        }
        if (removePIs) {
            WrappedDomNode.removePIs(doc);
        }
        WrappedDomNode.mergeAdjacentText(doc);
        return WrappedDomNode.wrapNode(doc);
    }

    public static WrappedDomNode parse(File f) throws SAXException, IOException, ParserConfigurationException {
        return WrappedDomNode.parse(f, true, true);
    }

    protected WrappedDomNode(Node node) {
        this.node = node;
    }

    @Override
    public Node getWrappedObject() {
        return this.node;
    }

    @Override
    public Object get(String key) {
        XPathSupport xps;
        if (key.startsWith("@@")) {
            if (key.equals("@@text")) {
                return WrappedDomNode.getText(this.node);
            }
            if (key.equals("@@namespace")) {
                String nsURI = this.node.getNamespaceURI();
                return nsURI == null ? null : nsURI;
            }
            if (key.equals("@@local_name")) {
                String localName = this.node.getLocalName();
                if (localName == null) {
                    localName = this.getNodeName();
                }
                return localName;
            }
            if (key.equals("@@markup")) {
                StringBuilder buf = new StringBuilder();
                NodeOutputter nu = new NodeOutputter(this.node);
                nu.outputContent(this.node, buf);
                return buf.toString();
            }
            if (key.equals("@@nested_markup")) {
                StringBuilder buf = new StringBuilder();
                NodeOutputter nu = new NodeOutputter(this.node);
                nu.outputContent(this.node.getChildNodes(), buf);
                return buf.toString();
            }
            if (key.equals("@@qname")) {
                String qname = this.getQualifiedName();
                return qname == null ? null : qname;
            }
        }
        if ((xps = this.getXPathSupport()) != null) {
            return xps.executeQuery(this.node, key);
        }
        throw new EvaluationException("Can't try to resolve the XML query key, because no XPath support is available. It's either malformed or an XPath expression: " + key);
    }

    @Override
    public WrappedNode getParentNode() {
        if (this.parent == null) {
            Node parentNode = this.node.getParentNode();
            if (parentNode == null && this.node instanceof Attr) {
                parentNode = ((Attr)this.node).getOwnerElement();
            }
            this.parent = WrappedDomNode.wrapNode(parentNode);
        }
        return this.parent;
    }

    @Override
    public List<WrappedNode> getChildNodes() {
        if (this.children == null) {
            this.children = this.node.getChildNodes();
        }
        ArrayList<WrappedNode> result = new ArrayList<WrappedNode>();
        for (int i = 0; i < this.children.getLength(); ++i) {
            result.add(WrappedDomNode.wrapNode(this.children.item(i)));
        }
        return result;
    }

    @Override
    public final String getNodeType() {
        short nodeType = this.node.getNodeType();
        switch (nodeType) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "text";
            }
            case 8: {
                return "comment";
            }
            case 11: {
                return "document_fragment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "document_type";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entity_reference";
            }
            case 12: {
                return "notation";
            }
            case 7: {
                return "pi";
            }
            case 3: {
                return "text";
            }
        }
        throw new EvaluationException("Unknown node type: " + nodeType + ". This should be impossible!");
    }

    public Object exec(List<Object> args) {
        if (args.size() != 1) {
            throw new EvaluationException("Expecting exactly one arguments");
        }
        String query = (String)args.get(0);
        XPathSupport xps = this.getXPathSupport();
        if (xps == null) {
            throw new EvaluationException("No XPath support available");
        }
        return xps.executeQuery(this.node, query);
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final Object get(int i) {
        return i == 0 ? this : null;
    }

    @Override
    public String getNodeNamespace() {
        short nodeType = this.node.getNodeType();
        if (nodeType != 2 && nodeType != 1) {
            return null;
        }
        String result = this.node.getNamespaceURI();
        if (result == null && nodeType == 1) {
            result = "";
        } else if ("".equals(result) && nodeType == 2) {
            result = null;
        }
        return result;
    }

    public final int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return other.getClass() == this.getClass() && ((WrappedDomNode)other).node.equals(this.node);
    }

    public static WrappedDomNode wrapNode(Node node) {
        if (node == null) {
            return null;
        }
        WrappedDomNode result = null;
        switch (node.getNodeType()) {
            case 9: {
                result = new DocumentModel((Document)node);
                break;
            }
            case 1: {
                result = new ElementModel((Element)node);
                break;
            }
            case 2: {
                result = new AttributeNodeModel((Attr)node);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                result = new CharacterDataNodeModel((CharacterData)node);
                break;
            }
            case 7: {
                result = new PINodeModel((ProcessingInstruction)node);
                break;
            }
            case 10: {
                result = new DocumentTypeModel((DocumentType)node);
            }
        }
        return result;
    }

    public static void removeComments(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int len = children.getLength();
        while (i < len) {
            Node child = children.item(i);
            if (child.hasChildNodes()) {
                WrappedDomNode.removeComments(child);
                ++i;
                continue;
            }
            if (child.getNodeType() == 8) {
                node.removeChild(child);
                --len;
                continue;
            }
            ++i;
        }
    }

    public static void removePIs(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int len = children.getLength();
        while (i < len) {
            Node child = children.item(i);
            if (child.hasChildNodes()) {
                WrappedDomNode.removePIs(child);
                ++i;
                continue;
            }
            if (child.getNodeType() == 7) {
                node.removeChild(child);
                --len;
                continue;
            }
            ++i;
        }
    }

    public static void mergeAdjacentText(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Text || child instanceof CDATASection) {
                Node next = child.getNextSibling();
                if (!(next instanceof Text) && !(next instanceof CDATASection)) continue;
                String fullText = child.getNodeValue() + next.getNodeValue();
                ((CharacterData)child).setData(fullText);
                node.removeChild(next);
                continue;
            }
            WrappedDomNode.mergeAdjacentText(child);
        }
    }

    public static void simplify(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        int len = children.getLength();
        Node prevTextChild = null;
        while (i < len) {
            Node child = children.item(i);
            if (child.hasChildNodes()) {
                WrappedDomNode.simplify(child);
                prevTextChild = null;
                ++i;
                continue;
            }
            short type = child.getNodeType();
            if (type == 7) {
                node.removeChild(child);
                --len;
                continue;
            }
            if (type == 8) {
                node.removeChild(child);
                --len;
                continue;
            }
            if (type == 3 || type == 4) {
                if (prevTextChild != null) {
                    CharacterData ptc = (CharacterData)prevTextChild;
                    ptc.setData(ptc.getNodeValue() + child.getNodeValue());
                    node.removeChild(child);
                    --len;
                    continue;
                }
                prevTextChild = child;
                ++i;
                continue;
            }
            prevTextChild = null;
            ++i;
        }
    }

    WrappedDomNode getDocumentNodeModel() {
        if (this.node instanceof Document) {
            return this;
        }
        return WrappedDomNode.wrapNode(this.node.getOwnerDocument());
    }

    private static String getText(Node node) {
        if (node instanceof Text || node instanceof CDATASection) {
            return ((CharacterData)node).getData();
        }
        if (node instanceof Element) {
            StringBuilder result = new StringBuilder();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                result.append(WrappedDomNode.getText(children.item(i)));
            }
            return result.toString();
        }
        if (node instanceof Document) {
            return WrappedDomNode.getText(((Document)node).getDocumentElement());
        }
        return "";
    }

    XPathSupport getXPathSupport() {
        return DefaultXPathSupport.instance;
    }

    String getQualifiedName() {
        return this.getNodeName();
    }
}

