/*
 * Decompiled with CFR 0.152.
 */
package freemarker.xml;

import freemarker.core.Environment;
import freemarker.core.variables.EvaluationException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.xml.ElementModel;
import freemarker.xml.WrappedDomNode;
import freemarker.xml.XPathSupport;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeListModel
implements TemplateSequenceModel,
TemplateHashModel {
    WrappedDomNode contextNode;
    XPathSupport xpathSupport;
    private List<Object> list = new ArrayList<Object>();

    NodeListModel(WrappedDomNode contextNode) {
        this.contextNode = contextNode;
    }

    NodeListModel(NodeList nodeList, WrappedDomNode contextNode) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.list.add(nodeList.item(i));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(NamedNodeMap nodeList, WrappedDomNode contextNode) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.list.add(nodeList.item(i));
        }
        this.contextNode = contextNode;
    }

    NodeListModel(List<Object> list, WrappedDomNode contextNode) {
        this.list = list;
        this.contextNode = contextNode;
    }

    public void add(Object obj) {
        this.list.add(obj);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Object get(int i) {
        return this.list.get(i);
    }

    NodeListModel filterByName(String name) {
        NodeListModel result = new NodeListModel(this.contextNode);
        int size = this.size();
        if (size == 0) {
            return result;
        }
        Environment env = Environment.getCurrentEnvironment();
        for (int i = 0; i < size; ++i) {
            WrappedDomNode nm = (WrappedDomNode)this.get(i);
            if (!(nm instanceof ElementModel) || !((ElementModel)nm).matchesName(name, env)) continue;
            result.add(nm);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object get(String key) {
        if (this.size() == 1) {
            WrappedDomNode nm = (WrappedDomNode)this.get(0);
            return nm.get(key);
        }
        if (key.equals("@@markup") || key.equals("@@nested_markup") || key.equals("@@text")) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                WrappedDomNode nm = (WrappedDomNode)this.get(i);
                Object textModel = nm.get(key);
                result.append(textModel.toString());
            }
            return result.toString();
        }
        if (ElementModel.isXMLID(key) || key.startsWith("@") && ElementModel.isXMLID(key.substring(1)) || key.equals("*") || key.equals("**") || key.equals("@@") || key.equals("@*")) {
            NodeListModel result = new NodeListModel(this.contextNode);
            for (int i = 0; i < this.size(); ++i) {
                TemplateSequenceModel tsm;
                WrappedDomNode nm = (WrappedDomNode)this.get(i);
                if (!(nm instanceof ElementModel) || (tsm = (TemplateSequenceModel)((ElementModel)nm).get(key)) == null) continue;
                int size = tsm.size();
                for (int j = 0; j < size; ++j) {
                    result.add(tsm.get(j));
                }
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
        XPathSupport xps = this.getXPathSupport();
        if (xps != null) {
            List<Node> context = this.size() == 0 ? null : this.rawNodeList();
            return xps.executeQuery(context, key);
        }
        throw new EvaluationException("Key: '" + key + "' is not legal for a node sequence (" + this.getClass().getName() + "). This node sequence contains " + this.size() + " node(s). Some keys are valid only for node sequences of size 1. If you use Xalan (instead of Jaxen), XPath expression keys work only with node lists of size 1.");
    }

    private List<Node> rawNodeList() {
        int size = this.size();
        ArrayList<Node> al = new ArrayList<Node>(size);
        for (int i = 0; i < size; ++i) {
            al.add(((WrappedDomNode)this.get((int)i)).node);
        }
        return al;
    }

    XPathSupport getXPathSupport() {
        if (this.xpathSupport == null) {
            if (this.contextNode != null) {
                this.xpathSupport = this.contextNode.getXPathSupport();
            } else if (this.size() > 0) {
                this.xpathSupport = ((WrappedDomNode)this.get(0)).getXPathSupport();
            }
        }
        return this.xpathSupport;
    }
}

