/*
 * Decompiled with CFR 0.152.
 */
package freemarker.xml;

import freemarker.core.Environment;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.WrappedNode;
import freemarker.xml.NodeListModel;
import freemarker.xml.NodeOutputter;
import freemarker.xml.WrappedDomNode;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ElementModel
extends WrappedDomNode {
    public ElementModel(Element element) {
        super(element);
    }

    @Override
    public Object get(String key) {
        if (key.equals("*")) {
            NodeListModel ns = new NodeListModel(this);
            List<WrappedNode> children = this.getChildNodes();
            for (int i = 0; i < children.size(); ++i) {
                WrappedDomNode child = (WrappedDomNode)children.get(i);
                if (child.node.getNodeType() != 1) continue;
                ns.add(child);
            }
            return ns;
        }
        if (key.equals("**")) {
            Element elem = (Element)this.node;
            return new NodeListModel(elem.getElementsByTagName("*"), (WrappedDomNode)this);
        }
        if (key.startsWith("@")) {
            if (key.equals("@@") || key.equals("@*")) {
                return new NodeListModel(this.node.getAttributes(), (WrappedDomNode)this);
            }
            if (key.equals("@@start_tag")) {
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                return nodeOutputter.getOpeningTag((Element)this.node);
            }
            if (key.equals("@@end_tag")) {
                NodeOutputter nodeOutputter = new NodeOutputter(this.node);
                return nodeOutputter.getClosingTag((Element)this.node);
            }
            if (key.equals("@@attributes_markup")) {
                StringBuilder buf = new StringBuilder();
                NodeOutputter nu = new NodeOutputter(this.node);
                nu.outputContent(this.node.getAttributes(), buf);
                return buf.toString().trim();
            }
            if (ElementModel.isXMLID(key.substring(1))) {
                Attr att = this.getAttribute(key.substring(1), Environment.getCurrentEnvironment());
                if (att == null) {
                    return new NodeListModel(this);
                }
                return ElementModel.wrapNode(att);
            }
        }
        if (ElementModel.isXMLID(key)) {
            Environment env = Environment.getCurrentEnvironment();
            NodeListModel result = new NodeListModel(this);
            for (WrappedNode node : this.getChildNodes()) {
                if (!(node instanceof ElementModel) || !((ElementModel)node).matchesName(key, env)) continue;
                result.add(node);
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
        return super.get(key);
    }

    public String toString() {
        NodeList nl = this.node.getChildNodes();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                String msg = "Only elements with no child elements can be processed as text.\nThis element with name \"" + this.node.getNodeName() + "\" has a child element named: " + child.getNodeName();
                throw new EvaluationException(msg);
            }
            if (nodeType != 3 && nodeType != 4) continue;
            result.append(child.getNodeValue());
        }
        return result.toString();
    }

    @Override
    public String getNodeName() {
        String result = this.node.getLocalName();
        if (result == null || result.equals("")) {
            result = this.node.getNodeName();
        }
        return result;
    }

    @Override
    String getQualifiedName() {
        String nodeName = this.getNodeName();
        String nsURI = this.getNodeNamespace();
        if (nsURI == null || nsURI.length() == 0) {
            return nodeName;
        }
        Environment env = Environment.getCurrentEnvironment();
        String defaultNS = env.getDefaultNS();
        String prefix = defaultNS != null && defaultNS.equals(nsURI) ? "D" : env.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return null;
        }
        if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        return prefix + nodeName;
    }

    private Attr getAttribute(String qname, Environment env) {
        Element element = (Element)this.node;
        Attr result = element.getAttributeNode(qname);
        if (result != null) {
            return result;
        }
        int colonIndex = qname.indexOf(58);
        if (colonIndex > 0) {
            String prefix = qname.substring(0, colonIndex);
            String uri = prefix.equals("D") ? Environment.getCurrentEnvironment().getDefaultNS() : Environment.getCurrentEnvironment().getNamespaceForPrefix(prefix);
            String localName = qname.substring(1 + colonIndex);
            if (uri != null) {
                result = element.getAttributeNodeNS(uri, localName);
            }
        }
        return result;
    }

    boolean matchesName(String name, Environment env) {
        return ElementModel.matchesName(name, this.getNodeName(), this.getNodeNamespace(), env);
    }

    private static boolean matchesName(String qname, String nodeName, String nsURI, Environment env) {
        String defaultNS = env.getDefaultNS();
        if (defaultNS != null && defaultNS.equals(nsURI)) {
            return qname.equals(nodeName) || qname.equals("D:" + nodeName);
        }
        if ("".equals(nsURI)) {
            if (defaultNS != null) {
                return qname.equals("N:" + nodeName);
            }
            return qname.equals(nodeName) || qname.equals("N:" + nodeName);
        }
        String prefix = env.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return false;
        }
        return qname.equals(prefix + ":" + nodeName);
    }

    static boolean isXMLID(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && (c == '-' || c == '.' || Character.isDigit(c))) {
                return false;
            }
            if (Character.isLetterOrDigit(c) || c == ':' || c == '_' || c == '-' || c == '.') continue;
            return false;
        }
        return true;
    }
}

