/*
 * Decompiled with CFR 0.152.
 */
package freemarker.xml;

import freemarker.core.Environment;
import freemarker.xml.ElementModel;
import freemarker.xml.NodeListModel;
import freemarker.xml.WrappedDomNode;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class DocumentModel
extends WrappedDomNode {
    private ElementModel rootElement;

    DocumentModel(Document doc) {
        super(doc);
    }

    @Override
    public String getNodeName() {
        return "@document";
    }

    @Override
    public Object get(String key) {
        if (key.equals("*")) {
            return this.getRootElement();
        }
        if (key.equals("**")) {
            NodeList nl = ((Document)this.node).getElementsByTagName("*");
            return new NodeListModel(nl, (WrappedDomNode)this);
        }
        if (ElementModel.isXMLID(key)) {
            ElementModel em = (ElementModel)WrappedDomNode.wrapNode(((Document)this.node).getDocumentElement());
            if (em.matchesName(key, Environment.getCurrentEnvironment())) {
                return em;
            }
            return new NodeListModel(this);
        }
        return super.get(key);
    }

    ElementModel getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = (ElementModel)DocumentModel.wrapNode(((Document)this.node).getDocumentElement());
        }
        return this.rootElement;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

