/*
 * Decompiled with CFR 0.152.
 */
package freemarker.xml;

import freemarker.core.Environment;
import freemarker.core.variables.Wrap;
import freemarker.xml.NodeListModel;
import freemarker.xml.WrappedDomNode;
import freemarker.xml.XPathSupport;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXPathSupport
implements XPathSupport {
    private static XPathFactory xpf;
    static DefaultXPathSupport instance;
    private static NamespaceContext nsc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeQuery(Object context, String xpathQuery) {
        XPath xp = null;
        XPathFactory xPathFactory = xpf;
        synchronized (xPathFactory) {
            xp = xpf.newXPath();
        }
        xp.setNamespaceContext(nsc);
        try {
            NodeList nl = (NodeList)xp.evaluate(xpathQuery, context, XPathConstants.NODESET);
            if (nl.getLength() == 1) {
                Node n = nl.item(0);
                return WrappedDomNode.wrapNode(n);
            }
            return new NodeListModel(nl, null);
        }
        catch (Exception nl) {
            String scalar = null;
            try {
                scalar = xp.evaluate(xpathQuery, context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (scalar == null) {
                return Wrap.JAVA_NULL;
            }
            if (scalar.equals("true")) {
                return Boolean.TRUE;
            }
            if (scalar.equals("false")) {
                return Boolean.FALSE;
            }
            try {
                return Double.valueOf(scalar);
            }
            catch (Exception exception) {
                return scalar;
            }
        }
    }

    static {
        instance = new DefaultXPathSupport();
        xpf = XPathFactory.newInstance();
        nsc = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix.equals("D")) {
                    return Environment.getCurrentEnvironment().getDefaultNS();
                }
                return Environment.getCurrentEnvironment().getNamespaceForPrefix(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return Environment.getCurrentEnvironment().getPrefixForNamespace(namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                String prefix = this.getPrefix(namespaceURI);
                LinkedList<String> l = new LinkedList<String>();
                l.add(prefix);
                return l.iterator();
            }
        };
    }
}

