/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.core.Environment;
import freemarker.core.variables.UserDirective;
import freemarker.core.variables.UserDirectiveBody;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class HtmlEscape
implements UserDirective {
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] QUOT = "&quot;".toCharArray();

    @Override
    public void execute(Environment env, Map<String, Object> args, Object[] bodyVars, UserDirectiveBody body) throws IOException {
        body.render(this.getWriter(env.getOut()));
    }

    public Writer getWriter(Writer out) {
        return new HtmlEscapeWriter(out);
    }

    class HtmlEscapeWriter
    extends Writer {
        Writer out;

        HtmlEscapeWriter(Writer out) {
            this.out = out;
        }

        @Override
        public void write(int c) throws IOException {
            switch (c) {
                case 60: {
                    this.out.write(LT, 0, 4);
                    break;
                }
                case 62: {
                    this.out.write(GT, 0, 4);
                    break;
                }
                case 38: {
                    this.out.write(AMP, 0, 5);
                    break;
                }
                case 34: {
                    this.out.write(QUOT, 0, 6);
                    break;
                }
                default: {
                    this.out.write(c);
                }
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            int lastoff = off;
            int lastpos = off + len;
            block6: for (int i = off; i < lastpos; ++i) {
                switch (cbuf[i]) {
                    case '<': {
                        this.out.write(cbuf, lastoff, i - lastoff);
                        this.out.write(LT, 0, 4);
                        lastoff = i + 1;
                        continue block6;
                    }
                    case '>': {
                        this.out.write(cbuf, lastoff, i - lastoff);
                        this.out.write(GT, 0, 4);
                        lastoff = i + 1;
                        continue block6;
                    }
                    case '&': {
                        this.out.write(cbuf, lastoff, i - lastoff);
                        this.out.write(AMP, 0, 5);
                        lastoff = i + 1;
                        continue block6;
                    }
                    case '\"': {
                        this.out.write(cbuf, lastoff, i - lastoff);
                        this.out.write(QUOT, 0, 6);
                        lastoff = i + 1;
                    }
                }
            }
            int remaining = lastpos - lastoff;
            if (remaining > 0) {
                this.out.write(cbuf, lastoff, remaining);
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() {
        }
    }
}

