/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.PrintWriter;
import java.io.Writer;

public interface TemplateExceptionHandler {
    public static final TemplateExceptionHandler IGNORE_HANDLER = new TemplateExceptionHandler(){

        @Override
        public void handleTemplateException(TemplateException te, Environment env, Writer out) {
        }
    };
    public static final TemplateExceptionHandler RETHROW_HANDLER = new TemplateExceptionHandler(){

        @Override
        public void handleTemplateException(TemplateException te, Environment env, Writer out) {
            throw te;
        }
    };
    public static final TemplateExceptionHandler DEBUG_HANDLER = new TemplateExceptionHandler(){

        @Override
        public void handleTemplateException(TemplateException te, Environment env, Writer out) {
            PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
            te.printStackTrace(pw);
            pw.flush();
            throw te;
        }
    };
    public static final TemplateExceptionHandler HTML_DEBUG_HANDLER = new TemplateExceptionHandler(){

        @Override
        public void handleTemplateException(TemplateException te, Environment env, Writer out) {
            PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
            pw.println("<!-- FREEMARKER ERROR MESSAGE STARTS HERE --><script language=javascript>//\"></script><script language=javascript>//'></script><script language=javascript>//\"></script><script language=javascript>//'></script></title></xmp></script></noscript></style></object></head></pre></table></form></table></table></table></a></u></i></b><div align=left style='background-color:#FFFF00; color:#FF0000; display:block; border-top:double; padding:2pt; font-size:medium; font-family:Arial,sans-serif; font-style: normal; font-variant: normal; font-weight: normal; text-decoration: none; text-transform: none'><b style='font-size:medium'>FreeMarker template error!</b><pre><xmp>");
            pw.println("</xmp></pre></div></html>");
            pw.flush();
            throw te;
        }
    };

    public void handleTemplateException(TemplateException var1, Environment var2, Writer var3);
}

