/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.IncludeInstruction;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.UnifiedCall;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TemplateException
extends RuntimeException {
    private List<TemplateElement> ftlStack;

    public TemplateException(String message) {
        super(message);
    }

    public TemplateException(String description, Environment env) {
        this(description, null, env);
    }

    public TemplateException(String description, Exception cause, Environment env) {
        super(TemplateException.getDescription(description, cause), cause);
        if (env != null) {
            this.ftlStack = new ArrayList<TemplateElement>(env.getElementStack());
            Collections.reverse(this.ftlStack);
        }
    }

    public TemplateException(Exception cause, Environment env) {
        this(null, cause, env);
    }

    private static String getDescription(String description, Exception cause) {
        if (description != null) {
            return description;
        }
        if (cause != null) {
            return cause.getClass().getName() + ": " + cause.getMessage();
        }
        return "No error message";
    }

    public String getFTLInstructionStack() {
        StringBuilder buf = new StringBuilder("----------\n");
        if (this.ftlStack != null) {
            boolean atFirstElement = true;
            for (TemplateElement location : this.ftlStack) {
                String line;
                if (atFirstElement) {
                    atFirstElement = false;
                    buf.append("==> ");
                    buf.append(location.getDescription());
                    buf.append(" [");
                    buf.append(location.getLocation());
                    buf.append("]\n");
                    continue;
                }
                if (!(location instanceof UnifiedCall) && !(location instanceof IncludeInstruction) || (line = location.getDescription() + " [" + location.getLocation() + "]") == null || line.length() <= 0) continue;
                buf.append(" in ");
                buf.append(line);
                buf.append("\n");
            }
            buf.append("----------\n");
        }
        return buf.toString();
    }

    public List<TemplateElement> getFTLStack() {
        if (this.ftlStack == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ftlStack);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(ps), true);
        this.printStackTrace(pw);
        pw.flush();
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        pw.println();
        pw.println(this.getMessage());
        pw.println(this.getFTLInstructionStack());
        pw.println("Java backtrace for programmers:");
        pw.println("----------");
        super.printStackTrace(pw);
        try {
            Throwable causeException = this.getCause();
            Method m = causeException.getClass().getMethod("getRootCause", new Class[0]);
            Throwable rootCause = (Throwable)m.invoke((Object)causeException, new Object[0]);
            if (rootCause != null) {
                Throwable j14Cause = null;
                if (causeException != null) {
                    m = causeException.getClass().getMethod("getCause", new Class[0]);
                    j14Cause = (Throwable)m.invoke((Object)causeException, new Object[0]);
                }
                if (j14Cause == null) {
                    pw.println("ServletException root cause: ");
                    rootCause.printStackTrace(pw);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

