/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Block;
import freemarker.core.nodes.generated.ImportDeclaration;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateHeaderElement;
import freemarker.core.parser.FMParser;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.ParsingProblemImpl;
import freemarker.core.variables.WrappedNode;
import freemarker.template.Configuration;
import freemarker.template.PostParseVisitor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Template
extends Configurable {
    public static final String DEFAULT_NAMESPACE_PREFIX = "D";
    public static final String NO_NS_PREFIX = "N";
    private Block rootElement;
    private Map<String, Macro> macros = new HashMap<String, Macro>();
    private List<ImportDeclaration> imports = new ArrayList<ImportDeclaration>();
    private String encoding;
    private String defaultNS;
    private final String name;
    private Map<String, String> prefixToNamespaceURILookup = new HashMap<String, String>();
    private Map<String, String> namespaceURIToPrefixLookup = new HashMap<String, String>();
    private boolean strictVariableDeclaration;
    private List<ParsingProblemImpl> parsingProblems = new ArrayList<ParsingProblemImpl>();
    private TemplateHeaderElement headerElement;

    protected Template(String name, Configuration cfg) {
        super(cfg != null ? cfg : Configuration.getDefaultConfiguration());
        this.name = name;
    }

    public Template(String name, Reader reader, Configuration cfg, String encoding) throws IOException {
        this(name, cfg);
        this.encoding = encoding;
        try {
            this.strictVariableDeclaration = this.getConfiguration().getStrictVariableDefinition();
            CharSequence content = this.readInTemplateText(reader);
            FMParser parser = new FMParser(this, content);
            parser.setInputSource(this.getName());
            this.rootElement = parser.Root();
            PostParseVisitor ppv = new PostParseVisitor(this);
            ppv.visit(this);
        }
        catch (ParseException e) {
            e.setTemplateName(name);
            throw e;
        }
        this.namespaceURIToPrefixLookup = Collections.unmodifiableMap(this.namespaceURIToPrefixLookup);
        this.prefixToNamespaceURILookup = Collections.unmodifiableMap(this.prefixToNamespaceURILookup);
    }

    public Template(String name, CharSequence input, Configuration cfg, String encoding) throws IOException {
        this(name, cfg);
        this.encoding = encoding;
        try {
            this.strictVariableDeclaration = this.getConfiguration().getStrictVariableDefinition();
            FMParser parser = new FMParser(this, input);
            parser.setInputSource(this.getName());
            this.rootElement = parser.Root();
            PostParseVisitor ppv = new PostParseVisitor(this);
            ppv.visit(this);
        }
        catch (ParseException e) {
            e.setTemplateName(name);
            throw e;
        }
        this.namespaceURIToPrefixLookup = Collections.unmodifiableMap(this.namespaceURIToPrefixLookup);
        this.prefixToNamespaceURILookup = Collections.unmodifiableMap(this.prefixToNamespaceURILookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence readInTemplateText(Reader reader) throws IOException {
        int charsRead = 0;
        StringBuilder buf = new StringBuilder();
        char[] chars = new char[65536];
        try {
            do {
                if ((charsRead = reader.read(chars)) <= 0) continue;
                buf.append(chars, 0, charsRead);
            } while (charsRead >= 0);
        }
        finally {
            reader.close();
        }
        return buf;
    }

    public Template(String name, Reader reader, Configuration cfg) throws IOException {
        this(name, reader, cfg, null);
    }

    public Template(String name, Reader reader) throws IOException {
        this(name, reader, null);
    }

    public static Template getPlainTextTemplate(String name, final String content, Configuration config) {
        Template template = new Template(name, config);
        template.rootElement = new Block(){

            @Override
            public void execute(Environment env) throws IOException {
                env.getOut().write(content);
            }
        };
        return template;
    }

    public void process(Map<String, Object> rootMap, Writer out) throws IOException {
        this.createProcessingEnvironment(rootMap, out).process();
    }

    public void process(Map<String, Object> rootMap, Writer out, WrappedNode rootNode) throws IOException {
        Environment env = this.createProcessingEnvironment(rootMap, out);
        if (rootNode != null) {
            env.setCurrentVisitorNode(rootNode);
        }
        env.process();
    }

    public Environment createProcessingEnvironment(Map<String, Object> rootMap, Writer out) {
        return new Environment(this, rootMap, out);
    }

    public String getName() {
        return this.name;
    }

    public Configuration getConfiguration() {
        return (Configuration)this.getFallback();
    }

    public List<ParsingProblemImpl> getParsingProblems() {
        return this.parsingProblems;
    }

    public boolean hasParsingProblems() {
        return !this.parsingProblems.isEmpty();
    }

    public void addParsingProblem(ParsingProblemImpl problem) {
        this.parsingProblems.add(problem);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void addImport(ImportDeclaration id) {
        this.imports.add(id);
    }

    public void setHeaderElement(TemplateHeaderElement headerElement) {
        this.headerElement = headerElement;
    }

    public TemplateHeaderElement getHeaderElement() {
        return this.headerElement;
    }

    public boolean declaresVariable(String name) {
        return this.getRootElement().declaresVariable(name);
    }

    public void declareVariable(String name) {
        this.getRootElement().declareVariable(name);
    }

    public boolean strictVariableDeclaration() {
        return this.strictVariableDeclaration;
    }

    public boolean legacySyntax() {
        return !this.strictVariableDeclaration;
    }

    public void setLegacySyntax(boolean legacySyntax) {
        this.strictVariableDeclaration = !legacySyntax;
    }

    public void setStrictVariableDeclaration(boolean strictVariableDeclaration) {
        this.strictVariableDeclaration = strictVariableDeclaration;
    }

    public TemplateElement getRootTreeNode() {
        return this.getRootElement();
    }

    public List<ImportDeclaration> getImports() {
        return this.imports;
    }

    public void addPrefixNSMapping(String prefix, String nsURI) {
        if (nsURI.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string URI");
        }
        if (prefix.length() == 0) {
            throw new IllegalArgumentException("Cannot map empty string prefix");
        }
        if (prefix.equals(NO_NS_PREFIX)) {
            throw new IllegalArgumentException("The prefix: " + prefix + " cannot be registered, it is reserved for special internal use.");
        }
        if (this.prefixToNamespaceURILookup.containsKey(prefix)) {
            throw new IllegalArgumentException("The prefix: '" + prefix + "' was repeated. This is illegal.");
        }
        if (this.namespaceURIToPrefixLookup.containsKey(nsURI)) {
            throw new IllegalArgumentException("The namespace URI: " + nsURI + " cannot be mapped to 2 different prefixes.");
        }
        if (prefix.equals(DEFAULT_NAMESPACE_PREFIX)) {
            this.defaultNS = nsURI;
        } else {
            this.prefixToNamespaceURILookup.put(prefix, nsURI);
            this.namespaceURIToPrefixLookup.put(nsURI, prefix);
        }
    }

    public String getDefaultNS() {
        return this.defaultNS;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (prefix.equals("")) {
            return this.defaultNS == null ? "" : this.defaultNS;
        }
        return this.prefixToNamespaceURILookup.get(prefix);
    }

    public String getPrefixForNamespace(String nsURI) {
        if (nsURI == null) {
            return null;
        }
        if (nsURI.length() == 0) {
            return this.defaultNS == null ? "" : NO_NS_PREFIX;
        }
        if (nsURI.equals(this.defaultNS)) {
            return "";
        }
        return this.namespaceURIToPrefixLookup.get(nsURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacro(Macro macro) {
        String macroName = macro.getName();
        Map<String, Macro> map = this.macros;
        synchronized (map) {
            this.macros.put(macroName, macro);
        }
    }

    public Map<String, Macro> getMacros() {
        return this.macros;
    }

    public Block getRootElement() {
        return this.rootElement;
    }

    public static class WrongEncodingException
    extends RuntimeException {
        public String specifiedEncoding;

        public WrongEncodingException(String specifiedEncoding) {
            this.specifiedEncoding = specifiedEncoding;
        }
    }
}

