/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.parser.ParseException;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;

class SettingStringParser {
    private String text;
    private int p;
    private int ln;

    SettingStringParser(String text) {
        this.text = text;
        this.p = 0;
        this.ln = text.length();
    }

    ArrayList<String> parseAsList() {
        char c;
        ArrayList<String> seq = new ArrayList<String>();
        while ((c = this.skipWS()) != ' ') {
            seq.add(this.fetchStringValue());
            c = this.skipWS();
            if (c == ' ') break;
            if (c != ',') {
                throw new ParseException("Expected \",\" or the end of text but found \"" + c + "\"", 0, 0);
            }
            ++this.p;
        }
        return seq;
    }

    HashMap<String, String> parseAsImportList() {
        char c;
        HashMap<String, String> map = new HashMap<String, String>();
        while ((c = this.skipWS()) != ' ') {
            String lib = this.fetchStringValue();
            c = this.skipWS();
            if (c == ' ') {
                throw new ParseException("Unexpected end of text: expected \"as\"", 0, 0);
            }
            String s = this.fetchKeyword();
            if (!s.equalsIgnoreCase("as")) {
                throw new ParseException("Expected \"as\", but found " + StringUtil.jQuote(s), 0, 0);
            }
            c = this.skipWS();
            if (c == ' ') {
                throw new ParseException("Unexpected end of text: expected gate hash name", 0, 0);
            }
            String ns = this.fetchStringValue();
            map.put(ns, lib);
            c = this.skipWS();
            if (c == ' ') break;
            if (c != ',') {
                throw new ParseException("Expected \",\" or the end of text but found \"" + c + "\"", 0, 0);
            }
            ++this.p;
        }
        return map;
    }

    String fetchStringValue() {
        String w = this.fetchWord();
        if (w.startsWith("'") || w.startsWith("\"")) {
            w = w.substring(1, w.length() - 1);
        }
        return StringUtil.FTLStringLiteralDec(w);
    }

    String fetchKeyword() {
        String w = this.fetchWord();
        if (w.startsWith("'") || w.startsWith("\"")) {
            throw new ParseException("Keyword expected, but a string value found: " + w, 0, 0);
        }
        return w;
    }

    char skipWS() {
        while (this.p < this.ln) {
            char c = this.text.charAt(this.p);
            if (!Character.isWhitespace(c)) {
                return c;
            }
            ++this.p;
        }
        return ' ';
    }

    private String fetchWord() {
        if (this.p == this.ln) {
            throw new ParseException("Unexpeced end of text", 0, 0);
        }
        char c = this.text.charAt(this.p);
        int b = this.p;
        if (c == '\'' || c == '\"') {
            boolean escaped = false;
            char q = c;
            ++this.p;
            while (this.p < this.ln) {
                c = this.text.charAt(this.p);
                if (!escaped) {
                    if (c == '\\') {
                        escaped = true;
                    } else if (c == q) {
                        break;
                    }
                } else {
                    escaped = false;
                }
                ++this.p;
            }
            if (this.p == this.ln) {
                throw new ParseException("Missing " + q, 0, 0);
            }
            ++this.p;
            return this.text.substring(b, this.p);
        }
        while (Character.isLetterOrDigit(c = this.text.charAt(this.p)) || c == '/' || c == '\\' || c == '_' || c == '.' || c == '-' || c == '!' || c == '*' || c == '?') {
            ++this.p;
            if (this.p < this.ln) continue;
        }
        if (b == this.p) {
            throw new ParseException("Unexpected character: " + c, 0, 0);
        }
        return this.text.substring(b, this.p);
    }
}

